
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import Union, TYPE_CHECKING, Optional
from ....gadgets.tlobject import TLObject
from ....gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ..user import TypeUser
    from ....gadgets.byteutils import Reader
    from ..help.terms_of_service import TypeHelpTermsOfService


class Authorization(TLObject, family='TypeAuthAuthorization'):
    """
    Contains user authorization info.
    """

    _id = 0X2EA2C0D4
    _group_id = 0X2A654890

    def __init__(
        self,
        user: 'TypeUser',
        setup_password_required: bool = False,
        otherwise_relogin_days: Optional[int] = None,
        tmp_sessions: Optional[int] = None,
        future_auth_token: Optional[bytes] = None
    ):

        """
        Contains user authorization info.

        Args:
            user ('TypeUser'): Info on authorized user
            setup_password_required (bool, optional): Suggests the user to set up a 2-step verification password to be able to log in again
            otherwise_relogin_days (Optional[int], optional): Iff setup_password_required is set and the user declines to set a 2-step verification password, they will be able to log into their account via SMS again only after this many days pass.
            tmp_sessions (Optional[int], optional): Temporary [passport](https://core.telegram.org/passport) sessions
            future_auth_token (Optional[bytes], optional): A [future auth token](https://core.telegram.org/api/auth#future-auth-tokens)
        """

        self.user = user
        self.setup_password_required = setup_password_required
        self.otherwise_relogin_days = otherwise_relogin_days
        self.tmp_sessions = tmp_sessions
        self.future_auth_token = future_auth_token

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xd4\xc0\xa2.' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.setup_password_required, 1)

                if flags(self.otherwise_relogin_days, 1):
                    writer.int(self.otherwise_relogin_days)

                if flags(self.tmp_sessions, 0):
                    writer.int(self.tmp_sessions)

                if flags(self.future_auth_token, 2):
                    writer.bytes(self.future_auth_token)
                writer.object(
                    self.user,
                    group_id=0X9BABE43A
                )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        otherwise_relogin_days_ = (
            reader.int()
            if flags(1) else None
        )

        tmp_sessions_ = (
            reader.int()
            if flags(0) else None
        )

        future_auth_token_ = (
            reader.bytes()
            if flags(2) else None
        )

        user_ = reader.object(
            group_id=0X9BABE43A
        )

        return cls(
            user=user_,
            setup_password_required=flags(1),
            otherwise_relogin_days=otherwise_relogin_days_,
            tmp_sessions=tmp_sessions_,
            future_auth_token=future_auth_token_
        )

class AuthorizationSignUpRequired(TLObject, family='TypeAuthAuthorization'):
    """
    An account with this phone number doesn't exist on telegram: the user has to [enter basic information and sign up](https://core.telegram.org/api/auth)
    """

    _id = 0X44747E9A
    _group_id = 0X2A654890

    def __init__(
        self,
        terms_of_service: Optional['TypeHelpTermsOfService'] = None
    ):

        """
        An account with this phone number doesn't exist on telegram: the user has to [enter basic information and sign up](https://core.telegram.org/api/auth)

        Args:
            terms_of_service (Optional['TypeHelpTermsOfService'], optional): Telegram's terms of service: the user must read and accept the terms of service before signing up to telegram
        """

        self.terms_of_service = terms_of_service

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x9a~tD' if boxed else b'') as writer:
            with writer.flag() as flags:

                if flags(self.terms_of_service, 0):
                    writer.object(
                        self.terms_of_service,
                        group_id=0XEA6FD826
                    )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        terms_of_service_ = (
            reader.object(
                group_id=0XEA6FD826
            )
            if flags(0) else None
        )

        return cls(
            terms_of_service=terms_of_service_
        )

TypeAuthAuthorization = Union[
    Authorization,
    AuthorizationSignUpRequired
]