
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING, Optional
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ...gadgets.byteutils import Reader


class AutoSaveSettings(TLObject, family='TypeAutoSaveSettings'):
    """
    Media autosave settings
    """

    _id = 0XC84834CE
    _group_id = 0X5D28B575

    def __init__(
        self,
        photos: bool = False,
        videos: bool = False,
        video_max_size: Optional[int] = None
    ):

        """
        Media autosave settings

        Args:
            photos (bool, optional): Whether photos should be autosaved to the gallery.
            videos (bool, optional): Whether videos should be autosaved to the gallery.
            video_max_size (Optional[int], optional): If set, specifies a size limit for autosavable videos
        """

        self.photos = photos
        self.videos = videos
        self.video_max_size = video_max_size

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xce4H\xc8' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.photos, 0)
                flags(self.videos, 1)

                if flags(self.video_max_size, 2):
                    writer.long(self.video_max_size)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        video_max_size_ = (
            reader.long()
            if flags(2) else None
        )

        return cls(
            photos=flags(0),
            videos=flags(1),
            video_max_size=video_max_size_
        )

TypeAutoSaveSettings = AutoSaveSettings