
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import Union, TYPE_CHECKING, Optional, List
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from .geo_point import TypeGeoPoint
    from .reply_markup import TypeReplyMarkup
    from .web_document import TypeWebDocument
    from .message_entity import TypeMessageEntity
    from ...gadgets.byteutils import Reader


class BotInlineMessageMediaAuto(TLObject, family='TypeBotInlineMessage'):
    """
    Send whatever media is attached to the [botInlineMediaResult](https://core.telegram.org/constructor/botInlineMediaResult)
    """

    _id = 0X764CF810
    _group_id = 0X54822C1B

    def __init__(
        self,
        message: str,
        invert_media: bool = False,
        entities: Optional[List['TypeMessageEntity']] = None,
        reply_markup: Optional['TypeReplyMarkup'] = None
    ):

        """
        Send whatever media is attached to the [botInlineMediaResult](https://core.telegram.org/constructor/botInlineMediaResult)

        Args:
            message (str): Caption
            invert_media (bool, optional): If set, any eventual webpage preview will be shown on top of the message instead of at the bottom.
            entities (Optional[List['TypeMessageEntity']], optional): [Message entities for styled text](https://core.telegram.org/api/entities)
            reply_markup (Optional['TypeReplyMarkup'], optional): Inline keyboard
        """

        self.message = message
        self.invert_media = invert_media
        self.entities = entities
        self.reply_markup = reply_markup

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x10\xf8Lv' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.invert_media, 3)
                writer.string(self.message)

                if flags(self.entities, 1):
                    writer.vector(
                        self.entities,
                        lambda value: writer.object(
                            value,
                            group_id=0X3CDFF38A
                        )
                    )

                if flags(self.reply_markup, 2):
                    writer.object(
                        self.reply_markup,
                        group_id=0X146C1631
                    )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        message_ = reader.string()
        entities_ = (
            reader.vector(
                lambda: reader.object(
                    group_id=0X3CDFF38A
                )
            )
            if flags(1) else None
        )

        reply_markup_ = (
            reader.object(
                group_id=0X146C1631
            )
            if flags(2) else None
        )

        return cls(
            message=message_,
            invert_media=flags(3),
            entities=entities_,
            reply_markup=reply_markup_
        )

class BotInlineMessageText(TLObject, family='TypeBotInlineMessage'):
    """
    Send a simple text message
    """

    _id = 0X8C7F65E2
    _group_id = 0X54822C1B

    def __init__(
        self,
        message: str,
        no_webpage: bool = False,
        invert_media: bool = False,
        entities: Optional[List['TypeMessageEntity']] = None,
        reply_markup: Optional['TypeReplyMarkup'] = None
    ):

        """
        Send a simple text message

        Args:
            message (str): The message
            no_webpage (bool, optional): Disable webpage preview
            invert_media (bool, optional): If set, any eventual webpage preview will be shown on top of the message instead of at the bottom.
            entities (Optional[List['TypeMessageEntity']], optional): [Message entities for styled text](https://core.telegram.org/api/entities)
            reply_markup (Optional['TypeReplyMarkup'], optional): Inline keyboard
        """

        self.message = message
        self.no_webpage = no_webpage
        self.invert_media = invert_media
        self.entities = entities
        self.reply_markup = reply_markup

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xe2e\x7f\x8c' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.no_webpage, 0)
                flags(self.invert_media, 3)
                writer.string(self.message)

                if flags(self.entities, 1):
                    writer.vector(
                        self.entities,
                        lambda value: writer.object(
                            value,
                            group_id=0X3CDFF38A
                        )
                    )

                if flags(self.reply_markup, 2):
                    writer.object(
                        self.reply_markup,
                        group_id=0X146C1631
                    )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        message_ = reader.string()
        entities_ = (
            reader.vector(
                lambda: reader.object(
                    group_id=0X3CDFF38A
                )
            )
            if flags(1) else None
        )

        reply_markup_ = (
            reader.object(
                group_id=0X146C1631
            )
            if flags(2) else None
        )

        return cls(
            message=message_,
            no_webpage=flags(0),
            invert_media=flags(3),
            entities=entities_,
            reply_markup=reply_markup_
        )

class BotInlineMessageMediaGeo(TLObject, family='TypeBotInlineMessage'):
    """
    Send a geolocation
    """

    _id = 0X51846FD
    _group_id = 0X54822C1B

    def __init__(
        self,
        geo: 'TypeGeoPoint',
        heading: Optional[int] = None,
        period: Optional[int] = None,
        proximity_notification_radius: Optional[int] = None,
        reply_markup: Optional['TypeReplyMarkup'] = None
    ):

        """
        Send a geolocation

        Args:
            geo ('TypeGeoPoint'): Geolocation
            heading (Optional[int], optional): For [live locations](https://core.telegram.org/api/live-location), a direction in which the location moves, in degrees; 1-360.
            period (Optional[int], optional): Validity period
            proximity_notification_radius (Optional[int], optional): For [live locations](https://core.telegram.org/api/live-location), a maximum distance to another chat member for proximity alerts, in meters (0-100000).
            reply_markup (Optional['TypeReplyMarkup'], optional): Inline keyboard
        """

        self.geo = geo
        self.heading = heading
        self.period = period
        self.proximity_notification_radius = proximity_notification_radius
        self.reply_markup = reply_markup

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xfdF\x18\x05' if boxed else b'') as writer:
            with writer.flag() as flags:
                writer.object(
                    self.geo,
                    group_id=0X9248B41D
                )

                if flags(self.heading, 0):
                    writer.int(self.heading)

                if flags(self.period, 1):
                    writer.int(self.period)

                if flags(self.proximity_notification_radius, 3):
                    writer.int(self.proximity_notification_radius)

                if flags(self.reply_markup, 2):
                    writer.object(
                        self.reply_markup,
                        group_id=0X146C1631
                    )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        geo_ = reader.object(
            group_id=0X9248B41D
        )

        heading_ = (
            reader.int()
            if flags(0) else None
        )

        period_ = (
            reader.int()
            if flags(1) else None
        )

        proximity_notification_radius_ = (
            reader.int()
            if flags(3) else None
        )

        reply_markup_ = (
            reader.object(
                group_id=0X146C1631
            )
            if flags(2) else None
        )

        return cls(
            geo=geo_,
            heading=heading_,
            period=period_,
            proximity_notification_radius=proximity_notification_radius_,
            reply_markup=reply_markup_
        )

class BotInlineMessageMediaVenue(TLObject, family='TypeBotInlineMessage'):
    """
    Send a venue
    """

    _id = 0X8A86659C
    _group_id = 0X54822C1B

    def __init__(
        self,
        geo: 'TypeGeoPoint',
        title: str,
        address: str,
        provider: str,
        venue_id: str,
        venue_type: str,
        reply_markup: Optional['TypeReplyMarkup'] = None
    ):

        """
        Send a venue

        Args:
            geo ('TypeGeoPoint'): Geolocation of venue
            title (str): Venue name
            address (str): Address
            provider (str): Venue provider: currently only "foursquare" and "gplaces" (Google Places) need to be supported
            venue_id (str): Venue ID in the provider's database
            venue_type (str): Venue type in the provider's database
            reply_markup (Optional['TypeReplyMarkup'], optional): Inline keyboard
        """

        self.geo = geo
        self.title = title
        self.address = address
        self.provider = provider
        self.venue_id = venue_id
        self.venue_type = venue_type
        self.reply_markup = reply_markup

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x9ce\x86\x8a' if boxed else b'') as writer:
            with writer.flag() as flags:
                writer.object(
                    self.geo,
                    group_id=0X9248B41D
                )
                writer.string(self.title)
                writer.string(self.address)
                writer.string(self.provider)
                writer.string(self.venue_id)
                writer.string(self.venue_type)

                if flags(self.reply_markup, 2):
                    writer.object(
                        self.reply_markup,
                        group_id=0X146C1631
                    )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        geo_ = reader.object(
            group_id=0X9248B41D
        )

        title_ = reader.string()
        address_ = reader.string()
        provider_ = reader.string()
        venue_id_ = reader.string()
        venue_type_ = reader.string()
        reply_markup_ = (
            reader.object(
                group_id=0X146C1631
            )
            if flags(2) else None
        )

        return cls(
            geo=geo_,
            title=title_,
            address=address_,
            provider=provider_,
            venue_id=venue_id_,
            venue_type=venue_type_,
            reply_markup=reply_markup_
        )

class BotInlineMessageMediaContact(TLObject, family='TypeBotInlineMessage'):
    """
    Send a contact
    """

    _id = 0X18D1CDC2
    _group_id = 0X54822C1B

    def __init__(
        self,
        phone_number: str,
        first_name: str,
        last_name: str,
        vcard: str,
        reply_markup: Optional['TypeReplyMarkup'] = None
    ):

        """
        Send a contact

        Args:
            phone_number (str): Phone number
            first_name (str): First name
            last_name (str): Last name
            vcard (str): VCard info
            reply_markup (Optional['TypeReplyMarkup'], optional): Inline keyboard
        """

        self.phone_number = phone_number
        self.first_name = first_name
        self.last_name = last_name
        self.vcard = vcard
        self.reply_markup = reply_markup

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xc2\xcd\xd1\x18' if boxed else b'') as writer:
            with writer.flag() as flags:
                writer.string(self.phone_number)
                writer.string(self.first_name)
                writer.string(self.last_name)
                writer.string(self.vcard)

                if flags(self.reply_markup, 2):
                    writer.object(
                        self.reply_markup,
                        group_id=0X146C1631
                    )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        phone_number_ = reader.string()
        first_name_ = reader.string()
        last_name_ = reader.string()
        vcard_ = reader.string()
        reply_markup_ = (
            reader.object(
                group_id=0X146C1631
            )
            if flags(2) else None
        )

        return cls(
            phone_number=phone_number_,
            first_name=first_name_,
            last_name=last_name_,
            vcard=vcard_,
            reply_markup=reply_markup_
        )

class BotInlineMessageMediaInvoice(TLObject, family='TypeBotInlineMessage'):
    """
    Send an invoice
    """

    _id = 0X354A9B09
    _group_id = 0X54822C1B

    def __init__(
        self,
        title: str,
        description: str,
        currency: str,
        total_amount: int,
        shipping_address_requested: bool = False,
        test: bool = False,
        photo: Optional['TypeWebDocument'] = None,
        reply_markup: Optional['TypeReplyMarkup'] = None
    ):

        """
        Send an invoice

        Args:
            title (str): Product name, 1-32 characters
            description (str): Product description, 1-255 characters
            currency (str): Three-letter ISO 4217 [currency](https://core.telegram.org/bots/payments#supported-currencies) code, or XTR for [Telegram Stars](https://core.telegram.org/api/stars).
            total_amount (int): Total price in the smallest units of the currency (integer, not float/double). For example, for a price of US$ 1.45 pass amount = 145. See the exp parameter in [currencies.json](https://core.telegram.org/bots/payments/currencies.json), it shows the number of digits past the decimal point for each currency (2 for the majority of currencies).
            shipping_address_requested (bool, optional): Set this flag if you require the user's shipping address to complete the order
            test (bool, optional): Test invoice
            photo (Optional['TypeWebDocument'], optional): Product photo
            reply_markup (Optional['TypeReplyMarkup'], optional): Inline keyboard
        """

        self.title = title
        self.description = description
        self.currency = currency
        self.total_amount = total_amount
        self.shipping_address_requested = shipping_address_requested
        self.test = test
        self.photo = photo
        self.reply_markup = reply_markup

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\t\x9bJ5' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.shipping_address_requested, 1)
                flags(self.test, 3)
                writer.string(self.title)
                writer.string(self.description)

                if flags(self.photo, 0):
                    writer.object(
                        self.photo,
                        group_id=0XCDE930D7
                    )
                writer.string(self.currency)
                writer.long(self.total_amount)

                if flags(self.reply_markup, 2):
                    writer.object(
                        self.reply_markup,
                        group_id=0X146C1631
                    )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        title_ = reader.string()
        description_ = reader.string()
        photo_ = (
            reader.object(
                group_id=0XCDE930D7
            )
            if flags(0) else None
        )

        currency_ = reader.string()
        total_amount_ = reader.long()
        reply_markup_ = (
            reader.object(
                group_id=0X146C1631
            )
            if flags(2) else None
        )

        return cls(
            title=title_,
            description=description_,
            currency=currency_,
            total_amount=total_amount_,
            shipping_address_requested=flags(1),
            test=flags(3),
            photo=photo_,
            reply_markup=reply_markup_
        )

class BotInlineMessageMediaWebPage(TLObject, family='TypeBotInlineMessage'):
    """
    Specifies options that must be used to generate the link preview for the message, or even a standalone link preview without an attached message.
    """

    _id = 0X809AD9A6
    _group_id = 0X54822C1B

    def __init__(
        self,
        message: str,
        url: str,
        invert_media: bool = False,
        force_large_media: bool = False,
        force_small_media: bool = False,
        manual: bool = False,
        safe: bool = False,
        entities: Optional[List['TypeMessageEntity']] = None,
        reply_markup: Optional['TypeReplyMarkup'] = None
    ):

        """
        Specifies options that must be used to generate the link preview for the message, or even a standalone link preview without an attached message.

        Args:
            message (str): The message, can be empty.
            url (str): The URL to use for the link preview.
            invert_media (bool, optional): If set, any eventual webpage preview will be shown on top of the message instead of at the bottom.
            force_large_media (bool, optional): If set, specifies that a large media preview should be used.
            force_small_media (bool, optional): If set, specifies that a small media preview should be used.
            manual (bool, optional): If set, indicates that the URL used for the webpage preview was specified manually using [inputMediaWebPage](https://core.telegram.org/constructor/inputMediaWebPage), and may not be related to any of the URLs specified in the message.
            safe (bool, optional): If set, the link can be opened directly without user confirmation.
            entities (Optional[List['TypeMessageEntity']], optional): [Message entities for styled text](https://core.telegram.org/api/entities)
            reply_markup (Optional['TypeReplyMarkup'], optional): Reply markup for sending bot buttons
        """

        self.message = message
        self.url = url
        self.invert_media = invert_media
        self.force_large_media = force_large_media
        self.force_small_media = force_small_media
        self.manual = manual
        self.safe = safe
        self.entities = entities
        self.reply_markup = reply_markup

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xa6\xd9\x9a\x80' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.invert_media, 3)
                flags(self.force_large_media, 4)
                flags(self.force_small_media, 5)
                flags(self.manual, 7)
                flags(self.safe, 8)
                writer.string(self.message)

                if flags(self.entities, 1):
                    writer.vector(
                        self.entities,
                        lambda value: writer.object(
                            value,
                            group_id=0X3CDFF38A
                        )
                    )
                writer.string(self.url)

                if flags(self.reply_markup, 2):
                    writer.object(
                        self.reply_markup,
                        group_id=0X146C1631
                    )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        message_ = reader.string()
        entities_ = (
            reader.vector(
                lambda: reader.object(
                    group_id=0X3CDFF38A
                )
            )
            if flags(1) else None
        )

        url_ = reader.string()
        reply_markup_ = (
            reader.object(
                group_id=0X146C1631
            )
            if flags(2) else None
        )

        return cls(
            message=message_,
            url=url_,
            invert_media=flags(3),
            force_large_media=flags(4),
            force_small_media=flags(5),
            manual=flags(7),
            safe=flags(8),
            entities=entities_,
            reply_markup=reply_markup_
        )

TypeBotInlineMessage = Union[
    BotInlineMessageMediaAuto,
    BotInlineMessageText,
    BotInlineMessageMediaGeo,
    BotInlineMessageMediaVenue,
    BotInlineMessageMediaContact,
    BotInlineMessageMediaInvoice,
    BotInlineMessageMediaWebPage
]