
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import Union, TYPE_CHECKING, List
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from .message_range import TypeMessageRange
    from ...gadgets.byteutils import Reader


class ChannelMessagesFilterEmpty(TLObject, family='TypeChannelMessagesFilter'):
    """
    No filter
    """

    _id = 0X94D42EE7
    _group_id = 0X5833A075


    def to_bytes(self, boxed: bool=True):
        return b'\xe7.\xd4\x94' if boxed else b''

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        return cls()

class ChannelMessagesFilter(TLObject, family='TypeChannelMessagesFilter'):
    """
    Filter for getting only certain types of channel messages
    """

    _id = 0XCD77D957
    _group_id = 0X5833A075

    def __init__(
        self,
        ranges: List['TypeMessageRange'],
        exclude_new_messages: bool = False
    ):

        """
        Filter for getting only certain types of channel messages

        Args:
            ranges (List['TypeMessageRange']): A range of messages to fetch
            exclude_new_messages (bool, optional): Whether to exclude new messages from the search
        """

        self.ranges = ranges
        self.exclude_new_messages = exclude_new_messages

    def to_bytes(self, boxed: bool=True):
        with Writer(b'W\xd9w\xcd' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.exclude_new_messages, 1)
                writer.vector(
                    self.ranges,
                    lambda value: writer.object(
                        value,
                        group_id=0XBC5C5B65
                    )
                )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        ranges_ = reader.vector(
            lambda: reader.object(
                group_id=0XBC5C5B65
            )
        )

        return cls(
            ranges=ranges_,
            exclude_new_messages=flags(1)
        )

TypeChannelMessagesFilter = Union[
    ChannelMessagesFilterEmpty,
    ChannelMessagesFilter
]