
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import Union, TYPE_CHECKING, List
from ....gadgets.tlobject import TLObject
from ....gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ..chat import TypeChat
    from ..user import TypeUser
    from ..channel_participant import TypeChannelParticipant
    from ....gadgets.byteutils import Reader


class ChannelParticipants(TLObject, family='TypeChannelsChannelParticipants'):
    """
    Represents multiple channel participants
    """

    _id = 0X9AB0FEAF
    _group_id = 0X5A75AC6A

    def __init__(
        self,
        count: int,
        participants: List['TypeChannelParticipant'],
        chats: List['TypeChat'],
        users: List['TypeUser']
    ):

        """
        Represents multiple channel participants

        Args:
            count (int): Total number of participants that correspond to the given query
            participants (List['TypeChannelParticipant']): Participants
            chats (List['TypeChat']): Mentioned chats
            users (List['TypeUser']): Users mentioned in participant info
        """

        self.count = count
        self.participants = participants
        self.chats = chats
        self.users = users

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xaf\xfe\xb0\x9a' if boxed else b'') as writer:
            writer.int(self.count)
            writer.vector(
                self.participants,
                lambda value: writer.object(
                    value,
                    group_id=0X21CCC4A0
                )
            )
            writer.vector(
                self.chats,
                lambda value: writer.object(
                    value,
                    group_id=0X73A5C0D9
                )
            )
            writer.vector(
                self.users,
                lambda value: writer.object(
                    value,
                    group_id=0X9BABE43A
                )
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        count_ = reader.int()
        participants_ = reader.vector(
            lambda: reader.object(
                group_id=0X21CCC4A0
            )
        )

        chats_ = reader.vector(
            lambda: reader.object(
                group_id=0X73A5C0D9
            )
        )

        users_ = reader.vector(
            lambda: reader.object(
                group_id=0X9BABE43A
            )
        )

        return cls(
            count=count_,
            participants=participants_,
            chats=chats_,
            users=users_
        )

class ChannelParticipantsNotModified(TLObject, family='TypeChannelsChannelParticipants'):
    """
    No new participant info could be found
    """

    _id = 0XF0173FE9
    _group_id = 0X5A75AC6A


    def to_bytes(self, boxed: bool=True):
        return b'\xe9?\x17\xf0' if boxed else b''

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        return cls()

TypeChannelsChannelParticipants = Union[
    ChannelParticipants,
    ChannelParticipantsNotModified
]