
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import Union, TYPE_CHECKING, Optional, List
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from .peer import TypePeer
    from .photo import TypePhoto
    from .bot_info import TypeBotInfo
    from .wall_paper import TypeWallPaper
    from .sticker_set import TypeStickerSet
    from .profile_tab import TypeProfileTab
    from .peer_stories import TypePeerStories
    from .chat_reactions import TypeChatReactions
    from .input_group_call import TypeInputGroupCall
    from .channel_location import TypeChannelLocation
    from .bot_verification import TypeBotVerification
    from .chat_participants import TypeChatParticipants
    from ...gadgets.byteutils import Reader
    from .peer_notify_settings import TypePeerNotifySettings
    from .exported_chat_invite import TypeExportedChatInvite


class ChatFull(TLObject, family='TypeChatFull'):
    """
    Full info about a [basic group](https://core.telegram.org/api/channel#basic-groups).
    """

    _id = 0X2633421B
    _group_id = 0X90C273E7

    def __init__(
        self,
        id: int,
        about: str,
        participants: 'TypeChatParticipants',
        notify_settings: 'TypePeerNotifySettings',
        can_set_username: bool = False,
        has_scheduled: bool = False,
        translations_disabled: bool = False,
        chat_photo: Optional['TypePhoto'] = None,
        exported_invite: Optional['TypeExportedChatInvite'] = None,
        bot_info: Optional[List['TypeBotInfo']] = None,
        pinned_msg_id: Optional[int] = None,
        folder_id: Optional[int] = None,
        call: Optional['TypeInputGroupCall'] = None,
        ttl_period: Optional[int] = None,
        groupcall_default_join_as: Optional['TypePeer'] = None,
        theme_emoticon: Optional[str] = None,
        requests_pending: Optional[int] = None,
        recent_requesters: Optional[List[int]] = None,
        available_reactions: Optional['TypeChatReactions'] = None,
        reactions_limit: Optional[int] = None
    ):

        """
        Full info about a [basic group](https://core.telegram.org/api/channel#basic-groups).

        Args:
            id (int): ID of the chat
            about (str): About string for this chat
            participants ('TypeChatParticipants'): Participant list
            notify_settings ('TypePeerNotifySettings'): Notification settings
            can_set_username (bool, optional): Can we change the username of this chat
            has_scheduled (bool, optional): Whether [scheduled messages](https://core.telegram.org/api/scheduled-messages) are available
            translations_disabled (bool, optional): Whether the [real-time chat translation popup](https://core.telegram.org/api/translation) should be hidden.
            chat_photo (Optional['TypePhoto'], optional): Chat photo
            exported_invite (Optional['TypeExportedChatInvite'], optional): Chat invite
            bot_info (Optional[List['TypeBotInfo']], optional): Info about bots that are in this chat
            pinned_msg_id (Optional[int], optional): Message ID of the last [pinned message](https://core.telegram.org/api/pin)
            folder_id (Optional[int], optional): [Peer folder ID, for more info click here](https://core.telegram.org/api/folders#peer-folders)
            call (Optional['TypeInputGroupCall'], optional): Group call information
            ttl_period (Optional[int], optional): Time-To-Live of messages sent by the current user to this chat
            groupcall_default_join_as (Optional['TypePeer'], optional): When using [phone.getGroupCallJoinAs](https://core.telegram.org/method/phone.getGroupCallJoinAs) to get a list of peers that can be used to join a group call, this field indicates the peer that should be selected by default.
            theme_emoticon (Optional[str], optional): Emoji representing a specific chat theme
            requests_pending (Optional[int], optional): Pending [join requests](https://core.telegram.org/api/invites#join-requests)
            recent_requesters (Optional[List[int]], optional): IDs of users who requested to join recently
            available_reactions (Optional['TypeChatReactions'], optional): Allowed [message reactions](https://core.telegram.org/api/reactions)
            reactions_limit (Optional[int], optional): This flag may be used to impose a custom limit of unique reactions (i.e. a customizable version of [appConfig.reactions_uniq_max](https://core.telegram.org/api/config#reactions-uniq-max)).
        """

        self.id = id
        self.about = about
        self.participants = participants
        self.notify_settings = notify_settings
        self.can_set_username = can_set_username
        self.has_scheduled = has_scheduled
        self.translations_disabled = translations_disabled
        self.chat_photo = chat_photo
        self.exported_invite = exported_invite
        self.bot_info = bot_info
        self.pinned_msg_id = pinned_msg_id
        self.folder_id = folder_id
        self.call = call
        self.ttl_period = ttl_period
        self.groupcall_default_join_as = groupcall_default_join_as
        self.theme_emoticon = theme_emoticon
        self.requests_pending = requests_pending
        self.recent_requesters = recent_requesters
        self.available_reactions = available_reactions
        self.reactions_limit = reactions_limit

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x1bB3&' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.can_set_username, 7)
                flags(self.has_scheduled, 8)
                flags(self.translations_disabled, 19)
                writer.long(self.id)
                writer.string(self.about)
                writer.object(
                    self.participants,
                    group_id=0X8FBBB6E2
                )

                if flags(self.chat_photo, 2):
                    writer.object(
                        self.chat_photo,
                        group_id=0XDDAD9CAC
                    )
                writer.object(
                    self.notify_settings,
                    group_id=0X372BF8CC
                )

                if flags(self.exported_invite, 13):
                    writer.object(
                        self.exported_invite,
                        group_id=0X4C7FB2E0
                    )

                if flags(self.bot_info, 3):
                    writer.vector(
                        self.bot_info,
                        lambda value: writer.object(
                            value,
                            group_id=0XAD8F02B7
                        )
                    )

                if flags(self.pinned_msg_id, 6):
                    writer.int(self.pinned_msg_id)

                if flags(self.folder_id, 11):
                    writer.int(self.folder_id)

                if flags(self.call, 12):
                    writer.object(
                        self.call,
                        group_id=0XDA9A559A
                    )

                if flags(self.ttl_period, 14):
                    writer.int(self.ttl_period)

                if flags(self.groupcall_default_join_as, 15):
                    writer.object(
                        self.groupcall_default_join_as,
                        group_id=0XB4DECBCA
                    )

                if flags(self.theme_emoticon, 16):
                    writer.string(self.theme_emoticon)

                if flags(self.requests_pending, 17):
                    writer.int(self.requests_pending)

                if flags(self.recent_requesters, 17):
                    writer.vector(
                        self.recent_requesters,
                        writer.long
                    )

                if flags(self.available_reactions, 18):
                    writer.object(
                        self.available_reactions,
                        group_id=0XE0A5CEE3
                    )

                if flags(self.reactions_limit, 20):
                    writer.int(self.reactions_limit)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        id_ = reader.long()
        about_ = reader.string()
        participants_ = reader.object(
            group_id=0X8FBBB6E2
        )

        chat_photo_ = (
            reader.object(
                group_id=0XDDAD9CAC
            )
            if flags(2) else None
        )

        notify_settings_ = reader.object(
            group_id=0X372BF8CC
        )

        exported_invite_ = (
            reader.object(
                group_id=0X4C7FB2E0
            )
            if flags(13) else None
        )

        bot_info_ = (
            reader.vector(
                lambda: reader.object(
                    group_id=0XAD8F02B7
                )
            )
            if flags(3) else None
        )

        pinned_msg_id_ = (
            reader.int()
            if flags(6) else None
        )

        folder_id_ = (
            reader.int()
            if flags(11) else None
        )

        call_ = (
            reader.object(
                group_id=0XDA9A559A
            )
            if flags(12) else None
        )

        ttl_period_ = (
            reader.int()
            if flags(14) else None
        )

        groupcall_default_join_as_ = (
            reader.object(
                group_id=0XB4DECBCA
            )
            if flags(15) else None
        )

        theme_emoticon_ = (
            reader.string()
            if flags(16) else None
        )

        requests_pending_ = (
            reader.int()
            if flags(17) else None
        )

        recent_requesters_ = (
            reader.vector(
                reader.long
            )
            if flags(17) else None
        )

        available_reactions_ = (
            reader.object(
                group_id=0XE0A5CEE3
            )
            if flags(18) else None
        )

        reactions_limit_ = (
            reader.int()
            if flags(20) else None
        )

        return cls(
            id=id_,
            about=about_,
            participants=participants_,
            notify_settings=notify_settings_,
            can_set_username=flags(7),
            has_scheduled=flags(8),
            translations_disabled=flags(19),
            chat_photo=chat_photo_,
            exported_invite=exported_invite_,
            bot_info=bot_info_,
            pinned_msg_id=pinned_msg_id_,
            folder_id=folder_id_,
            call=call_,
            ttl_period=ttl_period_,
            groupcall_default_join_as=groupcall_default_join_as_,
            theme_emoticon=theme_emoticon_,
            requests_pending=requests_pending_,
            recent_requesters=recent_requesters_,
            available_reactions=available_reactions_,
            reactions_limit=reactions_limit_
        )

class ChannelFull(TLObject, family='TypeChatFull'):
    """
    Full info about a [channel](https://core.telegram.org/api/channel#channels), [supergroup](https://core.telegram.org/api/channel#supergroups) or [gigagroup](https://core.telegram.org/api/channel#gigagroups).
    """

    _id = 0XE4E0B29D
    _group_id = 0X90C273E7

    def __init__(
        self,
        id: int,
        about: str,
        read_inbox_max_id: int,
        read_outbox_max_id: int,
        unread_count: int,
        chat_photo: 'TypePhoto',
        notify_settings: 'TypePeerNotifySettings',
        bot_info: List['TypeBotInfo'],
        pts: int,
        can_view_participants: bool = False,
        can_set_username: bool = False,
        can_set_stickers: bool = False,
        hidden_prehistory: bool = False,
        can_set_location: bool = False,
        has_scheduled: bool = False,
        can_view_stats: bool = False,
        blocked: bool = False,
        can_delete_channel: bool = False,
        antispam: bool = False,
        participants_hidden: bool = False,
        translations_disabled: bool = False,
        stories_pinned_available: bool = False,
        view_forum_as_messages: bool = False,
        restricted_sponsored: bool = False,
        can_view_revenue: bool = False,
        paid_media_allowed: bool = False,
        can_view_stars_revenue: bool = False,
        paid_reactions_available: bool = False,
        stargifts_available: bool = False,
        paid_messages_available: bool = False,
        participants_count: Optional[int] = None,
        admins_count: Optional[int] = None,
        kicked_count: Optional[int] = None,
        banned_count: Optional[int] = None,
        online_count: Optional[int] = None,
        exported_invite: Optional['TypeExportedChatInvite'] = None,
        migrated_from_chat_id: Optional[int] = None,
        migrated_from_max_id: Optional[int] = None,
        pinned_msg_id: Optional[int] = None,
        stickerset: Optional['TypeStickerSet'] = None,
        available_min_id: Optional[int] = None,
        folder_id: Optional[int] = None,
        linked_chat_id: Optional[int] = None,
        location: Optional['TypeChannelLocation'] = None,
        slowmode_seconds: Optional[int] = None,
        slowmode_next_send_date: Optional[int] = None,
        stats_dc: Optional[int] = None,
        call: Optional['TypeInputGroupCall'] = None,
        ttl_period: Optional[int] = None,
        pending_suggestions: Optional[List[str]] = None,
        groupcall_default_join_as: Optional['TypePeer'] = None,
        theme_emoticon: Optional[str] = None,
        requests_pending: Optional[int] = None,
        recent_requesters: Optional[List[int]] = None,
        default_send_as: Optional['TypePeer'] = None,
        available_reactions: Optional['TypeChatReactions'] = None,
        reactions_limit: Optional[int] = None,
        stories: Optional['TypePeerStories'] = None,
        wallpaper: Optional['TypeWallPaper'] = None,
        boosts_applied: Optional[int] = None,
        boosts_unrestrict: Optional[int] = None,
        emojiset: Optional['TypeStickerSet'] = None,
        bot_verification: Optional['TypeBotVerification'] = None,
        stargifts_count: Optional[int] = None,
        send_paid_messages_stars: Optional[int] = None,
        main_tab: Optional['TypeProfileTab'] = None
    ):

        """
        Full info about a [channel](https://core.telegram.org/api/channel#channels), [supergroup](https://core.telegram.org/api/channel#supergroups) or [gigagroup](https://core.telegram.org/api/channel#gigagroups).

        Args:
            id (int): ID of the channel
            about (str): Info about the channel
            read_inbox_max_id (int): Position up to which all incoming messages are read.
            read_outbox_max_id (int): Position up to which all outgoing messages are read.
            unread_count (int): Count of unread messages
            chat_photo ('TypePhoto'): Channel picture
            notify_settings ('TypePeerNotifySettings'): Notification settings
            bot_info (List['TypeBotInfo']): Info about bots in the channel/supergroup
            pts (int): Latest [PTS](https://core.telegram.org/api/updates) for this channel
            can_view_participants (bool, optional): Can we view the participant list?
            can_set_username (bool, optional): Can we set the channel's username?
            can_set_stickers (bool, optional): Can we [associate](https://core.telegram.org/method/channels.setStickers) a stickerpack to the supergroup?
            hidden_prehistory (bool, optional): Is the history before we joined hidden to us?
            can_set_location (bool, optional): Can we set the geolocation of this group (for geogroups)
            has_scheduled (bool, optional): Whether scheduled messages are available
            can_view_stats (bool, optional): Can the user view [channel/supergroup statistics](https://core.telegram.org/api/stats)
            blocked (bool, optional): Whether any anonymous admin of this supergroup was blocked: if set, you won't receive messages from anonymous group admins in [discussion replies via @replies](https://core.telegram.org/api/discussion)
            can_delete_channel (bool, optional): Can we delete this channel?
            antispam (bool, optional): Whether [native antispam](https://core.telegram.org/api/antispam) functionality is enabled in this supergroup.
            participants_hidden (bool, optional): Whether the participant list is hidden.
            translations_disabled (bool, optional): Whether the [real-time chat translation popup](https://core.telegram.org/api/translation) should be hidden.
            stories_pinned_available (bool, optional): Whether this user has some [pinned stories](https://core.telegram.org/api/stories#pinned-or-archived-stories).
            view_forum_as_messages (bool, optional): Users may also choose to display messages from all topics of a [forum](https://core.telegram.org/api/forum) as if they were sent to a normal group, using a "View as messages" setting in the local client.  This setting only affects the current account, and is synced to other logged in sessions using the [channels.toggleViewForumAsMessages](https://core.telegram.org/method/channels.toggleViewForumAsMessages) method; invoking this method will update the value of this flag.
            restricted_sponsored (bool, optional): Whether ads on this channel were [disabled as specified here](https://core.telegram.org/api/boost#disable-ads-on-the-channel) (this flag is only visible to the owner of the channel).
            can_view_revenue (bool, optional): If set, this user can view [ad revenue statistics](https://core.telegram.org/api/revenue#revenue-statistics) for this channel.
            paid_media_allowed (bool, optional): Whether the current user can send or forward [paid media](https://core.telegram.org/api/paid-media) to this channel.
            can_view_stars_revenue (bool, optional): If set, this user can view [Telegram Star revenue statistics](https://core.telegram.org/api/stars#revenue-statistics) for this channel.
            paid_reactions_available (bool, optional): If set, users may send [paid Telegram Star reactions](https://core.telegram.org/api/reactions#paid-reactions) to messages of this channel.
            stargifts_available (bool, optional): ...
            paid_messages_available (bool, optional): ...
            participants_count (Optional[int], optional): Number of participants of the channel
            admins_count (Optional[int], optional): Number of channel admins
            kicked_count (Optional[int], optional): Number of users [kicked](https://core.telegram.org/api/rights) from the channel
            banned_count (Optional[int], optional): Number of users [banned](https://core.telegram.org/api/rights) from the channel
            online_count (Optional[int], optional): Number of users currently online
            exported_invite (Optional['TypeExportedChatInvite'], optional): Invite link
            migrated_from_chat_id (Optional[int], optional): The chat ID from which this group was [migrated](https://core.telegram.org/api/channel)
            migrated_from_max_id (Optional[int], optional): The message ID in the original chat at which this group was [migrated](https://core.telegram.org/api/channel)
            pinned_msg_id (Optional[int], optional): Message ID of the last [pinned message](https://core.telegram.org/api/pin)
            stickerset (Optional['TypeStickerSet'], optional): Associated stickerset
            available_min_id (Optional[int], optional): Identifier of a maximum unavailable message in a channel due to hidden history.
            folder_id (Optional[int], optional): [Peer folder ID, for more info click here](https://core.telegram.org/api/folders#peer-folders)
            linked_chat_id (Optional[int], optional): ID of the linked [discussion chat](https://core.telegram.org/api/discussion) for channels (and vice versa, the ID of the linked channel for discussion chats).
            location (Optional['TypeChannelLocation'], optional): Location of the geogroup
            slowmode_seconds (Optional[int], optional): If specified, users in supergroups will only be able to send one message every slowmode_seconds seconds
            slowmode_next_send_date (Optional[int], optional): Indicates when the user will be allowed to send another message in the supergroup (unixtime)
            stats_dc (Optional[int], optional): If set, specifies the DC to use for fetching channel statistics
            call (Optional['TypeInputGroupCall'], optional): Livestream or group call information
            ttl_period (Optional[int], optional): Time-To-Live of messages in this channel or supergroup
            pending_suggestions (Optional[List[str]], optional): A list of [suggested actions](https://core.telegram.org/api/config#suggestions) for the supergroup admin, [see here for more info](https://core.telegram.org/api/config#suggestions).
            groupcall_default_join_as (Optional['TypePeer'], optional): When using [phone.getGroupCallJoinAs](https://core.telegram.org/method/phone.getGroupCallJoinAs) to get a list of peers that can be used to join a group call, this field indicates the peer that should be selected by default.
            theme_emoticon (Optional[str], optional): Emoji representing a specific chat theme
            requests_pending (Optional[int], optional): Pending [join requests](https://core.telegram.org/api/invites#join-requests)
            recent_requesters (Optional[List[int]], optional): IDs of users who requested to join recently
            default_send_as (Optional['TypePeer'], optional): Default peer used for sending messages to this channel
            available_reactions (Optional['TypeChatReactions'], optional): Allowed [message reactions](https://core.telegram.org/api/reactions)
            reactions_limit (Optional[int], optional): This flag may be used to impose a custom limit of unique reactions (i.e. a customizable version of [appConfig.reactions_uniq_max](https://core.telegram.org/api/config#reactions-uniq-max)).
            stories (Optional['TypePeerStories'], optional): Channel [stories](https://core.telegram.org/api/stories)
            wallpaper (Optional['TypeWallPaper'], optional): [Wallpaper](https://core.telegram.org/api/wallpapers)
            boosts_applied (Optional[int], optional): The number of [boosts](https://core.telegram.org/api/boost) the current user has applied to the current supergroup.
            boosts_unrestrict (Optional[int], optional): The number of [boosts](https://core.telegram.org/api/boost) this supergroup requires to bypass slowmode and other restrictions, see [here](https://core.telegram.org/api/boost#bypass-slowmode-and-chat-restrictions) for more info.
            emojiset (Optional['TypeStickerSet'], optional): [Custom emoji stickerset](https://core.telegram.org/api/custom-emoji) associated to the current supergroup, set using [channels.setEmojiStickers](https://core.telegram.org/method/channels.setEmojiStickers) after reaching the appropriate boost level, see [here](https://core.telegram.org/api/boost#setting-a-custom-emoji-stickerset-for-supergroups) for more info.
            bot_verification (Optional['TypeBotVerification'], optional): ...
            stargifts_count (Optional[int], optional): ...
            send_paid_messages_stars (Optional[int], optional): ...
            main_tab (Optional['TypeProfileTab'], optional): ...
        """

        self.id = id
        self.about = about
        self.read_inbox_max_id = read_inbox_max_id
        self.read_outbox_max_id = read_outbox_max_id
        self.unread_count = unread_count
        self.chat_photo = chat_photo
        self.notify_settings = notify_settings
        self.bot_info = bot_info
        self.pts = pts
        self.can_view_participants = can_view_participants
        self.can_set_username = can_set_username
        self.can_set_stickers = can_set_stickers
        self.hidden_prehistory = hidden_prehistory
        self.can_set_location = can_set_location
        self.has_scheduled = has_scheduled
        self.can_view_stats = can_view_stats
        self.blocked = blocked
        self.can_delete_channel = can_delete_channel
        self.antispam = antispam
        self.participants_hidden = participants_hidden
        self.translations_disabled = translations_disabled
        self.stories_pinned_available = stories_pinned_available
        self.view_forum_as_messages = view_forum_as_messages
        self.restricted_sponsored = restricted_sponsored
        self.can_view_revenue = can_view_revenue
        self.paid_media_allowed = paid_media_allowed
        self.can_view_stars_revenue = can_view_stars_revenue
        self.paid_reactions_available = paid_reactions_available
        self.stargifts_available = stargifts_available
        self.paid_messages_available = paid_messages_available
        self.participants_count = participants_count
        self.admins_count = admins_count
        self.kicked_count = kicked_count
        self.banned_count = banned_count
        self.online_count = online_count
        self.exported_invite = exported_invite
        self.migrated_from_chat_id = migrated_from_chat_id
        self.migrated_from_max_id = migrated_from_max_id
        self.pinned_msg_id = pinned_msg_id
        self.stickerset = stickerset
        self.available_min_id = available_min_id
        self.folder_id = folder_id
        self.linked_chat_id = linked_chat_id
        self.location = location
        self.slowmode_seconds = slowmode_seconds
        self.slowmode_next_send_date = slowmode_next_send_date
        self.stats_dc = stats_dc
        self.call = call
        self.ttl_period = ttl_period
        self.pending_suggestions = pending_suggestions
        self.groupcall_default_join_as = groupcall_default_join_as
        self.theme_emoticon = theme_emoticon
        self.requests_pending = requests_pending
        self.recent_requesters = recent_requesters
        self.default_send_as = default_send_as
        self.available_reactions = available_reactions
        self.reactions_limit = reactions_limit
        self.stories = stories
        self.wallpaper = wallpaper
        self.boosts_applied = boosts_applied
        self.boosts_unrestrict = boosts_unrestrict
        self.emojiset = emojiset
        self.bot_verification = bot_verification
        self.stargifts_count = stargifts_count
        self.send_paid_messages_stars = send_paid_messages_stars
        self.main_tab = main_tab

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x9d\xb2\xe0\xe4' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.can_view_participants, 3)
                flags(self.can_set_username, 6)
                flags(self.can_set_stickers, 7)
                flags(self.hidden_prehistory, 10)
                flags(self.can_set_location, 16)
                flags(self.has_scheduled, 19)
                flags(self.can_view_stats, 20)
                flags(self.blocked, 22)

                with writer.flag() as flags2:
                    flags2(self.can_delete_channel, 0)
                    flags2(self.antispam, 1)
                    flags2(self.participants_hidden, 2)
                    flags2(self.translations_disabled, 3)
                    flags2(self.stories_pinned_available, 5)
                    flags2(self.view_forum_as_messages, 6)
                    flags2(self.restricted_sponsored, 11)
                    flags2(self.can_view_revenue, 12)
                    flags2(self.paid_media_allowed, 14)
                    flags2(self.can_view_stars_revenue, 15)
                    flags2(self.paid_reactions_available, 16)
                    flags2(self.stargifts_available, 19)
                    flags2(self.paid_messages_available, 20)
                    writer.long(self.id)
                    writer.string(self.about)

                    if flags(self.participants_count, 0):
                        writer.int(self.participants_count)

                    if flags(self.admins_count, 1):
                        writer.int(self.admins_count)

                    if flags(self.kicked_count, 2):
                        writer.int(self.kicked_count)

                    if flags(self.banned_count, 2):
                        writer.int(self.banned_count)

                    if flags(self.online_count, 13):
                        writer.int(self.online_count)
                    writer.int(self.read_inbox_max_id)
                    writer.int(self.read_outbox_max_id)
                    writer.int(self.unread_count)
                    writer.object(
                        self.chat_photo,
                        group_id=0XDDAD9CAC
                    )
                    writer.object(
                        self.notify_settings,
                        group_id=0X372BF8CC
                    )

                    if flags(self.exported_invite, 23):
                        writer.object(
                            self.exported_invite,
                            group_id=0X4C7FB2E0
                        )
                    writer.vector(
                        self.bot_info,
                        lambda value: writer.object(
                            value,
                            group_id=0XAD8F02B7
                        )
                    )

                    if flags(self.migrated_from_chat_id, 4):
                        writer.long(self.migrated_from_chat_id)

                    if flags(self.migrated_from_max_id, 4):
                        writer.int(self.migrated_from_max_id)

                    if flags(self.pinned_msg_id, 5):
                        writer.int(self.pinned_msg_id)

                    if flags(self.stickerset, 8):
                        writer.object(
                            self.stickerset,
                            group_id=0X8EED6744
                        )

                    if flags(self.available_min_id, 9):
                        writer.int(self.available_min_id)

                    if flags(self.folder_id, 11):
                        writer.int(self.folder_id)

                    if flags(self.linked_chat_id, 14):
                        writer.long(self.linked_chat_id)

                    if flags(self.location, 15):
                        writer.object(
                            self.location,
                            group_id=0X40180970
                        )

                    if flags(self.slowmode_seconds, 17):
                        writer.int(self.slowmode_seconds)

                    if flags(self.slowmode_next_send_date, 18):
                        writer.int(self.slowmode_next_send_date)

                    if flags(self.stats_dc, 12):
                        writer.int(self.stats_dc)
                    writer.int(self.pts)

                    if flags(self.call, 21):
                        writer.object(
                            self.call,
                            group_id=0XDA9A559A
                        )

                    if flags(self.ttl_period, 24):
                        writer.int(self.ttl_period)

                    if flags(self.pending_suggestions, 25):
                        writer.vector(
                            self.pending_suggestions,
                            writer.string
                        )

                    if flags(self.groupcall_default_join_as, 26):
                        writer.object(
                            self.groupcall_default_join_as,
                            group_id=0XB4DECBCA
                        )

                    if flags(self.theme_emoticon, 27):
                        writer.string(self.theme_emoticon)

                    if flags(self.requests_pending, 28):
                        writer.int(self.requests_pending)

                    if flags(self.recent_requesters, 28):
                        writer.vector(
                            self.recent_requesters,
                            writer.long
                        )

                    if flags(self.default_send_as, 29):
                        writer.object(
                            self.default_send_as,
                            group_id=0XB4DECBCA
                        )

                    if flags(self.available_reactions, 30):
                        writer.object(
                            self.available_reactions,
                            group_id=0XE0A5CEE3
                        )

                    if flags2(self.reactions_limit, 13):
                        writer.int(self.reactions_limit)

                    if flags2(self.stories, 4):
                        writer.object(
                            self.stories,
                            group_id=0XE4A19284
                        )

                    if flags2(self.wallpaper, 7):
                        writer.object(
                            self.wallpaper,
                            group_id=0XC6E3E0E2
                        )

                    if flags2(self.boosts_applied, 8):
                        writer.int(self.boosts_applied)

                    if flags2(self.boosts_unrestrict, 9):
                        writer.int(self.boosts_unrestrict)

                    if flags2(self.emojiset, 10):
                        writer.object(
                            self.emojiset,
                            group_id=0X8EED6744
                        )

                    if flags2(self.bot_verification, 17):
                        writer.object(
                            self.bot_verification,
                            group_id=0X80813E55
                        )

                    if flags2(self.stargifts_count, 18):
                        writer.int(self.stargifts_count)

                    if flags2(self.send_paid_messages_stars, 21):
                        writer.long(self.send_paid_messages_stars)

                    if flags2(self.main_tab, 22):
                        writer.object(
                            self.main_tab,
                            group_id=0X9A764961
                        )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        flags2 = reader.flag()
        id_ = reader.long()
        about_ = reader.string()
        participants_count_ = (
            reader.int()
            if flags(0) else None
        )

        admins_count_ = (
            reader.int()
            if flags(1) else None
        )

        kicked_count_ = (
            reader.int()
            if flags(2) else None
        )

        banned_count_ = (
            reader.int()
            if flags(2) else None
        )

        online_count_ = (
            reader.int()
            if flags(13) else None
        )

        read_inbox_max_id_ = reader.int()
        read_outbox_max_id_ = reader.int()
        unread_count_ = reader.int()
        chat_photo_ = reader.object(
            group_id=0XDDAD9CAC
        )

        notify_settings_ = reader.object(
            group_id=0X372BF8CC
        )

        exported_invite_ = (
            reader.object(
                group_id=0X4C7FB2E0
            )
            if flags(23) else None
        )

        bot_info_ = reader.vector(
            lambda: reader.object(
                group_id=0XAD8F02B7
            )
        )

        migrated_from_chat_id_ = (
            reader.long()
            if flags(4) else None
        )

        migrated_from_max_id_ = (
            reader.int()
            if flags(4) else None
        )

        pinned_msg_id_ = (
            reader.int()
            if flags(5) else None
        )

        stickerset_ = (
            reader.object(
                group_id=0X8EED6744
            )
            if flags(8) else None
        )

        available_min_id_ = (
            reader.int()
            if flags(9) else None
        )

        folder_id_ = (
            reader.int()
            if flags(11) else None
        )

        linked_chat_id_ = (
            reader.long()
            if flags(14) else None
        )

        location_ = (
            reader.object(
                group_id=0X40180970
            )
            if flags(15) else None
        )

        slowmode_seconds_ = (
            reader.int()
            if flags(17) else None
        )

        slowmode_next_send_date_ = (
            reader.int()
            if flags(18) else None
        )

        stats_dc_ = (
            reader.int()
            if flags(12) else None
        )

        pts_ = reader.int()
        call_ = (
            reader.object(
                group_id=0XDA9A559A
            )
            if flags(21) else None
        )

        ttl_period_ = (
            reader.int()
            if flags(24) else None
        )

        pending_suggestions_ = (
            reader.vector(
                reader.string
            )
            if flags(25) else None
        )

        groupcall_default_join_as_ = (
            reader.object(
                group_id=0XB4DECBCA
            )
            if flags(26) else None
        )

        theme_emoticon_ = (
            reader.string()
            if flags(27) else None
        )

        requests_pending_ = (
            reader.int()
            if flags(28) else None
        )

        recent_requesters_ = (
            reader.vector(
                reader.long
            )
            if flags(28) else None
        )

        default_send_as_ = (
            reader.object(
                group_id=0XB4DECBCA
            )
            if flags(29) else None
        )

        available_reactions_ = (
            reader.object(
                group_id=0XE0A5CEE3
            )
            if flags(30) else None
        )

        reactions_limit_ = (
            reader.int()
            if flags2(13) else None
        )

        stories_ = (
            reader.object(
                group_id=0XE4A19284
            )
            if flags2(4) else None
        )

        wallpaper_ = (
            reader.object(
                group_id=0XC6E3E0E2
            )
            if flags2(7) else None
        )

        boosts_applied_ = (
            reader.int()
            if flags2(8) else None
        )

        boosts_unrestrict_ = (
            reader.int()
            if flags2(9) else None
        )

        emojiset_ = (
            reader.object(
                group_id=0X8EED6744
            )
            if flags2(10) else None
        )

        bot_verification_ = (
            reader.object(
                group_id=0X80813E55
            )
            if flags2(17) else None
        )

        stargifts_count_ = (
            reader.int()
            if flags2(18) else None
        )

        send_paid_messages_stars_ = (
            reader.long()
            if flags2(21) else None
        )

        main_tab_ = (
            reader.object(
                group_id=0X9A764961
            )
            if flags2(22) else None
        )

        return cls(
            id=id_,
            about=about_,
            read_inbox_max_id=read_inbox_max_id_,
            read_outbox_max_id=read_outbox_max_id_,
            unread_count=unread_count_,
            chat_photo=chat_photo_,
            notify_settings=notify_settings_,
            bot_info=bot_info_,
            pts=pts_,
            can_view_participants=flags(3),
            can_set_username=flags(6),
            can_set_stickers=flags(7),
            hidden_prehistory=flags(10),
            can_set_location=flags(16),
            has_scheduled=flags(19),
            can_view_stats=flags(20),
            blocked=flags(22),
            can_delete_channel=flags2(0),
            antispam=flags2(1),
            participants_hidden=flags2(2),
            translations_disabled=flags2(3),
            stories_pinned_available=flags2(5),
            view_forum_as_messages=flags2(6),
            restricted_sponsored=flags2(11),
            can_view_revenue=flags2(12),
            paid_media_allowed=flags2(14),
            can_view_stars_revenue=flags2(15),
            paid_reactions_available=flags2(16),
            stargifts_available=flags2(19),
            paid_messages_available=flags2(20),
            participants_count=participants_count_,
            admins_count=admins_count_,
            kicked_count=kicked_count_,
            banned_count=banned_count_,
            online_count=online_count_,
            exported_invite=exported_invite_,
            migrated_from_chat_id=migrated_from_chat_id_,
            migrated_from_max_id=migrated_from_max_id_,
            pinned_msg_id=pinned_msg_id_,
            stickerset=stickerset_,
            available_min_id=available_min_id_,
            folder_id=folder_id_,
            linked_chat_id=linked_chat_id_,
            location=location_,
            slowmode_seconds=slowmode_seconds_,
            slowmode_next_send_date=slowmode_next_send_date_,
            stats_dc=stats_dc_,
            call=call_,
            ttl_period=ttl_period_,
            pending_suggestions=pending_suggestions_,
            groupcall_default_join_as=groupcall_default_join_as_,
            theme_emoticon=theme_emoticon_,
            requests_pending=requests_pending_,
            recent_requesters=recent_requesters_,
            default_send_as=default_send_as_,
            available_reactions=available_reactions_,
            reactions_limit=reactions_limit_,
            stories=stories_,
            wallpaper=wallpaper_,
            boosts_applied=boosts_applied_,
            boosts_unrestrict=boosts_unrestrict_,
            emojiset=emojiset_,
            bot_verification=bot_verification_,
            stargifts_count=stargifts_count_,
            send_paid_messages_stars=send_paid_messages_stars_,
            main_tab=main_tab_
        )

TypeChatFull = Union[
    ChatFull,
    ChannelFull
]