
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import Union, TYPE_CHECKING
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ...gadgets.byteutils import Reader


class ChatParticipant(TLObject, family='TypeChatParticipant'):
    """
    Group member.
    """

    _id = 0XC02D4007
    _group_id = 0XD1426D89

    def __init__(
        self,
        user_id: int,
        inviter_id: int,
        date: int
    ):

        """
        Group member.

        Args:
            user_id (int): Member user ID
            inviter_id (int): ID of the user that added the member to the group
            date (int): Date added to the group
        """

        self.user_id = user_id
        self.inviter_id = inviter_id
        self.date = date

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x07@-\xc0' if boxed else b'') as writer:
            writer.long(self.user_id)
            writer.long(self.inviter_id)
            writer.int(self.date)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        user_id_ = reader.long()
        inviter_id_ = reader.long()
        date_ = reader.int()

        return cls(
            user_id=user_id_,
            inviter_id=inviter_id_,
            date=date_
        )

class ChatParticipantCreator(TLObject, family='TypeChatParticipant'):
    """
    Represents the creator of the group
    """

    _id = 0XE46BCEE4
    _group_id = 0XD1426D89

    def __init__(
        self,
        user_id: int
    ):

        """
        Represents the creator of the group

        Args:
            user_id (int): ID of the user that created the group
        """

        self.user_id = user_id

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xe4\xcek\xe4' if boxed else b'') as writer:
            writer.long(self.user_id)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        user_id_ = reader.long()

        return cls(
            user_id=user_id_
        )

class ChatParticipantAdmin(TLObject, family='TypeChatParticipant'):
    """
    Chat admin
    """

    _id = 0XA0933F5B
    _group_id = 0XD1426D89

    def __init__(
        self,
        user_id: int,
        inviter_id: int,
        date: int
    ):

        """
        Chat admin

        Args:
            user_id (int): ID of a group member that is admin
            inviter_id (int): ID of the user that added the member to the group
            date (int): Date when the user was added
        """

        self.user_id = user_id
        self.inviter_id = inviter_id
        self.date = date

    def to_bytes(self, boxed: bool=True):
        with Writer(b'[?\x93\xa0' if boxed else b'') as writer:
            writer.long(self.user_id)
            writer.long(self.inviter_id)
            writer.int(self.date)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        user_id_ = reader.long()
        inviter_id_ = reader.long()
        date_ = reader.int()

        return cls(
            user_id=user_id_,
            inviter_id=inviter_id_,
            date=date_
        )

TypeChatParticipant = Union[
    ChatParticipant,
    ChatParticipantCreator,
    ChatParticipantAdmin
]