
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import Union, TYPE_CHECKING, Optional, List
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from .chat_participant import TypeChatParticipant
    from ...gadgets.byteutils import Reader


class ChatParticipantsForbidden(TLObject, family='TypeChatParticipants'):
    """
    Info on members is unavailable
    """

    _id = 0X8763D3E1
    _group_id = 0X8FBBB6E2

    def __init__(
        self,
        chat_id: int,
        self_participant: Optional['TypeChatParticipant'] = None
    ):

        """
        Info on members is unavailable

        Args:
            chat_id (int): Group ID
            self_participant (Optional['TypeChatParticipant'], optional): Info about the group membership of the current user
        """

        self.chat_id = chat_id
        self.self_participant = self_participant

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xe1\xd3c\x87' if boxed else b'') as writer:
            with writer.flag() as flags:
                writer.long(self.chat_id)

                if flags(self.self_participant, 0):
                    writer.object(
                        self.self_participant,
                        group_id=0XD1426D89
                    )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        chat_id_ = reader.long()
        self_participant_ = (
            reader.object(
                group_id=0XD1426D89
            )
            if flags(0) else None
        )

        return cls(
            chat_id=chat_id_,
            self_participant=self_participant_
        )

class ChatParticipants(TLObject, family='TypeChatParticipants'):
    """
    Group members.
    """

    _id = 0X3CBC93F8
    _group_id = 0X8FBBB6E2

    def __init__(
        self,
        chat_id: int,
        participants: List['TypeChatParticipant'],
        version: int
    ):

        """
        Group members.

        Args:
            chat_id (int): Group identifier
            participants (List['TypeChatParticipant']): List of group members
            version (int): Group version number
        """

        self.chat_id = chat_id
        self.participants = participants
        self.version = version

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xf8\x93\xbc<' if boxed else b'') as writer:
            writer.long(self.chat_id)
            writer.vector(
                self.participants,
                lambda value: writer.object(
                    value,
                    group_id=0XD1426D89
                )
            )
            writer.int(self.version)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        chat_id_ = reader.long()
        participants_ = reader.vector(
            lambda: reader.object(
                group_id=0XD1426D89
            )
        )

        version_ = reader.int()

        return cls(
            chat_id=chat_id_,
            participants=participants_,
            version=version_
        )

TypeChatParticipants = Union[
    ChatParticipantsForbidden,
    ChatParticipants
]