
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import Union, TYPE_CHECKING, Optional
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from .mask_coords import TypeMaskCoords
    from .input_sticker_set import TypeInputStickerSet
    from ...gadgets.byteutils import Reader


class DocumentAttributeImageSize(TLObject, family='TypeDocumentAttribute'):
    """
    Defines the width and height of an image uploaded as document
    """

    _id = 0X6C37C15C
    _group_id = 0X9EBF3A46

    def __init__(
        self,
        w: int,
        h: int
    ):

        """
        Defines the width and height of an image uploaded as document

        Args:
            w (int): Width of image
            h (int): Height of image
        """

        self.w = w
        self.h = h

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\\\xc17l' if boxed else b'') as writer:
            writer.int(self.w)
            writer.int(self.h)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        w_ = reader.int()
        h_ = reader.int()

        return cls(
            w=w_,
            h=h_
        )

class DocumentAttributeAnimated(TLObject, family='TypeDocumentAttribute'):
    """
    Defines an animated GIF
    """

    _id = 0X11B58939
    _group_id = 0X9EBF3A46


    def to_bytes(self, boxed: bool=True):
        return b'9\x89\xb5\x11' if boxed else b''

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        return cls()

class DocumentAttributeSticker(TLObject, family='TypeDocumentAttribute'):
    """
    Defines a sticker
    """

    _id = 0X6319D612
    _group_id = 0X9EBF3A46

    def __init__(
        self,
        alt: str,
        stickerset: 'TypeInputStickerSet',
        mask: bool = False,
        mask_coords: Optional['TypeMaskCoords'] = None
    ):

        """
        Defines a sticker

        Args:
            alt (str): Alternative emoji representation of sticker
            stickerset ('TypeInputStickerSet'): Associated stickerset
            mask (bool, optional): Whether this is a mask sticker
            mask_coords (Optional['TypeMaskCoords'], optional): Mask coordinates (if this is a mask sticker, attached to a photo)
        """

        self.alt = alt
        self.stickerset = stickerset
        self.mask = mask
        self.mask_coords = mask_coords

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x12\xd6\x19c' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.mask, 1)
                writer.string(self.alt)
                writer.object(
                    self.stickerset,
                    group_id=0X919D8BA5
                )

                if flags(self.mask_coords, 0):
                    writer.object(
                        self.mask_coords,
                        group_id=0X32852A28
                    )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        alt_ = reader.string()
        stickerset_ = reader.object(
            group_id=0X919D8BA5
        )

        mask_coords_ = (
            reader.object(
                group_id=0X32852A28
            )
            if flags(0) else None
        )

        return cls(
            alt=alt_,
            stickerset=stickerset_,
            mask=flags(1),
            mask_coords=mask_coords_
        )

class DocumentAttributeVideo(TLObject, family='TypeDocumentAttribute'):
    """
    Defines a video
    """

    _id = 0X43C57C48
    _group_id = 0X9EBF3A46

    def __init__(
        self,
        duration: float,
        w: int,
        h: int,
        round_message: bool = False,
        supports_streaming: bool = False,
        nosound: bool = False,
        preload_prefix_size: Optional[int] = None,
        video_start_ts: Optional[float] = None,
        video_codec: Optional[str] = None
    ):

        """
        Defines a video

        Args:
            duration (float): Duration in seconds
            w (int): Video width
            h (int): Video height
            round_message (bool, optional): Whether this is a round video
            supports_streaming (bool, optional): Whether the video supports streaming
            nosound (bool, optional): Whether the specified document is a video file with no audio tracks (a GIF animation (even as MPEG4), for example)
            preload_prefix_size (Optional[int], optional): Number of bytes to preload when preloading videos (particularly [video stories](https://core.telegram.org/api/stories)).
            video_start_ts (Optional[float], optional): Floating point UNIX timestamp in seconds, indicating the frame of the video that should be used as static preview and thumbnail.
            video_codec (Optional[str], optional): Codec used for the video, i.e. "h264", "h265", or "av1"
        """

        self.duration = duration
        self.w = w
        self.h = h
        self.round_message = round_message
        self.supports_streaming = supports_streaming
        self.nosound = nosound
        self.preload_prefix_size = preload_prefix_size
        self.video_start_ts = video_start_ts
        self.video_codec = video_codec

    def to_bytes(self, boxed: bool=True):
        with Writer(b'H|\xc5C' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.round_message, 0)
                flags(self.supports_streaming, 1)
                flags(self.nosound, 3)
                writer.double(self.duration)
                writer.int(self.w)
                writer.int(self.h)

                if flags(self.preload_prefix_size, 2):
                    writer.int(self.preload_prefix_size)

                if flags(self.video_start_ts, 4):
                    writer.double(self.video_start_ts)

                if flags(self.video_codec, 5):
                    writer.string(self.video_codec)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        duration_ = reader.double()
        w_ = reader.int()
        h_ = reader.int()
        preload_prefix_size_ = (
            reader.int()
            if flags(2) else None
        )

        video_start_ts_ = (
            reader.double()
            if flags(4) else None
        )

        video_codec_ = (
            reader.string()
            if flags(5) else None
        )

        return cls(
            duration=duration_,
            w=w_,
            h=h_,
            round_message=flags(0),
            supports_streaming=flags(1),
            nosound=flags(3),
            preload_prefix_size=preload_prefix_size_,
            video_start_ts=video_start_ts_,
            video_codec=video_codec_
        )

class DocumentAttributeAudio(TLObject, family='TypeDocumentAttribute'):
    """
    Represents an audio file
    """

    _id = 0X9852F9C6
    _group_id = 0X9EBF3A46

    def __init__(
        self,
        duration: int,
        voice: bool = False,
        title: Optional[str] = None,
        performer: Optional[str] = None,
        waveform: Optional[bytes] = None
    ):

        """
        Represents an audio file

        Args:
            duration (int): Duration in seconds
            voice (bool, optional): Whether this is a voice message
            title (Optional[str], optional): Name of song
            performer (Optional[str], optional): Performer
            waveform (Optional[bytes], optional): Waveform: consists in a series of bitpacked 5-bit values. Example implementation: [android](https://github.com/DrKLO/Telegram/blob/96dce2c9aabc33b87db61d830aa087b6b03fe397/TMessagesProj/jni/audio.c#L546).
        """

        self.duration = duration
        self.voice = voice
        self.title = title
        self.performer = performer
        self.waveform = waveform

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xc6\xf9R\x98' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.voice, 10)
                writer.int(self.duration)

                if flags(self.title, 0):
                    writer.string(self.title)

                if flags(self.performer, 1):
                    writer.string(self.performer)

                if flags(self.waveform, 2):
                    writer.bytes(self.waveform)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        duration_ = reader.int()
        title_ = (
            reader.string()
            if flags(0) else None
        )

        performer_ = (
            reader.string()
            if flags(1) else None
        )

        waveform_ = (
            reader.bytes()
            if flags(2) else None
        )

        return cls(
            duration=duration_,
            voice=flags(10),
            title=title_,
            performer=performer_,
            waveform=waveform_
        )

class DocumentAttributeFilename(TLObject, family='TypeDocumentAttribute'):
    """
    A simple document with a file name
    """

    _id = 0X15590068
    _group_id = 0X9EBF3A46

    def __init__(
        self,
        file_name: str
    ):

        """
        A simple document with a file name

        Args:
            file_name (str): The file name
        """

        self.file_name = file_name

    def to_bytes(self, boxed: bool=True):
        with Writer(b'h\x00Y\x15' if boxed else b'') as writer:
            writer.string(self.file_name)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        file_name_ = reader.string()

        return cls(
            file_name=file_name_
        )

class DocumentAttributeHasStickers(TLObject, family='TypeDocumentAttribute'):
    """
    Whether the current document has stickers attached
    """

    _id = 0X9801D2F7
    _group_id = 0X9EBF3A46


    def to_bytes(self, boxed: bool=True):
        return b'\xf7\xd2\x01\x98' if boxed else b''

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        return cls()

class DocumentAttributeCustomEmoji(TLObject, family='TypeDocumentAttribute'):
    """
    Info about a custom emoji
    """

    _id = 0XFD149899
    _group_id = 0X9EBF3A46

    def __init__(
        self,
        alt: str,
        stickerset: 'TypeInputStickerSet',
        free: bool = False,
        text_color: bool = False
    ):

        """
        Info about a custom emoji

        Args:
            alt (str): The actual emoji
            stickerset ('TypeInputStickerSet'): The emoji stickerset to which this emoji belongs.
            free (bool, optional): Whether this custom emoji can be sent by non-Premium users
            text_color (bool, optional): Whether the color of this TGS custom emoji should be changed to the text color when used in messages, the accent color if used as emoji status, white on chat photos, or another appropriate color based on context.
        """

        self.alt = alt
        self.stickerset = stickerset
        self.free = free
        self.text_color = text_color

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x99\x98\x14\xfd' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.free, 0)
                flags(self.text_color, 1)
                writer.string(self.alt)
                writer.object(
                    self.stickerset,
                    group_id=0X919D8BA5
                )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        alt_ = reader.string()
        stickerset_ = reader.object(
            group_id=0X919D8BA5
        )

        return cls(
            alt=alt_,
            stickerset=stickerset_,
            free=flags(0),
            text_color=flags(1)
        )

TypeDocumentAttribute = Union[
    DocumentAttributeImageSize,
    DocumentAttributeAnimated,
    DocumentAttributeSticker,
    DocumentAttributeVideo,
    DocumentAttributeAudio,
    DocumentAttributeFilename,
    DocumentAttributeHasStickers,
    DocumentAttributeCustomEmoji
]