
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import Union, TYPE_CHECKING, List
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ...gadgets.byteutils import Reader


class EmojiGroup(TLObject, family='TypeEmojiGroup'):
    """
    Represents an [emoji category](https://core.telegram.org/api/emoji-categories).
    """

    _id = 0X7A9ABDA9
    _group_id = 0X61DE3946

    def __init__(
        self,
        title: str,
        icon_emoji_id: int,
        emoticons: List[str]
    ):

        """
        Represents an [emoji category](https://core.telegram.org/api/emoji-categories).

        Args:
            title (str): Category name, i.e. "Animals", "Flags", "Faces" and so on...
            icon_emoji_id (int): A single custom emoji used as preview for the category.
            emoticons (List[str]): A list of UTF-8 emojis, matching the category.
        """

        self.title = title
        self.icon_emoji_id = icon_emoji_id
        self.emoticons = emoticons

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xa9\xbd\x9az' if boxed else b'') as writer:
            writer.string(self.title)
            writer.long(self.icon_emoji_id)
            writer.vector(
                self.emoticons,
                writer.string
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        title_ = reader.string()
        icon_emoji_id_ = reader.long()
        emoticons_ = reader.vector(
            reader.string
        )

        return cls(
            title=title_,
            icon_emoji_id=icon_emoji_id_,
            emoticons=emoticons_
        )

class EmojiGroupGreeting(TLObject, family='TypeEmojiGroup'):
    """
    Represents an [emoji category](https://core.telegram.org/api/emoji-categories), that should be moved to the top of the list when choosing a sticker for a [business introduction](https://core.telegram.org/api/business#business-introduction)
    """

    _id = 0X80D26CC7
    _group_id = 0X61DE3946

    def __init__(
        self,
        title: str,
        icon_emoji_id: int,
        emoticons: List[str]
    ):

        """
        Represents an [emoji category](https://core.telegram.org/api/emoji-categories), that should be moved to the top of the list when choosing a sticker for a [business introduction](https://core.telegram.org/api/business#business-introduction)

        Args:
            title (str): Category name, i.e. "Animals", "Flags", "Faces" and so on...
            icon_emoji_id (int): A single custom emoji used as preview for the category.
            emoticons (List[str]): A list of UTF-8 emojis, matching the category.
        """

        self.title = title
        self.icon_emoji_id = icon_emoji_id
        self.emoticons = emoticons

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xc7l\xd2\x80' if boxed else b'') as writer:
            writer.string(self.title)
            writer.long(self.icon_emoji_id)
            writer.vector(
                self.emoticons,
                writer.string
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        title_ = reader.string()
        icon_emoji_id_ = reader.long()
        emoticons_ = reader.vector(
            reader.string
        )

        return cls(
            title=title_,
            icon_emoji_id=icon_emoji_id_,
            emoticons=emoticons_
        )

class EmojiGroupPremium(TLObject, family='TypeEmojiGroup'):
    """
    An [emoji category](https://core.telegram.org/api/emoji-categories), used to select all [Premium](https://core.telegram.org/api/premium)-only stickers (i.e. those with a [Premium effect](https://core.telegram.org/api/stickers#premium-animated-sticker-effects))/ [Premium](https://core.telegram.org/api/premium)-only [custom emojis](https://core.telegram.org/api/custom-emoji) (i.e. those where the [documentAttributeCustomEmoji](https://core.telegram.org/constructor/documentAttributeCustomEmoji). free flag is not set)
    """

    _id = 0X93BCF34
    _group_id = 0X61DE3946

    def __init__(
        self,
        title: str,
        icon_emoji_id: int
    ):

        """
        An [emoji category](https://core.telegram.org/api/emoji-categories), used to select all [Premium](https://core.telegram.org/api/premium)-only stickers (i.e. those with a [Premium effect](https://core.telegram.org/api/stickers#premium-animated-sticker-effects))/ [Premium](https://core.telegram.org/api/premium)-only [custom emojis](https://core.telegram.org/api/custom-emoji) (i.e. those where the [documentAttributeCustomEmoji](https://core.telegram.org/constructor/documentAttributeCustomEmoji). free flag is not set)

        Args:
            title (str): Category name, i.e. "Animals", "Flags", "Faces" and so on...
            icon_emoji_id (int): A single custom emoji used as preview for the category.
        """

        self.title = title
        self.icon_emoji_id = icon_emoji_id

    def to_bytes(self, boxed: bool=True):
        with Writer(b'4\xcf;\t' if boxed else b'') as writer:
            writer.string(self.title)
            writer.long(self.icon_emoji_id)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        title_ = reader.string()
        icon_emoji_id_ = reader.long()

        return cls(
            title=title_,
            icon_emoji_id=icon_emoji_id_
        )

TypeEmojiGroup = Union[
    EmojiGroup,
    EmojiGroupGreeting,
    EmojiGroupPremium
]