
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import Union, TYPE_CHECKING, List
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ...gadgets.byteutils import Reader


class EmojiListNotModified(TLObject, family='TypeEmojiList'):
    """
    The list of [custom emojis](https://core.telegram.org/api/custom-emoji) hasn't changed.
    """

    _id = 0X481EADFA
    _group_id = 0XECAE43D3


    def to_bytes(self, boxed: bool=True):
        return b'\xfa\xad\x1eH' if boxed else b''

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        return cls()

class EmojiList(TLObject, family='TypeEmojiList'):
    """
    Represents a list of [custom emojis](https://core.telegram.org/api/custom-emoji).
    """

    _id = 0X7A1E11D1
    _group_id = 0XECAE43D3

    def __init__(
        self,
        hash: int,
        document_id: List[int]
    ):

        """
        Represents a list of [custom emojis](https://core.telegram.org/api/custom-emoji).

        Args:
            hash (int): [Hash used for caching, for more info click here](https://core.telegram.org/api/offsets#hash-generation)
            document_id (List[int]): Custom emoji IDs
        """

        self.hash = hash
        self.document_id = document_id

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xd1\x11\x1ez' if boxed else b'') as writer:
            writer.long(self.hash)
            writer.vector(
                self.document_id,
                writer.long
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        hash_ = reader.long()
        document_id_ = reader.vector(
            reader.long
        )

        return cls(
            hash=hash_,
            document_id=document_id_
        )

TypeEmojiList = Union[
    EmojiListNotModified,
    EmojiList
]