
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import Union, TYPE_CHECKING, Optional
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ...gadgets.byteutils import Reader


class EmojiStatusEmpty(TLObject, family='TypeEmojiStatus'):
    """
    No emoji status is set
    """

    _id = 0X2DE11AAE
    _group_id = 0XFBDA9FB


    def to_bytes(self, boxed: bool=True):
        return b'\xae\x1a\xe1-' if boxed else b''

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        return cls()

class EmojiStatus(TLObject, family='TypeEmojiStatus'):
    """
    An [emoji status](https://core.telegram.org/api/emoji-status)
    """

    _id = 0XE7FF068A
    _group_id = 0XFBDA9FB

    def __init__(
        self,
        document_id: int,
        until: Optional[int] = None
    ):

        """
        An [emoji status](https://core.telegram.org/api/emoji-status)

        Args:
            document_id (int): [Custom emoji document ID](https://core.telegram.org/api/custom-emoji)
            until (Optional[int], optional): ...
        """

        self.document_id = document_id
        self.until = until

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x8a\x06\xff\xe7' if boxed else b'') as writer:
            with writer.flag() as flags:
                writer.long(self.document_id)

                if flags(self.until, 0):
                    writer.int(self.until)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        document_id_ = reader.long()
        until_ = (
            reader.int()
            if flags(0) else None
        )

        return cls(
            document_id=document_id_,
            until=until_
        )

class EmojiStatusCollectible(TLObject, family='TypeEmojiStatus'):
    _id = 0X7184603B
    _group_id = 0XFBDA9FB

    def __init__(
        self,
        collectible_id: int,
        document_id: int,
        title: str,
        slug: str,
        pattern_document_id: int,
        center_color: int,
        edge_color: int,
        pattern_color: int,
        text_color: int,
        until: Optional[int] = None
    ):

        self.collectible_id = collectible_id
        self.document_id = document_id
        self.title = title
        self.slug = slug
        self.pattern_document_id = pattern_document_id
        self.center_color = center_color
        self.edge_color = edge_color
        self.pattern_color = pattern_color
        self.text_color = text_color
        self.until = until

    def to_bytes(self, boxed: bool=True):
        with Writer(b';`\x84q' if boxed else b'') as writer:
            with writer.flag() as flags:
                writer.long(self.collectible_id)
                writer.long(self.document_id)
                writer.string(self.title)
                writer.string(self.slug)
                writer.long(self.pattern_document_id)
                writer.int(self.center_color)
                writer.int(self.edge_color)
                writer.int(self.pattern_color)
                writer.int(self.text_color)

                if flags(self.until, 0):
                    writer.int(self.until)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        collectible_id_ = reader.long()
        document_id_ = reader.long()
        title_ = reader.string()
        slug_ = reader.string()
        pattern_document_id_ = reader.long()
        center_color_ = reader.int()
        edge_color_ = reader.int()
        pattern_color_ = reader.int()
        text_color_ = reader.int()
        until_ = (
            reader.int()
            if flags(0) else None
        )

        return cls(
            collectible_id=collectible_id_,
            document_id=document_id_,
            title=title_,
            slug=slug_,
            pattern_document_id=pattern_document_id_,
            center_color=center_color_,
            edge_color=edge_color_,
            pattern_color=pattern_color_,
            text_color=text_color_,
            until=until_
        )

class InputEmojiStatusCollectible(TLObject, family='TypeEmojiStatus'):
    _id = 0X7141DBF
    _group_id = 0XFBDA9FB

    def __init__(
        self,
        collectible_id: int,
        until: Optional[int] = None
    ):

        self.collectible_id = collectible_id
        self.until = until

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xbf\x1d\x14\x07' if boxed else b'') as writer:
            with writer.flag() as flags:
                writer.long(self.collectible_id)

                if flags(self.until, 0):
                    writer.int(self.until)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        collectible_id_ = reader.long()
        until_ = (
            reader.int()
            if flags(0) else None
        )

        return cls(
            collectible_id=collectible_id_,
            until=until_
        )

TypeEmojiStatus = Union[
    EmojiStatusEmpty,
    EmojiStatus,
    EmojiStatusCollectible,
    InputEmojiStatusCollectible
]