
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING, Optional
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from .text_with_entities import TypeTextWithEntities
    from ...gadgets.byteutils import Reader


class FactCheck(TLObject, family='TypeFactCheck'):
    """
    Represents a [fact-check](https://core.telegram.org/api/factcheck) created by an independent fact-checker.
    """

    _id = 0XB89BFCCF
    _group_id = 0X16018ACA

    def __init__(
        self,
        hash: int,
        need_check: bool = False,
        country: Optional[str] = None,
        text: Optional['TypeTextWithEntities'] = None
    ):

        """
        Represents a [fact-check](https://core.telegram.org/api/factcheck) created by an independent fact-checker.

        Args:
            hash (int): [Hash used for caching, for more info click here](https://core.telegram.org/api/offsets#hash-generation)
            need_check (bool, optional): If set, the country/ text fields will not be set, and the fact check must be fetched manually by the client (if it isn't already cached with the key specified in hash) using bundled [messages.getFactCheck](https://core.telegram.org/method/messages.getFactCheck) requests, when the message with the factcheck scrolls into view.
            country (Optional[str], optional): A two-letter ISO 3166-1 alpha-2 country code of the country for which the fact-check should be shown.
            text (Optional['TypeTextWithEntities'], optional): The fact-check.
        """

        self.hash = hash
        self.need_check = need_check
        self.country = country
        self.text = text

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xcf\xfc\x9b\xb8' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.need_check, 0)

                if flags(self.country, 1):
                    writer.string(self.country)

                if flags(self.text, 1):
                    writer.object(
                        self.text,
                        group_id=0X5D96896
                    )
                writer.long(self.hash)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        country_ = (
            reader.string()
            if flags(1) else None
        )

        text_ = (
            reader.object(
                group_id=0X5D96896
            )
            if flags(1) else None
        )

        hash_ = reader.long()

        return cls(
            hash=hash_,
            need_check=flags(0),
            country=country_,
            text=text_
        )

TypeFactCheck = FactCheck