
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import Union, TYPE_CHECKING, List
from ....gadgets.tlobject import TLObject
from ....gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ....gadgets.byteutils import Reader


class PeerColorSet(TLObject, family='TypeHelpPeerColorSet'):
    """
    Represents a [color palette that can be used in message accents](https://core.telegram.org/api/colors).
    """

    _id = 0X26219A58
    _group_id = 0XE655D80C

    def __init__(
        self,
        colors: List[int]
    ):

        """
        Represents a [color palette that can be used in message accents](https://core.telegram.org/api/colors).

        Args:
            colors (List[int]): A list of 1-3 colors in RGB format, describing the accent color.
        """

        self.colors = colors

    def to_bytes(self, boxed: bool=True):
        with Writer(b'X\x9a!&' if boxed else b'') as writer:
            writer.vector(
                self.colors,
                writer.int
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        colors_ = reader.vector(
            reader.int
        )

        return cls(
            colors=colors_
        )

class PeerColorProfileSet(TLObject, family='TypeHelpPeerColorSet'):
    """
    Represents a [color palette that can be used in profile pages](https://core.telegram.org/api/colors).
    """

    _id = 0X767D61EB
    _group_id = 0XE655D80C

    def __init__(
        self,
        palette_colors: List[int],
        bg_colors: List[int],
        story_colors: List[int]
    ):

        """
        Represents a [color palette that can be used in profile pages](https://core.telegram.org/api/colors).

        Args:
            palette_colors (List[int]): A list of 1-2 colors in RGB format, shown in the color palette settings to describe the current palette.
            bg_colors (List[int]): A list of 1-2 colors in RGB format describing the colors used to generate the actual background used in the profile page.
            story_colors (List[int]): A list of 2 colors in RGB format describing the colors of the gradient used for the unread active story indicator around the profile photo.
        """

        self.palette_colors = palette_colors
        self.bg_colors = bg_colors
        self.story_colors = story_colors

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xeba}v' if boxed else b'') as writer:
            writer.vector(
                self.palette_colors,
                writer.int
            )
            writer.vector(
                self.bg_colors,
                writer.int
            )
            writer.vector(
                self.story_colors,
                writer.int
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        palette_colors_ = reader.vector(
            reader.int
        )

        bg_colors_ = reader.vector(
            reader.int
        )

        story_colors_ = reader.vector(
            reader.int
        )

        return cls(
            palette_colors=palette_colors_,
            bg_colors=bg_colors_,
            story_colors=story_colors_
        )

TypeHelpPeerColorSet = Union[
    PeerColorSet,
    PeerColorProfileSet
]