
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import Union, TYPE_CHECKING
from ....gadgets.tlobject import TLObject
from ....gadgets.byteutils import Writer


if TYPE_CHECKING:
    from .terms_of_service import TypeHelpTermsOfService
    from ....gadgets.byteutils import Reader


class TermsOfServiceUpdateEmpty(TLObject, family='TypeHelpTermsOfServiceUpdate'):
    """
    No changes were made to telegram's terms of service
    """

    _id = 0XE3309F7F
    _group_id = 0X30C950DE

    def __init__(
        self,
        expires: int
    ):

        """
        No changes were made to telegram's terms of service

        Args:
            expires (int): New TOS updates will have to be queried using [help.getTermsOfServiceUpdate](https://core.telegram.org/method/help.getTermsOfServiceUpdate) in expires seconds
        """

        self.expires = expires

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x7f\x9f0\xe3' if boxed else b'') as writer:
            writer.int(self.expires)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        expires_ = reader.int()

        return cls(
            expires=expires_
        )

class TermsOfServiceUpdate(TLObject, family='TypeHelpTermsOfServiceUpdate'):
    """
    Info about an update of telegram's terms of service. If the terms of service are declined, then the [account.deleteAccount](https://core.telegram.org/method/account.deleteAccount) method should be called with the reason "Decline ToS update"
    """

    _id = 0X28ECF961
    _group_id = 0X30C950DE

    def __init__(
        self,
        expires: int,
        terms_of_service: 'TypeHelpTermsOfService'
    ):

        """
        Info about an update of telegram's terms of service. If the terms of service are declined, then the [account.deleteAccount](https://core.telegram.org/method/account.deleteAccount) method should be called with the reason "Decline ToS update"

        Args:
            expires (int): New TOS updates will have to be queried using [help.getTermsOfServiceUpdate](https://core.telegram.org/method/help.getTermsOfServiceUpdate) in expires seconds
            terms_of_service ('TypeHelpTermsOfService'): New terms of service
        """

        self.expires = expires
        self.terms_of_service = terms_of_service

    def to_bytes(self, boxed: bool=True):
        with Writer(b'a\xf9\xec(' if boxed else b'') as writer:
            writer.int(self.expires)
            writer.object(
                self.terms_of_service,
                group_id=0XEA6FD826
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        expires_ = reader.int()
        terms_of_service_ = reader.object(
            group_id=0XEA6FD826
        )

        return cls(
            expires=expires_,
            terms_of_service=terms_of_service_
        )

TypeHelpTermsOfServiceUpdate = Union[
    TermsOfServiceUpdateEmpty,
    TermsOfServiceUpdate
]