
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import Union, TYPE_CHECKING
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from .input_user import TypeInputUser
    from ...gadgets.byteutils import Reader


class InputGameID(TLObject, family='TypeInputGame'):
    """
    Indicates an already sent game
    """

    _id = 0X32C3E77
    _group_id = 0X189071EA

    def __init__(
        self,
        id: int,
        access_hash: int
    ):

        """
        Indicates an already sent game

        Args:
            id (int): game ID from [Game](https://core.telegram.org/type/Game) constructor
            access_hash (int): access hash from [Game](https://core.telegram.org/type/Game) constructor
        """

        self.id = id
        self.access_hash = access_hash

    def to_bytes(self, boxed: bool=True):
        with Writer(b'w>,\x03' if boxed else b'') as writer:
            writer.long(self.id)
            writer.long(self.access_hash)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        id_ = reader.long()
        access_hash_ = reader.long()

        return cls(
            id=id_,
            access_hash=access_hash_
        )

class InputGameShortName(TLObject, family='TypeInputGame'):
    """
    Game by short name
    """

    _id = 0XC331E80A
    _group_id = 0X189071EA

    def __init__(
        self,
        bot_id: 'TypeInputUser',
        short_name: str
    ):

        """
        Game by short name

        Args:
            bot_id ('TypeInputUser'): The bot that provides the game
            short_name (str): The game's short name, usually obtained from a [game link](https://core.telegram.org/api/links#game-links)
        """

        self.bot_id = bot_id
        self.short_name = short_name

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\n\xe81\xc3' if boxed else b'') as writer:
            writer.object(
                self.bot_id,
                group_id=0XB628962F
            )
            writer.string(self.short_name)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        bot_id_ = reader.object(
            group_id=0XB628962F
        )

        short_name_ = reader.string()

        return cls(
            bot_id=bot_id_,
            short_name=short_name_
        )

TypeInputGame = Union[
    InputGameID,
    InputGameShortName
]