
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import Union, TYPE_CHECKING
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ...gadgets.byteutils import Reader


class InputMessageID(TLObject, family='TypeInputMessage'):
    """
    Message by ID
    """

    _id = 0XA676A322
    _group_id = 0X562DA2D7

    def __init__(
        self,
        id: int
    ):

        """
        Message by ID

        Args:
            id (int): Message ID
        """

        self.id = id

    def to_bytes(self, boxed: bool=True):
        with Writer(b'"\xa3v\xa6' if boxed else b'') as writer:
            writer.int(self.id)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        id_ = reader.int()

        return cls(
            id=id_
        )

class InputMessageReplyTo(TLObject, family='TypeInputMessage'):
    """
    Message to which the specified message replies to
    """

    _id = 0XBAD88395
    _group_id = 0X562DA2D7

    def __init__(
        self,
        id: int
    ):

        """
        Message to which the specified message replies to

        Args:
            id (int): ID of the message that replies to the message we need
        """

        self.id = id

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x95\x83\xd8\xba' if boxed else b'') as writer:
            writer.int(self.id)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        id_ = reader.int()

        return cls(
            id=id_
        )

class InputMessagePinned(TLObject, family='TypeInputMessage'):
    """
    Pinned message
    """

    _id = 0X86872538
    _group_id = 0X562DA2D7


    def to_bytes(self, boxed: bool=True):
        return b'8%\x87\x86' if boxed else b''

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        return cls()

class InputMessageCallbackQuery(TLObject, family='TypeInputMessage'):
    """
    Used by bots for fetching information about the message that originated a callback query
    """

    _id = 0XACFA1A7E
    _group_id = 0X562DA2D7

    def __init__(
        self,
        id: int,
        query_id: int
    ):

        """
        Used by bots for fetching information about the message that originated a callback query

        Args:
            id (int): Message ID
            query_id (int): Callback query ID
        """

        self.id = id
        self.query_id = query_id

    def to_bytes(self, boxed: bool=True):
        with Writer(b'~\x1a\xfa\xac' if boxed else b'') as writer:
            writer.int(self.id)
            writer.long(self.query_id)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        id_ = reader.int()
        query_id_ = reader.long()

        return cls(
            id=id_,
            query_id=query_id_
        )

TypeInputMessage = Union[
    InputMessageID,
    InputMessageReplyTo,
    InputMessagePinned,
    InputMessageCallbackQuery
]