
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import Union, TYPE_CHECKING
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from .input_peer import TypeInputPeer
    from ...gadgets.byteutils import Reader


class InputUserEmpty(TLObject, family='TypeInputUser'):
    """
    Empty constructor, does not define a user.
    """

    _id = 0XB98886CF
    _group_id = 0XB628962F


    def to_bytes(self, boxed: bool=True):
        return b'\xcf\x86\x88\xb9' if boxed else b''

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        return cls()

class InputUserSelf(TLObject, family='TypeInputUser'):
    """
    Defines the current user.
    """

    _id = 0XF7C1B13F
    _group_id = 0XB628962F


    def to_bytes(self, boxed: bool=True):
        return b'?\xb1\xc1\xf7' if boxed else b''

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        return cls()

class InputUser(TLObject, family='TypeInputUser'):
    """
    Defines a user for further interaction.
    """

    _id = 0XF21158C6
    _group_id = 0XB628962F

    def __init__(
        self,
        user_id: int,
        access_hash: int
    ):

        """
        Defines a user for further interaction.

        Args:
            user_id (int): User identifier
            access_hash (int): access_hash value from the [user](https://core.telegram.org/constructor/user) constructor
        """

        self.user_id = user_id
        self.access_hash = access_hash

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xc6X\x11\xf2' if boxed else b'') as writer:
            writer.long(self.user_id)
            writer.long(self.access_hash)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        user_id_ = reader.long()
        access_hash_ = reader.long()

        return cls(
            user_id=user_id_,
            access_hash=access_hash_
        )

class InputUserFromMessage(TLObject, family='TypeInputUser'):
    """
    Defines a [min](https://core.telegram.org/api/min) user that was seen in a certain message of a certain chat.
    """

    _id = 0X1DA448E2
    _group_id = 0XB628962F

    def __init__(
        self,
        peer: 'TypeInputPeer',
        msg_id: int,
        user_id: int
    ):

        """
        Defines a [min](https://core.telegram.org/api/min) user that was seen in a certain message of a certain chat.

        Args:
            peer ('TypeInputPeer'): The chat where the user was seen
            msg_id (int): The message ID
            user_id (int): The identifier of the user that was seen
        """

        self.peer = peer
        self.msg_id = msg_id
        self.user_id = user_id

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xe2H\xa4\x1d' if boxed else b'') as writer:
            writer.object(
                self.peer,
                group_id=0X995DB9DF
            )
            writer.int(self.msg_id)
            writer.long(self.user_id)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        peer_ = reader.object(
            group_id=0X995DB9DF
        )

        msg_id_ = reader.int()
        user_id_ = reader.long()

        return cls(
            peer=peer_,
            msg_id=msg_id_,
            user_id=user_id_
        )

TypeInputUser = Union[
    InputUserEmpty,
    InputUserSelf,
    InputUser,
    InputUserFromMessage
]