
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import Union, TYPE_CHECKING, Optional
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ...gadgets.byteutils import Reader


class LangPackString(TLObject, family='TypeLangPackString'):
    """
    Translated localization string
    """

    _id = 0XCAD181F6
    _group_id = 0X5EECD592

    def __init__(
        self,
        key: str,
        value: str
    ):

        """
        Translated localization string

        Args:
            key (str): Language key
            value (str): Value
        """

        self.key = key
        self.value = value

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xf6\x81\xd1\xca' if boxed else b'') as writer:
            writer.string(self.key)
            writer.string(self.value)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        key_ = reader.string()
        value_ = reader.string()

        return cls(
            key=key_,
            value=value_
        )

class LangPackStringPluralized(TLObject, family='TypeLangPackString'):
    """
    A language pack string which has different forms based on the number of some object it mentions. See [https://www.unicode.org/cldr/charts/latest/supplemental/language_plural_rules.html](https://www.unicode.org/cldr/charts/latest/supplemental/language_plural_rules.html) for more info
    """

    _id = 0X6C47AC9F
    _group_id = 0X5EECD592

    def __init__(
        self,
        key: str,
        other_value: str,
        zero_value: Optional[str] = None,
        one_value: Optional[str] = None,
        two_value: Optional[str] = None,
        few_value: Optional[str] = None,
        many_value: Optional[str] = None
    ):

        """
        A language pack string which has different forms based on the number of some object it mentions. See [https://www.unicode.org/cldr/charts/latest/supplemental/language_plural_rules.html](https://www.unicode.org/cldr/charts/latest/supplemental/language_plural_rules.html) for more info

        Args:
            key (str): Localization key
            other_value (str): Default value
            zero_value (Optional[str], optional): Value for zero objects
            one_value (Optional[str], optional): Value for one object
            two_value (Optional[str], optional): Value for two objects
            few_value (Optional[str], optional): Value for a few objects
            many_value (Optional[str], optional): Value for many objects
        """

        self.key = key
        self.other_value = other_value
        self.zero_value = zero_value
        self.one_value = one_value
        self.two_value = two_value
        self.few_value = few_value
        self.many_value = many_value

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x9f\xacGl' if boxed else b'') as writer:
            with writer.flag() as flags:
                writer.string(self.key)

                if flags(self.zero_value, 0):
                    writer.string(self.zero_value)

                if flags(self.one_value, 1):
                    writer.string(self.one_value)

                if flags(self.two_value, 2):
                    writer.string(self.two_value)

                if flags(self.few_value, 3):
                    writer.string(self.few_value)

                if flags(self.many_value, 4):
                    writer.string(self.many_value)
                writer.string(self.other_value)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        key_ = reader.string()
        zero_value_ = (
            reader.string()
            if flags(0) else None
        )

        one_value_ = (
            reader.string()
            if flags(1) else None
        )

        two_value_ = (
            reader.string()
            if flags(2) else None
        )

        few_value_ = (
            reader.string()
            if flags(3) else None
        )

        many_value_ = (
            reader.string()
            if flags(4) else None
        )

        other_value_ = reader.string()

        return cls(
            key=key_,
            other_value=other_value_,
            zero_value=zero_value_,
            one_value=one_value_,
            two_value=two_value_,
            few_value=few_value_,
            many_value=many_value_
        )

class LangPackStringDeleted(TLObject, family='TypeLangPackString'):
    """
    Deleted localization string
    """

    _id = 0X2979EEB2
    _group_id = 0X5EECD592

    def __init__(
        self,
        key: str
    ):

        """
        Deleted localization string

        Args:
            key (str): Localization key
        """

        self.key = key

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xb2\xeey)' if boxed else b'') as writer:
            writer.string(self.key)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        key_ = reader.string()

        return cls(
            key=key_
        )

TypeLangPackString = Union[
    LangPackString,
    LangPackStringPluralized,
    LangPackStringDeleted
]