
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING, Optional, List
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from .reaction_count import TypeReactionCount
    from .message_reactor import TypeMessageReactor
    from ...gadgets.byteutils import Reader
    from .message_peer_reaction import TypeMessagePeerReaction


class MessageReactions(TLObject, family='TypeMessageReactions'):
    """
    [Message reactions](https://core.telegram.org/api/reactions)
    """

    _id = 0XA339F0B
    _group_id = 0X1A48248F

    def __init__(
        self,
        results: List['TypeReactionCount'],
        min: bool = False,
        can_see_list: bool = False,
        reactions_as_tags: bool = False,
        recent_reactions: Optional[List['TypeMessagePeerReaction']] = None,
        top_reactors: Optional[List['TypeMessageReactor']] = None
    ):

        """
        [Message reactions](https://core.telegram.org/api/reactions)

        Args:
            results (List['TypeReactionCount']): Reactions
            min (bool, optional): Similar to [min](https://core.telegram.org/api/min) objects, used for [message reaction](https://core.telegram.org/api/reactions) constructors that are the same for all users so they don't have the reactions sent by the current user (you can use [messages.getMessagesReactions](https://core.telegram.org/method/messages.getMessagesReactions) to get the full reaction info).
            can_see_list (bool, optional): Whether [messages.getMessageReactionsList](https://core.telegram.org/method/messages.getMessageReactionsList) can be used to see how each specific peer reacted to the message
            reactions_as_tags (bool, optional): If set or if there are no reactions, all present and future reactions should be treated as [message tags, see here  for more info](https://core.telegram.org/api/saved-messages#tags).
            recent_reactions (Optional[List['TypeMessagePeerReaction']], optional): List of recent peers and their reactions
            top_reactors (Optional[List['TypeMessageReactor']], optional): [Paid Telegram Star reactions leaderboard](https://core.telegram.org/api/reactions#paid-reactions) for this message.
        """

        self.results = results
        self.min = min
        self.can_see_list = can_see_list
        self.reactions_as_tags = reactions_as_tags
        self.recent_reactions = recent_reactions
        self.top_reactors = top_reactors

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x0b\x9f3\n' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.min, 0)
                flags(self.can_see_list, 2)
                flags(self.reactions_as_tags, 3)
                writer.vector(
                    self.results,
                    lambda value: writer.object(
                        value,
                        group_id=0X21B32469
                    )
                )

                if flags(self.recent_reactions, 1):
                    writer.vector(
                        self.recent_reactions,
                        lambda value: writer.object(
                            value,
                            group_id=0X6A319223
                        )
                    )

                if flags(self.top_reactors, 4):
                    writer.vector(
                        self.top_reactors,
                        lambda value: writer.object(
                            value,
                            group_id=0X72C35592
                        )
                    )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        results_ = reader.vector(
            lambda: reader.object(
                group_id=0X21B32469
            )
        )

        recent_reactions_ = (
            reader.vector(
                lambda: reader.object(
                    group_id=0X6A319223
                )
            )
            if flags(1) else None
        )

        top_reactors_ = (
            reader.vector(
                lambda: reader.object(
                    group_id=0X72C35592
                )
            )
            if flags(4) else None
        )

        return cls(
            results=results_,
            min=flags(0),
            can_see_list=flags(2),
            reactions_as_tags=flags(3),
            recent_reactions=recent_reactions_,
            top_reactors=top_reactors_
        )

TypeMessageReactions = MessageReactions