
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING, Optional
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from .peer import TypePeer
    from ...gadgets.byteutils import Reader


class MessageReactor(TLObject, family='TypeMessageReactor'):
    """
    Info about a user in the [paid Star reactions leaderboard](https://core.telegram.org/api/reactions#paid-reactions) for a message.
    """

    _id = 0X4BA3A95A
    _group_id = 0X72C35592

    def __init__(
        self,
        count: int,
        top: bool = False,
        my: bool = False,
        anonymous: bool = False,
        peer_id: Optional['TypePeer'] = None
    ):

        """
        Info about a user in the [paid Star reactions leaderboard](https://core.telegram.org/api/reactions#paid-reactions) for a message.

        Args:
            count (int): The number of sent Telegram Stars.
            top (bool, optional): If set, the reactor is one of the most active reactors; may be unset if the reactor is the current user.
            my (bool, optional): If set, this reactor is the current user.
            anonymous (bool, optional): If set, the reactor is anonymous.
            peer_id (Optional['TypePeer'], optional): Identifier of the peer that reacted: may be unset for anonymous reactors different from the current user (i.e. if the current user sent an anonymous reaction anonymous will be set but this field will also be set).
        """

        self.count = count
        self.top = top
        self.my = my
        self.anonymous = anonymous
        self.peer_id = peer_id

    def to_bytes(self, boxed: bool=True):
        with Writer(b'Z\xa9\xa3K' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.top, 0)
                flags(self.my, 1)
                flags(self.anonymous, 2)

                if flags(self.peer_id, 3):
                    writer.object(
                        self.peer_id,
                        group_id=0XB4DECBCA
                    )
                writer.int(self.count)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        peer_id_ = (
            reader.object(
                group_id=0XB4DECBCA
            )
            if flags(3) else None
        )

        count_ = reader.int()

        return cls(
            count=count_,
            top=flags(0),
            my=flags(1),
            anonymous=flags(2),
            peer_id=peer_id_
        )

TypeMessageReactor = MessageReactor