
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING, Optional
from ....gadgets.tlobject import TLObject
from ....gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ....gadgets.byteutils import Reader


class BotCallbackAnswer(TLObject, family='TypeMessagesBotCallbackAnswer'):
    """
    Callback answer sent by the bot in response to a button press
    """

    _id = 0X36585EA4
    _group_id = 0X374CF30F

    def __init__(
        self,
        cache_time: int,
        alert: bool = False,
        has_url: bool = False,
        native_ui: bool = False,
        message: Optional[str] = None,
        url: Optional[str] = None
    ):

        """
        Callback answer sent by the bot in response to a button press

        Args:
            cache_time (int): For how long should this answer be cached
            alert (bool, optional): Whether an alert should be shown to the user instead of a toast notification
            has_url (bool, optional): Whether an URL is present
            native_ui (bool, optional): Whether to show games in WebView or in native UI.
            message (Optional[str], optional): Alert to show
            url (Optional[str], optional): URL to open
        """

        self.cache_time = cache_time
        self.alert = alert
        self.has_url = has_url
        self.native_ui = native_ui
        self.message = message
        self.url = url

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xa4^X6' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.alert, 1)
                flags(self.has_url, 3)
                flags(self.native_ui, 4)

                if flags(self.message, 0):
                    writer.string(self.message)

                if flags(self.url, 2):
                    writer.string(self.url)
                writer.int(self.cache_time)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        message_ = (
            reader.string()
            if flags(0) else None
        )

        url_ = (
            reader.string()
            if flags(2) else None
        )

        cache_time_ = reader.int()

        return cls(
            cache_time=cache_time_,
            alert=flags(1),
            has_url=flags(3),
            native_ui=flags(4),
            message=message_,
            url=url_
        )

TypeMessagesBotCallbackAnswer = BotCallbackAnswer