
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING, Optional, List
from ....gadgets.tlobject import TLObject
from ....gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ..user import TypeUser
    from ..bot_inline_result import TypeBotInlineResult
    from ..inline_bot_web_view import TypeInlineBotWebView
    from ....gadgets.byteutils import Reader
    from ..inline_bot_switch_pm import TypeInlineBotSwitchPM


class BotResults(TLObject, family='TypeMessagesBotResults'):
    """
    Result of a query to an inline bot
    """

    _id = 0XE021F2F6
    _group_id = 0XF96CDD05

    def __init__(
        self,
        query_id: int,
        results: List['TypeBotInlineResult'],
        cache_time: int,
        users: List['TypeUser'],
        gallery: bool = False,
        next_offset: Optional[str] = None,
        switch_pm: Optional['TypeInlineBotSwitchPM'] = None,
        switch_webview: Optional['TypeInlineBotWebView'] = None
    ):

        """
        Result of a query to an inline bot

        Args:
            query_id (int): Query ID
            results (List['TypeBotInlineResult']): The results
            cache_time (int): Caching validity of the results
            users (List['TypeUser']): Users mentioned in the results
            gallery (bool, optional): Whether the result is a picture gallery
            next_offset (Optional[str], optional): The next offset to use when navigating through results
            switch_pm (Optional['TypeInlineBotSwitchPM'], optional): Shown as a button on top of the remaining inline result list; if clicked, redirects the user to a private chat with the bot with the specified start parameter.
            switch_webview (Optional['TypeInlineBotWebView'], optional): Shown as a button on top of the remaining inline result list; if clicked, opens the specified [inline mode mini app](https://core.telegram.org/api/bots/webapps#inline-mode-mini-apps).
        """

        self.query_id = query_id
        self.results = results
        self.cache_time = cache_time
        self.users = users
        self.gallery = gallery
        self.next_offset = next_offset
        self.switch_pm = switch_pm
        self.switch_webview = switch_webview

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xf6\xf2!\xe0' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.gallery, 0)
                writer.long(self.query_id)

                if flags(self.next_offset, 1):
                    writer.string(self.next_offset)

                if flags(self.switch_pm, 2):
                    writer.object(
                        self.switch_pm,
                        group_id=0XEB2726E6
                    )

                if flags(self.switch_webview, 3):
                    writer.object(
                        self.switch_webview,
                        group_id=0XFCF33679
                    )
                writer.vector(
                    self.results,
                    lambda value: writer.object(
                        value,
                        group_id=0X940CB1DA
                    )
                )
                writer.int(self.cache_time)
                writer.vector(
                    self.users,
                    lambda value: writer.object(
                        value,
                        group_id=0X9BABE43A
                    )
                )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        query_id_ = reader.long()
        next_offset_ = (
            reader.string()
            if flags(1) else None
        )

        switch_pm_ = (
            reader.object(
                group_id=0XEB2726E6
            )
            if flags(2) else None
        )

        switch_webview_ = (
            reader.object(
                group_id=0XFCF33679
            )
            if flags(3) else None
        )

        results_ = reader.vector(
            lambda: reader.object(
                group_id=0X940CB1DA
            )
        )

        cache_time_ = reader.int()
        users_ = reader.vector(
            lambda: reader.object(
                group_id=0X9BABE43A
            )
        )

        return cls(
            query_id=query_id_,
            results=results_,
            cache_time=cache_time_,
            users=users_,
            gallery=flags(0),
            next_offset=next_offset_,
            switch_pm=switch_pm_,
            switch_webview=switch_webview_
        )

TypeMessagesBotResults = BotResults