
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING, Optional, List
from ....gadgets.tlobject import TLObject
from ....gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ..chat import TypeChat
    from ..user import TypeUser
    from ..message import TypeMessage
    from ....gadgets.byteutils import Reader


class DiscussionMessage(TLObject, family='TypeMessagesDiscussionMessage'):
    """
    Information about a [message thread](https://core.telegram.org/api/threads)
    """

    _id = 0XA6341782
    _group_id = 0X8F9C16B

    def __init__(
        self,
        messages: List['TypeMessage'],
        unread_count: int,
        chats: List['TypeChat'],
        users: List['TypeUser'],
        max_id: Optional[int] = None,
        read_inbox_max_id: Optional[int] = None,
        read_outbox_max_id: Optional[int] = None
    ):

        """
        Information about a [message thread](https://core.telegram.org/api/threads)

        Args:
            messages (List['TypeMessage']): The messages from which the thread starts. The messages are returned in reverse chronological order (i.e., in order of decreasing message ID).
            unread_count (int): Number of unread messages
            chats (List['TypeChat']): Chats mentioned in constructor
            users (List['TypeUser']): Users mentioned in constructor
            max_id (Optional[int], optional): Message ID of latest reply in this [thread](https://core.telegram.org/api/threads)
            read_inbox_max_id (Optional[int], optional): Message ID of latest read incoming message in this [thread](https://core.telegram.org/api/threads)
            read_outbox_max_id (Optional[int], optional): Message ID of latest read outgoing message in this [thread](https://core.telegram.org/api/threads)
        """

        self.messages = messages
        self.unread_count = unread_count
        self.chats = chats
        self.users = users
        self.max_id = max_id
        self.read_inbox_max_id = read_inbox_max_id
        self.read_outbox_max_id = read_outbox_max_id

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x82\x174\xa6' if boxed else b'') as writer:
            with writer.flag() as flags:
                writer.vector(
                    self.messages,
                    lambda value: writer.object(
                        value,
                        group_id=0X25780A8F
                    )
                )

                if flags(self.max_id, 0):
                    writer.int(self.max_id)

                if flags(self.read_inbox_max_id, 1):
                    writer.int(self.read_inbox_max_id)

                if flags(self.read_outbox_max_id, 2):
                    writer.int(self.read_outbox_max_id)
                writer.int(self.unread_count)
                writer.vector(
                    self.chats,
                    lambda value: writer.object(
                        value,
                        group_id=0X73A5C0D9
                    )
                )
                writer.vector(
                    self.users,
                    lambda value: writer.object(
                        value,
                        group_id=0X9BABE43A
                    )
                )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        messages_ = reader.vector(
            lambda: reader.object(
                group_id=0X25780A8F
            )
        )

        max_id_ = (
            reader.int()
            if flags(0) else None
        )

        read_inbox_max_id_ = (
            reader.int()
            if flags(1) else None
        )

        read_outbox_max_id_ = (
            reader.int()
            if flags(2) else None
        )

        unread_count_ = reader.int()
        chats_ = reader.vector(
            lambda: reader.object(
                group_id=0X73A5C0D9
            )
        )

        users_ = reader.vector(
            lambda: reader.object(
                group_id=0X9BABE43A
            )
        )

        return cls(
            messages=messages_,
            unread_count=unread_count_,
            chats=chats_,
            users=users_,
            max_id=max_id_,
            read_inbox_max_id=read_inbox_max_id_,
            read_outbox_max_id=read_outbox_max_id_
        )

TypeMessagesDiscussionMessage = DiscussionMessage