
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import Union, TYPE_CHECKING, List
from ....gadgets.tlobject import TLObject
from ....gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ..document import TypeDocument
    from ..sticker_pack import TypeStickerPack
    from ....gadgets.byteutils import Reader


class FavedStickersNotModified(TLObject, family='TypeMessagesFavedStickers'):
    """
    No new favorited stickers were found
    """

    _id = 0X9E8FA6D3
    _group_id = 0XB710FEE0


    def to_bytes(self, boxed: bool=True):
        return b'\xd3\xa6\x8f\x9e' if boxed else b''

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        return cls()

class FavedStickers(TLObject, family='TypeMessagesFavedStickers'):
    """
    Favorited stickers
    """

    _id = 0X2CB51097
    _group_id = 0XB710FEE0

    def __init__(
        self,
        hash: int,
        packs: List['TypeStickerPack'],
        stickers: List['TypeDocument']
    ):

        """
        Favorited stickers

        Args:
            hash (int): [Hash used for caching, for more info click here](https://core.telegram.org/api/offsets#hash-generation)
            packs (List['TypeStickerPack']): Emojis associated to stickers
            stickers (List['TypeDocument']): Favorited stickers
        """

        self.hash = hash
        self.packs = packs
        self.stickers = stickers

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x97\x10\xb5,' if boxed else b'') as writer:
            writer.long(self.hash)
            writer.vector(
                self.packs,
                lambda value: writer.object(
                    value,
                    group_id=0X6962BC17
                )
            )
            writer.vector(
                self.stickers,
                lambda value: writer.object(
                    value,
                    group_id=0X6547BD50
                )
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        hash_ = reader.long()
        packs_ = reader.vector(
            lambda: reader.object(
                group_id=0X6962BC17
            )
        )

        stickers_ = reader.vector(
            lambda: reader.object(
                group_id=0X6547BD50
            )
        )

        return cls(
            hash=hash_,
            packs=packs_,
            stickers=stickers_
        )

TypeMessagesFavedStickers = Union[
    FavedStickersNotModified,
    FavedStickers
]