
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING, Optional
from ....gadgets.tlobject import TLObject
from ....gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ....gadgets.byteutils import Reader


class HistoryImportParsed(TLObject, family='TypeMessagesHistoryImportParsed'):
    """
    Contains information about a chat export file [generated by a foreign chat app, click here for more info](https://core.telegram.org/api/import). 
    If neither the pm or group flags are set, the specified chat export was generated from a chat of unknown type.
    """

    _id = 0X5E0FB7B9
    _group_id = 0X9E7CA366

    def __init__(
        self,
        pm: bool = False,
        group: bool = False,
        title: Optional[str] = None
    ):

        """
        Contains information about a chat export file [generated by a foreign chat app, click here for more info](https://core.telegram.org/api/import). 
        If neither the pm or group flags are set, the specified chat export was generated from a chat of unknown type.

        Args:
            pm (bool, optional): The chat export file was generated from a private chat.
            group (bool, optional): The chat export file was generated from a group chat.
            title (Optional[str], optional): Title of the chat.
        """

        self.pm = pm
        self.group = group
        self.title = title

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xb9\xb7\x0f^' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.pm, 0)
                flags(self.group, 1)

                if flags(self.title, 2):
                    writer.string(self.title)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        title_ = (
            reader.string()
            if flags(2) else None
        )

        return cls(
            pm=flags(0),
            group=flags(1),
            title=title_
        )

TypeMessagesHistoryImportParsed = HistoryImportParsed