
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import Union, TYPE_CHECKING, List
from ....gadgets.tlobject import TLObject
from ....gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ..chat import TypeChat
    from ..user import TypeUser
    from ..message import TypeMessage
    from ..saved_dialog import TypeSavedDialog
    from ....gadgets.byteutils import Reader


class SavedDialogs(TLObject, family='TypeMessagesSavedDialogs'):
    """
    Represents some [saved message dialogs](https://core.telegram.org/api/saved-messages).
    """

    _id = 0XF83AE221
    _group_id = 0X169239D

    def __init__(
        self,
        dialogs: List['TypeSavedDialog'],
        messages: List['TypeMessage'],
        chats: List['TypeChat'],
        users: List['TypeUser']
    ):

        """
        Represents some [saved message dialogs](https://core.telegram.org/api/saved-messages).

        Args:
            dialogs (List['TypeSavedDialog']): [Saved message dialogs](https://core.telegram.org/api/saved-messages).
            messages (List['TypeMessage']): List of last messages from each saved dialog
            chats (List['TypeChat']): Mentioned chats
            users (List['TypeUser']): Mentioned users
        """

        self.dialogs = dialogs
        self.messages = messages
        self.chats = chats
        self.users = users

    def to_bytes(self, boxed: bool=True):
        with Writer(b'!\xe2:\xf8' if boxed else b'') as writer:
            writer.vector(
                self.dialogs,
                lambda value: writer.object(
                    value,
                    group_id=0XD5377DC5
                )
            )
            writer.vector(
                self.messages,
                lambda value: writer.object(
                    value,
                    group_id=0X25780A8F
                )
            )
            writer.vector(
                self.chats,
                lambda value: writer.object(
                    value,
                    group_id=0X73A5C0D9
                )
            )
            writer.vector(
                self.users,
                lambda value: writer.object(
                    value,
                    group_id=0X9BABE43A
                )
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        dialogs_ = reader.vector(
            lambda: reader.object(
                group_id=0XD5377DC5
            )
        )

        messages_ = reader.vector(
            lambda: reader.object(
                group_id=0X25780A8F
            )
        )

        chats_ = reader.vector(
            lambda: reader.object(
                group_id=0X73A5C0D9
            )
        )

        users_ = reader.vector(
            lambda: reader.object(
                group_id=0X9BABE43A
            )
        )

        return cls(
            dialogs=dialogs_,
            messages=messages_,
            chats=chats_,
            users=users_
        )

class SavedDialogsSlice(TLObject, family='TypeMessagesSavedDialogs'):
    """
    Incomplete list of [saved message dialogs](https://core.telegram.org/api/saved-messages) with messages and auxiliary data.
    """

    _id = 0X44BA9DD9
    _group_id = 0X169239D

    def __init__(
        self,
        count: int,
        dialogs: List['TypeSavedDialog'],
        messages: List['TypeMessage'],
        chats: List['TypeChat'],
        users: List['TypeUser']
    ):

        """
        Incomplete list of [saved message dialogs](https://core.telegram.org/api/saved-messages) with messages and auxiliary data.

        Args:
            count (int): Total number of saved message dialogs
            dialogs (List['TypeSavedDialog']): List of saved message dialogs
            messages (List['TypeMessage']): List of last messages from dialogs
            chats (List['TypeChat']): Mentioned chats
            users (List['TypeUser']): Mentioned users
        """

        self.count = count
        self.dialogs = dialogs
        self.messages = messages
        self.chats = chats
        self.users = users

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xd9\x9d\xbaD' if boxed else b'') as writer:
            writer.int(self.count)
            writer.vector(
                self.dialogs,
                lambda value: writer.object(
                    value,
                    group_id=0XD5377DC5
                )
            )
            writer.vector(
                self.messages,
                lambda value: writer.object(
                    value,
                    group_id=0X25780A8F
                )
            )
            writer.vector(
                self.chats,
                lambda value: writer.object(
                    value,
                    group_id=0X73A5C0D9
                )
            )
            writer.vector(
                self.users,
                lambda value: writer.object(
                    value,
                    group_id=0X9BABE43A
                )
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        count_ = reader.int()
        dialogs_ = reader.vector(
            lambda: reader.object(
                group_id=0XD5377DC5
            )
        )

        messages_ = reader.vector(
            lambda: reader.object(
                group_id=0X25780A8F
            )
        )

        chats_ = reader.vector(
            lambda: reader.object(
                group_id=0X73A5C0D9
            )
        )

        users_ = reader.vector(
            lambda: reader.object(
                group_id=0X9BABE43A
            )
        )

        return cls(
            count=count_,
            dialogs=dialogs_,
            messages=messages_,
            chats=chats_,
            users=users_
        )

class SavedDialogsNotModified(TLObject, family='TypeMessagesSavedDialogs'):
    """
    The saved dialogs haven't changed
    """

    _id = 0XC01F6FE8
    _group_id = 0X169239D

    def __init__(
        self,
        count: int
    ):

        """
        The saved dialogs haven't changed

        Args:
            count (int): Number of [saved dialogs](https://core.telegram.org/api/saved-messages) found server-side by the query
        """

        self.count = count

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xe8o\x1f\xc0' if boxed else b'') as writer:
            writer.int(self.count)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        count_ = reader.int()

        return cls(
            count=count_
        )

TypeMessagesSavedDialogs = Union[
    SavedDialogs,
    SavedDialogsSlice,
    SavedDialogsNotModified
]