
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING, Optional
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from .peer import TypePeer
    from ...gadgets.byteutils import Reader


class MyBoost(TLObject, family='TypeMyBoost'):
    """
    Contains information about a single [boost slot](https://core.telegram.org/api/boost).
    """

    _id = 0XC448415C
    _group_id = 0X99626BD3

    def __init__(
        self,
        slot: int,
        date: int,
        expires: int,
        peer: Optional['TypePeer'] = None,
        cooldown_until_date: Optional[int] = None
    ):

        """
        Contains information about a single [boost slot](https://core.telegram.org/api/boost).

        Args:
            slot (int): [Boost slot ID](https://core.telegram.org/api/boost)
            date (int): When (unixtime) we started boosting the peer, 0 otherwise.
            expires (int): Indicates the (unixtime) expiration date of the boost in peer ( 0 if peer is not set).
            peer (Optional['TypePeer'], optional): If set, indicates this slot is currently occupied, i.e. we are [boosting](https://core.telegram.org/api/boost) this peer.  Note that we can assign multiple boost slots to the same peer.
            cooldown_until_date (Optional[int], optional): If peer is set, indicates the (unixtime) date after which this boost can be reassigned to another channel.
        """

        self.slot = slot
        self.date = date
        self.expires = expires
        self.peer = peer
        self.cooldown_until_date = cooldown_until_date

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\\AH\xc4' if boxed else b'') as writer:
            with writer.flag() as flags:
                writer.int(self.slot)

                if flags(self.peer, 0):
                    writer.object(
                        self.peer,
                        group_id=0XB4DECBCA
                    )
                writer.int(self.date)
                writer.int(self.expires)

                if flags(self.cooldown_until_date, 1):
                    writer.int(self.cooldown_until_date)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        slot_ = reader.int()
        peer_ = (
            reader.object(
                group_id=0XB4DECBCA
            )
            if flags(0) else None
        )

        date_ = reader.int()
        expires_ = reader.int()
        cooldown_until_date_ = (
            reader.int()
            if flags(1) else None
        )

        return cls(
            slot=slot_,
            date=date_,
            expires=expires_,
            peer=peer_,
            cooldown_until_date=cooldown_until_date_
        )

TypeMyBoost = MyBoost