
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING, Optional, List
from ....gadgets.tlobject import TLObject
from ....gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ..chat import TypeChat
    from ..user import TypeUser
    from ..peer import TypePeer
    from ....gadgets.byteutils import Reader


class CheckedGiftCode(TLObject, family='TypePaymentsCheckedGiftCode'):
    """
    Contains info about a [Telegram Premium giftcode link](https://core.telegram.org/api/links#premium-giftcode-links).
    """

    _id = 0X284A1096
    _group_id = 0XD3F72DD8

    def __init__(
        self,
        date: int,
        months: int,
        chats: List['TypeChat'],
        users: List['TypeUser'],
        via_giveaway: bool = False,
        from_id: Optional['TypePeer'] = None,
        giveaway_msg_id: Optional[int] = None,
        to_id: Optional[int] = None,
        used_date: Optional[int] = None
    ):

        """
        Contains info about a [Telegram Premium giftcode link](https://core.telegram.org/api/links#premium-giftcode-links).

        Args:
            date (int): Creation date of the gift code.
            months (int): Duration in months of the gifted [Telegram Premium](https://core.telegram.org/api/premium) subscription.
            chats (List['TypeChat']): Mentioned chats
            users (List['TypeUser']): Mentioned users
            via_giveaway (bool, optional): Whether this giftcode was created by a [giveaway](https://core.telegram.org/api/giveaways).
            from_id (Optional['TypePeer'], optional): The peer that created the gift code.
            giveaway_msg_id (Optional[int], optional): Message ID of the giveaway in the channel specified in from_id.
            to_id (Optional[int], optional): The destination user of the gift.
            used_date (Optional[int], optional): When was the giftcode imported, if it was imported.
        """

        self.date = date
        self.months = months
        self.chats = chats
        self.users = users
        self.via_giveaway = via_giveaway
        self.from_id = from_id
        self.giveaway_msg_id = giveaway_msg_id
        self.to_id = to_id
        self.used_date = used_date

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x96\x10J(' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.via_giveaway, 2)

                if flags(self.from_id, 4):
                    writer.object(
                        self.from_id,
                        group_id=0XB4DECBCA
                    )

                if flags(self.giveaway_msg_id, 3):
                    writer.int(self.giveaway_msg_id)

                if flags(self.to_id, 0):
                    writer.long(self.to_id)
                writer.int(self.date)
                writer.int(self.months)

                if flags(self.used_date, 1):
                    writer.int(self.used_date)
                writer.vector(
                    self.chats,
                    lambda value: writer.object(
                        value,
                        group_id=0X73A5C0D9
                    )
                )
                writer.vector(
                    self.users,
                    lambda value: writer.object(
                        value,
                        group_id=0X9BABE43A
                    )
                )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        from_id_ = (
            reader.object(
                group_id=0XB4DECBCA
            )
            if flags(4) else None
        )

        giveaway_msg_id_ = (
            reader.int()
            if flags(3) else None
        )

        to_id_ = (
            reader.long()
            if flags(0) else None
        )

        date_ = reader.int()
        months_ = reader.int()
        used_date_ = (
            reader.int()
            if flags(1) else None
        )

        chats_ = reader.vector(
            lambda: reader.object(
                group_id=0X73A5C0D9
            )
        )

        users_ = reader.vector(
            lambda: reader.object(
                group_id=0X9BABE43A
            )
        )

        return cls(
            date=date_,
            months=months_,
            chats=chats_,
            users=users_,
            via_giveaway=flags(2),
            from_id=from_id_,
            giveaway_msg_id=giveaway_msg_id_,
            to_id=to_id_,
            used_date=used_date_
        )

TypePaymentsCheckedGiftCode = CheckedGiftCode