
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING, List
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ...gadgets.byteutils import Reader


class PhoneCallProtocol(TLObject, family='TypePhoneCallProtocol'):
    """
    Protocol info for libtgvoip
    """

    _id = 0XFC878FC8
    _group_id = 0X11AF407E

    def __init__(
        self,
        min_layer: int,
        max_layer: int,
        library_versions: List[str],
        udp_p2p: bool = False,
        udp_reflector: bool = False
    ):

        """
        Protocol info for libtgvoip

        Args:
            min_layer (int): Minimum layer for remote libtgvoip
            max_layer (int): Maximum layer for remote libtgvoip
            library_versions (List[str]): When using [phone.requestCall](https://core.telegram.org/method/phone.requestCall) and [phone.acceptCall](https://core.telegram.org/method/phone.acceptCall), specify all library versions supported by the client. The server will merge and choose the best library version supported by both peers, returning only the best value in the result of the callee's [phone.acceptCall](https://core.telegram.org/method/phone.acceptCall) and in the [phoneCallAccepted](https://core.telegram.org/constructor/phoneCallAccepted) update received by the caller.
            udp_p2p (bool, optional): Whether to allow P2P connection to the other participant
            udp_reflector (bool, optional): Whether to allow connection to the other participants through the reflector servers
        """

        self.min_layer = min_layer
        self.max_layer = max_layer
        self.library_versions = library_versions
        self.udp_p2p = udp_p2p
        self.udp_reflector = udp_reflector

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xc8\x8f\x87\xfc' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.udp_p2p, 0)
                flags(self.udp_reflector, 1)
                writer.int(self.min_layer)
                writer.int(self.max_layer)
                writer.vector(
                    self.library_versions,
                    writer.string
                )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        min_layer_ = reader.int()
        max_layer_ = reader.int()
        library_versions_ = reader.vector(
            reader.string
        )

        return cls(
            min_layer=min_layer_,
            max_layer=max_layer_,
            library_versions=library_versions_,
            udp_p2p=flags(0),
            udp_reflector=flags(1)
        )

TypePhoneCallProtocol = PhoneCallProtocol