
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import Union, TYPE_CHECKING
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ...gadgets.byteutils import Reader


class PrepaidGiveaway(TLObject, family='TypePrepaidGiveaway'):
    """
    Contains info about a [prepaid giveaway](https://core.telegram.org/api/giveaways).
    """

    _id = 0XB2539D54
    _group_id = 0X4200658F

    def __init__(
        self,
        id: int,
        months: int,
        quantity: int,
        date: int
    ):

        """
        Contains info about a [prepaid giveaway](https://core.telegram.org/api/giveaways).

        Args:
            id (int): Prepaid giveaway ID.
            months (int): Duration in months of each gifted [Telegram Premium](https://core.telegram.org/api/premium) subscription.
            quantity (int): Number of given away [Telegram Premium](https://core.telegram.org/api/premium) subscriptions.
            date (int): Payment date.
        """

        self.id = id
        self.months = months
        self.quantity = quantity
        self.date = date

    def to_bytes(self, boxed: bool=True):
        with Writer(b'T\x9dS\xb2' if boxed else b'') as writer:
            writer.long(self.id)
            writer.int(self.months)
            writer.int(self.quantity)
            writer.int(self.date)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        id_ = reader.long()
        months_ = reader.int()
        quantity_ = reader.int()
        date_ = reader.int()

        return cls(
            id=id_,
            months=months_,
            quantity=quantity_,
            date=date_
        )

class PrepaidStarsGiveaway(TLObject, family='TypePrepaidGiveaway'):
    """
    Contains info about a [prepaid Telegram Star giveaway](https://core.telegram.org/api/giveaways#star-giveaways).
    """

    _id = 0X9A9D77E0
    _group_id = 0X4200658F

    def __init__(
        self,
        id: int,
        stars: int,
        quantity: int,
        boosts: int,
        date: int
    ):

        """
        Contains info about a [prepaid Telegram Star giveaway](https://core.telegram.org/api/giveaways#star-giveaways).

        Args:
            id (int): Prepaid giveaway ID.
            stars (int): Number of given away [Telegram Stars](https://core.telegram.org/api/stars)
            quantity (int): Number of giveaway winners
            boosts (int): Number of boosts the channel will gain by launching the giveaway.
            date (int): When was the giveaway paid for
        """

        self.id = id
        self.stars = stars
        self.quantity = quantity
        self.boosts = boosts
        self.date = date

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xe0w\x9d\x9a' if boxed else b'') as writer:
            writer.long(self.id)
            writer.long(self.stars)
            writer.int(self.quantity)
            writer.int(self.boosts)
            writer.int(self.date)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        id_ = reader.long()
        stars_ = reader.long()
        quantity_ = reader.int()
        boosts_ = reader.int()
        date_ = reader.int()

        return cls(
            id=id_,
            stars=stars_,
            quantity=quantity_,
            boosts=boosts_,
            date=date_
        )

TypePrepaidGiveaway = Union[
    PrepaidGiveaway,
    PrepaidStarsGiveaway
]