
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING, Optional
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from .reaction import TypeReaction
    from ...gadgets.byteutils import Reader


class ReactionCount(TLObject, family='TypeReactionCount'):
    """
    Reactions
    """

    _id = 0XA3D1CB80
    _group_id = 0X21B32469

    def __init__(
        self,
        reaction: 'TypeReaction',
        count: int,
        chosen_order: Optional[int] = None
    ):

        """
        Reactions

        Args:
            reaction ('TypeReaction'): The reaction.
            count (int): Number of users that reacted with this emoji.
            chosen_order (Optional[int], optional): If set, indicates that the current user also sent this reaction. The integer value indicates when was the reaction added: the bigger the value, the newer the reaction.
        """

        self.reaction = reaction
        self.count = count
        self.chosen_order = chosen_order

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x80\xcb\xd1\xa3' if boxed else b'') as writer:
            with writer.flag() as flags:

                if flags(self.chosen_order, 0):
                    writer.int(self.chosen_order)
                writer.object(
                    self.reaction,
                    group_id=0X19F930D1
                )
                writer.int(self.count)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        chosen_order_ = (
            reader.int()
            if flags(0) else None
        )

        reaction_ = reader.object(
            group_id=0X19F930D1
        )

        count_ = reader.int()

        return cls(
            reaction=reaction_,
            count=count_,
            chosen_order=chosen_order_
        )

TypeReactionCount = ReactionCount