
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ...gadgets.byteutils import Reader


class RestrictionReason(TLObject, family='TypeRestrictionReason'):
    """
    Restriction reason.
    """

    _id = 0XD072ACB4
    _group_id = 0X6F3B4470

    def __init__(
        self,
        platform: str,
        reason: str,
        text: str
    ):

        """
        Restriction reason.

        Args:
            platform (str): Platform identifier (ios, android, wp, all, etc.), can be concatenated with a dash as separator ( android-ios, ios-wp, etc)
            reason (str): Restriction reason ( porno, terms, etc.). Ignore this restriction reason if it is contained in the [ignore_restriction_reasons](https://core.telegram.org/api/config#ignore-restriction-reasons) client configuration parameter.
            text (str): Error message to be shown to the user
        """

        self.platform = platform
        self.reason = reason
        self.text = text

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xb4\xacr\xd0' if boxed else b'') as writer:
            writer.string(self.platform)
            writer.string(self.reason)
            writer.string(self.text)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        platform_ = reader.string()
        reason_ = reader.string()
        text_ = reader.string()

        return cls(
            platform=platform_,
            reason=reason_,
            text=text_
        )

TypeRestrictionReason = RestrictionReason