
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import Union, TYPE_CHECKING, List
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from .document import TypeDocument
    from .sticker_set import TypeStickerSet
    from .sticker_pack import TypeStickerPack
    from .sticker_keyword import TypeStickerKeyword
    from ...gadgets.byteutils import Reader


class StickerSetCovered(TLObject, family='TypeStickerSetCovered'):
    """
    Stickerset with a single sticker as preview
    """

    _id = 0X6410A5D2
    _group_id = 0X16103538

    def __init__(
        self,
        set: 'TypeStickerSet',
        cover: 'TypeDocument'
    ):

        """
        Stickerset with a single sticker as preview

        Args:
            set ('TypeStickerSet'): Stickerset
            cover ('TypeDocument'): Preview
        """

        self.set = set
        self.cover = cover

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xd2\xa5\x10d' if boxed else b'') as writer:
            writer.object(
                self.set,
                group_id=0X8EED6744
            )
            writer.object(
                self.cover,
                group_id=0X6547BD50
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        set_ = reader.object(
            group_id=0X8EED6744
        )

        cover_ = reader.object(
            group_id=0X6547BD50
        )

        return cls(
            set=set_,
            cover=cover_
        )

class StickerSetMultiCovered(TLObject, family='TypeStickerSetCovered'):
    """
    Stickerset, with multiple stickers as preview
    """

    _id = 0X3407E51B
    _group_id = 0X16103538

    def __init__(
        self,
        set: 'TypeStickerSet',
        covers: List['TypeDocument']
    ):

        """
        Stickerset, with multiple stickers as preview

        Args:
            set ('TypeStickerSet'): Stickerset
            covers (List['TypeDocument']): Preview stickers
        """

        self.set = set
        self.covers = covers

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x1b\xe5\x074' if boxed else b'') as writer:
            writer.object(
                self.set,
                group_id=0X8EED6744
            )
            writer.vector(
                self.covers,
                lambda value: writer.object(
                    value,
                    group_id=0X6547BD50
                )
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        set_ = reader.object(
            group_id=0X8EED6744
        )

        covers_ = reader.vector(
            lambda: reader.object(
                group_id=0X6547BD50
            )
        )

        return cls(
            set=set_,
            covers=covers_
        )

class StickerSetFullCovered(TLObject, family='TypeStickerSetCovered'):
    """
    Stickerset preview with all stickers of the stickerset included. 
    Currently used only for [custom emoji stickersets](https://core.telegram.org/api/custom-emoji), to avoid a further call to [messages.getStickerSet](https://core.telegram.org/method/messages.getStickerSet).
    """

    _id = 0X40D13C0E
    _group_id = 0X16103538

    def __init__(
        self,
        set: 'TypeStickerSet',
        packs: List['TypeStickerPack'],
        keywords: List['TypeStickerKeyword'],
        documents: List['TypeDocument']
    ):

        """
        Stickerset preview with all stickers of the stickerset included. 
        Currently used only for [custom emoji stickersets](https://core.telegram.org/api/custom-emoji), to avoid a further call to [messages.getStickerSet](https://core.telegram.org/method/messages.getStickerSet).

        Args:
            set ('TypeStickerSet'): Stickerset
            packs (List['TypeStickerPack']): Emoji information about every sticker in the stickerset
            keywords (List['TypeStickerKeyword']): Keywords for some or every sticker in the stickerset.
            documents (List['TypeDocument']): Stickers
        """

        self.set = set
        self.packs = packs
        self.keywords = keywords
        self.documents = documents

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x0e<\xd1@' if boxed else b'') as writer:
            writer.object(
                self.set,
                group_id=0X8EED6744
            )
            writer.vector(
                self.packs,
                lambda value: writer.object(
                    value,
                    group_id=0X6962BC17
                )
            )
            writer.vector(
                self.keywords,
                lambda value: writer.object(
                    value,
                    group_id=0XD76E5240
                )
            )
            writer.vector(
                self.documents,
                lambda value: writer.object(
                    value,
                    group_id=0X6547BD50
                )
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        set_ = reader.object(
            group_id=0X8EED6744
        )

        packs_ = reader.vector(
            lambda: reader.object(
                group_id=0X6962BC17
            )
        )

        keywords_ = reader.vector(
            lambda: reader.object(
                group_id=0XD76E5240
            )
        )

        documents_ = reader.vector(
            lambda: reader.object(
                group_id=0X6547BD50
            )
        )

        return cls(
            set=set_,
            packs=packs_,
            keywords=keywords_,
            documents=documents_
        )

class StickerSetNoCovered(TLObject, family='TypeStickerSetCovered'):
    """
    Just the stickerset information, with no previews.
    """

    _id = 0X77B15D1C
    _group_id = 0X16103538

    def __init__(
        self,
        set: 'TypeStickerSet'
    ):

        """
        Just the stickerset information, with no previews.

        Args:
            set ('TypeStickerSet'): Stickerset information.
        """

        self.set = set

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x1c]\xb1w' if boxed else b'') as writer:
            writer.object(
                self.set,
                group_id=0X8EED6744
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        set_ = reader.object(
            group_id=0X8EED6744
        )

        return cls(
            set=set_
        )

TypeStickerSetCovered = Union[
    StickerSetCovered,
    StickerSetMultiCovered,
    StickerSetFullCovered,
    StickerSetNoCovered
]