
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import Union, TYPE_CHECKING, List
from ....gadgets.tlobject import TLObject
from ....gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ..chat import TypeChat
    from ..user import TypeUser
    from ..peer_stories import TypePeerStories
    from ....gadgets.byteutils import Reader
    from ..stories_stealth_mode import TypeStoriesStealthMode


class AllStoriesNotModified(TLObject, family='TypeStoriesAllStories'):
    """
    The list of active (or active and hidden) [stories](https://core.telegram.org/api/stories#watching-stories) has not changed.
    """

    _id = 0X1158FE3E
    _group_id = 0X7372A65E

    def __init__(
        self,
        state: str,
        stealth_mode: 'TypeStoriesStealthMode'
    ):

        """
        The list of active (or active and hidden) [stories](https://core.telegram.org/api/stories#watching-stories) has not changed.

        Args:
            state (str): State to use to ask for updates
            stealth_mode ('TypeStoriesStealthMode'): Current [stealth mode](https://core.telegram.org/api/stories#stealth-mode) information
        """

        self.state = state
        self.stealth_mode = stealth_mode

    def to_bytes(self, boxed: bool=True):
        with Writer(b'>\xfeX\x11' if boxed else b'') as writer:
            with writer.flag() as flags:
                writer.string(self.state)
                writer.object(
                    self.stealth_mode,
                    group_id=0XFAE6BCB9
                )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        state_ = reader.string()
        stealth_mode_ = reader.object(
            group_id=0XFAE6BCB9
        )

        return cls(
            state=state_,
            stealth_mode=stealth_mode_
        )

class AllStories(TLObject, family='TypeStoriesAllStories'):
    """
    Full list of active (or active and hidden) [stories](https://core.telegram.org/api/stories#watching-stories).
    """

    _id = 0X6EFC5E81
    _group_id = 0X7372A65E

    def __init__(
        self,
        count: int,
        state: str,
        peer_stories: List['TypePeerStories'],
        chats: List['TypeChat'],
        users: List['TypeUser'],
        stealth_mode: 'TypeStoriesStealthMode',
        has_more: bool = False
    ):

        """
        Full list of active (or active and hidden) [stories](https://core.telegram.org/api/stories#watching-stories).

        Args:
            count (int): Total number of active (or active and hidden) stories
            state (str): State to use for pagination
            peer_stories (List['TypePeerStories']): Stories
            chats (List['TypeChat']): Mentioned chats
            users (List['TypeUser']): Mentioned users
            stealth_mode ('TypeStoriesStealthMode'): Current [stealth mode](https://core.telegram.org/api/stories#stealth-mode) information
            has_more (bool, optional): Whether more results can be fetched as [described here](https://core.telegram.org/api/stories#watching-stories).
        """

        self.count = count
        self.state = state
        self.peer_stories = peer_stories
        self.chats = chats
        self.users = users
        self.stealth_mode = stealth_mode
        self.has_more = has_more

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x81^\xfcn' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.has_more, 0)
                writer.int(self.count)
                writer.string(self.state)
                writer.vector(
                    self.peer_stories,
                    lambda value: writer.object(
                        value,
                        group_id=0XE4A19284
                    )
                )
                writer.vector(
                    self.chats,
                    lambda value: writer.object(
                        value,
                        group_id=0X73A5C0D9
                    )
                )
                writer.vector(
                    self.users,
                    lambda value: writer.object(
                        value,
                        group_id=0X9BABE43A
                    )
                )
                writer.object(
                    self.stealth_mode,
                    group_id=0XFAE6BCB9
                )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        count_ = reader.int()
        state_ = reader.string()
        peer_stories_ = reader.vector(
            lambda: reader.object(
                group_id=0XE4A19284
            )
        )

        chats_ = reader.vector(
            lambda: reader.object(
                group_id=0X73A5C0D9
            )
        )

        users_ = reader.vector(
            lambda: reader.object(
                group_id=0X9BABE43A
            )
        )

        stealth_mode_ = reader.object(
            group_id=0XFAE6BCB9
        )

        return cls(
            count=count_,
            state=state_,
            peer_stories=peer_stories_,
            chats=chats_,
            users=users_,
            stealth_mode=stealth_mode_,
            has_more=flags(0)
        )

TypeStoriesAllStories = Union[
    AllStoriesNotModified,
    AllStories
]