
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING, Optional, List
from ....gadgets.tlobject import TLObject
from ....gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ..chat import TypeChat
    from ..user import TypeUser
    from ..story_item import TypeStoryItem
    from ....gadgets.byteutils import Reader


class Stories(TLObject, family='TypeStoriesStories'):
    """
    List of [stories](https://core.telegram.org/api/stories#pinned-or-archived-stories)
    """

    _id = 0X63C3DD0A
    _group_id = 0X596CD06C

    def __init__(
        self,
        count: int,
        stories: List['TypeStoryItem'],
        chats: List['TypeChat'],
        users: List['TypeUser'],
        pinned_to_top: Optional[List[int]] = None
    ):

        """
        List of [stories](https://core.telegram.org/api/stories#pinned-or-archived-stories)

        Args:
            count (int): Total number of stories that can be fetched
            stories (List['TypeStoryItem']): Stories
            chats (List['TypeChat']): Mentioned chats
            users (List['TypeUser']): Mentioned users
            pinned_to_top (Optional[List[int]], optional): IDs of pinned stories.
        """

        self.count = count
        self.stories = stories
        self.chats = chats
        self.users = users
        self.pinned_to_top = pinned_to_top

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\n\xdd\xc3c' if boxed else b'') as writer:
            with writer.flag() as flags:
                writer.int(self.count)
                writer.vector(
                    self.stories,
                    lambda value: writer.object(
                        value,
                        group_id=0X8436985A
                    )
                )

                if flags(self.pinned_to_top, 0):
                    writer.vector(
                        self.pinned_to_top,
                        writer.int
                    )
                writer.vector(
                    self.chats,
                    lambda value: writer.object(
                        value,
                        group_id=0X73A5C0D9
                    )
                )
                writer.vector(
                    self.users,
                    lambda value: writer.object(
                        value,
                        group_id=0X9BABE43A
                    )
                )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        count_ = reader.int()
        stories_ = reader.vector(
            lambda: reader.object(
                group_id=0X8436985A
            )
        )

        pinned_to_top_ = (
            reader.vector(
                reader.int
            )
            if flags(0) else None
        )

        chats_ = reader.vector(
            lambda: reader.object(
                group_id=0X73A5C0D9
            )
        )

        users_ = reader.vector(
            lambda: reader.object(
                group_id=0X9BABE43A
            )
        )

        return cls(
            count=count_,
            stories=stories_,
            chats=chats_,
            users=users_,
            pinned_to_top=pinned_to_top_
        )

TypeStoriesStories = Stories