
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import Union, TYPE_CHECKING
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from .user import TypeUser
    from ...gadgets.byteutils import Reader


class UrlAuthResultRequest(TLObject, family='TypeUrlAuthResult'):
    """
    Details about the authorization request, for more info [click here](https://core.telegram.org/api/url-authorization)
    """

    _id = 0X92D33A0E
    _group_id = 0X84DE2148

    def __init__(
        self,
        bot: 'TypeUser',
        domain: str,
        request_write_access: bool = False
    ):

        """
        Details about the authorization request, for more info [click here](https://core.telegram.org/api/url-authorization)

        Args:
            bot ('TypeUser'): Username of a bot, which will be used for user authorization. If not specified, the current bot's username will be assumed. The url's domain must be the same as the domain linked with the bot. See [Linking your domain to the bot](https://core.telegram.org/widgets/login#linking-your-domain-to-the-bot) for more details.
            domain (str): The domain name of the website on which the user will log in.
            request_write_access (bool, optional): Whether the bot would like to send messages to the user
        """

        self.bot = bot
        self.domain = domain
        self.request_write_access = request_write_access

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x0e:\xd3\x92' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.request_write_access, 0)
                writer.object(
                    self.bot,
                    group_id=0X9BABE43A
                )
                writer.string(self.domain)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        bot_ = reader.object(
            group_id=0X9BABE43A
        )

        domain_ = reader.string()

        return cls(
            bot=bot_,
            domain=domain_,
            request_write_access=flags(0)
        )

class UrlAuthResultAccepted(TLObject, family='TypeUrlAuthResult'):
    """
    Details about an accepted authorization request, for more info [click here](https://core.telegram.org/api/url-authorization)
    """

    _id = 0X8F8C0E4E
    _group_id = 0X84DE2148

    def __init__(
        self,
        url: str
    ):

        """
        Details about an accepted authorization request, for more info [click here](https://core.telegram.org/api/url-authorization)

        Args:
            url (str): The URL name of the website on which the user has logged in.
        """

        self.url = url

    def to_bytes(self, boxed: bool=True):
        with Writer(b'N\x0e\x8c\x8f' if boxed else b'') as writer:
            writer.string(self.url)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        url_ = reader.string()

        return cls(
            url=url_
        )

class UrlAuthResultDefault(TLObject, family='TypeUrlAuthResult'):
    """
    Details about an accepted authorization request, for more info [click here](https://core.telegram.org/api/url-authorization)
    """

    _id = 0XA9D6DB1F
    _group_id = 0X84DE2148


    def to_bytes(self, boxed: bool=True):
        return b'\x1f\xdb\xd6\xa9' if boxed else b''

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        return cls()

TypeUrlAuthResult = Union[
    UrlAuthResultRequest,
    UrlAuthResultAccepted,
    UrlAuthResultDefault
]