"""Matplotlib's colors as enums. Generated automatically at 2019-06-27T19:34:05.026894 with using Matplotlib v3.1.0"""
from enum import Enum
from .mixin import RgbTuple


class BaseColor(RgbTuple, Enum):
    K = (0.0, 0.0, 0.0)
    W = (1.0, 1.0, 1.0)
    R = (1.0, 0.0, 0.0)
    Y = (0.75, 0.75, 0.0)
    G = (0.0, 0.5, 0.0)
    C = (0.0, 0.75, 0.75)
    B = (0.0, 0.0, 1.0)
    M = (0.75, 0.0, 0.75)


class TableauColor(RgbTuple, Enum):
    GRAY = (0.4980392156862745, 0.4980392156862745, 0.4980392156862745)
    GREY = (0.4980392156862745, 0.4980392156862745, 0.4980392156862745)
    BROWN = (0.5490196078431373, 0.33725490196078434, 0.29411764705882354)
    ORANGE = (1.0, 0.4980392156862745, 0.054901960784313725)
    OLIVE = (0.7372549019607844, 0.7411764705882353, 0.13333333333333333)
    GREEN = (0.17254901960784313, 0.6274509803921569, 0.17254901960784313)
    CYAN = (0.09019607843137255, 0.7450980392156863, 0.8117647058823529)
    BLUE = (0.12156862745098039, 0.4666666666666667, 0.7058823529411765)
    PURPLE = (0.5803921568627451, 0.403921568627451, 0.7411764705882353)
    PINK = (0.8901960784313725, 0.4666666666666667, 0.7607843137254902)
    RED = (0.8392156862745098, 0.15294117647058825, 0.1568627450980392)


class XkcdColor(RgbTuple, Enum):
    BLACK = (0.0, 0.0, 0.0)
    WHITE = (1.0, 1.0, 1.0)
    DULL_RED = (0.7333333333333333, 0.24705882352941178, 0.24705882352941178)
    DRIED_BLOOD = (0.29411764705882354, 0.00392156862745098, 0.00392156862745098)
    DARK_RED = (0.5176470588235295, 0.0, 0.0)
    RED = (0.8980392156862745, 0.0, 0.0)
    DEEP_RED = (0.6039215686274509, 0.00784313725490196, 0.0)
    MAHOGANY = (0.2901960784313726, 0.00392156862745098, 0.0)
    PASTEL_RED = (0.8588235294117647, 0.34509803921568627, 0.33725490196078434)
    REDDISH = (0.7686274509803922, 0.25882352941176473, 0.25098039215686274)
    GRAPEFRUIT = (0.9921568627450981, 0.34901960784313724, 0.33725490196078434)
    DEEP_BROWN = (0.2549019607843137, 0.00784313725490196, 0.0)
    DARK_CORAL = (0.8117647058823529, 0.3215686274509804, 0.3058823529411765)
    PALE_RED = (0.8509803921568627, 0.32941176470588235, 0.30196078431372547)
    CORAL = (0.9882352941176471, 0.35294117647058826, 0.3137254901960784)
    DARK_SALMON = (0.7843137254901961, 0.35294117647058826, 0.3254901960784314)
    BROWNISH_PINK = (0.7607843137254902, 0.49411764705882355, 0.4745098039215686)
    VERY_DARK_BROWN = (0.11372549019607843, 0.00784313725490196, 0.0)
    INDIAN_RED = (0.5215686274509804, 0.054901960784313725, 0.01568627450980392)
    SALMON = (1.0, 0.4745098039215686, 0.4235294117647059)
    PINKISH_GRAY = (0.7843137254901961, 0.6745098039215687, 0.6627450980392157)
    PINKISH_GREY = (0.7843137254901961, 0.6745098039215687, 0.6627450980392157)
    REDDY_BROWN = (0.43137254901960786, 0.06274509803921569, 0.0196078431372549)
    REDDISH_GRAY = (0.6, 0.4588235294117647, 0.4392156862745098)
    REDDISH_GREY = (0.6, 0.4588235294117647, 0.4392156862745098)
    BRICK_RED = (0.5607843137254902, 0.0784313725490196, 0.00784313725490196)
    TOMATO = (0.9372549019607843, 0.25098039215686274, 0.14901960784313725)
    PEACHY_PINK = (1.0, 0.6039215686274509, 0.5411764705882353)
    ORANGEY_RED = (0.9803921568627451, 0.25882352941176473, 0.1411764705882353)
    BRICK = (0.6274509803921569, 0.21176470588235294, 0.13725490196078433)
    VERY_LIGHT_PINK = (1.0, 0.9568627450980393, 0.9490196078431372)
    BROWNISH_RED = (0.6196078431372549, 0.21176470588235294, 0.13725490196078433)
    ORANGE_RED = (0.9921568627450981, 0.2549019607843137, 0.11764705882352941)
    BLUSH = (0.9490196078431372, 0.6196078431372549, 0.5568627450980392)
    VERMILLION = (0.9568627450980393, 0.19607843137254902, 0.047058823529411764)
    ORANGE_PINK = (1.0, 0.43529411764705883, 0.3215686274509804)
    TOMATO_RED = (0.9254901960784314, 0.17647058823529413, 0.00392156862745098)
    BURNT_RED = (0.6235294117647059, 0.13725490196078433, 0.0196078431372549)
    REDDISH_ORANGE = (0.9725490196078431, 0.2823529411764706, 0.10980392156862745)
    ORANGISH_RED = (0.9568627450980393, 0.21176470588235294, 0.0196078431372549)
    RED_BROWN = (0.5450980392156862, 0.1803921568627451, 0.08627450980392157)
    LIGHT_SALMON = (0.996078431372549, 0.6627450980392157, 0.5764705882352941)
    MELON = (1.0, 0.47058823529411764, 0.3333333333333333)
    RUSTY_RED = (0.6862745098039216, 0.1843137254901961, 0.050980392156862744)
    RUST_RED = (0.6666666666666666, 0.15294117647058825, 0.01568627450980392)
    PINKISH_ORANGE = (1.0, 0.4470588235294118, 0.2980392156862745)
    PINKISH_BROWN = (0.6941176470588235, 0.4470588235294118, 0.3803921568627451)
    ORANGERED = (0.996078431372549, 0.25882352941176473, 0.058823529411764705)
    RED_ORANGE = (0.9921568627450981, 0.23529411764705882, 0.023529411764705882)
    PALE_SALMON = (1.0, 0.6941176470588235, 0.6039215686274509)
    CLAY = (0.7137254901960784, 0.41568627450980394, 0.3137254901960784)
    DARK_PEACH = (0.8705882352941177, 0.49411764705882355, 0.36470588235294116)
    BROWN_RED = (0.5725490196078431, 0.16862745098039217, 0.0196078431372549)
    TERRACOTTA = (0.792156862745098, 0.4, 0.2549019607843137)
    TERRACOTA = (0.796078431372549, 0.40784313725490196, 0.2627450980392157)
    REDDISH_BROWN = (0.4980392156862745, 0.16862745098039217, 0.0392156862745098)
    BLOOD_ORANGE = (0.996078431372549, 0.29411764705882354, 0.011764705882352941)
    PINKISH_TAN = (0.8509803921568627, 0.6078431372549019, 0.5098039215686274)
    TERRA_COTTA = (0.788235294117647, 0.39215686274509803, 0.23137254901960785)
    AUBURN = (0.6039215686274509, 0.18823529411764706, 0.00392156862745098)
    ADOBE = (0.7411764705882353, 0.4235294117647059, 0.2823529411764706)
    ORANGISH = (0.9882352941176471, 0.5098039215686274, 0.2901960784313726)
    WARM_GRAY = (0.592156862745098, 0.5411764705882353, 0.5176470588235295)
    WARM_GREY = (0.592156862745098, 0.5411764705882353, 0.5176470588235295)
    BROWNISH = (0.611764705882353, 0.42745098039215684, 0.3411764705882353)
    RUST = (0.6588235294117647, 0.23529411764705882, 0.03529411764705882)
    RUSSET = (0.6313725490196078, 0.2235294117647059, 0.0196078431372549)
    CHESTNUT = (0.4549019607843137, 0.1568627450980392, 0.00784313725490196)
    RUST_BROWN = (0.5450980392156862, 0.19215686274509805, 0.011764705882352941)
    DEEP_ORANGE = (0.8627450980392157, 0.30196078431372547, 0.00392156862745098)
    BRICK_ORANGE = (0.7568627450980392, 0.2901960784313726, 0.03529411764705882)
    BRIGHT_ORANGE = (1.0, 0.3568627450980392, 0.0)
    BURNT_UMBER = (0.6274509803921569, 0.27058823529411763, 0.054901960784313725)
    ORANGEISH = (0.9921568627450981, 0.5529411764705883, 0.28627450980392155)
    CHOCOLATE_BROWN = (0.2549019607843137, 0.09803921568627451, 0.0)
    EARTH = (0.6352941176470588, 0.396078431372549, 0.24313725490196078)
    BURNT_SIENNA = (0.6901960784313725, 0.3058823529411765, 0.058823529411764705)
    PEACH = (1.0, 0.6901960784313725, 0.48627450980392156)
    DUSTY_ORANGE = (0.9411764705882353, 0.5137254901960784, 0.22745098039215686)
    SIENNA = (0.6627450980392157, 0.33725490196078434, 0.11764705882352941)
    DARK_ORANGE = (0.7764705882352941, 0.3176470588235294, 0.00784313725490196)
    BURNT_ORANGE = (0.7529411764705882, 0.3058823529411765, 0.00392156862745098)
    PASTEL_ORANGE = (1.0, 0.5882352941176471, 0.30980392156862746)
    RUSTY_ORANGE = (0.803921568627451, 0.34901960784313724, 0.03529411764705882)
    RUST_ORANGE = (0.7686274509803922, 0.3333333333333333, 0.03137254901960784)
    COCOA = (0.5294117647058824, 0.37254901960784315, 0.25882352941176473)
    COPPER = (0.7137254901960784, 0.38823529411764707, 0.1450980392156863)
    FADED_ORANGE = (0.9411764705882353, 0.5803921568627451, 0.30196078431372547)
    BURNT_SIENA = (0.7176470588235294, 0.3215686274509804, 0.011764705882352941)
    CINNAMON = (0.6745098039215687, 0.30980392156862746, 0.023529411764705882)
    MUSHROOM = (0.7294117647058823, 0.6196078431372549, 0.5333333333333333)
    CHOCOLATE = (0.23921568627450981, 0.10980392156862745, 0.00784313725490196)
    CLAY_BROWN = (0.6980392156862745, 0.44313725490196076, 0.23921568627450981)
    ORANGE = (0.9764705882352941, 0.45098039215686275, 0.023529411764705882)
    APRICOT = (1.0, 0.6941176470588235, 0.42745098039215684)
    SEPIA = (0.596078431372549, 0.3686274509803922, 0.16862745098039217)
    DULL_ORANGE = (0.8470588235294118, 0.5254901960784314, 0.23137254901960785)
    PALE_ORANGE = (1.0, 0.6549019607843137, 0.33725490196078434)
    PUMPKIN_ORANGE = (0.984313725490196, 0.49019607843137253, 0.027450980392156862)
    MOCHA = (0.615686274509804, 0.4627450980392157, 0.3176470588235294)
    MILK_CHOCOLATE = (0.4980392156862745, 0.3058823529411765, 0.11764705882352941)
    LIGHT_PEACH = (1.0, 0.8470588235294118, 0.6941176470588235)
    BROWNISH_ORANGE = (0.796078431372549, 0.4666666666666667, 0.13725490196078433)
    WARM_BROWN = (0.5882352941176471, 0.3058823529411765, 0.00784313725490196)
    DARK_BROWN = (0.20392156862745098, 0.10980392156862745, 0.00784313725490196)
    PALE_BROWN = (0.6941176470588235, 0.5686274509803921, 0.43137254901960786)
    BROWNY_ORANGE = (0.792156862745098, 0.4196078431372549, 0.00784313725490196)
    ORANGISH_BROWN = (0.6980392156862745, 0.37254901960784315, 0.011764705882352941)
    ORANGE_BROWN = (0.7450980392156863, 0.39215686274509803, 0.0)
    TAN_BROWN = (0.6705882352941176, 0.49411764705882355, 0.2980392156862745)
    PUMPKIN = (0.8823529411764706, 0.4666666666666667, 0.00392156862745098)
    LIGHT_BROWN = (0.6784313725490196, 0.5058823529411764, 0.3137254901960784)
    PUCE = (0.6470588235294118, 0.49411764705882355, 0.3215686274509804)
    DARK_TAUPE = (0.4980392156862745, 0.40784313725490196, 0.3058823529411765)
    LEATHER = (0.6745098039215687, 0.4549019607843137, 0.20392156862745098)
    ORANGEY_BROWN = (0.6941176470588235, 0.3764705882352941, 0.00784313725490196)
    RAW_UMBER = (0.6549019607843137, 0.3686274509803922, 0.03529411764705882)
    LIGHT_ORANGE = (0.9921568627450981, 0.6666666666666666, 0.2823529411764706)
    BROWN = (0.396078431372549, 0.21568627450980393, 0.0)
    UMBER = (0.6980392156862745, 0.39215686274509803, 0.0)
    BROWN_ORANGE = (0.7254901960784313, 0.4117647058823529, 0.00784313725490196)
    TANGERINE = (1.0, 0.5803921568627451, 0.03137254901960784)
    DIRTY_ORANGE = (0.7843137254901961, 0.4627450980392157, 0.023529411764705882)
    MEDIUM_BROWN = (0.4980392156862745, 0.3176470588235294, 0.07058823529411765)
    MANGO = (1.0, 0.6509803921568628, 0.16862745098039217)
    BUTTERSCOTCH = (0.9921568627450981, 0.6941176470588235, 0.2784313725490196)
    DULL_BROWN = (0.5294117647058824, 0.43137254901960786, 0.29411764705882354)
    COFFEE = (0.6509803921568628, 0.5058823529411764, 0.2980392156862745)
    TAUPE = (0.7254901960784313, 0.6352941176470588, 0.5058823529411764)
    DIRT = (0.5411764705882353, 0.43137254901960786, 0.27058823529411763)
    DIRT_BROWN = (0.5137254901960784, 0.396078431372549, 0.2235294117647059)
    DARK_TAN = (0.6862745098039216, 0.5333333333333333, 0.2901960784313726)
    CARAMEL = (0.6862745098039216, 0.43529411764705883, 0.03529411764705882)
    BROWNISH_GRAY = (0.5254901960784314, 0.4666666666666667, 0.37254901960784315)
    BROWNISH_GREY = (0.5254901960784314, 0.4666666666666667, 0.37254901960784315)
    FAWN = (0.8117647058823529, 0.6862745098039216, 0.4823529411764706)
    GRAYISH_BROWN = (0.47843137254901963, 0.41568627450980394, 0.30980392156862746)
    GREYISH_BROWN = (0.47843137254901963, 0.41568627450980394, 0.30980392156862746)
    DUST = (0.6980392156862745, 0.6, 0.43137254901960786)
    TOUPE = (0.7803921568627451, 0.6745098039215687, 0.49019607843137253)
    RAW_SIENNA = (0.6039215686274509, 0.3843137254901961, 0.0)
    VERY_LIGHT_BROWN = (0.8274509803921568, 0.7137254901960784, 0.5137254901960784)
    CAMEL = (0.7764705882352941, 0.6235294117647059, 0.34901960784313724)
    SAND_BROWN = (0.796078431372549, 0.6470588235294118, 0.3764705882352941)
    YELLOWISH_ORANGE = (1.0, 0.6705882352941176, 0.058823529411764705)
    GRAY_BROWN = (0.4980392156862745, 0.4392156862745098, 0.3254901960784314)
    GREY_BROWN = (0.4980392156862745, 0.4392156862745098, 0.3254901960784314)
    DARK_BEIGE = (0.6745098039215687, 0.5764705882352941, 0.3843137254901961)
    ORANGE_YELLOW = (1.0, 0.6784313725490196, 0.00392156862745098)
    SQUASH = (0.9490196078431372, 0.6705882352941176, 0.08235294117647059)
    MUD_BROWN = (0.3764705882352941, 0.27450980392156865, 0.058823529411764705)
    SANDSTONE = (0.788235294117647, 0.6823529411764706, 0.4549019607843137)
    MACARONI_AND_CHEESE = (0.9372549019607843, 0.7058823529411765, 0.20784313725490197)
    PALE_PEACH = (1.0, 0.8980392156862745, 0.6784313725490196)
    DARK_SAND = (0.6588235294117647, 0.5607843137254902, 0.34901960784313724)
    GOLDEN_BROWN = (0.6980392156862745, 0.47843137254901963, 0.00392156862745098)
    TAN = (0.8196078431372549, 0.6980392156862745, 0.43529411764705883)
    SAFFRON = (0.996078431372549, 0.6980392156862745, 0.03529411764705882)
    PUTTY = (0.7450980392156863, 0.6823529411764706, 0.5411764705882353)
    AMBER = (0.996078431372549, 0.7019607843137254, 0.03137254901960784)
    POO_BROWN = (0.5333333333333333, 0.37254901960784315, 0.00392156862745098)
    SANDY_BROWN = (0.7686274509803922, 0.6509803921568628, 0.3803921568627451)
    YELLOW_ORANGE = (0.9882352941176471, 0.6901960784313725, 0.00392156862745098)
    SHIT_BROWN = (0.4823529411764706, 0.34509803921568627, 0.01568627450980392)
    ORANGEY_YELLOW = (0.9921568627450981, 0.7254901960784313, 0.08235294117647059)
    DESERT = (0.8, 0.6784313725490196, 0.3764705882352941)
    BRONZE = (0.6588235294117647, 0.4745098039215686, 0.0)
    MUSTARD_BROWN = (0.6745098039215687, 0.49411764705882355, 0.01568627450980392)
    POOP_BROWN = (0.47843137254901963, 0.34901960784313724, 0.00392156862745098)
    POOP = (0.4980392156862745, 0.3686274509803922, 0.0)
    GOLDEN_ROD = (0.9764705882352941, 0.7372549019607844, 0.03137254901960784)
    OCHRE = (0.7490196078431373, 0.5647058823529412, 0.0196078431372549)
    SHIT = (0.4980392156862745, 0.37254901960784315, 0.0)
    MUDDY_BROWN = (0.5333333333333333, 0.40784313725490196, 0.023529411764705882)
    SUNFLOWER = (1.0, 0.7725490196078432, 0.07058823529411765)
    MARIGOLD = (0.9882352941176471, 0.7529411764705882, 0.023529411764705882)
    BROWN_GRAY = (0.5529411764705883, 0.5176470588235295, 0.40784313725490196)
    BROWN_GREY = (0.5529411764705883, 0.5176470588235295, 0.40784313725490196)
    GOLDEN_YELLOW = (0.996078431372549, 0.7764705882352941, 0.08235294117647059)
    WHEAT = (0.984313725490196, 0.8666666666666667, 0.49411764705882355)
    MUD = (0.45098039215686275, 0.3607843137254902, 0.07058823529411765)
    YELLOW_OCHRE = (0.796078431372549, 0.615686274509804, 0.023529411764705882)
    GOLDENROD = (0.9803921568627451, 0.7607843137254902, 0.0196078431372549)
    LIGHT_MUSTARD = (0.9686274509803922, 0.8352941176470589, 0.3764705882352941)
    MAIZE = (0.9568627450980393, 0.8156862745098039, 0.32941176470588235)
    GOLDEN = (0.9607843137254902, 0.7490196078431373, 0.011764705882352941)
    SAND = (0.8862745098039215, 0.792156862745098, 0.4627450980392157)
    OCRE = (0.7764705882352941, 0.611764705882353, 0.01568627450980392)
    YELLOWY_BROWN = (0.6823529411764706, 0.5450980392156862, 0.047058823529411764)
    YELLOWISH_BROWN = (0.6078431372549019, 0.47843137254901963, 0.00392156862745098)
    PALE_GOLD = (0.9921568627450981, 0.8705882352941177, 0.4235294117647059)
    STONE = (0.6784313725490196, 0.6470588235294118, 0.5294117647058824)
    GRAYISH = (0.6588235294117647, 0.6431372549019608, 0.5843137254901961)
    GREYISH = (0.6588235294117647, 0.6431372549019608, 0.5843137254901961)
    BURNT_YELLOW = (0.8352941176470589, 0.6705882352941176, 0.03529411764705882)
    LIGHT_GOLD = (0.9921568627450981, 0.8627450980392157, 0.3607843137254902)
    PUKE_BROWN = (0.5803921568627451, 0.4666666666666667, 0.023529411764705882)
    HAZEL = (0.5568627450980392, 0.4627450980392157, 0.09411764705882353)
    OCHER = (0.7490196078431373, 0.6078431372549019, 0.047058823529411764)
    DARK_GOLD = (0.7098039215686275, 0.5803921568627451, 0.06274509803921569)
    POO = (0.5607843137254902, 0.45098039215686275, 0.011764705882352941)
    BLAND = (0.6862745098039216, 0.6588235294117647, 0.5450980392156862)
    SANDY = (0.9450980392156862, 0.8549019607843137, 0.47843137254901963)
    YELLOW_TAN = (1.0, 0.8901960784313725, 0.43137254901960786)
    YELLOW_BROWN = (0.7176470588235294, 0.5803921568627451, 0.0)
    DARK_MUSTARD = (0.6588235294117647, 0.5372549019607843, 0.0196078431372549)
    GOLD = (0.8588235294117647, 0.7058823529411765, 0.047058823529411764)
    BEIGE = (0.9019607843137255, 0.8549019607843137, 0.6509803921568628)
    BABY_SHIT_BROWN = (0.6784313725490196, 0.5647058823529412, 0.050980392156862744)
    SAND_YELLOW = (0.9882352941176471, 0.8823529411764706, 0.4)
    DIARRHEA = (0.6235294117647059, 0.5137254901960784, 0.011764705882352941)
    DARK_KHAKI = (0.6078431372549019, 0.5607843137254902, 0.3333333333333333)
    OLIVE_BROWN = (0.39215686274509803, 0.32941176470588235, 0.011764705882352941)
    LIGHT_TAN = (0.984313725490196, 0.9333333333333333, 0.6745098039215687)
    BABY_POO = (0.6705882352941176, 0.5647058823529412, 0.01568627450980392)
    BABY_POOP = (0.5764705882352941, 0.48627450980392156, 0.0)
    BROWN_YELLOW = (0.6980392156862745, 0.592156862745098, 0.0196078431372549)
    DARK_YELLOW = (0.8352941176470589, 0.7137254901960784, 0.0392156862745098)
    SUNFLOWER_YELLOW = (1.0, 0.8549019607843137, 0.011764705882352941)
    SUN_YELLOW = (1.0, 0.8745098039215686, 0.13333333333333333)
    MUSTARD = (0.807843137254902, 0.7019607843137254, 0.00392156862745098)
    PALE = (1.0, 0.9764705882352941, 0.8156862745098039)
    BROWNISH_YELLOW = (0.788235294117647, 0.6901960784313725, 0.011764705882352941)
    DANDELION = (0.996078431372549, 0.8745098039215686, 0.03137254901960784)
    DULL_YELLOW = (0.9333333333333333, 0.8627450980392157, 0.3568627450980392)
    DARK_CREAM = (1.0, 0.9529411764705882, 0.6039215686274509)
    SANDY_YELLOW = (0.9921568627450981, 0.9333333333333333, 0.45098039215686275)
    MUSTARD_YELLOW = (0.8235294117647058, 0.7411764705882353, 0.0392156862745098)
    MUDDY_YELLOW = (0.7490196078431373, 0.6745098039215687, 0.0196078431372549)
    CEMENT = (0.6470588235294118, 0.6392156862745098, 0.5686274509803921)
    UGLY_BROWN = (0.49019607843137253, 0.44313725490196076, 0.011764705882352941)
    GREENISH_BROWN = (0.4117647058823529, 0.3803921568627451, 0.07058823529411765)
    GREENY_BROWN = (0.4117647058823529, 0.3764705882352941, 0.023529411764705882)
    BUFF = (0.996078431372549, 0.9647058823529412, 0.6196078431372549)
    YELLOWISH = (0.9803921568627451, 0.9333333333333333, 0.4)
    GREEN_BROWN = (0.32941176470588235, 0.3058823529411765, 0.011764705882352941)
    UGLY_YELLOW = (0.8156862745098039, 0.7568627450980392, 0.00392156862745098)
    OLIVE_YELLOW = (0.7607843137254902, 0.7176470588235294, 0.03529411764705882)
    KHAKI = (0.6666666666666666, 0.6509803921568628, 0.3843137254901961)
    EGG_SHELL = (1.0, 0.9882352941176471, 0.7686274509803922)
    STRAW = (0.9882352941176471, 0.9647058823529412, 0.4745098039215686)
    BROWN_GREEN = (0.4392156862745098, 0.4235294117647059, 0.06666666666666667)
    MANILLA = (1.0, 0.9803921568627451, 0.5254901960784314)
    DIRTY_YELLOW = (0.803921568627451, 0.7725490196078432, 0.0392156862745098)
    PISS_YELLOW = (0.8666666666666667, 0.8392156862745098, 0.09411764705882353)
    VOMIT_YELLOW = (0.7803921568627451, 0.7568627450980392, 0.047058823529411764)
    BROWNY_GREEN = (0.43529411764705883, 0.4235294117647059, 0.0392156862745098)
    SUNNY_YELLOW = (1.0, 0.9764705882352941, 0.09019607843137255)
    PARCHMENT = (0.996078431372549, 0.9882352941176471, 0.6862745098039216)
    PUKE_YELLOW = (0.7607843137254902, 0.7450980392156863, 0.054901960784313725)
    CUSTARD = (1.0, 0.9921568627450981, 0.47058823529411764)
    BUTTER_YELLOW = (1.0, 0.9921568627450981, 0.4549019607843137)
    LIGHT_BEIGE = (1.0, 0.996078431372549, 0.7137254901960784)
    SUNSHINE_YELLOW = (1.0, 0.9921568627450981, 0.21568627450980393)
    BRIGHT_YELLOW = (1.0, 0.9921568627450981, 0.00392156862745098)
    LIGHT_YELLOW = (1.0, 0.996078431372549, 0.47843137254901963)
    PASTEL_YELLOW = (1.0, 0.996078431372549, 0.44313725490196076)
    CANARY_YELLOW = (1.0, 0.996078431372549, 0.25098039215686274)
    OFF_WHITE = (1.0, 1.0, 0.8941176470588236)
    EGGSHELL = (1.0, 1.0, 0.8313725490196079)
    IVORY = (1.0, 1.0, 0.796078431372549)
    CREAM = (1.0, 1.0, 0.7607843137254902)
    CREME = (1.0, 1.0, 0.7137254901960784)
    PALE_YELLOW = (1.0, 1.0, 0.5176470588235295)
    YELLOWISH_TAN = (0.9882352941176471, 0.9882352941176471, 0.5058823529411764)
    BUTTER = (1.0, 1.0, 0.5058823529411764)
    BANANA = (1.0, 1.0, 0.49411764705882355)
    YELLOW = (1.0, 1.0, 0.0784313725490196)
    PUKE = (0.6470588235294118, 0.6470588235294118, 0.00784313725490196)
    FADED_YELLOW = (0.996078431372549, 1.0, 0.4980392156862745)
    LEMON_YELLOW = (0.9921568627450981, 1.0, 0.2196078431372549)
    OFF_YELLOW = (0.9450980392156862, 0.9529411764705882, 0.24705882352941178)
    LEMON = (0.9921568627450981, 1.0, 0.3215686274509804)
    CANARY = (0.9921568627450981, 1.0, 0.38823529411764707)
    VOMIT = (0.6352941176470588, 0.6431372549019608, 0.08235294117647059)
    DRAB = (0.5098039215686274, 0.5137254901960784, 0.26666666666666666)
    ECRU = (0.996078431372549, 1.0, 0.792156862745098)
    BANANA_YELLOW = (0.9803921568627451, 0.996078431372549, 0.29411764705882354)
    BROWNISH_GREEN = (0.41568627450980394, 0.43137254901960786, 0.03529411764705882)
    PEA_SOUP = (0.5725490196078431, 0.6, 0.00392156862745098)
    MUD_GREEN = (0.3764705882352941, 0.4, 0.00784313725490196)
    BABY_POOP_GREEN = (0.5607843137254902, 0.596078431372549, 0.0196078431372549)
    OLIVE = (0.43137254901960786, 0.4588235294117647, 0.054901960784313725)
    MUSTARD_GREEN = (0.6588235294117647, 0.7098039215686275, 0.01568627450980392)
    BABY_PUKE_GREEN = (0.7137254901960784, 0.7686274509803922, 0.023529411764705882)
    BILE = (0.7098039215686275, 0.7647058823529411, 0.023529411764705882)
    SHIT_GREEN = (0.4588235294117647, 0.5019607843137255, 0.0)
    SNOT = (0.6745098039215687, 0.7333333333333333, 0.050980392156862744)
    GREENISH_BEIGE = (0.788235294117647, 0.8196078431372549, 0.4745098039215686)
    OLIVE_DRAB = (0.43529411764705883, 0.4627450980392157, 0.19607843137254902)
    POOP_GREEN = (0.43529411764705883, 0.48627450980392156, 0.0)
    SICKLY_YELLOW = (0.8156862745098039, 0.8941176470588236, 0.1607843137254902)
    DARK_OLIVE = (0.21568627450980393, 0.24313725490196078, 0.00784313725490196)
    BABY_SHIT_GREEN = (0.5333333333333333, 0.592156862745098, 0.09019607843137255)
    PUKE_GREEN = (0.6039215686274509, 0.6823529411764706, 0.027450980392156862)
    PEA_SOUP_GREEN = (0.5803921568627451, 0.6509803921568628, 0.09019607843137255)
    GREEN_SLASH_YELLOW = (0.7098039215686275, 0.807843137254902, 0.03137254901960784)
    SWAMP_GREEN = (0.4549019607843137, 0.5215686274509804, 0.0)
    MURKY_GREEN = (0.4235294117647059, 0.47843137254901963, 0.054901960784313725)
    BARF_GREEN = (0.5803921568627451, 0.6745098039215687, 0.00784313725490196)
    LIGHT_KHAKI = (0.9019607843137255, 0.9490196078431372, 0.6352941176470588)
    VOMIT_GREEN = (0.5372549019607843, 0.6352941176470588, 0.011764705882352941)
    OLIVE_GREEN = (0.403921568627451, 0.47843137254901963, 0.01568627450980392)
    BRIGHT_OLIVE = (0.611764705882353, 0.7333333333333333, 0.01568627450980392)
    BOOGER_GREEN = (0.5882352941176471, 0.7058823529411765, 0.011764705882352941)
    PEA = (0.6431372549019608, 0.7490196078431373, 0.12549019607843137)
    GROSS_GREEN = (0.6274509803921569, 0.7490196078431373, 0.08627450980392157)
    GREENISH_TAN = (0.7372549019607844, 0.796078431372549, 0.47843137254901963)
    SNOT_GREEN = (0.615686274509804, 0.7568627450980392, 0.0)
    PEA_GREEN = (0.5568627450980392, 0.6705882352941176, 0.07058823529411765)
    NEON_YELLOW = (0.8117647058823529, 1.0, 0.01568627450980392)
    GREENISH_YELLOW = (0.803921568627451, 0.9921568627450981, 0.00784313725490196)
    UGLY_GREEN = (0.47843137254901963, 0.592156862745098, 0.011764705882352941)
    SICK_GREEN = (0.615686274509804, 0.7254901960784313, 0.17254901960784313)
    SICKLY_GREEN = (0.5803921568627451, 0.6980392156862745, 0.10980392156862745)
    LIME_YELLOW = (0.8156862745098039, 0.996078431372549, 0.11372549019607843)
    DARK_YELLOW_GREEN = (0.4470588235294118, 0.5607843137254902, 0.00784313725490196)
    GREENY_YELLOW = (0.7764705882352941, 0.9725490196078431, 0.03137254901960784)
    BOOGER = (0.6078431372549019, 0.7098039215686275, 0.23529411764705882)
    LIGHT_OLIVE = (0.6745098039215687, 0.7490196078431373, 0.4117647058823529)
    ICKY_GREEN = (0.5607843137254902, 0.6823529411764706, 0.13333333333333333)
    YELLOWISH_GREEN = (0.6901960784313725, 0.8666666666666667, 0.08627450980392157)
    MUDDY_GREEN = (0.396078431372549, 0.4549019607843137, 0.19607843137254902)
    DARK_OLIVE_GREEN = (0.23529411764705882, 0.30196078431372547, 0.011764705882352941)
    CHARTREUSE = (0.7568627450980392, 0.9725490196078431, 0.0392156862745098)
    CAMO = (0.4980392156862745, 0.5607843137254902, 0.3058823529411765)
    YELLOWY_GREEN = (0.7490196078431373, 0.9450980392156862, 0.1568627450980392)
    GREEN_YELLOW = (0.788235294117647, 1.0, 0.15294117647058825)
    AVOCADO_GREEN = (0.5294117647058824, 0.6627450980392157, 0.13333333333333333)
    PALE_OLIVE = (0.7254901960784313, 0.8, 0.5058823529411764)
    ARMY_GREEN = (0.29411764705882354, 0.36470588235294116, 0.08627450980392157)
    SLIME_GREEN = (0.6, 0.8, 0.01568627450980392)
    KHAKI_GREEN = (0.4470588235294118, 0.5254901960784314, 0.2235294117647059)
    AVOCADO = (0.5647058823529412, 0.6941176470588235, 0.20392156862745098)
    YELLOWGREEN = (0.7333333333333333, 0.9764705882352941, 0.058823529411764705)
    LIGHT_OLIVE_GREEN = (0.6431372549019608, 0.7450980392156863, 0.3607843137254902)
    TAN_GREEN = (0.6627450980392157, 0.7450980392156863, 0.4392156862745098)
    YELLOW_SLASH_GREEN = (0.7843137254901961, 0.9921568627450981, 0.23921568627450981)
    DARK_LIME = (0.5176470588235295, 0.7176470588235294, 0.00392156862745098)
    CAMOUFLAGE_GREEN = (0.29411764705882354, 0.3803921568627451, 0.07450980392156863)
    YELLOW_GREEN = (0.7529411764705882, 0.984313725490196, 0.17647058823529413)
    DIRTY_GREEN = (0.4, 0.49411764705882355, 0.17254901960784313)
    PEAR = (0.796078431372549, 0.9725490196078431, 0.37254901960784315)
    LEMON_LIME = (0.7490196078431373, 0.996078431372549, 0.1568627450980392)
    CAMO_GREEN = (0.3215686274509804, 0.396078431372549, 0.1450980392156863)
    LEMON_GREEN = (0.6784313725490196, 0.9725490196078431, 0.00784313725490196)
    DARK_LIME_GREEN = (0.49411764705882355, 0.7411764705882353, 0.00392156862745098)
    ELECTRIC_LIME = (0.6588235294117647, 1.0, 0.01568627450980392)
    SWAMP = (0.4117647058823529, 0.5137254901960784, 0.2235294117647059)
    MILITARY_GREEN = (0.4, 0.48627450980392156, 0.24313725490196078)
    PALE_OLIVE_GREEN = (0.6941176470588235, 0.8235294117647058, 0.4823529411764706)
    BRIGHT_YELLOW_GREEN = (0.615686274509804, 1.0, 0.0)
    LIGHT_YELLOW_GREEN = (0.8, 0.9921568627450981, 0.4980392156862745)
    SAP_GREEN = (0.3607843137254902, 0.5450980392156862, 0.08235294117647059)
    MOSSY_GREEN = (0.38823529411764707, 0.5450980392156862, 0.15294117647058825)
    LIGHT_MOSS_GREEN = (0.6509803921568628, 0.7843137254901961, 0.4588235294117647)
    NAVY_GREEN = (0.20784313725490197, 0.3254901960784314, 0.0392156862745098)
    LIME = (0.6666666666666666, 1.0, 0.19607843137254902)
    ACID_GREEN = (0.5607843137254902, 0.996078431372549, 0.03529411764705882)
    PALE_LIME = (0.7450980392156863, 0.9921568627450981, 0.45098039215686275)
    LIGHT_LIME_GREEN = (0.7254901960784313, 1.0, 0.4)
    MOSS_GREEN = (0.396078431372549, 0.5450980392156862, 0.2196078431372549)
    LEAF_GREEN = (0.3607843137254902, 0.6627450980392157, 0.01568627450980392)
    LIGHT_PEA_GREEN = (0.7686274509803922, 0.996078431372549, 0.5098039215686274)
    LIME_GREEN = (0.5372549019607843, 0.996078431372549, 0.0196078431372549)
    BRIGHT_LIME = (0.5294117647058824, 0.9921568627450981, 0.0196078431372549)
    KIWI = (0.611764705882353, 0.9372549019607843, 0.2627450980392157)
    LEAF = (0.44313725490196076, 0.6666666666666666, 0.20392156862745098)
    KERMIT_GREEN = (0.3607843137254902, 0.6980392156862745, 0.0)
    DRAB_GREEN = (0.4549019607843137, 0.5843137254901961, 0.3176470588235294)
    PALE_LIME_GREEN = (0.6941176470588235, 1.0, 0.396078431372549)
    LIGHT_YELLOWISH_GREEN = (0.7607843137254902, 1.0, 0.5372549019607843)
    APPLE_GREEN = (0.4627450980392157, 0.803921568627451, 0.14901960784313725)
    PISTACHIO = (0.7529411764705882, 0.9803921568627451, 0.5450980392156862)
    KIWI_GREEN = (0.5568627450980392, 0.8980392156862745, 0.24705882352941178)
    MOSS = (0.4627450980392157, 0.6, 0.34509803921568627)
    LIGHT_LIME = (0.6823529411764706, 0.9921568627450981, 0.4235294117647059)
    FROG_GREEN = (0.34509803921568627, 0.7372549019607844, 0.03137254901960784)
    KEY_LIME = (0.6823529411764706, 1.0, 0.43137254901960786)
    LAWN_GREEN = (0.30196078431372547, 0.6431372549019608, 0.03529411764705882)
    NASTY_GREEN = (0.4392156862745098, 0.6980392156862745, 0.24705882352941178)
    CELERY = (0.7568627450980392, 0.9921568627450981, 0.5843137254901961)
    DARK_GRASS_GREEN = (0.2196078431372549, 0.5019607843137255, 0.01568627450980392)
    SPRING_GREEN = (0.6627450980392157, 0.9764705882352941, 0.44313725490196076)
    GRASSY_GREEN = (0.2549019607843137, 0.611764705882353, 0.011764705882352941)
    ASPARAGUS = (0.4666666666666667, 0.6705882352941176, 0.33725490196078434)
    BRIGHT_LIME_GREEN = (0.396078431372549, 0.996078431372549, 0.03137254901960784)
    GRASS = (0.3607843137254902, 0.6745098039215687, 0.17647058823529413)
    LIGHT_GRASS_GREEN = (0.6039215686274509, 0.9686274509803922, 0.39215686274509803)
    TURTLE_GREEN = (0.4588235294117647, 0.7215686274509804, 0.30980392156862746)
    GRASS_GREEN = (0.24705882352941178, 0.6078431372549019, 0.043137254901960784)
    FLAT_GREEN = (0.4117647058823529, 0.615686274509804, 0.2980392156862745)
    APPLE = (0.43137254901960786, 0.796078431372549, 0.23529411764705882)
    LIGHT_GRAY_GREEN = (0.7176470588235294, 0.8823529411764706, 0.6313725490196078)
    LIGHT_GREY_GREEN = (0.7176470588235294, 0.8823529411764706, 0.6313725490196078)
    LICHEN = (0.5607843137254902, 0.7137254901960784, 0.4823529411764706)
    SAGE = (0.5294117647058824, 0.6823529411764706, 0.45098039215686275)
    GREEN_APPLE = (0.3686274509803922, 0.8627450980392157, 0.12156862745098039)
    MEDIUM_GRAY = (0.49019607843137253, 0.4980392156862745, 0.48627450980392156)
    MEDIUM_GREY = (0.49019607843137253, 0.4980392156862745, 0.48627450980392156)
    LIGHT_GRAY = (0.8470588235294118, 0.8627450980392157, 0.8392156862745098)
    LIGHT_GREY = (0.8470588235294118, 0.8627450980392157, 0.8392156862745098)
    TEA_GREEN = (0.7411764705882353, 0.9725490196078431, 0.6392156862745098)
    TOXIC_GREEN = (0.3803921568627451, 0.8705882352941177, 0.16470588235294117)
    LIGHT_LIGHT_GREEN = (0.7843137254901961, 1.0, 0.6901960784313725)
    VERY_LIGHT_GREEN = (0.8196078431372549, 1.0, 0.7411764705882353)
    OFF_GREEN = (0.4196078431372549, 0.6392156862745098, 0.3254901960784314)
    VERY_PALE_GREEN = (0.8117647058823529, 0.9921568627450981, 0.7372549019607844)
    WASHED_OUT_GREEN = (0.7372549019607844, 0.9607843137254902, 0.6509803921568628)
    GREENISH_GRAY = (0.5882352941176471, 0.6823529411764706, 0.5529411764705883)
    GREENISH_GREY = (0.5882352941176471, 0.6823529411764706, 0.5529411764705883)
    SAGE_GREEN = (0.5333333333333333, 0.7019607843137254, 0.47058823529411764)
    DULL_GREEN = (0.4549019607843137, 0.6509803921568628, 0.3843137254901961)
    GRAY_SLASH_GREEN = (0.5254901960784314, 0.6313725490196078, 0.49019607843137253)
    GREY_SLASH_GREEN = (0.5254901960784314, 0.6313725490196078, 0.49019607843137253)
    LIGHT_SAGE = (0.7372549019607844, 0.9254901960784314, 0.6745098039215687)
    PALE_GREEN = (0.7803921568627451, 0.9921568627450981, 0.7098039215686275)
    GRAY = (0.5725490196078431, 0.5843137254901961, 0.5686274509803921)
    GREY = (0.5725490196078431, 0.5843137254901961, 0.5686274509803921)
    PALE_LIGHT_GREEN = (0.6941176470588235, 0.9882352941176471, 0.6)
    FORREST_GREEN = (0.08235294117647059, 0.26666666666666666, 0.023529411764705882)
    GREEN_GRAY = (0.4666666666666667, 0.5725490196078431, 0.43529411764705883)
    GREEN_GREY = (0.4666666666666667, 0.5725490196078431, 0.43529411764705883)
    FERN_GREEN = (0.32941176470588235, 0.5529411764705883, 0.26666666666666666)
    LIGHT_GREEN = (0.5882352941176471, 0.9764705882352941, 0.4823529411764706)
    FERN = (0.38823529411764707, 0.6627450980392157, 0.3137254901960784)
    PASTEL_GREEN = (0.6901960784313725, 1.0, 0.615686274509804)
    FRESH_GREEN = (0.4117647058823529, 0.8470588235294118, 0.30980392156862746)
    POISON_GREEN = (0.25098039215686274, 0.9921568627450981, 0.0784313725490196)
    LEAFY_GREEN = (0.3176470588235294, 0.7176470588235294, 0.23137254901960785)
    TREE_GREEN = (0.16470588235294117, 0.49411764705882355, 0.09803921568627451)
    MUTED_GREEN = (0.37254901960784315, 0.6274509803921569, 0.3215686274509804)
    LIGHT_PASTEL_GREEN = (0.6980392156862745, 0.984313725490196, 0.6470588235294118)
    VIVID_GREEN = (0.1843137254901961, 0.9372549019607843, 0.06274509803921569)
    GRAY_GREEN = (0.47058823529411764, 0.6078431372549019, 0.45098039215686275)
    GREY_GREEN = (0.47058823529411764, 0.6078431372549019, 0.45098039215686275)
    GRAYISH_GREEN = (0.5098039215686274, 0.6509803921568628, 0.49019607843137253)
    GREYISH_GREEN = (0.5098039215686274, 0.6509803921568628, 0.49019607843137253)
    LIGHTER_GREEN = (0.4588235294117647, 0.9921568627450981, 0.38823529411764707)
    FADED_GREEN = (0.4823529411764706, 0.6980392156862745, 0.4549019607843137)
    EASTER_GREEN = (0.5490196078431373, 0.9921568627450981, 0.49411764705882355)
    GREENY_GRAY = (0.49411764705882355, 0.6274509803921569, 0.47843137254901963)
    GREENY_GREY = (0.49411764705882355, 0.6274509803921569, 0.47843137254901963)
    CELADON = (0.7450980392156863, 0.9921568627450981, 0.7176470588235294)
    MID_GREEN = (0.3137254901960784, 0.6549019607843137, 0.2784313725490196)
    HIGHLIGHTER_GREEN = (0.10588235294117647, 0.9882352941176471, 0.023529411764705882)
    ELECTRIC_GREEN = (0.12941176470588237, 0.9882352941176471, 0.050980392156862744)
    VERY_DARK_GREEN = (0.023529411764705882, 0.1803921568627451, 0.011764705882352941)
    DARK_SAGE = (0.34901960784313724, 0.5215686274509804, 0.33725490196078434)
    RADIOACTIVE_GREEN = (0.17254901960784313, 0.9803921568627451, 0.12156862745098039)
    DARK_GREEN = (0.011764705882352941, 0.20784313725490197, 0.0)
    DUSTY_GREEN = (0.4627450980392157, 0.6627450980392157, 0.45098039215686275)
    HUNTER_GREEN = (0.043137254901960784, 0.25098039215686274, 0.03137254901960784)
    FLURO_GREEN = (0.0392156862745098, 1.0, 0.00784313725490196)
    TRUE_GREEN = (0.03137254901960784, 0.5803921568627451, 0.01568627450980392)
    FOREST = (0.043137254901960784, 0.3333333333333333, 0.03529411764705882)
    RACING_GREEN = (0.00392156862745098, 0.27450980392156865, 0.0)
    VIBRANT_GREEN = (0.0392156862745098, 0.8666666666666667, 0.03137254901960784)
    LIGHTISH_GREEN = (0.3803921568627451, 0.8823529411764706, 0.3764705882352941)
    NEON_GREEN = (0.047058823529411764, 1.0, 0.047058823529411764)
    FLUORESCENT_GREEN = (0.03137254901960784, 1.0, 0.03137254901960784)
    DARK_PASTEL_GREEN = (0.33725490196078434, 0.6823529411764706, 0.3411764705882353)
    BOTTLE_GREEN = (0.01568627450980392, 0.2901960784313726, 0.0196078431372549)
    HOT_GREEN = (0.1450980392156863, 1.0, 0.1607843137254902)
    BRIGHT_GREEN = (0.00392156862745098, 1.0, 0.027450980392156862)
    BORING_GREEN = (0.38823529411764707, 0.7019607843137254, 0.396078431372549)
    DARKGREEN = (0.0196078431372549, 0.28627450980392155, 0.027450980392156862)
    GREEN = (0.08235294117647059, 0.6901960784313725, 0.10196078431372549)
    LIGHT_NEON_GREEN = (0.3058823529411765, 0.9921568627450981, 0.32941176470588235)
    LIGHTGREEN = (0.4627450980392157, 1.0, 0.4823529411764706)
    LIGHT_BRIGHT_GREEN = (0.3254901960784314, 0.996078431372549, 0.3607843137254902)
    LIGHT_FOREST_GREEN = (0.30980392156862746, 0.5686274509803921, 0.3254901960784314)
    LIGHT_MINT = (0.7137254901960784, 1.0, 0.7333333333333333)
    SOFT_GREEN = (0.43529411764705883, 0.7607843137254902, 0.4627450980392157)
    DARK_FOREST_GREEN = (0.0, 0.17647058823529413, 0.01568627450980392)
    FOREST_GREEN = (0.023529411764705882, 0.2784313725490196, 0.047058823529411764)
    BRITISH_RACING_GREEN = (
        0.0196078431372549,
        0.2823529411764706,
        0.050980392156862744,
    )
    MEDIUM_GREEN = (0.2235294117647059, 0.6784313725490196, 0.2823529411764706)
    LIGHT_MINT_GREEN = (0.6509803921568628, 0.984313725490196, 0.6980392156862745)
    MINT_GREEN = (0.5607843137254902, 1.0, 0.6235294117647059)
    DEEP_GREEN = (0.00784313725490196, 0.34901960784313724, 0.058823529411764705)
    BABY_GREEN = (0.5490196078431373, 1.0, 0.6196078431372549)
    LIGHT_SEAFOAM_GREEN = (0.6549019607843137, 1.0, 0.7098039215686275)
    DARKISH_GREEN = (0.1568627450980392, 0.48627450980392156, 0.21568627450980393)
    MINT = (0.6235294117647059, 0.996078431372549, 0.6901960784313725)
    PINE = (0.16862745098039217, 0.36470588235294116, 0.20392156862745098)
    BRIGHT_LIGHT_GREEN = (0.17647058823529413, 0.996078431372549, 0.32941176470588235)
    EMERALD_GREEN = (0.00784313725490196, 0.5607843137254902, 0.11764705882352941)
    SLATE_GREEN = (0.396078431372549, 0.5529411764705883, 0.42745098039215684)
    HOSPITAL_GREEN = (0.6078431372549019, 0.8980392156862745, 0.6666666666666666)
    ALGAE = (0.32941176470588235, 0.6745098039215687, 0.40784313725490196)
    FOAM_GREEN = (0.5647058823529412, 0.9921568627450981, 0.6627450980392157)
    LIGHT_SEA_GREEN = (0.596078431372549, 0.9647058823529412, 0.6901960784313725)
    KELLY_GREEN = (0.00784313725490196, 0.6705882352941176, 0.1803921568627451)
    IRISH_GREEN = (0.00392156862745098, 0.5843137254901961, 0.1607843137254902)
    PINE_GREEN = (0.0392156862745098, 0.2823529411764706, 0.11764705882352941)
    TEA = (0.396078431372549, 0.6705882352941176, 0.48627450980392156)
    LIGHT_SEAFOAM = (0.6274509803921569, 0.996078431372549, 0.7490196078431373)
    DARK_MINT = (0.2823529411764706, 0.7529411764705882, 0.4470588235294118)
    COOL_GREEN = (0.2, 0.7215686274509804, 0.39215686274509803)
    LIGHT_BLUISH_GREEN = (0.4627450980392157, 0.9921568627450981, 0.6588235294117647)
    SEAFOAM = (0.5019607843137255, 0.9764705882352941, 0.6784313725490196)
    KELLEY_GREEN = (0.0, 0.5764705882352941, 0.21568627450980393)
    SEAFOAM_GREEN = (0.47843137254901963, 0.9764705882352941, 0.6705882352941176)
    SHAMROCK_GREEN = (0.00784313725490196, 0.7568627450980392, 0.30196078431372547)
    WEIRD_GREEN = (0.22745098039215686, 0.8980392156862745, 0.4980392156862745)
    SPEARMINT = (0.11764705882352941, 0.9725490196078431, 0.4627450980392157)
    GREENISH = (0.25098039215686274, 0.6392156862745098, 0.40784313725490196)
    SHAMROCK = (0.00392156862745098, 0.7058823529411765, 0.2980392156862745)
    LIGHT_BLUE_GREEN = (0.49411764705882355, 0.984313725490196, 0.7019607843137254)
    SEAWEED_GREEN = (0.20784313725490197, 0.6784313725490196, 0.4196078431372549)
    EMERALD = (0.00392156862745098, 0.6274509803921569, 0.28627450980392155)
    LIGHT_GREEN_BLUE = (0.33725490196078434, 0.9882352941176471, 0.6352941176470588)
    SEA_GREEN = (0.3254901960784314, 0.9882352941176471, 0.6313725490196078)
    WINTERGREEN = (0.12549019607843137, 0.9764705882352941, 0.5254901960784314)
    JADE_GREEN = (0.16862745098039217, 0.6862745098039216, 0.41568627450980394)
    ALGAE_GREEN = (0.12941176470588237, 0.7647058823529411, 0.43529411764705883)
    MINTY_GREEN = (0.043137254901960784, 0.9686274509803922, 0.49019607843137253)
    TEALISH_GREEN = (0.047058823529411764, 0.8627450980392157, 0.45098039215686275)
    DARK_SEAFOAM_GREEN = (0.24313725490196078, 0.6862745098039216, 0.4627450980392157)
    SILVER = (0.7725490196078432, 0.788235294117647, 0.7803921568627451)
    JUNGLE_GREEN = (0.01568627450980392, 0.5098039215686274, 0.2627450980392157)
    DARK_MINT_GREEN = (0.12549019607843137, 0.7529411764705882, 0.45098039215686275)
    SEAWEED = (0.09411764705882353, 0.8196078431372549, 0.4823529411764706)
    SPRUCE = (0.0392156862745098, 0.37254901960784315, 0.2196078431372549)
    LIGHT_GREENISH_BLUE = (0.38823529411764707, 0.9686274509803922, 0.7058823529411765)
    TURQUOISE_GREEN = (0.01568627450980392, 0.9568627450980393, 0.5372549019607843)
    PALE_TURQUOISE = (0.6470588235294118, 0.984313725490196, 0.8352941176470589)
    EVERGREEN = (0.0196078431372549, 0.2784313725490196, 0.16470588235294117)
    GREENISH_TEAL = (0.19607843137254902, 0.7490196078431373, 0.5176470588235295)
    BLUEY_GREEN = (0.16862745098039217, 0.6941176470588235, 0.4745098039215686)
    LIGHT_TEAL = (0.5647058823529412, 0.8941176470588236, 0.7568627450980392)
    LIGHT_AQUAMARINE = (0.4823529411764706, 0.9921568627450981, 0.7803921568627451)
    OCEAN_GREEN = (0.23921568627450981, 0.6, 0.45098039215686275)
    TEAL_GREEN = (0.1450980392156863, 0.6392156862745098, 0.43529411764705883)
    DARK_SEAFOAM = (0.12156862745098039, 0.7098039215686275, 0.47843137254901963)
    AQUA_GREEN = (0.07058823529411765, 0.8823529411764706, 0.5764705882352941)
    JADE = (0.12156862745098039, 0.6549019607843137, 0.4549019607843137)
    GREEN_TEAL = (0.047058823529411764, 0.7098039215686275, 0.4666666666666667)
    VIRIDIAN = (0.11764705882352941, 0.5686274509803921, 0.403921568627451)
    BRIGHT_SEA_GREEN = (0.0196078431372549, 1.0, 0.6509803921568628)
    DARK_SEA_GREEN = (0.06666666666666667, 0.5294117647058824, 0.36470588235294116)
    GREENBLUE = (0.13725490196078433, 0.7686274509803922, 0.5450980392156862)
    PALE_TEAL = (0.5098039215686274, 0.796078431372549, 0.6980392156862745)
    LIGHT_TURQUOISE = (0.49411764705882355, 0.9568627450980393, 0.8)
    GREENISH_CYAN = (0.16470588235294117, 0.996078431372549, 0.7176470588235294)
    BLUISH_GREEN = (0.06274509803921569, 0.6509803921568628, 0.4549019607843137)
    LIGHT_AQUA = (0.5490196078431373, 1.0, 0.8588235294117647)
    GRAYISH_TEAL = (0.44313725490196076, 0.6235294117647059, 0.5686274509803921)
    GREYISH_TEAL = (0.44313725490196076, 0.6235294117647059, 0.5686274509803921)
    SEAFOAM_BLUE = (0.47058823529411764, 0.8196078431372549, 0.7137254901960784)
    GREENISH_TURQUOISE = (0.0, 0.984313725490196, 0.6901960784313725)
    PALE_AQUA = (0.7215686274509804, 1.0, 0.9215686274509803)
    GRAY_TEAL = (0.3686274509803922, 0.6078431372549019, 0.5411764705882353)
    GREY_TEAL = (0.3686274509803922, 0.6078431372549019, 0.5411764705882353)
    GREEN_SLASH_BLUE = (0.00392156862745098, 0.7529411764705882, 0.5529411764705883)
    GREENY_BLUE = (0.25882352941176473, 0.7019607843137254, 0.5843137254901961)
    CHARCOAL = (0.20392156862745098, 0.2196078431372549, 0.21568627450980393)
    AQUA_MARINE = (0.1803921568627451, 0.9098039215686274, 0.7333333333333333)
    DULL_TEAL = (0.37254901960784315, 0.6196078431372549, 0.5607843137254902)
    GREEN_BLUE = (0.023529411764705882, 0.7058823529411765, 0.5450980392156862)
    BRIGHT_TEAL = (0.00392156862745098, 0.9764705882352941, 0.7764705882352941)
    TIFFANY_BLUE = (0.4823529411764706, 0.9490196078431372, 0.8549019607843137)
    AQUAMARINE = (0.01568627450980392, 0.8470588235294118, 0.6980392156862745)
    DARK_GREEN_BLUE = (0.12156862745098039, 0.38823529411764707, 0.3411764705882353)
    DUSTY_TEAL = (0.2980392156862745, 0.5647058823529412, 0.5215686274509804)
    BLUE_GREEN = (0.07450980392156863, 0.49411764705882355, 0.42745098039215684)
    AQUA = (0.07450980392156863, 0.9176470588235294, 0.788235294117647)
    EGGSHELL_BLUE = (0.7686274509803922, 1.0, 0.9686274509803922)
    TEALISH = (0.1411764705882353, 0.7372549019607844, 0.6588235294117647)
    DUCK_EGG_BLUE = (0.7647058823529411, 0.984313725490196, 0.9568627450980393)
    ICE = (0.8392156862745098, 1.0, 0.9803921568627451)
    TURQUOISE = (0.023529411764705882, 0.7607843137254902, 0.6745098039215687)
    DARK_BLUE_GREEN = (0.0, 0.3215686274509804, 0.28627450980392155)
    BLUE_SLASH_GREEN = (0.058823529411764705, 0.6078431372549019, 0.5568627450980392)
    TEAL = (0.00784313725490196, 0.5764705882352941, 0.5254901960784314)
    LIGHT_LIGHT_BLUE = (0.792156862745098, 1.0, 0.984313725490196)
    SEA = (0.23529411764705882, 0.6, 0.5725490196078431)
    TOPAZ = (0.07450980392156863, 0.7333333333333333, 0.6862745098039216)
    PALE_CYAN = (0.7176470588235294, 1.0, 0.9803921568627451)
    BRIGHT_AQUA = (0.043137254901960784, 0.9764705882352941, 0.9176470588235294)
    LIGHT_CYAN = (0.6745098039215687, 1.0, 0.9882352941176471)
    GREENISH_BLUE = (0.043137254901960784, 0.5450980392156862, 0.5294117647058824)
    ICE_BLUE = (0.8431372549019608, 1.0, 0.996078431372549)
    VERY_PALE_BLUE = (0.8392156862745098, 1.0, 0.996078431372549)
    DARK_TURQUOISE = (0.01568627450980392, 0.3607843137254902, 0.35294117647058826)
    BRIGHT_TURQUOISE = (0.058823529411764705, 0.996078431372549, 0.9764705882352941)
    DARK_AQUAMARINE = (0.00392156862745098, 0.45098039215686275, 0.44313725490196076)
    BLUEGREEN = (0.00392156862745098, 0.47843137254901963, 0.4745098039215686)
    DARK_GRAY = (0.21176470588235294, 0.21568627450980393, 0.21568627450980393)
    DARK_GREY = (0.21176470588235294, 0.21568627450980393, 0.21568627450980393)
    VERY_LIGHT_BLUE = (0.8352941176470589, 1.0, 1.0)
    REALLY_LIGHT_BLUE = (0.8313725490196079, 1.0, 1.0)
    PALE_BLUE = (0.8156862745098039, 0.996078431372549, 0.996078431372549)
    ALMOST_BLACK = (0.027450980392156862, 0.050980392156862744, 0.050980392156862744)
    CYAN = (0.0, 1.0, 1.0)
    BRIGHT_CYAN = (0.2549019607843137, 0.9921568627450981, 0.996078431372549)
    DEEP_TURQUOISE = (0.00392156862745098, 0.45098039215686275, 0.4549019607843137)
    DARK_TEAL = (0.00392156862745098, 0.30196078431372547, 0.3058823529411765)
    DARK_CYAN = (0.0392156862745098, 0.5333333333333333, 0.5411764705882353)
    DARK_AQUA = (0.0196078431372549, 0.4117647058823529, 0.4196078431372549)
    BRIGHT_LIGHT_BLUE = (0.14901960784313725, 0.9686274509803922, 0.9921568627450981)
    LIGHT_SKY_BLUE = (0.7764705882352941, 0.9882352941176471, 1.0)
    DEEP_TEAL = (0.0, 0.3333333333333333, 0.35294117647058826)
    DEEP_AQUA = (0.03137254901960784, 0.47058823529411764, 0.4980392156862745)
    AQUA_BLUE = (0.00784313725490196, 0.8470588235294118, 0.9137254901960784)
    TURQUOISE_BLUE = (0.023529411764705882, 0.6941176470588235, 0.7686274509803922)
    ROBIN_S_EGG_BLUE = (0.596078431372549, 0.9372549019607843, 0.9764705882352941)
    PETROL = (0.0, 0.37254901960784315, 0.41568627450980394)
    ROBIN_S_EGG = (0.42745098039215684, 0.9294117647058824, 0.9921568627450981)
    ROBIN_EGG_BLUE = (0.5411764705882353, 0.9450980392156862, 0.996078431372549)
    PALE_SKY_BLUE = (0.7411764705882353, 0.9647058823529412, 0.996078431372549)
    TEAL_BLUE = (0.00392156862745098, 0.5333333333333333, 0.6235294117647059)
    NEON_BLUE = (0.01568627450980392, 0.8509803921568627, 1.0)
    OCEAN = (0.00392156862745098, 0.4823529411764706, 0.5725490196078431)
    CHARCOAL_GRAY = (0.23529411764705882, 0.2549019607843137, 0.25882352941176473)
    CHARCOAL_GREY = (0.23529411764705882, 0.2549019607843137, 0.25882352941176473)
    COOL_GRAY = (0.5843137254901961, 0.6392156862745098, 0.6509803921568628)
    COOL_GREY = (0.5843137254901961, 0.6392156862745098, 0.6509803921568628)
    BRIGHT_SKY_BLUE = (0.00784313725490196, 0.8, 0.996078431372549)
    SEA_BLUE = (0.01568627450980392, 0.4549019607843137, 0.5843137254901961)
    GUNMETAL = (0.3254901960784314, 0.3843137254901961, 0.403921568627451)
    OCEAN_BLUE = (0.011764705882352941, 0.44313725490196076, 0.611764705882353)
    DIRTY_BLUE = (0.24705882352941178, 0.5098039215686274, 0.615686274509804)
    STEEL_GRAY = (0.43529411764705883, 0.5098039215686274, 0.5411764705882353)
    STEEL_GREY = (0.43529411764705883, 0.5098039215686274, 0.5411764705882353)
    PEACOCK_BLUE = (0.00392156862745098, 0.403921568627451, 0.5843137254901961)
    GRAYBLUE = (0.4666666666666667, 0.6313725490196078, 0.7098039215686275)
    GREYBLUE = (0.4666666666666667, 0.6313725490196078, 0.7098039215686275)
    BLUEGRAY = (0.5215686274509804, 0.6392156862745098, 0.6980392156862745)
    BLUEGREY = (0.5215686274509804, 0.6392156862745098, 0.6980392156862745)
    NICE_BLUE = (0.06274509803921569, 0.47843137254901963, 0.6901960784313725)
    BLUISH_GRAY = (0.4549019607843137, 0.5450980392156862, 0.592156862745098)
    BLUISH_GREY = (0.4549019607843137, 0.5450980392156862, 0.592156862745098)
    BATTLESHIP_GRAY = (0.4196078431372549, 0.48627450980392156, 0.5215686274509804)
    BATTLESHIP_GREY = (0.4196078431372549, 0.48627450980392156, 0.5215686274509804)
    DEEP_SEA_BLUE = (0.00392156862745098, 0.32941176470588235, 0.5098039215686274)
    WATER_BLUE = (0.054901960784313725, 0.5294117647058824, 0.8)
    CERULEAN = (0.01568627450980392, 0.5215686274509804, 0.8196078431372549)
    LIGHTBLUE = (0.4823529411764706, 0.7843137254901961, 0.9647058823529412)
    AZURE = (0.023529411764705882, 0.6039215686274509, 0.9529411764705882)
    BLUE_GRAY = (0.3764705882352941, 0.48627450980392156, 0.5568627450980392)
    BLUE_GREY = (0.3764705882352941, 0.48627450980392156, 0.5568627450980392)
    DARK_BLUE_GRAY = (0.12156862745098039, 0.23137254901960785, 0.30196078431372547)
    DARK_BLUE_GREY = (0.12156862745098039, 0.23137254901960785, 0.30196078431372547)
    SLATE = (0.3176470588235294, 0.396078431372549, 0.4470588235294118)
    SLATE_GRAY = (0.34901960784313724, 0.396078431372549, 0.42745098039215684)
    SLATE_GREY = (0.34901960784313724, 0.396078431372549, 0.42745098039215684)
    UGLY_BLUE = (0.19215686274509805, 0.4, 0.5411764705882353)
    GRAY_SLASH_BLUE = (0.39215686274509803, 0.49019607843137253, 0.5568627450980392)
    GREY_SLASH_BLUE = (0.39215686274509803, 0.49019607843137253, 0.5568627450980392)
    DARK_SLATE_BLUE = (0.12941176470588237, 0.2784313725490196, 0.3803921568627451)
    SKY = (0.5098039215686274, 0.792156862745098, 0.9882352941176471)
    BLUEY_GRAY = (0.5372549019607843, 0.6274509803921569, 0.6901960784313725)
    BLUEY_GREY = (0.5372549019607843, 0.6274509803921569, 0.6901960784313725)
    DARK_GRAY_BLUE = (0.1607843137254902, 0.27450980392156865, 0.3568627450980392)
    DARK_GREY_BLUE = (0.1607843137254902, 0.27450980392156865, 0.3568627450980392)
    PRUSSIAN_BLUE = (0.0, 0.27058823529411763, 0.4666666666666667)
    LIGHT_BLUE = (0.5843137254901961, 0.8156862745098039, 0.9882352941176471)
    METALLIC_BLUE = (0.30980392156862746, 0.45098039215686275, 0.5568627450980392)
    STORMY_BLUE = (0.3137254901960784, 0.4823529411764706, 0.611764705882353)
    LIGHT_GRAY_BLUE = (0.615686274509804, 0.7372549019607844, 0.8313725490196079)
    LIGHT_GREY_BLUE = (0.615686274509804, 0.7372549019607844, 0.8313725490196079)
    GRAY_BLUE = (0.4196078431372549, 0.5450980392156862, 0.6431372549019608)
    GREY_BLUE = (0.4196078431372549, 0.5450980392156862, 0.6431372549019608)
    GRAYISH_BLUE = (0.3686274509803922, 0.5058823529411764, 0.615686274509804)
    GREYISH_BLUE = (0.3686274509803922, 0.5058823529411764, 0.615686274509804)
    STEEL_BLUE = (0.35294117647058826, 0.49019607843137253, 0.6039215686274509)
    MUTED_BLUE = (0.23137254901960785, 0.44313725490196076, 0.6235294117647059)
    SLATE_BLUE = (0.3568627450980392, 0.48627450980392156, 0.6)
    COOL_BLUE = (0.28627450980392155, 0.5176470588235295, 0.7215686274509804)
    LIGHT_NAVY = (0.08235294117647059, 0.3137254901960784, 0.5176470588235295)
    DUSTY_BLUE = (0.35294117647058826, 0.5254901960784314, 0.6784313725490196)
    DULL_BLUE = (0.28627450980392155, 0.4588235294117647, 0.611764705882353)
    STEEL = (0.45098039215686275, 0.5215686274509804, 0.5843137254901961)
    CADET_BLUE = (0.3058823529411765, 0.4549019607843137, 0.5882352941176471)
    BLUISH = (0.1607843137254902, 0.4627450980392157, 0.7333333333333333)
    MARINE_BLUE = (0.00392156862745098, 0.2196078431372549, 0.41568627450980394)
    OFF_BLUE = (0.33725490196078434, 0.5176470588235295, 0.6823529411764706)
    BLUE_SLASH_GRAY = (0.4588235294117647, 0.5529411764705883, 0.6392156862745098)
    BLUE_SLASH_GREY = (0.4588235294117647, 0.5529411764705883, 0.6392156862745098)
    SKY_BLUE = (0.4588235294117647, 0.7333333333333333, 0.9921568627450981)
    FLAT_BLUE = (0.23529411764705882, 0.45098039215686275, 0.6588235294117647)
    TWILIGHT_BLUE = (0.0392156862745098, 0.2627450980392157, 0.47843137254901963)
    DARKISH_BLUE = (0.00392156862745098, 0.2549019607843137, 0.5098039215686274)
    DENIM = (0.23137254901960785, 0.38823529411764707, 0.5490196078431373)
    BABY_BLUE = (0.6352941176470588, 0.8117647058823529, 0.996078431372549)
    LIGHT_NAVY_BLUE = (0.1803921568627451, 0.35294117647058826, 0.5333333333333333)
    CLOUDY_BLUE = (0.6745098039215687, 0.7607843137254902, 0.8509803921568627)
    MID_BLUE = (0.15294117647058825, 0.41568627450980394, 0.7019607843137254)
    WINDOWS_BLUE = (0.21568627450980393, 0.47058823529411764, 0.7490196078431373)
    MEDIUM_BLUE = (0.17254901960784313, 0.43529411764705883, 0.7333333333333333)
    DARK_SKY_BLUE = (0.26666666666666666, 0.5568627450980392, 0.8941176470588236)
    MARINE = (0.01568627450980392, 0.1803921568627451, 0.3764705882352941)
    FADED_BLUE = (0.396078431372549, 0.5490196078431373, 0.7333333333333333)
    CERULEAN_BLUE = (0.0196078431372549, 0.43137254901960786, 0.9333333333333333)
    DEEP_SKY_BLUE = (0.050980392156862744, 0.4588235294117647, 0.9725490196078431)
    DUSK_BLUE = (0.14901960784313725, 0.3254901960784314, 0.5529411764705883)
    POWDER_BLUE = (0.6941176470588235, 0.8196078431372549, 0.9882352941176471)
    LIGHT_BLUE_GRAY = (0.7176470588235294, 0.788235294117647, 0.8862745098039215)
    LIGHT_BLUE_GREY = (0.7176470588235294, 0.788235294117647, 0.8862745098039215)
    DARK = (0.10588235294117647, 0.1411764705882353, 0.19215686274509805)
    BRIGHT_BLUE = (0.00392156862745098, 0.396078431372549, 0.9882352941176471)
    CAROLINA_BLUE = (0.5411764705882353, 0.7215686274509804, 0.996078431372549)
    CLEAR_BLUE = (0.1411764705882353, 0.47843137254901963, 0.9921568627450981)
    FRENCH_BLUE = (0.2627450980392157, 0.4196078431372549, 0.6784313725490196)
    COBALT = (0.11764705882352941, 0.2823529411764706, 0.5607843137254902)
    DENIM_BLUE = (0.23137254901960785, 0.3568627450980392, 0.5725490196078431)
    DODGER_BLUE = (0.24313725490196078, 0.5098039215686274, 0.9882352941176471)
    NAVY = (0.00392156862745098, 0.08235294117647059, 0.24313725490196078)
    LIGHTISH_BLUE = (0.23921568627450981, 0.47843137254901963, 0.9921568627450981)
    PASTEL_BLUE = (0.6352941176470588, 0.7490196078431373, 0.996078431372549)
    DUSKY_BLUE = (0.2784313725490196, 0.37254901960784315, 0.5803921568627451)
    AZUL = (0.11372549019607843, 0.36470588235294116, 0.9254901960784314)
    ELECTRIC_BLUE = (0.023529411764705882, 0.3215686274509804, 1.0)
    BLUE = (0.011764705882352941, 0.2627450980392157, 0.8745098039215686)
    SOFT_BLUE = (0.39215686274509803, 0.5333333333333333, 0.9176470588235294)
    NAVY_BLUE = (0.0, 0.06666666666666667, 0.27450980392156865)
    CORNFLOWER_BLUE = (0.3176470588235294, 0.4392156862745098, 0.8431372549019608)
    VIBRANT_BLUE = (0.011764705882352941, 0.2235294117647059, 0.9725490196078431)
    BLUE_BLUE = (0.13333333333333333, 0.25882352941176473, 0.7803921568627451)
    SAPPHIRE = (0.12941176470588237, 0.2196078431372549, 0.6705882352941176)
    DUSK = (0.3058823529411765, 0.32941176470588235, 0.5058823529411764)
    VIVID_BLUE = (0.08235294117647059, 0.1803921568627451, 1.0)
    CORNFLOWER = (0.41568627450980394, 0.4745098039215686, 0.9686274509803922)
    RICH_BLUE = (0.00784313725490196, 0.10588235294117647, 0.9764705882352941)
    PERIWINKLE_BLUE = (0.5607843137254902, 0.6, 0.984313725490196)
    LIGHT_PERIWINKLE = (0.7568627450980392, 0.7764705882352941, 0.9882352941176471)
    WARM_BLUE = (0.29411764705882354, 0.3411764705882353, 0.8588235294117647)
    ROYAL = (0.047058823529411764, 0.09019607843137255, 0.5764705882352941)
    DARK_NAVY = (0.0, 0.01568627450980392, 0.20784313725490197)
    TRUE_BLUE = (0.00392156862745098, 0.058823529411764705, 0.8)
    TWILIGHT = (0.3058823529411765, 0.3176470588235294, 0.5450980392156862)
    DARK_NAVY_BLUE = (0.0, 0.00784313725490196, 0.1803921568627451)
    COBALT_BLUE = (0.011764705882352941, 0.0392156862745098, 0.6549019607843137)
    DARKBLUE = (0.011764705882352941, 0.027450980392156862, 0.39215686274509803)
    DARK_ROYAL_BLUE = (0.00784313725490196, 0.023529411764705882, 0.43529411764705883)
    DARK_BLUE = (0.0, 0.011764705882352941, 0.3568627450980392)
    VERY_DARK_BLUE = (0.0, 0.00392156862745098, 0.2)
    PURE_BLUE = (0.00784313725490196, 0.011764705882352941, 0.8862745098039215)
    PALE_GRAY = (0.9921568627450981, 0.9921568627450981, 0.996078431372549)
    PALE_GREY = (0.9921568627450981, 0.9921568627450981, 0.996078431372549)
    ROYAL_BLUE = (0.0196078431372549, 0.01568627450980392, 0.6666666666666666)
    NIGHT_BLUE = (0.01568627450980392, 0.011764705882352941, 0.2823529411764706)
    PRIMARY_BLUE = (0.03137254901960784, 0.01568627450980392, 0.9764705882352941)
    DEEP_BLUE = (0.01568627450980392, 0.00784313725490196, 0.45098039215686275)
    STRONG_BLUE = (0.047058823529411764, 0.023529411764705882, 0.9686274509803922)
    LAVENDER_BLUE = (0.5450980392156862, 0.5333333333333333, 0.9725490196078431)
    PERRYWINKLE = (0.5607843137254902, 0.5490196078431373, 0.9058823529411765)
    MIDNIGHT_BLUE = (0.00784313725490196, 0.0, 0.20784313725490197)
    MIDNIGHT = (0.011764705882352941, 0.00392156862745098, 0.17647058823529413)
    LIGHT_ROYAL_BLUE = (0.22745098039215686, 0.1803921568627451, 0.996078431372549)
    BLUEBERRY = (0.27450980392156865, 0.2549019607843137, 0.5882352941176471)
    DARK_PERIWINKLE = (0.4, 0.37254901960784315, 0.8196078431372549)
    ULTRAMARINE_BLUE = (0.09411764705882353, 0.0196078431372549, 0.8588235294117647)
    IRIS = (0.3843137254901961, 0.34509803921568627, 0.7686274509803922)
    PERIWINKLE = (0.5568627450980392, 0.5098039215686274, 0.996078431372549)
    LIGHT_INDIGO = (0.42745098039215684, 0.35294117647058826, 0.8117647058823529)
    BLUE_WITH_A_HINT_OF_PURPLE = (
        0.3254901960784314,
        0.23529411764705882,
        0.7764705882352941,
    )
    ULTRAMARINE = (0.12549019607843137, 0.0, 0.6941176470588235)
    PURPLEISH_BLUE = (0.3803921568627451, 0.25098039215686274, 0.9372549019607843)
    BLURPLE = (0.3333333333333333, 0.2235294117647059, 0.8)
    INDIGO_BLUE = (0.22745098039215686, 0.09411764705882353, 0.6941176470588235)
    PURPLEY_BLUE = (0.37254901960784315, 0.20392156862745098, 0.9058823529411765)
    BLUEY_PURPLE = (0.3843137254901961, 0.2549019607843137, 0.7803921568627451)
    BLUE_PURPLE = (0.3411764705882353, 0.1607843137254902, 0.807843137254902)
    PURPLE_BLUE = (0.38823529411764707, 0.17647058823529413, 0.9137254901960784)
    DARK_INDIGO = (0.12156862745098039, 0.03529411764705882, 0.32941176470588235)
    PURPLISH_BLUE = (0.3764705882352941, 0.11764705882352941, 0.9764705882352941)
    BURPLE = (0.40784313725490196, 0.19607843137254902, 0.8901960784313725)
    BLUISH_PURPLE = (0.4392156862745098, 0.23137254901960785, 0.9058823529411765)
    PURPLE_SLASH_BLUE = (0.36470588235294116, 0.12941176470588237, 0.8156862745098039)
    PURPLEY = (0.5294117647058824, 0.33725490196078434, 0.8941176470588236)
    PURPLY_BLUE = (0.4, 0.10196078431372549, 0.9333333333333333)
    BLUE_SLASH_PURPLE = (0.35294117647058826, 0.023529411764705882, 0.9372549019607843)
    VIOLET_BLUE = (0.3176470588235294, 0.0392156862745098, 0.788235294117647)
    BLUE_VIOLET = (0.36470588235294116, 0.023529411764705882, 0.9137254901960784)
    PALE_VIOLET = (0.807843137254902, 0.6823529411764706, 0.9803921568627451)
    INDIGO = (0.2196078431372549, 0.00784313725490196, 0.5098039215686274)
    PASTEL_PURPLE = (0.792156862745098, 0.6274509803921569, 1.0)
    LIGHT_LAVENDER = (0.8745098039215686, 0.7725490196078432, 0.996078431372549)
    LIGHT_VIOLET = (0.8392156862745098, 0.7058823529411765, 0.9882352941176471)
    PALE_LILAC = (0.8941176470588236, 0.796078431372549, 1.0)
    LILAC = (0.807843137254902, 0.6352941176470588, 0.9921568627450981)
    LILIAC = (0.7686274509803922, 0.5568627450980392, 0.9921568627450981)
    LIGHTER_PURPLE = (0.6470588235294118, 0.35294117647058826, 0.9568627450980393)
    LAVENDER = (0.7803921568627451, 0.6235294117647059, 0.9372549019607843)
    LIGHT_URPLE = (0.7019607843137254, 0.43529411764705883, 0.9647058823529412)
    DEEP_LILAC = (0.5882352941176471, 0.43137254901960786, 0.7411764705882353)
    BABY_PURPLE = (0.792156862745098, 0.6078431372549019, 0.9686274509803922)
    DEEP_LAVENDER = (0.5529411764705883, 0.3686274509803922, 0.7176470588235294)
    EASTER_PURPLE = (0.7529411764705882, 0.44313725490196076, 0.996078431372549)
    LIGHTISH_PURPLE = (0.6470588235294118, 0.3215686274509804, 0.9019607843137255)
    LIGHT_PURPLE = (0.7490196078431373, 0.4666666666666667, 0.9647058823529412)
    PALE_PURPLE = (0.7176470588235294, 0.5647058823529412, 0.8313725490196079)
    VIVID_PURPLE = (0.6, 0.0, 0.9803921568627451)
    DARK_LAVENDER = (0.5215686274509804, 0.403921568627451, 0.596078431372549)
    ELECTRIC_PURPLE = (0.6666666666666666, 0.13725490196078433, 1.0)
    AMETHYST = (0.6078431372549019, 0.37254901960784315, 0.7529411764705882)
    WISTERIA = (0.6588235294117647, 0.49019607843137253, 0.7607843137254902)
    VIOLET = (0.6039215686274509, 0.054901960784313725, 0.9176470588235294)
    BRIGHT_LAVENDER = (0.7803921568627451, 0.3764705882352941, 1.0)
    PALE_LAVENDER = (0.9333333333333333, 0.8117647058823529, 0.996078431372549)
    BRIGHT_VIOLET = (0.6784313725490196, 0.0392156862745098, 0.9921568627450981)
    LIGHT_LILAC = (0.9294117647058824, 0.7843137254901961, 1.0)
    GRAY_PURPLE = (0.5098039215686274, 0.42745098039215684, 0.5490196078431373)
    GREY_PURPLE = (0.5098039215686274, 0.42745098039215684, 0.5490196078431373)
    BRIGHT_LILAC = (0.788235294117647, 0.3686274509803922, 0.984313725490196)
    ROYAL_PURPLE = (0.29411764705882354, 0.0, 0.43137254901960786)
    GRAYISH_PURPLE = (0.5333333333333333, 0.44313725490196076, 0.5686274509803921)
    GREYISH_PURPLE = (0.5333333333333333, 0.44313725490196076, 0.5686274509803921)
    NEON_PURPLE = (0.7372549019607844, 0.07450980392156863, 0.996078431372549)
    MIDNIGHT_PURPLE = (0.1568627450980392, 0.00392156862745098, 0.21568627450980393)
    BRIGHT_PURPLE = (0.7450980392156863, 0.011764705882352941, 0.9921568627450981)
    LIGHT_LAVENDAR = (0.9372549019607843, 0.7529411764705882, 0.996078431372549)
    PURPLE = (0.49411764705882355, 0.11764705882352941, 0.611764705882353)
    PURPLY = (0.596078431372549, 0.24705882352941178, 0.6980392156862745)
    VIBRANT_PURPLE = (0.6784313725490196, 0.011764705882352941, 0.8705882352941177)
    PURPLISH_GRAY = (0.47843137254901963, 0.40784313725490196, 0.4980392156862745)
    PURPLISH_GREY = (0.47843137254901963, 0.40784313725490196, 0.4980392156862745)
    SOFT_PURPLE = (0.6509803921568628, 0.43529411764705883, 0.7098039215686275)
    HEATHER = (0.6431372549019608, 0.5176470588235295, 0.6745098039215687)
    VERY_DARK_PURPLE = (0.16470588235294117, 0.00392156862745098, 0.20392156862745098)
    FADED_PURPLE = (0.5686274509803921, 0.43137254901960786, 0.6)
    DARK_VIOLET = (0.20392156862745098, 0.00392156862745098, 0.24705882352941178)
    HOT_PURPLE = (0.796078431372549, 0.0, 0.9607843137254902)
    HELIOTROPE = (0.8509803921568627, 0.30980392156862746, 0.9607843137254902)
    DARK_LILAC = (0.611764705882353, 0.42745098039215684, 0.6470588235294118)
    DARK_PURPLE = (0.20784313725490197, 0.023529411764705882, 0.24313725490196078)
    MUTED_PURPLE = (0.5019607843137255, 0.3568627450980392, 0.5294117647058824)
    DEEP_PURPLE = (0.21176470588235294, 0.00392156862745098, 0.24705882352941178)
    VERY_LIGHT_PURPLE = (0.9647058823529412, 0.807843137254902, 0.9882352941176471)
    DUSTY_PURPLE = (0.5098039215686274, 0.37254901960784315, 0.5294117647058824)
    BARNEY = (0.6745098039215687, 0.11372549019607843, 0.7215686274509804)
    MEDIUM_PURPLE = (0.6196078431372549, 0.2627450980392157, 0.6352941176470588)
    PURPLE_SLASH_PINK = (0.8431372549019608, 0.1450980392156863, 0.8705882352941177)
    PLUM_PURPLE = (0.3058823529411765, 0.0196078431372549, 0.3137254901960784)
    PINKISH_PURPLE = (0.8392156862745098, 0.2823529411764706, 0.8431372549019608)
    VIOLET_PINK = (0.984313725490196, 0.37254901960784315, 0.9882352941176471)
    PURPLEY_GRAY = (0.5803921568627451, 0.49411764705882355, 0.5803921568627451)
    PURPLEY_GREY = (0.5803921568627451, 0.49411764705882355, 0.5803921568627451)
    PINK_PURPLE = (0.8588235294117647, 0.29411764705882354, 0.8549019607843137)
    DEEP_VIOLET = (0.28627450980392155, 0.023529411764705882, 0.2823529411764706)
    LIGHT_MAGENTA = (0.9803921568627451, 0.37254901960784315, 0.9686274509803922)
    DARKISH_PURPLE = (0.4588235294117647, 0.09803921568627451, 0.45098039215686275)
    EGGPLANT_PURPLE = (0.2627450980392157, 0.0196078431372549, 0.2549019607843137)
    PINK_SLASH_PURPLE = (0.9372549019607843, 0.11372549019607843, 0.9058823529411765)
    UGLY_PURPLE = (0.6431372549019608, 0.25882352941176473, 0.6274509803921569)
    PURPLE_GRAY = (0.5254901960784314, 0.43529411764705883, 0.5215686274509804)
    PURPLE_GREY = (0.5254901960784314, 0.43529411764705883, 0.5215686274509804)
    PALE_MAUVE = (0.996078431372549, 0.8156862745098039, 0.9882352941176471)
    ORCHID = (0.7843137254901961, 0.4588235294117647, 0.7686274509803922)
    PURPLE_PINK = (0.8784313725490196, 0.24705882352941178, 0.8470588235294118)
    BARNEY_PURPLE = (0.6274509803921569, 0.01568627450980392, 0.596078431372549)
    WARM_PURPLE = (0.5843137254901961, 0.1803921568627451, 0.5607843137254902)
    LIGHT_EGGPLANT = (0.5372549019607843, 0.27058823529411763, 0.5215686274509804)
    EGGPLANT = (0.2196078431372549, 0.03137254901960784, 0.20784313725490197)
    LAVENDER_PINK = (0.8666666666666667, 0.5215686274509804, 0.8431372549019608)
    PURPLY_PINK = (0.9411764705882353, 0.4588235294117647, 0.9019607843137255)
    PINKY_PURPLE = (0.788235294117647, 0.2980392156862745, 0.7450980392156863)
    FUCHSIA = (0.9294117647058824, 0.050980392156862744, 0.8509803921568627)
    BRIGHT_MAGENTA = (1.0, 0.03137254901960784, 0.9098039215686274)
    DUSTY_LAVENDER = (0.6745098039215687, 0.5254901960784314, 0.6588235294117647)
    PURPLEY_PINK = (0.7843137254901961, 0.23529411764705882, 0.7254901960784313)
    PURPLISH = (0.5803921568627451, 0.33725490196078434, 0.5490196078431373)
    DULL_PURPLE = (0.5176470588235295, 0.34901960784313724, 0.49411764705882355)
    CANDY_PINK = (1.0, 0.38823529411764707, 0.9137254901960784)
    PURPLEISH_PINK = (0.8745098039215686, 0.3058823529411765, 0.7843137254901961)
    GRAPE_PURPLE = (0.36470588235294116, 0.0784313725490196, 0.3176470588235294)
    PURPLEISH = (0.596078431372549, 0.33725490196078434, 0.5529411764705883)
    AUBERGINE = (0.23921568627450981, 0.027450980392156862, 0.20392156862745098)
    HOT_MAGENTA = (0.9607843137254902, 0.01568627450980392, 0.788235294117647)
    GRAPE = (0.4235294117647059, 0.20392156862745098, 0.3803921568627451)
    BRUISE = (0.49411764705882355, 0.25098039215686274, 0.44313725490196076)
    RICH_PURPLE = (0.4470588235294118, 0.0, 0.34509803921568627)
    PURPLISH_PINK = (0.807843137254902, 0.36470588235294116, 0.6823529411764706)
    DUSKY_PURPLE = (0.5372549019607843, 0.3568627450980392, 0.4823529411764706)
    BRIGHT_PINK = (0.996078431372549, 0.00392156862745098, 0.6941176470588235)
    DARK_PLUM = (0.24705882352941178, 0.00392156862745098, 0.17254901960784313)
    PLUM = (0.34509803921568627, 0.058823529411764705, 0.2549019607843137)
    VELVET = (0.4588235294117647, 0.03137254901960784, 0.3176470588235294)
    DIRTY_PURPLE = (0.45098039215686275, 0.2901960784313726, 0.396078431372549)
    RED_VIOLET = (0.6196078431372549, 0.00392156862745098, 0.40784313725490196)
    SHOCKING_PINK = (0.996078431372549, 0.00784313725490196, 0.6352941176470588)
    LIGHT_PLUM = (0.615686274509804, 0.3411764705882353, 0.5137254901960784)
    PALE_MAGENTA = (0.8431372549019608, 0.403921568627451, 0.6784313725490196)
    MAGENTA = (0.7607843137254902, 0.0, 0.47058823529411764)
    NEON_PINK = (0.996078431372549, 0.00392156862745098, 0.6039215686274509)
    BUBBLEGUM_PINK = (0.996078431372549, 0.5137254901960784, 0.8)
    DARK_MAGENTA = (0.5882352941176471, 0.0, 0.33725490196078434)
    DEEP_MAGENTA = (0.6274509803921569, 0.00784313725490196, 0.3607843137254902)
    ELECTRIC_PINK = (1.0, 0.01568627450980392, 0.5647058823529412)
    HOT_PINK = (1.0, 0.00784313725490196, 0.5529411764705883)
    DARK_FUCHSIA = (0.615686274509804, 0.027450980392156862, 0.34901960784313724)
    REDDISH_PURPLE = (0.5686274509803921, 0.03529411764705882, 0.3176470588235294)
    STRONG_PINK = (1.0, 0.027450980392156862, 0.5372549019607843)
    RED_PURPLE = (0.5098039215686274, 0.027450980392156862, 0.2784313725490196)
    BARBIE_PINK = (0.996078431372549, 0.27450980392156865, 0.6470588235294118)
    VIOLET_RED = (0.6470588235294118, 0.0, 0.3333333333333333)
    PINK = (1.0, 0.5058823529411764, 0.7529411764705882)
    MULBERRY = (0.5725490196078431, 0.0392156862745098, 0.3058823529411765)
    BUBBLEGUM = (1.0, 0.4235294117647059, 0.7098039215686275)
    MERLOT = (0.45098039215686275, 0.0, 0.2235294117647059)
    WINE = (0.5019607843137255, 0.00392156862745098, 0.24705882352941178)
    DEEP_PINK = (0.796078431372549, 0.00392156862745098, 0.3843137254901961)
    DARK_HOT_PINK = (0.8509803921568627, 0.00392156862745098, 0.4)
    BUBBLE_GUM_PINK = (1.0, 0.4117647058823529, 0.6862745098039216)
    PURPLE_RED = (0.6, 0.00392156862745098, 0.2784313725490196)
    BERRY = (0.6, 0.058823529411764705, 0.29411764705882354)
    RASPBERRY = (0.6901960784313725, 0.00392156862745098, 0.28627450980392155)
    CERISE = (0.8705882352941177, 0.047058823529411764, 0.3843137254901961)
    PURPLISH_RED = (0.6901960784313725, 0.0196078431372549, 0.29411764705882354)
    POWDER_PINK = (1.0, 0.6980392156862745, 0.8156862745098039)
    DARK_MAUVE = (0.5294117647058824, 0.2980392156862745, 0.3843137254901961)
    DARKISH_PINK = (0.8549019607843137, 0.27450980392156865, 0.49019607843137253)
    RED_WINE = (0.5490196078431373, 0.0, 0.20392156862745098)
    CRANBERRY = (0.6196078431372549, 0.0, 0.22745098039215686)
    MEDIUM_PINK = (0.9529411764705882, 0.3803921568627451, 0.5882352941176471)
    BURGUNDY = (0.3803921568627451, 0.0, 0.13725490196078433)
    BORDEAUX = (0.4823529411764706, 0.0, 0.17254901960784313)
    RUBY = (0.792156862745098, 0.00392156862745098, 0.2784313725490196)
    MAROON = (0.396078431372549, 0.0, 0.12941176470588237)
    BABY_PINK = (1.0, 0.7176470588235294, 0.807843137254902)
    LIGHT_MAUVE = (0.7607843137254902, 0.5725490196078431, 0.6313725490196078)
    CARNATION_PINK = (1.0, 0.4980392156862745, 0.6549019607843137)
    ROSE_RED = (0.7450980392156863, 0.00392156862745098, 0.23529411764705882)
    PINK_RED = (0.9607843137254902, 0.0196078431372549, 0.30980392156862746)
    PINKY = (0.9882352941176471, 0.5254901960784314, 0.6666666666666666)
    LIGHT_PINK = (1.0, 0.8196078431372549, 0.8745098039215686)
    DARK_PINK = (0.796078431372549, 0.2549019607843137, 0.4196078431372549)
    DULL_PINK = (0.8352941176470589, 0.5254901960784314, 0.615686274509804)
    LIPSTICK = (0.8352941176470589, 0.09019607843137255, 0.3058823529411765)
    PASTEL_PINK = (1.0, 0.7294117647058823, 0.803921568627451)
    MUTED_PINK = (0.8196078431372549, 0.4627450980392157, 0.5607843137254902)
    PALE_PINK = (1.0, 0.8117647058823529, 0.8627450980392157)
    ROSY_PINK = (0.9647058823529412, 0.40784313725490196, 0.5568627450980392)
    WINE_RED = (0.4823529411764706, 0.011764705882352941, 0.13725490196078433)
    WARM_PINK = (0.984313725490196, 0.3333333333333333, 0.5058823529411764)
    MAUVE = (0.6823529411764706, 0.44313725490196076, 0.5058823529411764)
    PIG_PINK = (0.9058823529411765, 0.5568627450980392, 0.6470588235294118)
    ROUGE = (0.6705882352941176, 0.07058823529411765, 0.2235294117647059)
    LIGHT_BURGUNDY = (0.6588235294117647, 0.2549019607843137, 0.3568627450980392)
    ROSA = (0.996078431372549, 0.5254901960784314, 0.6431372549019608)
    DEEP_ROSE = (0.7803921568627451, 0.2784313725490196, 0.403921568627451)
    PINKISH_RED = (0.9450980392156862, 0.047058823529411764, 0.27058823529411763)
    CHERRY = (0.8117647058823529, 0.00784313725490196, 0.20392156862745098)
    LIPSTICK_RED = (0.7529411764705882, 0.00784313725490196, 0.1843137254901961)
    FADED_PINK = (0.8705882352941177, 0.615686274509804, 0.6745098039215687)
    BROWNISH_PURPLE = (0.4627450980392157, 0.25882352941176473, 0.3058823529411765)
    CLARET = (0.40784313725490196, 0.0, 0.09411764705882353)
    GRAY_PINK = (0.7647058823529411, 0.5647058823529412, 0.6078431372549019)
    GREY_PINK = (0.7647058823529411, 0.5647058823529412, 0.6078431372549019)
    SOFT_PINK = (0.9921568627450981, 0.6901960784313725, 0.7529411764705882)
    DUSKY_PINK = (0.8, 0.47843137254901963, 0.5450980392156862)
    RED_PINK = (0.9803921568627451, 0.16470588235294117, 0.3333333333333333)
    NEON_RED = (1.0, 0.027450980392156862, 0.22745098039215686)
    DARK_ROSE = (0.7098039215686275, 0.2823529411764706, 0.36470588235294116)
    REDDISH_PINK = (0.996078431372549, 0.17254901960784313, 0.32941176470588235)
    PINKISH = (0.8313725490196079, 0.41568627450980394, 0.49411764705882355)
    ROSE = (0.8117647058823529, 0.3843137254901961, 0.4588235294117647)
    UGLY_PINK = (0.803921568627451, 0.4588235294117647, 0.5176470588235295)
    ROSE_PINK = (0.9686274509803922, 0.5294117647058824, 0.6039215686274509)
    OLD_PINK = (0.7803921568627451, 0.4745098039215686, 0.5254901960784314)
    CARNATION = (0.9921568627450981, 0.4745098039215686, 0.5607843137254902)
    LIGHT_MAROON = (0.6352941176470588, 0.2823529411764706, 0.3411764705882353)
    CHERRY_RED = (0.9686274509803922, 0.00784313725490196, 0.16470588235294117)
    PINKY_RED = (0.9882352941176471, 0.14901960784313725, 0.2784313725490196)
    OLD_ROSE = (0.7843137254901961, 0.4980392156862745, 0.5372549019607843)
    DUSKY_ROSE = (0.7294117647058823, 0.40784313725490196, 0.45098039215686275)
    DUSTY_PINK = (0.8352941176470589, 0.5411764705882353, 0.5803921568627451)
    DARK_MAROON = (0.23529411764705882, 0.0, 0.03137254901960784)
    LIGHTISH_RED = (0.996078431372549, 0.1843137254901961, 0.2901960784313726)
    CARMINE = (0.615686274509804, 0.00784313725490196, 0.08627450980392157)
    SCARLET = (0.7450980392156863, 0.00392156862745098, 0.09803921568627451)
    STRAWBERRY = (0.984313725490196, 0.1607843137254902, 0.2627450980392157)
    PURPLISH_BROWN = (0.4196078431372549, 0.25882352941176473, 0.2784313725490196)
    GRAYISH_PINK = (0.7843137254901961, 0.5529411764705883, 0.5803921568627451)
    GREYISH_PINK = (0.7843137254901961, 0.5529411764705883, 0.5803921568627451)
    PURPLE_BROWN = (0.403921568627451, 0.22745098039215686, 0.24705882352941178)
    CRIMSON = (0.5490196078431373, 0.0, 0.058823529411764705)
    WATERMELON = (0.9921568627450981, 0.27450980392156865, 0.34901960784313724)
    LIGHT_ROSE = (1.0, 0.7725490196078432, 0.796078431372549)
    DUSTY_ROSE = (0.7529411764705882, 0.45098039215686275, 0.47843137254901963)
    BLUSH_PINK = (0.996078431372549, 0.5098039215686274, 0.5490196078431373)
    PALE_ROSE = (0.9921568627450981, 0.7568627450980392, 0.7725490196078432)
    DIRTY_PINK = (0.792156862745098, 0.4823529411764706, 0.5019607843137255)
    DUSTY_RED = (0.7254901960784313, 0.2823529411764706, 0.3058823529411765)
    BRIGHT_RED = (1.0, 0.0, 0.050980392156862744)
    FADED_RED = (0.8274509803921568, 0.28627450980392155, 0.3058823529411765)
    DARKISH_RED = (0.6627450980392157, 0.011764705882352941, 0.03137254901960784)
    LIGHT_RED = (1.0, 0.2784313725490196, 0.2980392156862745)
    BLOOD_RED = (0.596078431372549, 0.0, 0.00784313725490196)
    CORAL_PINK = (1.0, 0.3803921568627451, 0.38823529411764707)
    BLOOD = (0.4666666666666667, 0.0, 0.00392156862745098)
    FIRE_ENGINE_RED = (0.996078431372549, 0.0, 0.00784313725490196)
    SALMON_PINK = (0.996078431372549, 0.4823529411764706, 0.48627450980392156)


class Css4Color(RgbTuple, Enum):
    BLACK = (0.0, 0.0, 0.0)
    DIMGRAY = (0.4117647058823529, 0.4117647058823529, 0.4117647058823529)
    DIMGREY = (0.4117647058823529, 0.4117647058823529, 0.4117647058823529)
    GRAY = (0.5019607843137255, 0.5019607843137255, 0.5019607843137255)
    GREY = (0.5019607843137255, 0.5019607843137255, 0.5019607843137255)
    DARKGRAY = (0.6627450980392157, 0.6627450980392157, 0.6627450980392157)
    DARKGREY = (0.6627450980392157, 0.6627450980392157, 0.6627450980392157)
    SILVER = (0.7529411764705882, 0.7529411764705882, 0.7529411764705882)
    LIGHTGRAY = (0.8274509803921568, 0.8274509803921568, 0.8274509803921568)
    LIGHTGREY = (0.8274509803921568, 0.8274509803921568, 0.8274509803921568)
    GAINSBORO = (0.8627450980392157, 0.8627450980392157, 0.8627450980392157)
    WHITESMOKE = (0.9607843137254902, 0.9607843137254902, 0.9607843137254902)
    WHITE = (1.0, 1.0, 1.0)
    SNOW = (1.0, 0.9803921568627451, 0.9803921568627451)
    ROSYBROWN = (0.7372549019607844, 0.5607843137254902, 0.5607843137254902)
    LIGHTCORAL = (0.9411764705882353, 0.5019607843137255, 0.5019607843137255)
    INDIANRED = (0.803921568627451, 0.3607843137254902, 0.3607843137254902)
    BROWN = (0.6470588235294118, 0.16470588235294117, 0.16470588235294117)
    FIREBRICK = (0.6980392156862745, 0.13333333333333333, 0.13333333333333333)
    MAROON = (0.5019607843137255, 0.0, 0.0)
    DARKRED = (0.5450980392156862, 0.0, 0.0)
    RED = (1.0, 0.0, 0.0)
    MISTYROSE = (1.0, 0.8941176470588236, 0.8823529411764706)
    SALMON = (0.9803921568627451, 0.5019607843137255, 0.4470588235294118)
    TOMATO = (1.0, 0.38823529411764707, 0.2784313725490196)
    DARKSALMON = (0.9137254901960784, 0.5882352941176471, 0.47843137254901963)
    CORAL = (1.0, 0.4980392156862745, 0.3137254901960784)
    ORANGERED = (1.0, 0.27058823529411763, 0.0)
    LIGHTSALMON = (1.0, 0.6274509803921569, 0.47843137254901963)
    SIENNA = (0.6274509803921569, 0.3215686274509804, 0.17647058823529413)
    SEASHELL = (1.0, 0.9607843137254902, 0.9333333333333333)
    CHOCOLATE = (0.8235294117647058, 0.4117647058823529, 0.11764705882352941)
    SADDLEBROWN = (0.5450980392156862, 0.27058823529411763, 0.07450980392156863)
    SANDYBROWN = (0.9568627450980393, 0.6431372549019608, 0.3764705882352941)
    PEACHPUFF = (1.0, 0.8549019607843137, 0.7254901960784313)
    PERU = (0.803921568627451, 0.5215686274509804, 0.24705882352941178)
    LINEN = (0.9803921568627451, 0.9411764705882353, 0.9019607843137255)
    BISQUE = (1.0, 0.8941176470588236, 0.7686274509803922)
    DARKORANGE = (1.0, 0.5490196078431373, 0.0)
    BURLYWOOD = (0.8705882352941177, 0.7215686274509804, 0.5294117647058824)
    ANTIQUEWHITE = (0.9803921568627451, 0.9215686274509803, 0.8431372549019608)
    TAN = (0.8235294117647058, 0.7058823529411765, 0.5490196078431373)
    NAVAJOWHITE = (1.0, 0.8705882352941177, 0.6784313725490196)
    BLANCHEDALMOND = (1.0, 0.9215686274509803, 0.803921568627451)
    PAPAYAWHIP = (1.0, 0.9372549019607843, 0.8352941176470589)
    MOCCASIN = (1.0, 0.8941176470588236, 0.7098039215686275)
    ORANGE = (1.0, 0.6470588235294118, 0.0)
    WHEAT = (0.9607843137254902, 0.8705882352941177, 0.7019607843137254)
    OLDLACE = (0.9921568627450981, 0.9607843137254902, 0.9019607843137255)
    FLORALWHITE = (1.0, 0.9803921568627451, 0.9411764705882353)
    DARKGOLDENROD = (0.7215686274509804, 0.5254901960784314, 0.043137254901960784)
    GOLDENROD = (0.8549019607843137, 0.6470588235294118, 0.12549019607843137)
    CORNSILK = (1.0, 0.9725490196078431, 0.8627450980392157)
    GOLD = (1.0, 0.8431372549019608, 0.0)
    LEMONCHIFFON = (1.0, 0.9803921568627451, 0.803921568627451)
    KHAKI = (0.9411764705882353, 0.9019607843137255, 0.5490196078431373)
    PALEGOLDENROD = (0.9333333333333333, 0.9098039215686274, 0.6666666666666666)
    DARKKHAKI = (0.7411764705882353, 0.7176470588235294, 0.4196078431372549)
    IVORY = (1.0, 1.0, 0.9411764705882353)
    BEIGE = (0.9607843137254902, 0.9607843137254902, 0.8627450980392157)
    LIGHTYELLOW = (1.0, 1.0, 0.8784313725490196)
    LIGHTGOLDENRODYELLOW = (0.9803921568627451, 0.9803921568627451, 0.8235294117647058)
    OLIVE = (0.5019607843137255, 0.5019607843137255, 0.0)
    YELLOW = (1.0, 1.0, 0.0)
    OLIVEDRAB = (0.4196078431372549, 0.5568627450980392, 0.13725490196078433)
    YELLOWGREEN = (0.6039215686274509, 0.803921568627451, 0.19607843137254902)
    DARKOLIVEGREEN = (0.3333333333333333, 0.4196078431372549, 0.1843137254901961)
    GREENYELLOW = (0.6784313725490196, 1.0, 0.1843137254901961)
    CHARTREUSE = (0.4980392156862745, 1.0, 0.0)
    LAWNGREEN = (0.48627450980392156, 0.9882352941176471, 0.0)
    HONEYDEW = (0.9411764705882353, 1.0, 0.9411764705882353)
    DARKSEAGREEN = (0.5607843137254902, 0.7372549019607844, 0.5607843137254902)
    PALEGREEN = (0.596078431372549, 0.984313725490196, 0.596078431372549)
    LIGHTGREEN = (0.5647058823529412, 0.9333333333333333, 0.5647058823529412)
    FORESTGREEN = (0.13333333333333333, 0.5450980392156862, 0.13333333333333333)
    LIMEGREEN = (0.19607843137254902, 0.803921568627451, 0.19607843137254902)
    DARKGREEN = (0.0, 0.39215686274509803, 0.0)
    GREEN = (0.0, 0.5019607843137255, 0.0)
    LIME = (0.0, 1.0, 0.0)
    SEAGREEN = (0.1803921568627451, 0.5450980392156862, 0.3411764705882353)
    MEDIUMSEAGREEN = (0.23529411764705882, 0.7019607843137254, 0.44313725490196076)
    SPRINGGREEN = (0.0, 1.0, 0.4980392156862745)
    MINTCREAM = (0.9607843137254902, 1.0, 0.9803921568627451)
    MEDIUMSPRINGGREEN = (0.0, 0.9803921568627451, 0.6039215686274509)
    MEDIUMAQUAMARINE = (0.4, 0.803921568627451, 0.6666666666666666)
    AQUAMARINE = (0.4980392156862745, 1.0, 0.8313725490196079)
    TURQUOISE = (0.25098039215686274, 0.8784313725490196, 0.8156862745098039)
    LIGHTSEAGREEN = (0.12549019607843137, 0.6980392156862745, 0.6666666666666666)
    MEDIUMTURQUOISE = (0.2823529411764706, 0.8196078431372549, 0.8)
    AZURE = (0.9411764705882353, 1.0, 1.0)
    LIGHTCYAN = (0.8784313725490196, 1.0, 1.0)
    PALETURQUOISE = (0.6862745098039216, 0.9333333333333333, 0.9333333333333333)
    DARKSLATEGRAY = (0.1843137254901961, 0.30980392156862746, 0.30980392156862746)
    DARKSLATEGREY = (0.1843137254901961, 0.30980392156862746, 0.30980392156862746)
    TEAL = (0.0, 0.5019607843137255, 0.5019607843137255)
    DARKCYAN = (0.0, 0.5450980392156862, 0.5450980392156862)
    AQUA = (0.0, 1.0, 1.0)
    CYAN = (0.0, 1.0, 1.0)
    DARKTURQUOISE = (0.0, 0.807843137254902, 0.8196078431372549)
    CADETBLUE = (0.37254901960784315, 0.6196078431372549, 0.6274509803921569)
    POWDERBLUE = (0.6901960784313725, 0.8784313725490196, 0.9019607843137255)
    LIGHTBLUE = (0.6784313725490196, 0.8470588235294118, 0.9019607843137255)
    DEEPSKYBLUE = (0.0, 0.7490196078431373, 1.0)
    SKYBLUE = (0.5294117647058824, 0.807843137254902, 0.9215686274509803)
    LIGHTSKYBLUE = (0.5294117647058824, 0.807843137254902, 0.9803921568627451)
    STEELBLUE = (0.27450980392156865, 0.5098039215686274, 0.7058823529411765)
    ALICEBLUE = (0.9411764705882353, 0.9725490196078431, 1.0)
    DODGERBLUE = (0.11764705882352941, 0.5647058823529412, 1.0)
    LIGHTSLATEGRAY = (0.4666666666666667, 0.5333333333333333, 0.6)
    LIGHTSLATEGREY = (0.4666666666666667, 0.5333333333333333, 0.6)
    SLATEGRAY = (0.4392156862745098, 0.5019607843137255, 0.5647058823529412)
    SLATEGREY = (0.4392156862745098, 0.5019607843137255, 0.5647058823529412)
    LIGHTSTEELBLUE = (0.6901960784313725, 0.7686274509803922, 0.8705882352941177)
    CORNFLOWERBLUE = (0.39215686274509803, 0.5843137254901961, 0.9294117647058824)
    ROYALBLUE = (0.2549019607843137, 0.4117647058823529, 0.8823529411764706)
    GHOSTWHITE = (0.9725490196078431, 0.9725490196078431, 1.0)
    LAVENDER = (0.9019607843137255, 0.9019607843137255, 0.9803921568627451)
    MIDNIGHTBLUE = (0.09803921568627451, 0.09803921568627451, 0.4392156862745098)
    NAVY = (0.0, 0.0, 0.5019607843137255)
    DARKBLUE = (0.0, 0.0, 0.5450980392156862)
    MEDIUMBLUE = (0.0, 0.0, 0.803921568627451)
    BLUE = (0.0, 0.0, 1.0)
    SLATEBLUE = (0.41568627450980394, 0.35294117647058826, 0.803921568627451)
    DARKSLATEBLUE = (0.2823529411764706, 0.23921568627450981, 0.5450980392156862)
    MEDIUMSLATEBLUE = (0.4823529411764706, 0.40784313725490196, 0.9333333333333333)
    MEDIUMPURPLE = (0.5764705882352941, 0.4392156862745098, 0.8588235294117647)
    REBECCAPURPLE = (0.4, 0.2, 0.6)
    BLUEVIOLET = (0.5411764705882353, 0.16862745098039217, 0.8862745098039215)
    INDIGO = (0.29411764705882354, 0.0, 0.5098039215686274)
    DARKORCHID = (0.6, 0.19607843137254902, 0.8)
    DARKVIOLET = (0.5803921568627451, 0.0, 0.8274509803921568)
    MEDIUMORCHID = (0.7294117647058823, 0.3333333333333333, 0.8274509803921568)
    THISTLE = (0.8470588235294118, 0.7490196078431373, 0.8470588235294118)
    PLUM = (0.8666666666666667, 0.6274509803921569, 0.8666666666666667)
    VIOLET = (0.9333333333333333, 0.5098039215686274, 0.9333333333333333)
    PURPLE = (0.5019607843137255, 0.0, 0.5019607843137255)
    DARKMAGENTA = (0.5450980392156862, 0.0, 0.5450980392156862)
    FUCHSIA = (1.0, 0.0, 1.0)
    MAGENTA = (1.0, 0.0, 1.0)
    ORCHID = (0.8549019607843137, 0.4392156862745098, 0.8392156862745098)
    MEDIUMVIOLETRED = (0.7803921568627451, 0.08235294117647059, 0.5215686274509804)
    DEEPPINK = (1.0, 0.0784313725490196, 0.5764705882352941)
    HOTPINK = (1.0, 0.4117647058823529, 0.7058823529411765)
    LAVENDERBLUSH = (1.0, 0.9411764705882353, 0.9607843137254902)
    PALEVIOLETRED = (0.8588235294117647, 0.4392156862745098, 0.5764705882352941)
    CRIMSON = (0.8627450980392157, 0.0784313725490196, 0.23529411764705882)
    PINK = (1.0, 0.7529411764705882, 0.796078431372549)
    LIGHTPINK = (1.0, 0.7137254901960784, 0.7568627450980392)


class Color(RgbTuple, Enum):
    BLACK = (0.0, 0.0, 0.0)
    K = (0.0, 0.0, 0.0)
    XKCD_BLACK = (0.0, 0.0, 0.0)
    DIMGRAY = (0.4117647058823529, 0.4117647058823529, 0.4117647058823529)
    DIMGREY = (0.4117647058823529, 0.4117647058823529, 0.4117647058823529)
    TAB_GRAY = (0.4980392156862745, 0.4980392156862745, 0.4980392156862745)
    TAB_GREY = (0.4980392156862745, 0.4980392156862745, 0.4980392156862745)
    GRAY = (0.5019607843137255, 0.5019607843137255, 0.5019607843137255)
    GREY = (0.5019607843137255, 0.5019607843137255, 0.5019607843137255)
    DARKGRAY = (0.6627450980392157, 0.6627450980392157, 0.6627450980392157)
    DARKGREY = (0.6627450980392157, 0.6627450980392157, 0.6627450980392157)
    SILVER = (0.7529411764705882, 0.7529411764705882, 0.7529411764705882)
    LIGHTGRAY = (0.8274509803921568, 0.8274509803921568, 0.8274509803921568)
    LIGHTGREY = (0.8274509803921568, 0.8274509803921568, 0.8274509803921568)
    GAINSBORO = (0.8627450980392157, 0.8627450980392157, 0.8627450980392157)
    WHITESMOKE = (0.9607843137254902, 0.9607843137254902, 0.9607843137254902)
    W = (1.0, 1.0, 1.0)
    WHITE = (1.0, 1.0, 1.0)
    XKCD_WHITE = (1.0, 1.0, 1.0)
    SNOW = (1.0, 0.9803921568627451, 0.9803921568627451)
    ROSYBROWN = (0.7372549019607844, 0.5607843137254902, 0.5607843137254902)
    LIGHTCORAL = (0.9411764705882353, 0.5019607843137255, 0.5019607843137255)
    INDIANRED = (0.803921568627451, 0.3607843137254902, 0.3607843137254902)
    XKCD_DULL_RED = (0.7333333333333333, 0.24705882352941178, 0.24705882352941178)
    BROWN = (0.6470588235294118, 0.16470588235294117, 0.16470588235294117)
    FIREBRICK = (0.6980392156862745, 0.13333333333333333, 0.13333333333333333)
    XKCD_DRIED_BLOOD = (0.29411764705882354, 0.00392156862745098, 0.00392156862745098)
    MAROON = (0.5019607843137255, 0.0, 0.0)
    XKCD_DARK_RED = (0.5176470588235295, 0.0, 0.0)
    DARKRED = (0.5450980392156862, 0.0, 0.0)
    XKCD_RED = (0.8980392156862745, 0.0, 0.0)
    R = (1.0, 0.0, 0.0)
    RED = (1.0, 0.0, 0.0)
    XKCD_DEEP_RED = (0.6039215686274509, 0.00784313725490196, 0.0)
    XKCD_MAHOGANY = (0.2901960784313726, 0.00392156862745098, 0.0)
    XKCD_PASTEL_RED = (0.8588235294117647, 0.34509803921568627, 0.33725490196078434)
    XKCD_REDDISH = (0.7686274509803922, 0.25882352941176473, 0.25098039215686274)
    XKCD_GRAPEFRUIT = (0.9921568627450981, 0.34901960784313724, 0.33725490196078434)
    XKCD_DEEP_BROWN = (0.2549019607843137, 0.00784313725490196, 0.0)
    XKCD_DARK_CORAL = (0.8117647058823529, 0.3215686274509804, 0.3058823529411765)
    XKCD_PALE_RED = (0.8509803921568627, 0.32941176470588235, 0.30196078431372547)
    XKCD_CORAL = (0.9882352941176471, 0.35294117647058826, 0.3137254901960784)
    XKCD_DARK_SALMON = (0.7843137254901961, 0.35294117647058826, 0.3254901960784314)
    XKCD_BROWNISH_PINK = (0.7607843137254902, 0.49411764705882355, 0.4745098039215686)
    XKCD_VERY_DARK_BROWN = (0.11372549019607843, 0.00784313725490196, 0.0)
    XKCD_INDIAN_RED = (0.5215686274509804, 0.054901960784313725, 0.01568627450980392)
    XKCD_SALMON = (1.0, 0.4745098039215686, 0.4235294117647059)
    XKCD_PINKISH_GRAY = (0.7843137254901961, 0.6745098039215687, 0.6627450980392157)
    XKCD_PINKISH_GREY = (0.7843137254901961, 0.6745098039215687, 0.6627450980392157)
    MISTYROSE = (1.0, 0.8941176470588236, 0.8823529411764706)
    SALMON = (0.9803921568627451, 0.5019607843137255, 0.4470588235294118)
    XKCD_REDDY_BROWN = (0.43137254901960786, 0.06274509803921569, 0.0196078431372549)
    XKCD_REDDISH_GRAY = (0.6, 0.4588235294117647, 0.4392156862745098)
    XKCD_REDDISH_GREY = (0.6, 0.4588235294117647, 0.4392156862745098)
    XKCD_BRICK_RED = (0.5607843137254902, 0.0784313725490196, 0.00784313725490196)
    XKCD_TOMATO = (0.9372549019607843, 0.25098039215686274, 0.14901960784313725)
    XKCD_PEACHY_PINK = (1.0, 0.6039215686274509, 0.5411764705882353)
    XKCD_ORANGEY_RED = (0.9803921568627451, 0.25882352941176473, 0.1411764705882353)
    XKCD_BRICK = (0.6274509803921569, 0.21176470588235294, 0.13725490196078433)
    TOMATO = (1.0, 0.38823529411764707, 0.2784313725490196)
    XKCD_VERY_LIGHT_PINK = (1.0, 0.9568627450980393, 0.9490196078431372)
    XKCD_BROWNISH_RED = (0.6196078431372549, 0.21176470588235294, 0.13725490196078433)
    XKCD_ORANGE_RED = (0.9921568627450981, 0.2549019607843137, 0.11764705882352941)
    XKCD_BLUSH = (0.9490196078431372, 0.6196078431372549, 0.5568627450980392)
    XKCD_VERMILLION = (0.9568627450980393, 0.19607843137254902, 0.047058823529411764)
    XKCD_ORANGE_PINK = (1.0, 0.43529411764705883, 0.3215686274509804)
    TAB_BROWN = (0.5490196078431373, 0.33725490196078434, 0.29411764705882354)
    XKCD_TOMATO_RED = (0.9254901960784314, 0.17647058823529413, 0.00392156862745098)
    XKCD_BURNT_RED = (0.6235294117647059, 0.13725490196078433, 0.0196078431372549)
    XKCD_REDDISH_ORANGE = (0.9725490196078431, 0.2823529411764706, 0.10980392156862745)
    XKCD_ORANGISH_RED = (0.9568627450980393, 0.21176470588235294, 0.0196078431372549)
    XKCD_RED_BROWN = (0.5450980392156862, 0.1803921568627451, 0.08627450980392157)
    XKCD_LIGHT_SALMON = (0.996078431372549, 0.6627450980392157, 0.5764705882352941)
    XKCD_MELON = (1.0, 0.47058823529411764, 0.3333333333333333)
    XKCD_RUSTY_RED = (0.6862745098039216, 0.1843137254901961, 0.050980392156862744)
    XKCD_RUST_RED = (0.6666666666666666, 0.15294117647058825, 0.01568627450980392)
    XKCD_PINKISH_ORANGE = (1.0, 0.4470588235294118, 0.2980392156862745)
    XKCD_PINKISH_BROWN = (0.6941176470588235, 0.4470588235294118, 0.3803921568627451)
    XKCD_ORANGERED = (0.996078431372549, 0.25882352941176473, 0.058823529411764705)
    XKCD_RED_ORANGE = (0.9921568627450981, 0.23529411764705882, 0.023529411764705882)
    XKCD_PALE_SALMON = (1.0, 0.6941176470588235, 0.6039215686274509)
    DARKSALMON = (0.9137254901960784, 0.5882352941176471, 0.47843137254901963)
    XKCD_CLAY = (0.7137254901960784, 0.41568627450980394, 0.3137254901960784)
    XKCD_DARK_PEACH = (0.8705882352941177, 0.49411764705882355, 0.36470588235294116)
    CORAL = (1.0, 0.4980392156862745, 0.3137254901960784)
    XKCD_BROWN_RED = (0.5725490196078431, 0.16862745098039217, 0.0196078431372549)
    XKCD_TERRACOTTA = (0.792156862745098, 0.4, 0.2549019607843137)
    ORANGERED = (1.0, 0.27058823529411763, 0.0)
    XKCD_TERRACOTA = (0.796078431372549, 0.40784313725490196, 0.2627450980392157)
    XKCD_REDDISH_BROWN = (0.4980392156862745, 0.16862745098039217, 0.0392156862745098)
    LIGHTSALMON = (1.0, 0.6274509803921569, 0.47843137254901963)
    XKCD_BLOOD_ORANGE = (0.996078431372549, 0.29411764705882354, 0.011764705882352941)
    XKCD_PINKISH_TAN = (0.8509803921568627, 0.6078431372549019, 0.5098039215686274)
    XKCD_TERRA_COTTA = (0.788235294117647, 0.39215686274509803, 0.23137254901960785)
    XKCD_AUBURN = (0.6039215686274509, 0.18823529411764706, 0.00392156862745098)
    XKCD_ADOBE = (0.7411764705882353, 0.4235294117647059, 0.2823529411764706)
    XKCD_ORANGISH = (0.9882352941176471, 0.5098039215686274, 0.2901960784313726)
    XKCD_WARM_GRAY = (0.592156862745098, 0.5411764705882353, 0.5176470588235295)
    XKCD_WARM_GREY = (0.592156862745098, 0.5411764705882353, 0.5176470588235295)
    XKCD_BROWNISH = (0.611764705882353, 0.42745098039215684, 0.3411764705882353)
    XKCD_RUST = (0.6588235294117647, 0.23529411764705882, 0.03529411764705882)
    SIENNA = (0.6274509803921569, 0.3215686274509804, 0.17647058823529413)
    XKCD_RUSSET = (0.6313725490196078, 0.2235294117647059, 0.0196078431372549)
    XKCD_CHESTNUT = (0.4549019607843137, 0.1568627450980392, 0.00784313725490196)
    XKCD_RUST_BROWN = (0.5450980392156862, 0.19215686274509805, 0.011764705882352941)
    XKCD_DEEP_ORANGE = (0.8627450980392157, 0.30196078431372547, 0.00392156862745098)
    XKCD_BRICK_ORANGE = (0.7568627450980392, 0.2901960784313726, 0.03529411764705882)
    XKCD_BRIGHT_ORANGE = (1.0, 0.3568627450980392, 0.0)
    XKCD_BURNT_UMBER = (0.6274509803921569, 0.27058823529411763, 0.054901960784313725)
    XKCD_ORANGEISH = (0.9921568627450981, 0.5529411764705883, 0.28627450980392155)
    XKCD_CHOCOLATE_BROWN = (0.2549019607843137, 0.09803921568627451, 0.0)
    XKCD_EARTH = (0.6352941176470588, 0.396078431372549, 0.24313725490196078)
    XKCD_BURNT_SIENNA = (0.6901960784313725, 0.3058823529411765, 0.058823529411764705)
    XKCD_PEACH = (1.0, 0.6901960784313725, 0.48627450980392156)
    XKCD_DUSTY_ORANGE = (0.9411764705882353, 0.5137254901960784, 0.22745098039215686)
    XKCD_SIENNA = (0.6627450980392157, 0.33725490196078434, 0.11764705882352941)
    XKCD_DARK_ORANGE = (0.7764705882352941, 0.3176470588235294, 0.00784313725490196)
    XKCD_BURNT_ORANGE = (0.7529411764705882, 0.3058823529411765, 0.00392156862745098)
    XKCD_PASTEL_ORANGE = (1.0, 0.5882352941176471, 0.30980392156862746)
    XKCD_RUSTY_ORANGE = (0.803921568627451, 0.34901960784313724, 0.03529411764705882)
    XKCD_RUST_ORANGE = (0.7686274509803922, 0.3333333333333333, 0.03137254901960784)
    SEASHELL = (1.0, 0.9607843137254902, 0.9333333333333333)
    CHOCOLATE = (0.8235294117647058, 0.4117647058823529, 0.11764705882352941)
    SADDLEBROWN = (0.5450980392156862, 0.27058823529411763, 0.07450980392156863)
    XKCD_COCOA = (0.5294117647058824, 0.37254901960784315, 0.25882352941176473)
    XKCD_COPPER = (0.7137254901960784, 0.38823529411764707, 0.1450980392156863)
    XKCD_FADED_ORANGE = (0.9411764705882353, 0.5803921568627451, 0.30196078431372547)
    XKCD_BURNT_SIENA = (0.7176470588235294, 0.3215686274509804, 0.011764705882352941)
    XKCD_CINNAMON = (0.6745098039215687, 0.30980392156862746, 0.023529411764705882)
    XKCD_MUSHROOM = (0.7294117647058823, 0.6196078431372549, 0.5333333333333333)
    XKCD_CHOCOLATE = (0.23921568627450981, 0.10980392156862745, 0.00784313725490196)
    XKCD_CLAY_BROWN = (0.6980392156862745, 0.44313725490196076, 0.23921568627450981)
    XKCD_ORANGE = (0.9764705882352941, 0.45098039215686275, 0.023529411764705882)
    SANDYBROWN = (0.9568627450980393, 0.6431372549019608, 0.3764705882352941)
    XKCD_APRICOT = (1.0, 0.6941176470588235, 0.42745098039215684)
    XKCD_SEPIA = (0.596078431372549, 0.3686274509803922, 0.16862745098039217)
    TAB_ORANGE = (1.0, 0.4980392156862745, 0.054901960784313725)
    PEACHPUFF = (1.0, 0.8549019607843137, 0.7254901960784313)
    XKCD_DULL_ORANGE = (0.8470588235294118, 0.5254901960784314, 0.23137254901960785)
    XKCD_PALE_ORANGE = (1.0, 0.6549019607843137, 0.33725490196078434)
    XKCD_PUMPKIN_ORANGE = (0.984313725490196, 0.49019607843137253, 0.027450980392156862)
    XKCD_MOCHA = (0.615686274509804, 0.4627450980392157, 0.3176470588235294)
    PERU = (0.803921568627451, 0.5215686274509804, 0.24705882352941178)
    XKCD_MILK_CHOCOLATE = (0.4980392156862745, 0.3058823529411765, 0.11764705882352941)
    LINEN = (0.9803921568627451, 0.9411764705882353, 0.9019607843137255)
    XKCD_LIGHT_PEACH = (1.0, 0.8470588235294118, 0.6941176470588235)
    XKCD_BROWNISH_ORANGE = (0.796078431372549, 0.4666666666666667, 0.13725490196078433)
    XKCD_WARM_BROWN = (0.5882352941176471, 0.3058823529411765, 0.00784313725490196)
    XKCD_DARK_BROWN = (0.20392156862745098, 0.10980392156862745, 0.00784313725490196)
    XKCD_PALE_BROWN = (0.6941176470588235, 0.5686274509803921, 0.43137254901960786)
    XKCD_BROWNY_ORANGE = (0.792156862745098, 0.4196078431372549, 0.00784313725490196)
    XKCD_ORANGISH_BROWN = (
        0.6980392156862745,
        0.37254901960784315,
        0.011764705882352941,
    )
    XKCD_ORANGE_BROWN = (0.7450980392156863, 0.39215686274509803, 0.0)
    XKCD_TAN_BROWN = (0.6705882352941176, 0.49411764705882355, 0.2980392156862745)
    XKCD_PUMPKIN = (0.8823529411764706, 0.4666666666666667, 0.00392156862745098)
    XKCD_LIGHT_BROWN = (0.6784313725490196, 0.5058823529411764, 0.3137254901960784)
    XKCD_PUCE = (0.6470588235294118, 0.49411764705882355, 0.3215686274509804)
    XKCD_DARK_TAUPE = (0.4980392156862745, 0.40784313725490196, 0.3058823529411765)
    XKCD_LEATHER = (0.6745098039215687, 0.4549019607843137, 0.20392156862745098)
    XKCD_ORANGEY_BROWN = (0.6941176470588235, 0.3764705882352941, 0.00784313725490196)
    XKCD_RAW_UMBER = (0.6549019607843137, 0.3686274509803922, 0.03529411764705882)
    XKCD_LIGHT_ORANGE = (0.9921568627450981, 0.6666666666666666, 0.2823529411764706)
    BISQUE = (1.0, 0.8941176470588236, 0.7686274509803922)
    XKCD_BROWN = (0.396078431372549, 0.21568627450980393, 0.0)
    DARKORANGE = (1.0, 0.5490196078431373, 0.0)
    XKCD_UMBER = (0.6980392156862745, 0.39215686274509803, 0.0)
    XKCD_BROWN_ORANGE = (0.7254901960784313, 0.4117647058823529, 0.00784313725490196)
    BURLYWOOD = (0.8705882352941177, 0.7215686274509804, 0.5294117647058824)
    XKCD_TANGERINE = (1.0, 0.5803921568627451, 0.03137254901960784)
    ANTIQUEWHITE = (0.9803921568627451, 0.9215686274509803, 0.8431372549019608)
    TAN = (0.8235294117647058, 0.7058823529411765, 0.5490196078431373)
    XKCD_DIRTY_ORANGE = (0.7843137254901961, 0.4627450980392157, 0.023529411764705882)
    XKCD_MEDIUM_BROWN = (0.4980392156862745, 0.3176470588235294, 0.07058823529411765)
    XKCD_MANGO = (1.0, 0.6509803921568628, 0.16862745098039217)
    XKCD_BUTTERSCOTCH = (0.9921568627450981, 0.6941176470588235, 0.2784313725490196)
    XKCD_DULL_BROWN = (0.5294117647058824, 0.43137254901960786, 0.29411764705882354)
    XKCD_COFFEE = (0.6509803921568628, 0.5058823529411764, 0.2980392156862745)
    XKCD_TAUPE = (0.7254901960784313, 0.6352941176470588, 0.5058823529411764)
    XKCD_DIRT = (0.5411764705882353, 0.43137254901960786, 0.27058823529411763)
    XKCD_DIRT_BROWN = (0.5137254901960784, 0.396078431372549, 0.2235294117647059)
    NAVAJOWHITE = (1.0, 0.8705882352941177, 0.6784313725490196)
    BLANCHEDALMOND = (1.0, 0.9215686274509803, 0.803921568627451)
    XKCD_DARK_TAN = (0.6862745098039216, 0.5333333333333333, 0.2901960784313726)
    XKCD_CARAMEL = (0.6862745098039216, 0.43529411764705883, 0.03529411764705882)
    XKCD_BROWNISH_GRAY = (0.5254901960784314, 0.4666666666666667, 0.37254901960784315)
    XKCD_BROWNISH_GREY = (0.5254901960784314, 0.4666666666666667, 0.37254901960784315)
    PAPAYAWHIP = (1.0, 0.9372549019607843, 0.8352941176470589)
    XKCD_FAWN = (0.8117647058823529, 0.6862745098039216, 0.4823529411764706)
    XKCD_GRAYISH_BROWN = (0.47843137254901963, 0.41568627450980394, 0.30980392156862746)
    XKCD_GREYISH_BROWN = (0.47843137254901963, 0.41568627450980394, 0.30980392156862746)
    XKCD_DUST = (0.6980392156862745, 0.6, 0.43137254901960786)
    MOCCASIN = (1.0, 0.8941176470588236, 0.7098039215686275)
    XKCD_TOUPE = (0.7803921568627451, 0.6745098039215687, 0.49019607843137253)
    XKCD_RAW_SIENNA = (0.6039215686274509, 0.3843137254901961, 0.0)
    XKCD_VERY_LIGHT_BROWN = (0.8274509803921568, 0.7137254901960784, 0.5137254901960784)
    XKCD_CAMEL = (0.7764705882352941, 0.6235294117647059, 0.34901960784313724)
    XKCD_SAND_BROWN = (0.796078431372549, 0.6470588235294118, 0.3764705882352941)
    ORANGE = (1.0, 0.6470588235294118, 0.0)
    XKCD_YELLOWISH_ORANGE = (1.0, 0.6705882352941176, 0.058823529411764705)
    WHEAT = (0.9607843137254902, 0.8705882352941177, 0.7019607843137254)
    OLDLACE = (0.9921568627450981, 0.9607843137254902, 0.9019607843137255)
    XKCD_GRAY_BROWN = (0.4980392156862745, 0.4392156862745098, 0.3254901960784314)
    XKCD_GREY_BROWN = (0.4980392156862745, 0.4392156862745098, 0.3254901960784314)
    XKCD_DARK_BEIGE = (0.6745098039215687, 0.5764705882352941, 0.3843137254901961)
    FLORALWHITE = (1.0, 0.9803921568627451, 0.9411764705882353)
    XKCD_ORANGE_YELLOW = (1.0, 0.6784313725490196, 0.00392156862745098)
    XKCD_SQUASH = (0.9490196078431372, 0.6705882352941176, 0.08235294117647059)
    XKCD_MUD_BROWN = (0.3764705882352941, 0.27450980392156865, 0.058823529411764705)
    XKCD_SANDSTONE = (0.788235294117647, 0.6823529411764706, 0.4549019607843137)
    XKCD_MACARONI_AND_CHEESE = (
        0.9372549019607843,
        0.7058823529411765,
        0.20784313725490197,
    )
    XKCD_PALE_PEACH = (1.0, 0.8980392156862745, 0.6784313725490196)
    XKCD_DARK_SAND = (0.6588235294117647, 0.5607843137254902, 0.34901960784313724)
    XKCD_GOLDEN_BROWN = (0.6980392156862745, 0.47843137254901963, 0.00392156862745098)
    XKCD_TAN = (0.8196078431372549, 0.6980392156862745, 0.43529411764705883)
    XKCD_SAFFRON = (0.996078431372549, 0.6980392156862745, 0.03529411764705882)
    XKCD_PUTTY = (0.7450980392156863, 0.6823529411764706, 0.5411764705882353)
    XKCD_AMBER = (0.996078431372549, 0.7019607843137254, 0.03137254901960784)
    XKCD_POO_BROWN = (0.5333333333333333, 0.37254901960784315, 0.00392156862745098)
    XKCD_SANDY_BROWN = (0.7686274509803922, 0.6509803921568628, 0.3803921568627451)
    XKCD_YELLOW_ORANGE = (0.9882352941176471, 0.6901960784313725, 0.00392156862745098)
    XKCD_SHIT_BROWN = (0.4823529411764706, 0.34509803921568627, 0.01568627450980392)
    XKCD_ORANGEY_YELLOW = (0.9921568627450981, 0.7254901960784313, 0.08235294117647059)
    DARKGOLDENROD = (0.7215686274509804, 0.5254901960784314, 0.043137254901960784)
    XKCD_DESERT = (0.8, 0.6784313725490196, 0.3764705882352941)
    GOLDENROD = (0.8549019607843137, 0.6470588235294118, 0.12549019607843137)
    XKCD_BRONZE = (0.6588235294117647, 0.4745098039215686, 0.0)
    XKCD_MUSTARD_BROWN = (0.6745098039215687, 0.49411764705882355, 0.01568627450980392)
    XKCD_POOP_BROWN = (0.47843137254901963, 0.34901960784313724, 0.00392156862745098)
    XKCD_POOP = (0.4980392156862745, 0.3686274509803922, 0.0)
    XKCD_GOLDEN_ROD = (0.9764705882352941, 0.7372549019607844, 0.03137254901960784)
    XKCD_OCHRE = (0.7490196078431373, 0.5647058823529412, 0.0196078431372549)
    XKCD_SHIT = (0.4980392156862745, 0.37254901960784315, 0.0)
    XKCD_MUDDY_BROWN = (0.5333333333333333, 0.40784313725490196, 0.023529411764705882)
    XKCD_SUNFLOWER = (1.0, 0.7725490196078432, 0.07058823529411765)
    XKCD_MARIGOLD = (0.9882352941176471, 0.7529411764705882, 0.023529411764705882)
    XKCD_BROWN_GRAY = (0.5529411764705883, 0.5176470588235295, 0.40784313725490196)
    XKCD_BROWN_GREY = (0.5529411764705883, 0.5176470588235295, 0.40784313725490196)
    XKCD_GOLDEN_YELLOW = (0.996078431372549, 0.7764705882352941, 0.08235294117647059)
    XKCD_WHEAT = (0.984313725490196, 0.8666666666666667, 0.49411764705882355)
    XKCD_MUD = (0.45098039215686275, 0.3607843137254902, 0.07058823529411765)
    XKCD_YELLOW_OCHRE = (0.796078431372549, 0.615686274509804, 0.023529411764705882)
    XKCD_GOLDENROD = (0.9803921568627451, 0.7607843137254902, 0.0196078431372549)
    XKCD_LIGHT_MUSTARD = (0.9686274509803922, 0.8352941176470589, 0.3764705882352941)
    XKCD_MAIZE = (0.9568627450980393, 0.8156862745098039, 0.32941176470588235)
    XKCD_GOLDEN = (0.9607843137254902, 0.7490196078431373, 0.011764705882352941)
    XKCD_SAND = (0.8862745098039215, 0.792156862745098, 0.4627450980392157)
    XKCD_OCRE = (0.7764705882352941, 0.611764705882353, 0.01568627450980392)
    XKCD_YELLOWY_BROWN = (0.6823529411764706, 0.5450980392156862, 0.047058823529411764)
    XKCD_YELLOWISH_BROWN = (
        0.6078431372549019,
        0.47843137254901963,
        0.00392156862745098,
    )
    XKCD_PALE_GOLD = (0.9921568627450981, 0.8705882352941177, 0.4235294117647059)
    XKCD_STONE = (0.6784313725490196, 0.6470588235294118, 0.5294117647058824)
    XKCD_GRAYISH = (0.6588235294117647, 0.6431372549019608, 0.5843137254901961)
    XKCD_GREYISH = (0.6588235294117647, 0.6431372549019608, 0.5843137254901961)
    XKCD_BURNT_YELLOW = (0.8352941176470589, 0.6705882352941176, 0.03529411764705882)
    XKCD_LIGHT_GOLD = (0.9921568627450981, 0.8627450980392157, 0.3607843137254902)
    XKCD_PUKE_BROWN = (0.5803921568627451, 0.4666666666666667, 0.023529411764705882)
    XKCD_HAZEL = (0.5568627450980392, 0.4627450980392157, 0.09411764705882353)
    XKCD_OCHER = (0.7490196078431373, 0.6078431372549019, 0.047058823529411764)
    CORNSILK = (1.0, 0.9725490196078431, 0.8627450980392157)
    XKCD_DARK_GOLD = (0.7098039215686275, 0.5803921568627451, 0.06274509803921569)
    XKCD_POO = (0.5607843137254902, 0.45098039215686275, 0.011764705882352941)
    XKCD_BLAND = (0.6862745098039216, 0.6588235294117647, 0.5450980392156862)
    XKCD_SANDY = (0.9450980392156862, 0.8549019607843137, 0.47843137254901963)
    XKCD_YELLOW_TAN = (1.0, 0.8901960784313725, 0.43137254901960786)
    XKCD_YELLOW_BROWN = (0.7176470588235294, 0.5803921568627451, 0.0)
    XKCD_DARK_MUSTARD = (0.6588235294117647, 0.5372549019607843, 0.0196078431372549)
    XKCD_GOLD = (0.8588235294117647, 0.7058823529411765, 0.047058823529411764)
    XKCD_BEIGE = (0.9019607843137255, 0.8549019607843137, 0.6509803921568628)
    XKCD_BABY_SHIT_BROWN = (
        0.6784313725490196,
        0.5647058823529412,
        0.050980392156862744,
    )
    XKCD_SAND_YELLOW = (0.9882352941176471, 0.8823529411764706, 0.4)
    XKCD_DIARRHEA = (0.6235294117647059, 0.5137254901960784, 0.011764705882352941)
    XKCD_DARK_KHAKI = (0.6078431372549019, 0.5607843137254902, 0.3333333333333333)
    XKCD_OLIVE_BROWN = (0.39215686274509803, 0.32941176470588235, 0.011764705882352941)
    XKCD_LIGHT_TAN = (0.984313725490196, 0.9333333333333333, 0.6745098039215687)
    XKCD_BABY_POO = (0.6705882352941176, 0.5647058823529412, 0.01568627450980392)
    GOLD = (1.0, 0.8431372549019608, 0.0)
    XKCD_BABY_POOP = (0.5764705882352941, 0.48627450980392156, 0.0)
    XKCD_BROWN_YELLOW = (0.6980392156862745, 0.592156862745098, 0.0196078431372549)
    XKCD_DARK_YELLOW = (0.8352941176470589, 0.7137254901960784, 0.0392156862745098)
    XKCD_SUNFLOWER_YELLOW = (1.0, 0.8549019607843137, 0.011764705882352941)
    XKCD_SUN_YELLOW = (1.0, 0.8745098039215686, 0.13333333333333333)
    XKCD_MUSTARD = (0.807843137254902, 0.7019607843137254, 0.00392156862745098)
    XKCD_PALE = (1.0, 0.9764705882352941, 0.8156862745098039)
    XKCD_BROWNISH_YELLOW = (0.788235294117647, 0.6901960784313725, 0.011764705882352941)
    XKCD_DANDELION = (0.996078431372549, 0.8745098039215686, 0.03137254901960784)
    XKCD_DULL_YELLOW = (0.9333333333333333, 0.8627450980392157, 0.3568627450980392)
    XKCD_DARK_CREAM = (1.0, 0.9529411764705882, 0.6039215686274509)
    XKCD_SANDY_YELLOW = (0.9921568627450981, 0.9333333333333333, 0.45098039215686275)
    XKCD_MUSTARD_YELLOW = (0.8235294117647058, 0.7411764705882353, 0.0392156862745098)
    XKCD_MUDDY_YELLOW = (0.7490196078431373, 0.6745098039215687, 0.0196078431372549)
    XKCD_CEMENT = (0.6470588235294118, 0.6392156862745098, 0.5686274509803921)
    LEMONCHIFFON = (1.0, 0.9803921568627451, 0.803921568627451)
    KHAKI = (0.9411764705882353, 0.9019607843137255, 0.5490196078431373)
    XKCD_UGLY_BROWN = (0.49019607843137253, 0.44313725490196076, 0.011764705882352941)
    XKCD_GREENISH_BROWN = (0.4117647058823529, 0.3803921568627451, 0.07058823529411765)
    XKCD_GREENY_BROWN = (0.4117647058823529, 0.3764705882352941, 0.023529411764705882)
    PALEGOLDENROD = (0.9333333333333333, 0.9098039215686274, 0.6666666666666666)
    XKCD_BUFF = (0.996078431372549, 0.9647058823529412, 0.6196078431372549)
    XKCD_YELLOWISH = (0.9803921568627451, 0.9333333333333333, 0.4)
    XKCD_GREEN_BROWN = (0.32941176470588235, 0.3058823529411765, 0.011764705882352941)
    DARKKHAKI = (0.7411764705882353, 0.7176470588235294, 0.4196078431372549)
    XKCD_UGLY_YELLOW = (0.8156862745098039, 0.7568627450980392, 0.00392156862745098)
    XKCD_OLIVE_YELLOW = (0.7607843137254902, 0.7176470588235294, 0.03529411764705882)
    XKCD_KHAKI = (0.6666666666666666, 0.6509803921568628, 0.3843137254901961)
    XKCD_EGG_SHELL = (1.0, 0.9882352941176471, 0.7686274509803922)
    XKCD_STRAW = (0.9882352941176471, 0.9647058823529412, 0.4745098039215686)
    XKCD_BROWN_GREEN = (0.4392156862745098, 0.4235294117647059, 0.06666666666666667)
    XKCD_MANILLA = (1.0, 0.9803921568627451, 0.5254901960784314)
    XKCD_DIRTY_YELLOW = (0.803921568627451, 0.7725490196078432, 0.0392156862745098)
    XKCD_PISS_YELLOW = (0.8666666666666667, 0.8392156862745098, 0.09411764705882353)
    XKCD_VOMIT_YELLOW = (0.7803921568627451, 0.7568627450980392, 0.047058823529411764)
    XKCD_BROWNY_GREEN = (0.43529411764705883, 0.4235294117647059, 0.0392156862745098)
    XKCD_SUNNY_YELLOW = (1.0, 0.9764705882352941, 0.09019607843137255)
    XKCD_PARCHMENT = (0.996078431372549, 0.9882352941176471, 0.6862745098039216)
    XKCD_PUKE_YELLOW = (0.7607843137254902, 0.7450980392156863, 0.054901960784313725)
    XKCD_CUSTARD = (1.0, 0.9921568627450981, 0.47058823529411764)
    XKCD_BUTTER_YELLOW = (1.0, 0.9921568627450981, 0.4549019607843137)
    XKCD_LIGHT_BEIGE = (1.0, 0.996078431372549, 0.7137254901960784)
    XKCD_SUNSHINE_YELLOW = (1.0, 0.9921568627450981, 0.21568627450980393)
    XKCD_BRIGHT_YELLOW = (1.0, 0.9921568627450981, 0.00392156862745098)
    XKCD_LIGHT_YELLOW = (1.0, 0.996078431372549, 0.47843137254901963)
    XKCD_PASTEL_YELLOW = (1.0, 0.996078431372549, 0.44313725490196076)
    XKCD_CANARY_YELLOW = (1.0, 0.996078431372549, 0.25098039215686274)
    IVORY = (1.0, 1.0, 0.9411764705882353)
    BEIGE = (0.9607843137254902, 0.9607843137254902, 0.8627450980392157)
    XKCD_OFF_WHITE = (1.0, 1.0, 0.8941176470588236)
    LIGHTYELLOW = (1.0, 1.0, 0.8784313725490196)
    LIGHTGOLDENRODYELLOW = (0.9803921568627451, 0.9803921568627451, 0.8235294117647058)
    XKCD_EGGSHELL = (1.0, 1.0, 0.8313725490196079)
    XKCD_IVORY = (1.0, 1.0, 0.796078431372549)
    XKCD_CREAM = (1.0, 1.0, 0.7607843137254902)
    XKCD_CREME = (1.0, 1.0, 0.7137254901960784)
    XKCD_PALE_YELLOW = (1.0, 1.0, 0.5176470588235295)
    XKCD_YELLOWISH_TAN = (0.9882352941176471, 0.9882352941176471, 0.5058823529411764)
    XKCD_BUTTER = (1.0, 1.0, 0.5058823529411764)
    XKCD_BANANA = (1.0, 1.0, 0.49411764705882355)
    XKCD_YELLOW = (1.0, 1.0, 0.0784313725490196)
    XKCD_PUKE = (0.6470588235294118, 0.6470588235294118, 0.00784313725490196)
    OLIVE = (0.5019607843137255, 0.5019607843137255, 0.0)
    Y = (0.75, 0.75, 0.0)
    YELLOW = (1.0, 1.0, 0.0)
    TAB_OLIVE = (0.7372549019607844, 0.7411764705882353, 0.13333333333333333)
    XKCD_FADED_YELLOW = (0.996078431372549, 1.0, 0.4980392156862745)
    XKCD_LEMON_YELLOW = (0.9921568627450981, 1.0, 0.2196078431372549)
    XKCD_OFF_YELLOW = (0.9450980392156862, 0.9529411764705882, 0.24705882352941178)
    XKCD_LEMON = (0.9921568627450981, 1.0, 0.3215686274509804)
    XKCD_CANARY = (0.9921568627450981, 1.0, 0.38823529411764707)
    XKCD_VOMIT = (0.6352941176470588, 0.6431372549019608, 0.08235294117647059)
    XKCD_DRAB = (0.5098039215686274, 0.5137254901960784, 0.26666666666666666)
    XKCD_ECRU = (0.996078431372549, 1.0, 0.792156862745098)
    XKCD_BANANA_YELLOW = (0.9803921568627451, 0.996078431372549, 0.29411764705882354)
    XKCD_BROWNISH_GREEN = (
        0.41568627450980394,
        0.43137254901960786,
        0.03529411764705882,
    )
    XKCD_PEA_SOUP = (0.5725490196078431, 0.6, 0.00392156862745098)
    XKCD_MUD_GREEN = (0.3764705882352941, 0.4, 0.00784313725490196)
    XKCD_BABY_POOP_GREEN = (0.5607843137254902, 0.596078431372549, 0.0196078431372549)
    XKCD_OLIVE = (0.43137254901960786, 0.4588235294117647, 0.054901960784313725)
    XKCD_MUSTARD_GREEN = (0.6588235294117647, 0.7098039215686275, 0.01568627450980392)
    XKCD_BABY_PUKE_GREEN = (
        0.7137254901960784,
        0.7686274509803922,
        0.023529411764705882,
    )
    XKCD_BILE = (0.7098039215686275, 0.7647058823529411, 0.023529411764705882)
    XKCD_SHIT_GREEN = (0.4588235294117647, 0.5019607843137255, 0.0)
    XKCD_SNOT = (0.6745098039215687, 0.7333333333333333, 0.050980392156862744)
    XKCD_GREENISH_BEIGE = (0.788235294117647, 0.8196078431372549, 0.4745098039215686)
    XKCD_OLIVE_DRAB = (0.43529411764705883, 0.4627450980392157, 0.19607843137254902)
    XKCD_POOP_GREEN = (0.43529411764705883, 0.48627450980392156, 0.0)
    XKCD_SICKLY_YELLOW = (0.8156862745098039, 0.8941176470588236, 0.1607843137254902)
    XKCD_DARK_OLIVE = (0.21568627450980393, 0.24313725490196078, 0.00784313725490196)
    XKCD_BABY_SHIT_GREEN = (0.5333333333333333, 0.592156862745098, 0.09019607843137255)
    XKCD_PUKE_GREEN = (0.6039215686274509, 0.6823529411764706, 0.027450980392156862)
    XKCD_PEA_SOUP_GREEN = (0.5803921568627451, 0.6509803921568628, 0.09019607843137255)
    XKCD_GREEN_SLASH_YELLOW = (
        0.7098039215686275,
        0.807843137254902,
        0.03137254901960784,
    )
    XKCD_SWAMP_GREEN = (0.4549019607843137, 0.5215686274509804, 0.0)
    XKCD_MURKY_GREEN = (0.4235294117647059, 0.47843137254901963, 0.054901960784313725)
    XKCD_BARF_GREEN = (0.5803921568627451, 0.6745098039215687, 0.00784313725490196)
    XKCD_LIGHT_KHAKI = (0.9019607843137255, 0.9490196078431372, 0.6352941176470588)
    XKCD_VOMIT_GREEN = (0.5372549019607843, 0.6352941176470588, 0.011764705882352941)
    XKCD_OLIVE_GREEN = (0.403921568627451, 0.47843137254901963, 0.01568627450980392)
    XKCD_BRIGHT_OLIVE = (0.611764705882353, 0.7333333333333333, 0.01568627450980392)
    XKCD_BOOGER_GREEN = (0.5882352941176471, 0.7058823529411765, 0.011764705882352941)
    XKCD_PEA = (0.6431372549019608, 0.7490196078431373, 0.12549019607843137)
    XKCD_GROSS_GREEN = (0.6274509803921569, 0.7490196078431373, 0.08627450980392157)
    XKCD_GREENISH_TAN = (0.7372549019607844, 0.796078431372549, 0.47843137254901963)
    XKCD_SNOT_GREEN = (0.615686274509804, 0.7568627450980392, 0.0)
    XKCD_PEA_GREEN = (0.5568627450980392, 0.6705882352941176, 0.07058823529411765)
    XKCD_NEON_YELLOW = (0.8117647058823529, 1.0, 0.01568627450980392)
    XKCD_GREENISH_YELLOW = (0.803921568627451, 0.9921568627450981, 0.00784313725490196)
    XKCD_UGLY_GREEN = (0.47843137254901963, 0.592156862745098, 0.011764705882352941)
    XKCD_SICK_GREEN = (0.615686274509804, 0.7254901960784313, 0.17254901960784313)
    XKCD_SICKLY_GREEN = (0.5803921568627451, 0.6980392156862745, 0.10980392156862745)
    XKCD_LIME_YELLOW = (0.8156862745098039, 0.996078431372549, 0.11372549019607843)
    XKCD_DARK_YELLOW_GREEN = (
        0.4470588235294118,
        0.5607843137254902,
        0.00784313725490196,
    )
    XKCD_GREENY_YELLOW = (0.7764705882352941, 0.9725490196078431, 0.03137254901960784)
    XKCD_BOOGER = (0.6078431372549019, 0.7098039215686275, 0.23529411764705882)
    XKCD_LIGHT_OLIVE = (0.6745098039215687, 0.7490196078431373, 0.4117647058823529)
    XKCD_ICKY_GREEN = (0.5607843137254902, 0.6823529411764706, 0.13333333333333333)
    XKCD_YELLOWISH_GREEN = (0.6901960784313725, 0.8666666666666667, 0.08627450980392157)
    XKCD_MUDDY_GREEN = (0.396078431372549, 0.4549019607843137, 0.19607843137254902)
    XKCD_DARK_OLIVE_GREEN = (
        0.23529411764705882,
        0.30196078431372547,
        0.011764705882352941,
    )
    XKCD_CHARTREUSE = (0.7568627450980392, 0.9725490196078431, 0.0392156862745098)
    XKCD_CAMO = (0.4980392156862745, 0.5607843137254902, 0.3058823529411765)
    XKCD_YELLOWY_GREEN = (0.7490196078431373, 0.9450980392156862, 0.1568627450980392)
    XKCD_GREEN_YELLOW = (0.788235294117647, 1.0, 0.15294117647058825)
    XKCD_AVOCADO_GREEN = (0.5294117647058824, 0.6627450980392157, 0.13333333333333333)
    XKCD_PALE_OLIVE = (0.7254901960784313, 0.8, 0.5058823529411764)
    XKCD_ARMY_GREEN = (0.29411764705882354, 0.36470588235294116, 0.08627450980392157)
    XKCD_SLIME_GREEN = (0.6, 0.8, 0.01568627450980392)
    XKCD_KHAKI_GREEN = (0.4470588235294118, 0.5254901960784314, 0.2235294117647059)
    XKCD_AVOCADO = (0.5647058823529412, 0.6941176470588235, 0.20392156862745098)
    XKCD_YELLOWGREEN = (0.7333333333333333, 0.9764705882352941, 0.058823529411764705)
    XKCD_LIGHT_OLIVE_GREEN = (
        0.6431372549019608,
        0.7450980392156863,
        0.3607843137254902,
    )
    XKCD_TAN_GREEN = (0.6627450980392157, 0.7450980392156863, 0.4392156862745098)
    XKCD_YELLOW_SLASH_GREEN = (
        0.7843137254901961,
        0.9921568627450981,
        0.23921568627450981,
    )
    XKCD_DARK_LIME = (0.5176470588235295, 0.7176470588235294, 0.00392156862745098)
    XKCD_CAMOUFLAGE_GREEN = (
        0.29411764705882354,
        0.3803921568627451,
        0.07450980392156863,
    )
    XKCD_YELLOW_GREEN = (0.7529411764705882, 0.984313725490196, 0.17647058823529413)
    XKCD_DIRTY_GREEN = (0.4, 0.49411764705882355, 0.17254901960784313)
    XKCD_PEAR = (0.796078431372549, 0.9725490196078431, 0.37254901960784315)
    XKCD_LEMON_LIME = (0.7490196078431373, 0.996078431372549, 0.1568627450980392)
    XKCD_CAMO_GREEN = (0.3215686274509804, 0.396078431372549, 0.1450980392156863)
    XKCD_LEMON_GREEN = (0.6784313725490196, 0.9725490196078431, 0.00784313725490196)
    OLIVEDRAB = (0.4196078431372549, 0.5568627450980392, 0.13725490196078433)
    YELLOWGREEN = (0.6039215686274509, 0.803921568627451, 0.19607843137254902)
    XKCD_DARK_LIME_GREEN = (
        0.49411764705882355,
        0.7411764705882353,
        0.00392156862745098,
    )
    XKCD_ELECTRIC_LIME = (0.6588235294117647, 1.0, 0.01568627450980392)
    XKCD_SWAMP = (0.4117647058823529, 0.5137254901960784, 0.2235294117647059)
    XKCD_MILITARY_GREEN = (0.4, 0.48627450980392156, 0.24313725490196078)
    DARKOLIVEGREEN = (0.3333333333333333, 0.4196078431372549, 0.1843137254901961)
    XKCD_PALE_OLIVE_GREEN = (0.6941176470588235, 0.8235294117647058, 0.4823529411764706)
    XKCD_BRIGHT_YELLOW_GREEN = (0.615686274509804, 1.0, 0.0)
    XKCD_LIGHT_YELLOW_GREEN = (0.8, 0.9921568627450981, 0.4980392156862745)
    GREENYELLOW = (0.6784313725490196, 1.0, 0.1843137254901961)
    XKCD_SAP_GREEN = (0.3607843137254902, 0.5450980392156862, 0.08235294117647059)
    XKCD_MOSSY_GREEN = (0.38823529411764707, 0.5450980392156862, 0.15294117647058825)
    XKCD_LIGHT_MOSS_GREEN = (0.6509803921568628, 0.7843137254901961, 0.4588235294117647)
    XKCD_NAVY_GREEN = (0.20784313725490197, 0.3254901960784314, 0.0392156862745098)
    XKCD_LIME = (0.6666666666666666, 1.0, 0.19607843137254902)
    XKCD_ACID_GREEN = (0.5607843137254902, 0.996078431372549, 0.03529411764705882)
    XKCD_PALE_LIME = (0.7450980392156863, 0.9921568627450981, 0.45098039215686275)
    XKCD_LIGHT_LIME_GREEN = (0.7254901960784313, 1.0, 0.4)
    XKCD_MOSS_GREEN = (0.396078431372549, 0.5450980392156862, 0.2196078431372549)
    XKCD_LEAF_GREEN = (0.3607843137254902, 0.6627450980392157, 0.01568627450980392)
    XKCD_LIGHT_PEA_GREEN = (0.7686274509803922, 0.996078431372549, 0.5098039215686274)
    XKCD_LIME_GREEN = (0.5372549019607843, 0.996078431372549, 0.0196078431372549)
    XKCD_BRIGHT_LIME = (0.5294117647058824, 0.9921568627450981, 0.0196078431372549)
    XKCD_KIWI = (0.611764705882353, 0.9372549019607843, 0.2627450980392157)
    XKCD_LEAF = (0.44313725490196076, 0.6666666666666666, 0.20392156862745098)
    XKCD_KERMIT_GREEN = (0.3607843137254902, 0.6980392156862745, 0.0)
    XKCD_DRAB_GREEN = (0.4549019607843137, 0.5843137254901961, 0.3176470588235294)
    CHARTREUSE = (0.4980392156862745, 1.0, 0.0)
    XKCD_PALE_LIME_GREEN = (0.6941176470588235, 1.0, 0.396078431372549)
    LAWNGREEN = (0.48627450980392156, 0.9882352941176471, 0.0)
    XKCD_LIGHT_YELLOWISH_GREEN = (0.7607843137254902, 1.0, 0.5372549019607843)
    XKCD_APPLE_GREEN = (0.4627450980392157, 0.803921568627451, 0.14901960784313725)
    XKCD_PISTACHIO = (0.7529411764705882, 0.9803921568627451, 0.5450980392156862)
    XKCD_KIWI_GREEN = (0.5568627450980392, 0.8980392156862745, 0.24705882352941178)
    XKCD_MOSS = (0.4627450980392157, 0.6, 0.34509803921568627)
    XKCD_LIGHT_LIME = (0.6823529411764706, 0.9921568627450981, 0.4235294117647059)
    XKCD_FROG_GREEN = (0.34509803921568627, 0.7372549019607844, 0.03137254901960784)
    XKCD_KEY_LIME = (0.6823529411764706, 1.0, 0.43137254901960786)
    XKCD_LAWN_GREEN = (0.30196078431372547, 0.6431372549019608, 0.03529411764705882)
    XKCD_NASTY_GREEN = (0.4392156862745098, 0.6980392156862745, 0.24705882352941178)
    XKCD_CELERY = (0.7568627450980392, 0.9921568627450981, 0.5843137254901961)
    XKCD_DARK_GRASS_GREEN = (
        0.2196078431372549,
        0.5019607843137255,
        0.01568627450980392,
    )
    XKCD_SPRING_GREEN = (0.6627450980392157, 0.9764705882352941, 0.44313725490196076)
    XKCD_GRASSY_GREEN = (0.2549019607843137, 0.611764705882353, 0.011764705882352941)
    XKCD_ASPARAGUS = (0.4666666666666667, 0.6705882352941176, 0.33725490196078434)
    XKCD_BRIGHT_LIME_GREEN = (0.396078431372549, 0.996078431372549, 0.03137254901960784)
    XKCD_GRASS = (0.3607843137254902, 0.6745098039215687, 0.17647058823529413)
    XKCD_LIGHT_GRASS_GREEN = (
        0.6039215686274509,
        0.9686274509803922,
        0.39215686274509803,
    )
    XKCD_TURTLE_GREEN = (0.4588235294117647, 0.7215686274509804, 0.30980392156862746)
    XKCD_GRASS_GREEN = (0.24705882352941178, 0.6078431372549019, 0.043137254901960784)
    XKCD_FLAT_GREEN = (0.4117647058823529, 0.615686274509804, 0.2980392156862745)
    XKCD_APPLE = (0.43137254901960786, 0.796078431372549, 0.23529411764705882)
    XKCD_LIGHT_GRAY_GREEN = (0.7176470588235294, 0.8823529411764706, 0.6313725490196078)
    XKCD_LIGHT_GREY_GREEN = (0.7176470588235294, 0.8823529411764706, 0.6313725490196078)
    XKCD_LICHEN = (0.5607843137254902, 0.7137254901960784, 0.4823529411764706)
    XKCD_SAGE = (0.5294117647058824, 0.6823529411764706, 0.45098039215686275)
    XKCD_GREEN_APPLE = (0.3686274509803922, 0.8627450980392157, 0.12156862745098039)
    XKCD_MEDIUM_GRAY = (0.49019607843137253, 0.4980392156862745, 0.48627450980392156)
    XKCD_MEDIUM_GREY = (0.49019607843137253, 0.4980392156862745, 0.48627450980392156)
    XKCD_LIGHT_GRAY = (0.8470588235294118, 0.8627450980392157, 0.8392156862745098)
    XKCD_LIGHT_GREY = (0.8470588235294118, 0.8627450980392157, 0.8392156862745098)
    XKCD_TEA_GREEN = (0.7411764705882353, 0.9725490196078431, 0.6392156862745098)
    XKCD_TOXIC_GREEN = (0.3803921568627451, 0.8705882352941177, 0.16470588235294117)
    XKCD_LIGHT_LIGHT_GREEN = (0.7843137254901961, 1.0, 0.6901960784313725)
    XKCD_VERY_LIGHT_GREEN = (0.8196078431372549, 1.0, 0.7411764705882353)
    XKCD_OFF_GREEN = (0.4196078431372549, 0.6392156862745098, 0.3254901960784314)
    XKCD_VERY_PALE_GREEN = (0.8117647058823529, 0.9921568627450981, 0.7372549019607844)
    XKCD_WASHED_OUT_GREEN = (0.7372549019607844, 0.9607843137254902, 0.6509803921568628)
    XKCD_GREENISH_GRAY = (0.5882352941176471, 0.6823529411764706, 0.5529411764705883)
    XKCD_GREENISH_GREY = (0.5882352941176471, 0.6823529411764706, 0.5529411764705883)
    XKCD_SAGE_GREEN = (0.5333333333333333, 0.7019607843137254, 0.47058823529411764)
    XKCD_DULL_GREEN = (0.4549019607843137, 0.6509803921568628, 0.3843137254901961)
    XKCD_GRAY_SLASH_GREEN = (
        0.5254901960784314,
        0.6313725490196078,
        0.49019607843137253,
    )
    XKCD_GREY_SLASH_GREEN = (
        0.5254901960784314,
        0.6313725490196078,
        0.49019607843137253,
    )
    XKCD_LIGHT_SAGE = (0.7372549019607844, 0.9254901960784314, 0.6745098039215687)
    XKCD_PALE_GREEN = (0.7803921568627451, 0.9921568627450981, 0.7098039215686275)
    XKCD_GRAY = (0.5725490196078431, 0.5843137254901961, 0.5686274509803921)
    XKCD_GREY = (0.5725490196078431, 0.5843137254901961, 0.5686274509803921)
    XKCD_PALE_LIGHT_GREEN = (0.6941176470588235, 0.9882352941176471, 0.6)
    XKCD_FORREST_GREEN = (
        0.08235294117647059,
        0.26666666666666666,
        0.023529411764705882,
    )
    XKCD_GREEN_GRAY = (0.4666666666666667, 0.5725490196078431, 0.43529411764705883)
    XKCD_GREEN_GREY = (0.4666666666666667, 0.5725490196078431, 0.43529411764705883)
    XKCD_FERN_GREEN = (0.32941176470588235, 0.5529411764705883, 0.26666666666666666)
    XKCD_LIGHT_GREEN = (0.5882352941176471, 0.9764705882352941, 0.4823529411764706)
    XKCD_FERN = (0.38823529411764707, 0.6627450980392157, 0.3137254901960784)
    XKCD_PASTEL_GREEN = (0.6901960784313725, 1.0, 0.615686274509804)
    XKCD_FRESH_GREEN = (0.4117647058823529, 0.8470588235294118, 0.30980392156862746)
    XKCD_POISON_GREEN = (0.25098039215686274, 0.9921568627450981, 0.0784313725490196)
    XKCD_LEAFY_GREEN = (0.3176470588235294, 0.7176470588235294, 0.23137254901960785)
    XKCD_TREE_GREEN = (0.16470588235294117, 0.49411764705882355, 0.09803921568627451)
    XKCD_MUTED_GREEN = (0.37254901960784315, 0.6274509803921569, 0.3215686274509804)
    XKCD_LIGHT_PASTEL_GREEN = (
        0.6980392156862745,
        0.984313725490196,
        0.6470588235294118,
    )
    XKCD_VIVID_GREEN = (0.1843137254901961, 0.9372549019607843, 0.06274509803921569)
    XKCD_GRAY_GREEN = (0.47058823529411764, 0.6078431372549019, 0.45098039215686275)
    XKCD_GREY_GREEN = (0.47058823529411764, 0.6078431372549019, 0.45098039215686275)
    XKCD_GRAYISH_GREEN = (0.5098039215686274, 0.6509803921568628, 0.49019607843137253)
    XKCD_GREYISH_GREEN = (0.5098039215686274, 0.6509803921568628, 0.49019607843137253)
    XKCD_LIGHTER_GREEN = (0.4588235294117647, 0.9921568627450981, 0.38823529411764707)
    XKCD_FADED_GREEN = (0.4823529411764706, 0.6980392156862745, 0.4549019607843137)
    XKCD_EASTER_GREEN = (0.5490196078431373, 0.9921568627450981, 0.49411764705882355)
    XKCD_GREENY_GRAY = (0.49411764705882355, 0.6274509803921569, 0.47843137254901963)
    XKCD_GREENY_GREY = (0.49411764705882355, 0.6274509803921569, 0.47843137254901963)
    XKCD_CELADON = (0.7450980392156863, 0.9921568627450981, 0.7176470588235294)
    XKCD_MID_GREEN = (0.3137254901960784, 0.6549019607843137, 0.2784313725490196)
    XKCD_HIGHLIGHTER_GREEN = (
        0.10588235294117647,
        0.9882352941176471,
        0.023529411764705882,
    )
    XKCD_ELECTRIC_GREEN = (
        0.12941176470588237,
        0.9882352941176471,
        0.050980392156862744,
    )
    XKCD_VERY_DARK_GREEN = (
        0.023529411764705882,
        0.1803921568627451,
        0.011764705882352941,
    )
    XKCD_DARK_SAGE = (0.34901960784313724, 0.5215686274509804, 0.33725490196078434)
    XKCD_RADIOACTIVE_GREEN = (
        0.17254901960784313,
        0.9803921568627451,
        0.12156862745098039,
    )
    XKCD_DARK_GREEN = (0.011764705882352941, 0.20784313725490197, 0.0)
    XKCD_DUSTY_GREEN = (0.4627450980392157, 0.6627450980392157, 0.45098039215686275)
    XKCD_HUNTER_GREEN = (0.043137254901960784, 0.25098039215686274, 0.03137254901960784)
    XKCD_FLURO_GREEN = (0.0392156862745098, 1.0, 0.00784313725490196)
    XKCD_TRUE_GREEN = (0.03137254901960784, 0.5803921568627451, 0.01568627450980392)
    XKCD_FOREST = (0.043137254901960784, 0.3333333333333333, 0.03529411764705882)
    XKCD_RACING_GREEN = (0.00392156862745098, 0.27450980392156865, 0.0)
    XKCD_VIBRANT_GREEN = (0.0392156862745098, 0.8666666666666667, 0.03137254901960784)
    XKCD_LIGHTISH_GREEN = (0.3803921568627451, 0.8823529411764706, 0.3764705882352941)
    HONEYDEW = (0.9411764705882353, 1.0, 0.9411764705882353)
    DARKSEAGREEN = (0.5607843137254902, 0.7372549019607844, 0.5607843137254902)
    PALEGREEN = (0.596078431372549, 0.984313725490196, 0.596078431372549)
    LIGHTGREEN = (0.5647058823529412, 0.9333333333333333, 0.5647058823529412)
    TAB_GREEN = (0.17254901960784313, 0.6274509803921569, 0.17254901960784313)
    FORESTGREEN = (0.13333333333333333, 0.5450980392156862, 0.13333333333333333)
    LIMEGREEN = (0.19607843137254902, 0.803921568627451, 0.19607843137254902)
    XKCD_NEON_GREEN = (0.047058823529411764, 1.0, 0.047058823529411764)
    XKCD_FLUORESCENT_GREEN = (0.03137254901960784, 1.0, 0.03137254901960784)
    DARKGREEN = (0.0, 0.39215686274509803, 0.0)
    G = (0.0, 0.5, 0.0)
    GREEN = (0.0, 0.5019607843137255, 0.0)
    LIME = (0.0, 1.0, 0.0)
    XKCD_DARK_PASTEL_GREEN = (
        0.33725490196078434,
        0.6823529411764706,
        0.3411764705882353,
    )
    XKCD_BOTTLE_GREEN = (0.01568627450980392, 0.2901960784313726, 0.0196078431372549)
    XKCD_HOT_GREEN = (0.1450980392156863, 1.0, 0.1607843137254902)
    XKCD_BRIGHT_GREEN = (0.00392156862745098, 1.0, 0.027450980392156862)
    XKCD_BORING_GREEN = (0.38823529411764707, 0.7019607843137254, 0.396078431372549)
    XKCD_DARKGREEN = (0.0196078431372549, 0.28627450980392155, 0.027450980392156862)
    XKCD_GREEN = (0.08235294117647059, 0.6901960784313725, 0.10196078431372549)
    XKCD_LIGHT_NEON_GREEN = (
        0.3058823529411765,
        0.9921568627450981,
        0.32941176470588235,
    )
    XKCD_LIGHTGREEN = (0.4627450980392157, 1.0, 0.4823529411764706)
    XKCD_LIGHT_BRIGHT_GREEN = (
        0.3254901960784314,
        0.996078431372549,
        0.3607843137254902,
    )
    XKCD_LIGHT_FOREST_GREEN = (
        0.30980392156862746,
        0.5686274509803921,
        0.3254901960784314,
    )
    XKCD_LIGHT_MINT = (0.7137254901960784, 1.0, 0.7333333333333333)
    XKCD_SOFT_GREEN = (0.43529411764705883, 0.7607843137254902, 0.4627450980392157)
    XKCD_DARK_FOREST_GREEN = (0.0, 0.17647058823529413, 0.01568627450980392)
    XKCD_FOREST_GREEN = (0.023529411764705882, 0.2784313725490196, 0.047058823529411764)
    XKCD_BRITISH_RACING_GREEN = (
        0.0196078431372549,
        0.2823529411764706,
        0.050980392156862744,
    )
    XKCD_MEDIUM_GREEN = (0.2235294117647059, 0.6784313725490196, 0.2823529411764706)
    XKCD_LIGHT_MINT_GREEN = (0.6509803921568628, 0.984313725490196, 0.6980392156862745)
    XKCD_MINT_GREEN = (0.5607843137254902, 1.0, 0.6235294117647059)
    XKCD_DEEP_GREEN = (0.00784313725490196, 0.34901960784313724, 0.058823529411764705)
    XKCD_BABY_GREEN = (0.5490196078431373, 1.0, 0.6196078431372549)
    XKCD_LIGHT_SEAFOAM_GREEN = (0.6549019607843137, 1.0, 0.7098039215686275)
    XKCD_DARKISH_GREEN = (0.1568627450980392, 0.48627450980392156, 0.21568627450980393)
    XKCD_MINT = (0.6235294117647059, 0.996078431372549, 0.6901960784313725)
    XKCD_PINE = (0.16862745098039217, 0.36470588235294116, 0.20392156862745098)
    XKCD_BRIGHT_LIGHT_GREEN = (
        0.17647058823529413,
        0.996078431372549,
        0.32941176470588235,
    )
    XKCD_EMERALD_GREEN = (0.00784313725490196, 0.5607843137254902, 0.11764705882352941)
    XKCD_SLATE_GREEN = (0.396078431372549, 0.5529411764705883, 0.42745098039215684)
    XKCD_HOSPITAL_GREEN = (0.6078431372549019, 0.8980392156862745, 0.6666666666666666)
    XKCD_ALGAE = (0.32941176470588235, 0.6745098039215687, 0.40784313725490196)
    XKCD_FOAM_GREEN = (0.5647058823529412, 0.9921568627450981, 0.6627450980392157)
    XKCD_LIGHT_SEA_GREEN = (0.596078431372549, 0.9647058823529412, 0.6901960784313725)
    XKCD_KELLY_GREEN = (0.00784313725490196, 0.6705882352941176, 0.1803921568627451)
    XKCD_IRISH_GREEN = (0.00392156862745098, 0.5843137254901961, 0.1607843137254902)
    XKCD_PINE_GREEN = (0.0392156862745098, 0.2823529411764706, 0.11764705882352941)
    XKCD_TEA = (0.396078431372549, 0.6705882352941176, 0.48627450980392156)
    XKCD_LIGHT_SEAFOAM = (0.6274509803921569, 0.996078431372549, 0.7490196078431373)
    XKCD_DARK_MINT = (0.2823529411764706, 0.7529411764705882, 0.4470588235294118)
    XKCD_COOL_GREEN = (0.2, 0.7215686274509804, 0.39215686274509803)
    XKCD_LIGHT_BLUISH_GREEN = (
        0.4627450980392157,
        0.9921568627450981,
        0.6588235294117647,
    )
    XKCD_SEAFOAM = (0.5019607843137255, 0.9764705882352941, 0.6784313725490196)
    XKCD_KELLEY_GREEN = (0.0, 0.5764705882352941, 0.21568627450980393)
    XKCD_SEAFOAM_GREEN = (0.47843137254901963, 0.9764705882352941, 0.6705882352941176)
    XKCD_SHAMROCK_GREEN = (0.00784313725490196, 0.7568627450980392, 0.30196078431372547)
    XKCD_WEIRD_GREEN = (0.22745098039215686, 0.8980392156862745, 0.4980392156862745)
    XKCD_SPEARMINT = (0.11764705882352941, 0.9725490196078431, 0.4627450980392157)
    XKCD_GREENISH = (0.25098039215686274, 0.6392156862745098, 0.40784313725490196)
    XKCD_SHAMROCK = (0.00392156862745098, 0.7058823529411765, 0.2980392156862745)
    XKCD_LIGHT_BLUE_GREEN = (0.49411764705882355, 0.984313725490196, 0.7019607843137254)
    SEAGREEN = (0.1803921568627451, 0.5450980392156862, 0.3411764705882353)
    MEDIUMSEAGREEN = (0.23529411764705882, 0.7019607843137254, 0.44313725490196076)
    XKCD_SEAWEED_GREEN = (0.20784313725490197, 0.6784313725490196, 0.4196078431372549)
    XKCD_EMERALD = (0.00392156862745098, 0.6274509803921569, 0.28627450980392155)
    XKCD_LIGHT_GREEN_BLUE = (
        0.33725490196078434,
        0.9882352941176471,
        0.6352941176470588,
    )
    XKCD_SEA_GREEN = (0.3254901960784314, 0.9882352941176471, 0.6313725490196078)
    XKCD_WINTERGREEN = (0.12549019607843137, 0.9764705882352941, 0.5254901960784314)
    XKCD_JADE_GREEN = (0.16862745098039217, 0.6862745098039216, 0.41568627450980394)
    XKCD_ALGAE_GREEN = (0.12941176470588237, 0.7647058823529411, 0.43529411764705883)
    XKCD_MINTY_GREEN = (0.043137254901960784, 0.9686274509803922, 0.49019607843137253)
    XKCD_TEALISH_GREEN = (0.047058823529411764, 0.8627450980392157, 0.45098039215686275)
    XKCD_DARK_SEAFOAM_GREEN = (
        0.24313725490196078,
        0.6862745098039216,
        0.4627450980392157,
    )
    SPRINGGREEN = (0.0, 1.0, 0.4980392156862745)
    MINTCREAM = (0.9607843137254902, 1.0, 0.9803921568627451)
    XKCD_SILVER = (0.7725490196078432, 0.788235294117647, 0.7803921568627451)
    XKCD_JUNGLE_GREEN = (0.01568627450980392, 0.5098039215686274, 0.2627450980392157)
    XKCD_DARK_MINT_GREEN = (
        0.12549019607843137,
        0.7529411764705882,
        0.45098039215686275,
    )
    XKCD_SEAWEED = (0.09411764705882353, 0.8196078431372549, 0.4823529411764706)
    XKCD_SPRUCE = (0.0392156862745098, 0.37254901960784315, 0.2196078431372549)
    XKCD_LIGHT_GREENISH_BLUE = (
        0.38823529411764707,
        0.9686274509803922,
        0.7058823529411765,
    )
    XKCD_TURQUOISE_GREEN = (0.01568627450980392, 0.9568627450980393, 0.5372549019607843)
    XKCD_PALE_TURQUOISE = (0.6470588235294118, 0.984313725490196, 0.8352941176470589)
    XKCD_EVERGREEN = (0.0196078431372549, 0.2784313725490196, 0.16470588235294117)
    XKCD_GREENISH_TEAL = (0.19607843137254902, 0.7490196078431373, 0.5176470588235295)
    XKCD_BLUEY_GREEN = (0.16862745098039217, 0.6941176470588235, 0.4745098039215686)
    XKCD_LIGHT_TEAL = (0.5647058823529412, 0.8941176470588236, 0.7568627450980392)
    XKCD_LIGHT_AQUAMARINE = (0.4823529411764706, 0.9921568627450981, 0.7803921568627451)
    XKCD_OCEAN_GREEN = (0.23921568627450981, 0.6, 0.45098039215686275)
    XKCD_TEAL_GREEN = (0.1450980392156863, 0.6392156862745098, 0.43529411764705883)
    XKCD_DARK_SEAFOAM = (0.12156862745098039, 0.7098039215686275, 0.47843137254901963)
    MEDIUMSPRINGGREEN = (0.0, 0.9803921568627451, 0.6039215686274509)
    XKCD_AQUA_GREEN = (0.07058823529411765, 0.8823529411764706, 0.5764705882352941)
    XKCD_JADE = (0.12156862745098039, 0.6549019607843137, 0.4549019607843137)
    XKCD_GREEN_TEAL = (0.047058823529411764, 0.7098039215686275, 0.4666666666666667)
    XKCD_VIRIDIAN = (0.11764705882352941, 0.5686274509803921, 0.403921568627451)
    XKCD_BRIGHT_SEA_GREEN = (0.0196078431372549, 1.0, 0.6509803921568628)
    XKCD_DARK_SEA_GREEN = (0.06666666666666667, 0.5294117647058824, 0.36470588235294116)
    XKCD_GREENBLUE = (0.13725490196078433, 0.7686274509803922, 0.5450980392156862)
    XKCD_PALE_TEAL = (0.5098039215686274, 0.796078431372549, 0.6980392156862745)
    MEDIUMAQUAMARINE = (0.4, 0.803921568627451, 0.6666666666666666)
    XKCD_LIGHT_TURQUOISE = (0.49411764705882355, 0.9568627450980393, 0.8)
    AQUAMARINE = (0.4980392156862745, 1.0, 0.8313725490196079)
    XKCD_GREENISH_CYAN = (0.16470588235294117, 0.996078431372549, 0.7176470588235294)
    XKCD_BLUISH_GREEN = (0.06274509803921569, 0.6509803921568628, 0.4549019607843137)
    XKCD_LIGHT_AQUA = (0.5490196078431373, 1.0, 0.8588235294117647)
    XKCD_GRAYISH_TEAL = (0.44313725490196076, 0.6235294117647059, 0.5686274509803921)
    XKCD_GREYISH_TEAL = (0.44313725490196076, 0.6235294117647059, 0.5686274509803921)
    XKCD_SEAFOAM_BLUE = (0.47058823529411764, 0.8196078431372549, 0.7137254901960784)
    XKCD_GREENISH_TURQUOISE = (0.0, 0.984313725490196, 0.6901960784313725)
    XKCD_PALE_AQUA = (0.7215686274509804, 1.0, 0.9215686274509803)
    XKCD_GRAY_TEAL = (0.3686274509803922, 0.6078431372549019, 0.5411764705882353)
    XKCD_GREY_TEAL = (0.3686274509803922, 0.6078431372549019, 0.5411764705882353)
    XKCD_GREEN_SLASH_BLUE = (
        0.00392156862745098,
        0.7529411764705882,
        0.5529411764705883,
    )
    XKCD_GREENY_BLUE = (0.25882352941176473, 0.7019607843137254, 0.5843137254901961)
    XKCD_CHARCOAL = (0.20392156862745098, 0.2196078431372549, 0.21568627450980393)
    XKCD_AQUA_MARINE = (0.1803921568627451, 0.9098039215686274, 0.7333333333333333)
    XKCD_DULL_TEAL = (0.37254901960784315, 0.6196078431372549, 0.5607843137254902)
    XKCD_GREEN_BLUE = (0.023529411764705882, 0.7058823529411765, 0.5450980392156862)
    XKCD_BRIGHT_TEAL = (0.00392156862745098, 0.9764705882352941, 0.7764705882352941)
    XKCD_TIFFANY_BLUE = (0.4823529411764706, 0.9490196078431372, 0.8549019607843137)
    XKCD_AQUAMARINE = (0.01568627450980392, 0.8470588235294118, 0.6980392156862745)
    XKCD_DARK_GREEN_BLUE = (
        0.12156862745098039,
        0.38823529411764707,
        0.3411764705882353,
    )
    XKCD_DUSTY_TEAL = (0.2980392156862745, 0.5647058823529412, 0.5215686274509804)
    XKCD_BLUE_GREEN = (0.07450980392156863, 0.49411764705882355, 0.42745098039215684)
    XKCD_AQUA = (0.07450980392156863, 0.9176470588235294, 0.788235294117647)
    XKCD_EGGSHELL_BLUE = (0.7686274509803922, 1.0, 0.9686274509803922)
    XKCD_TEALISH = (0.1411764705882353, 0.7372549019607844, 0.6588235294117647)
    XKCD_DUCK_EGG_BLUE = (0.7647058823529411, 0.984313725490196, 0.9568627450980393)
    XKCD_ICE = (0.8392156862745098, 1.0, 0.9803921568627451)
    XKCD_TURQUOISE = (0.023529411764705882, 0.7607843137254902, 0.6745098039215687)
    XKCD_DARK_BLUE_GREEN = (0.0, 0.3215686274509804, 0.28627450980392155)
    TURQUOISE = (0.25098039215686274, 0.8784313725490196, 0.8156862745098039)
    XKCD_BLUE_SLASH_GREEN = (
        0.058823529411764705,
        0.6078431372549019,
        0.5568627450980392,
    )
    XKCD_TEAL = (0.00784313725490196, 0.5764705882352941, 0.5254901960784314)
    XKCD_LIGHT_LIGHT_BLUE = (0.792156862745098, 1.0, 0.984313725490196)
    XKCD_SEA = (0.23529411764705882, 0.6, 0.5725490196078431)
    XKCD_TOPAZ = (0.07450980392156863, 0.7333333333333333, 0.6862745098039216)
    XKCD_PALE_CYAN = (0.7176470588235294, 1.0, 0.9803921568627451)
    XKCD_BRIGHT_AQUA = (0.043137254901960784, 0.9764705882352941, 0.9176470588235294)
    LIGHTSEAGREEN = (0.12549019607843137, 0.6980392156862745, 0.6666666666666666)
    MEDIUMTURQUOISE = (0.2823529411764706, 0.8196078431372549, 0.8)
    XKCD_LIGHT_CYAN = (0.6745098039215687, 1.0, 0.9882352941176471)
    XKCD_GREENISH_BLUE = (0.043137254901960784, 0.5450980392156862, 0.5294117647058824)
    XKCD_ICE_BLUE = (0.8431372549019608, 1.0, 0.996078431372549)
    XKCD_VERY_PALE_BLUE = (0.8392156862745098, 1.0, 0.996078431372549)
    XKCD_DARK_TURQUOISE = (0.01568627450980392, 0.3607843137254902, 0.35294117647058826)
    XKCD_BRIGHT_TURQUOISE = (
        0.058823529411764705,
        0.996078431372549,
        0.9764705882352941,
    )
    XKCD_DARK_AQUAMARINE = (
        0.00392156862745098,
        0.45098039215686275,
        0.44313725490196076,
    )
    XKCD_BLUEGREEN = (0.00392156862745098, 0.47843137254901963, 0.4745098039215686)
    XKCD_DARK_GRAY = (0.21176470588235294, 0.21568627450980393, 0.21568627450980393)
    XKCD_DARK_GREY = (0.21176470588235294, 0.21568627450980393, 0.21568627450980393)
    AZURE = (0.9411764705882353, 1.0, 1.0)
    LIGHTCYAN = (0.8784313725490196, 1.0, 1.0)
    XKCD_VERY_LIGHT_BLUE = (0.8352941176470589, 1.0, 1.0)
    XKCD_REALLY_LIGHT_BLUE = (0.8313725490196079, 1.0, 1.0)
    XKCD_PALE_BLUE = (0.8156862745098039, 0.996078431372549, 0.996078431372549)
    PALETURQUOISE = (0.6862745098039216, 0.9333333333333333, 0.9333333333333333)
    DARKSLATEGRAY = (0.1843137254901961, 0.30980392156862746, 0.30980392156862746)
    DARKSLATEGREY = (0.1843137254901961, 0.30980392156862746, 0.30980392156862746)
    XKCD_ALMOST_BLACK = (
        0.027450980392156862,
        0.050980392156862744,
        0.050980392156862744,
    )
    TEAL = (0.0, 0.5019607843137255, 0.5019607843137255)
    DARKCYAN = (0.0, 0.5450980392156862, 0.5450980392156862)
    C = (0.0, 0.75, 0.75)
    AQUA = (0.0, 1.0, 1.0)
    CYAN = (0.0, 1.0, 1.0)
    XKCD_CYAN = (0.0, 1.0, 1.0)
    XKCD_BRIGHT_CYAN = (0.2549019607843137, 0.9921568627450981, 0.996078431372549)
    XKCD_DEEP_TURQUOISE = (0.00392156862745098, 0.45098039215686275, 0.4549019607843137)
    XKCD_DARK_TEAL = (0.00392156862745098, 0.30196078431372547, 0.3058823529411765)
    DARKTURQUOISE = (0.0, 0.807843137254902, 0.8196078431372549)
    XKCD_DARK_CYAN = (0.0392156862745098, 0.5333333333333333, 0.5411764705882353)
    XKCD_DARK_AQUA = (0.0196078431372549, 0.4117647058823529, 0.4196078431372549)
    XKCD_BRIGHT_LIGHT_BLUE = (
        0.14901960784313725,
        0.9686274509803922,
        0.9921568627450981,
    )
    CADETBLUE = (0.37254901960784315, 0.6196078431372549, 0.6274509803921569)
    XKCD_LIGHT_SKY_BLUE = (0.7764705882352941, 0.9882352941176471, 1.0)
    XKCD_DEEP_TEAL = (0.0, 0.3333333333333333, 0.35294117647058826)
    XKCD_DEEP_AQUA = (0.03137254901960784, 0.47058823529411764, 0.4980392156862745)
    XKCD_AQUA_BLUE = (0.00784313725490196, 0.8470588235294118, 0.9137254901960784)
    TAB_CYAN = (0.09019607843137255, 0.7450980392156863, 0.8117647058823529)
    XKCD_TURQUOISE_BLUE = (0.023529411764705882, 0.6941176470588235, 0.7686274509803922)
    XKCD_ROBIN_S_EGG_BLUE = (0.596078431372549, 0.9372549019607843, 0.9764705882352941)
    XKCD_PETROL = (0.0, 0.37254901960784315, 0.41568627450980394)
    POWDERBLUE = (0.6901960784313725, 0.8784313725490196, 0.9019607843137255)
    XKCD_ROBIN_S_EGG = (0.42745098039215684, 0.9294117647058824, 0.9921568627450981)
    XKCD_ROBIN_EGG_BLUE = (0.5411764705882353, 0.9450980392156862, 0.996078431372549)
    XKCD_PALE_SKY_BLUE = (0.7411764705882353, 0.9647058823529412, 0.996078431372549)
    XKCD_TEAL_BLUE = (0.00392156862745098, 0.5333333333333333, 0.6235294117647059)
    XKCD_NEON_BLUE = (0.01568627450980392, 0.8509803921568627, 1.0)
    XKCD_OCEAN = (0.00392156862745098, 0.4823529411764706, 0.5725490196078431)
    XKCD_CHARCOAL_GRAY = (0.23529411764705882, 0.2549019607843137, 0.25882352941176473)
    XKCD_CHARCOAL_GREY = (0.23529411764705882, 0.2549019607843137, 0.25882352941176473)
    XKCD_COOL_GRAY = (0.5843137254901961, 0.6392156862745098, 0.6509803921568628)
    XKCD_COOL_GREY = (0.5843137254901961, 0.6392156862745098, 0.6509803921568628)
    XKCD_BRIGHT_SKY_BLUE = (0.00784313725490196, 0.8, 0.996078431372549)
    XKCD_SEA_BLUE = (0.01568627450980392, 0.4549019607843137, 0.5843137254901961)
    LIGHTBLUE = (0.6784313725490196, 0.8470588235294118, 0.9019607843137255)
    XKCD_GUNMETAL = (0.3254901960784314, 0.3843137254901961, 0.403921568627451)
    DEEPSKYBLUE = (0.0, 0.7490196078431373, 1.0)
    XKCD_OCEAN_BLUE = (0.011764705882352941, 0.44313725490196076, 0.611764705882353)
    XKCD_DIRTY_BLUE = (0.24705882352941178, 0.5098039215686274, 0.615686274509804)
    SKYBLUE = (0.5294117647058824, 0.807843137254902, 0.9215686274509803)
    XKCD_STEEL_GRAY = (0.43529411764705883, 0.5098039215686274, 0.5411764705882353)
    XKCD_STEEL_GREY = (0.43529411764705883, 0.5098039215686274, 0.5411764705882353)
    XKCD_PEACOCK_BLUE = (0.00392156862745098, 0.403921568627451, 0.5843137254901961)
    XKCD_GRAYBLUE = (0.4666666666666667, 0.6313725490196078, 0.7098039215686275)
    XKCD_GREYBLUE = (0.4666666666666667, 0.6313725490196078, 0.7098039215686275)
    XKCD_BLUEGRAY = (0.5215686274509804, 0.6392156862745098, 0.6980392156862745)
    XKCD_BLUEGREY = (0.5215686274509804, 0.6392156862745098, 0.6980392156862745)
    XKCD_NICE_BLUE = (0.06274509803921569, 0.47843137254901963, 0.6901960784313725)
    XKCD_BLUISH_GRAY = (0.4549019607843137, 0.5450980392156862, 0.592156862745098)
    XKCD_BLUISH_GREY = (0.4549019607843137, 0.5450980392156862, 0.592156862745098)
    XKCD_BATTLESHIP_GRAY = (0.4196078431372549, 0.48627450980392156, 0.5215686274509804)
    XKCD_BATTLESHIP_GREY = (0.4196078431372549, 0.48627450980392156, 0.5215686274509804)
    XKCD_DEEP_SEA_BLUE = (0.00392156862745098, 0.32941176470588235, 0.5098039215686274)
    XKCD_WATER_BLUE = (0.054901960784313725, 0.5294117647058824, 0.8)
    XKCD_CERULEAN = (0.01568627450980392, 0.5215686274509804, 0.8196078431372549)
    XKCD_LIGHTBLUE = (0.4823529411764706, 0.7843137254901961, 0.9647058823529412)
    XKCD_AZURE = (0.023529411764705882, 0.6039215686274509, 0.9529411764705882)
    LIGHTSKYBLUE = (0.5294117647058824, 0.807843137254902, 0.9803921568627451)
    XKCD_BLUE_GRAY = (0.3764705882352941, 0.48627450980392156, 0.5568627450980392)
    XKCD_BLUE_GREY = (0.3764705882352941, 0.48627450980392156, 0.5568627450980392)
    XKCD_DARK_BLUE_GRAY = (
        0.12156862745098039,
        0.23137254901960785,
        0.30196078431372547,
    )
    XKCD_DARK_BLUE_GREY = (
        0.12156862745098039,
        0.23137254901960785,
        0.30196078431372547,
    )
    XKCD_SLATE = (0.3176470588235294, 0.396078431372549, 0.4470588235294118)
    XKCD_SLATE_GRAY = (0.34901960784313724, 0.396078431372549, 0.42745098039215684)
    XKCD_SLATE_GREY = (0.34901960784313724, 0.396078431372549, 0.42745098039215684)
    XKCD_UGLY_BLUE = (0.19215686274509805, 0.4, 0.5411764705882353)
    XKCD_GRAY_SLASH_BLUE = (
        0.39215686274509803,
        0.49019607843137253,
        0.5568627450980392,
    )
    XKCD_GREY_SLASH_BLUE = (
        0.39215686274509803,
        0.49019607843137253,
        0.5568627450980392,
    )
    XKCD_DARK_SLATE_BLUE = (0.12941176470588237, 0.2784313725490196, 0.3803921568627451)
    TAB_BLUE = (0.12156862745098039, 0.4666666666666667, 0.7058823529411765)
    XKCD_SKY = (0.5098039215686274, 0.792156862745098, 0.9882352941176471)
    XKCD_BLUEY_GRAY = (0.5372549019607843, 0.6274509803921569, 0.6901960784313725)
    XKCD_BLUEY_GREY = (0.5372549019607843, 0.6274509803921569, 0.6901960784313725)
    XKCD_DARK_GRAY_BLUE = (0.1607843137254902, 0.27450980392156865, 0.3568627450980392)
    XKCD_DARK_GREY_BLUE = (0.1607843137254902, 0.27450980392156865, 0.3568627450980392)
    XKCD_PRUSSIAN_BLUE = (0.0, 0.27058823529411763, 0.4666666666666667)
    XKCD_LIGHT_BLUE = (0.5843137254901961, 0.8156862745098039, 0.9882352941176471)
    XKCD_METALLIC_BLUE = (0.30980392156862746, 0.45098039215686275, 0.5568627450980392)
    XKCD_STORMY_BLUE = (0.3137254901960784, 0.4823529411764706, 0.611764705882353)
    XKCD_LIGHT_GRAY_BLUE = (0.615686274509804, 0.7372549019607844, 0.8313725490196079)
    XKCD_LIGHT_GREY_BLUE = (0.615686274509804, 0.7372549019607844, 0.8313725490196079)
    XKCD_GRAY_BLUE = (0.4196078431372549, 0.5450980392156862, 0.6431372549019608)
    XKCD_GREY_BLUE = (0.4196078431372549, 0.5450980392156862, 0.6431372549019608)
    XKCD_GRAYISH_BLUE = (0.3686274509803922, 0.5058823529411764, 0.615686274509804)
    XKCD_GREYISH_BLUE = (0.3686274509803922, 0.5058823529411764, 0.615686274509804)
    XKCD_STEEL_BLUE = (0.35294117647058826, 0.49019607843137253, 0.6039215686274509)
    STEELBLUE = (0.27450980392156865, 0.5098039215686274, 0.7058823529411765)
    XKCD_MUTED_BLUE = (0.23137254901960785, 0.44313725490196076, 0.6235294117647059)
    ALICEBLUE = (0.9411764705882353, 0.9725490196078431, 1.0)
    XKCD_SLATE_BLUE = (0.3568627450980392, 0.48627450980392156, 0.6)
    XKCD_COOL_BLUE = (0.28627450980392155, 0.5176470588235295, 0.7215686274509804)
    XKCD_LIGHT_NAVY = (0.08235294117647059, 0.3137254901960784, 0.5176470588235295)
    XKCD_DUSTY_BLUE = (0.35294117647058826, 0.5254901960784314, 0.6784313725490196)
    XKCD_DULL_BLUE = (0.28627450980392155, 0.4588235294117647, 0.611764705882353)
    XKCD_STEEL = (0.45098039215686275, 0.5215686274509804, 0.5843137254901961)
    XKCD_CADET_BLUE = (0.3058823529411765, 0.4549019607843137, 0.5882352941176471)
    XKCD_BLUISH = (0.1607843137254902, 0.4627450980392157, 0.7333333333333333)
    XKCD_MARINE_BLUE = (0.00392156862745098, 0.2196078431372549, 0.41568627450980394)
    XKCD_OFF_BLUE = (0.33725490196078434, 0.5176470588235295, 0.6823529411764706)
    XKCD_BLUE_SLASH_GRAY = (0.4588235294117647, 0.5529411764705883, 0.6392156862745098)
    XKCD_BLUE_SLASH_GREY = (0.4588235294117647, 0.5529411764705883, 0.6392156862745098)
    XKCD_SKY_BLUE = (0.4588235294117647, 0.7333333333333333, 0.9921568627450981)
    XKCD_FLAT_BLUE = (0.23529411764705882, 0.45098039215686275, 0.6588235294117647)
    XKCD_TWILIGHT_BLUE = (0.0392156862745098, 0.2627450980392157, 0.47843137254901963)
    DODGERBLUE = (0.11764705882352941, 0.5647058823529412, 1.0)
    LIGHTSLATEGRAY = (0.4666666666666667, 0.5333333333333333, 0.6)
    LIGHTSLATEGREY = (0.4666666666666667, 0.5333333333333333, 0.6)
    SLATEGRAY = (0.4392156862745098, 0.5019607843137255, 0.5647058823529412)
    SLATEGREY = (0.4392156862745098, 0.5019607843137255, 0.5647058823529412)
    XKCD_DARKISH_BLUE = (0.00392156862745098, 0.2549019607843137, 0.5098039215686274)
    XKCD_DENIM = (0.23137254901960785, 0.38823529411764707, 0.5490196078431373)
    XKCD_BABY_BLUE = (0.6352941176470588, 0.8117647058823529, 0.996078431372549)
    XKCD_LIGHT_NAVY_BLUE = (0.1803921568627451, 0.35294117647058826, 0.5333333333333333)
    XKCD_CLOUDY_BLUE = (0.6745098039215687, 0.7607843137254902, 0.8509803921568627)
    XKCD_MID_BLUE = (0.15294117647058825, 0.41568627450980394, 0.7019607843137254)
    XKCD_WINDOWS_BLUE = (0.21568627450980393, 0.47058823529411764, 0.7490196078431373)
    XKCD_MEDIUM_BLUE = (0.17254901960784313, 0.43529411764705883, 0.7333333333333333)
    XKCD_DARK_SKY_BLUE = (0.26666666666666666, 0.5568627450980392, 0.8941176470588236)
    XKCD_MARINE = (0.01568627450980392, 0.1803921568627451, 0.3764705882352941)
    XKCD_FADED_BLUE = (0.396078431372549, 0.5490196078431373, 0.7333333333333333)
    XKCD_CERULEAN_BLUE = (0.0196078431372549, 0.43137254901960786, 0.9333333333333333)
    XKCD_DEEP_SKY_BLUE = (0.050980392156862744, 0.4588235294117647, 0.9725490196078431)
    XKCD_DUSK_BLUE = (0.14901960784313725, 0.3254901960784314, 0.5529411764705883)
    LIGHTSTEELBLUE = (0.6901960784313725, 0.7686274509803922, 0.8705882352941177)
    XKCD_POWDER_BLUE = (0.6941176470588235, 0.8196078431372549, 0.9882352941176471)
    XKCD_LIGHT_BLUE_GRAY = (0.7176470588235294, 0.788235294117647, 0.8862745098039215)
    XKCD_LIGHT_BLUE_GREY = (0.7176470588235294, 0.788235294117647, 0.8862745098039215)
    XKCD_DARK = (0.10588235294117647, 0.1411764705882353, 0.19215686274509805)
    XKCD_BRIGHT_BLUE = (0.00392156862745098, 0.396078431372549, 0.9882352941176471)
    XKCD_CAROLINA_BLUE = (0.5411764705882353, 0.7215686274509804, 0.996078431372549)
    XKCD_CLEAR_BLUE = (0.1411764705882353, 0.47843137254901963, 0.9921568627450981)
    XKCD_FRENCH_BLUE = (0.2627450980392157, 0.4196078431372549, 0.6784313725490196)
    XKCD_COBALT = (0.11764705882352941, 0.2823529411764706, 0.5607843137254902)
    XKCD_DENIM_BLUE = (0.23137254901960785, 0.3568627450980392, 0.5725490196078431)
    XKCD_DODGER_BLUE = (0.24313725490196078, 0.5098039215686274, 0.9882352941176471)
    CORNFLOWERBLUE = (0.39215686274509803, 0.5843137254901961, 0.9294117647058824)
    XKCD_NAVY = (0.00392156862745098, 0.08235294117647059, 0.24313725490196078)
    XKCD_LIGHTISH_BLUE = (0.23921568627450981, 0.47843137254901963, 0.9921568627450981)
    XKCD_PASTEL_BLUE = (0.6352941176470588, 0.7490196078431373, 0.996078431372549)
    XKCD_DUSKY_BLUE = (0.2784313725490196, 0.37254901960784315, 0.5803921568627451)
    XKCD_AZUL = (0.11372549019607843, 0.36470588235294116, 0.9254901960784314)
    XKCD_ELECTRIC_BLUE = (0.023529411764705882, 0.3215686274509804, 1.0)
    XKCD_BLUE = (0.011764705882352941, 0.2627450980392157, 0.8745098039215686)
    XKCD_SOFT_BLUE = (0.39215686274509803, 0.5333333333333333, 0.9176470588235294)
    ROYALBLUE = (0.2549019607843137, 0.4117647058823529, 0.8823529411764706)
    XKCD_NAVY_BLUE = (0.0, 0.06666666666666667, 0.27450980392156865)
    XKCD_CORNFLOWER_BLUE = (0.3176470588235294, 0.4392156862745098, 0.8431372549019608)
    XKCD_VIBRANT_BLUE = (0.011764705882352941, 0.2235294117647059, 0.9725490196078431)
    XKCD_BLUE_BLUE = (0.13333333333333333, 0.25882352941176473, 0.7803921568627451)
    XKCD_SAPPHIRE = (0.12941176470588237, 0.2196078431372549, 0.6705882352941176)
    XKCD_DUSK = (0.3058823529411765, 0.32941176470588235, 0.5058823529411764)
    XKCD_VIVID_BLUE = (0.08235294117647059, 0.1803921568627451, 1.0)
    XKCD_CORNFLOWER = (0.41568627450980394, 0.4745098039215686, 0.9686274509803922)
    XKCD_RICH_BLUE = (0.00784313725490196, 0.10588235294117647, 0.9764705882352941)
    XKCD_PERIWINKLE_BLUE = (0.5607843137254902, 0.6, 0.984313725490196)
    XKCD_LIGHT_PERIWINKLE = (0.7568627450980392, 0.7764705882352941, 0.9882352941176471)
    XKCD_WARM_BLUE = (0.29411764705882354, 0.3411764705882353, 0.8588235294117647)
    XKCD_ROYAL = (0.047058823529411764, 0.09019607843137255, 0.5764705882352941)
    XKCD_DARK_NAVY = (0.0, 0.01568627450980392, 0.20784313725490197)
    XKCD_TRUE_BLUE = (0.00392156862745098, 0.058823529411764705, 0.8)
    XKCD_TWILIGHT = (0.3058823529411765, 0.3176470588235294, 0.5450980392156862)
    XKCD_DARK_NAVY_BLUE = (0.0, 0.00784313725490196, 0.1803921568627451)
    XKCD_COBALT_BLUE = (0.011764705882352941, 0.0392156862745098, 0.6549019607843137)
    XKCD_DARKBLUE = (0.011764705882352941, 0.027450980392156862, 0.39215686274509803)
    XKCD_DARK_ROYAL_BLUE = (
        0.00784313725490196,
        0.023529411764705882,
        0.43529411764705883,
    )
    XKCD_DARK_BLUE = (0.0, 0.011764705882352941, 0.3568627450980392)
    XKCD_VERY_DARK_BLUE = (0.0, 0.00392156862745098, 0.2)
    XKCD_PURE_BLUE = (0.00784313725490196, 0.011764705882352941, 0.8862745098039215)
    XKCD_PALE_GRAY = (0.9921568627450981, 0.9921568627450981, 0.996078431372549)
    XKCD_PALE_GREY = (0.9921568627450981, 0.9921568627450981, 0.996078431372549)
    GHOSTWHITE = (0.9725490196078431, 0.9725490196078431, 1.0)
    LAVENDER = (0.9019607843137255, 0.9019607843137255, 0.9803921568627451)
    MIDNIGHTBLUE = (0.09803921568627451, 0.09803921568627451, 0.4392156862745098)
    NAVY = (0.0, 0.0, 0.5019607843137255)
    DARKBLUE = (0.0, 0.0, 0.5450980392156862)
    MEDIUMBLUE = (0.0, 0.0, 0.803921568627451)
    B = (0.0, 0.0, 1.0)
    BLUE = (0.0, 0.0, 1.0)
    XKCD_ROYAL_BLUE = (0.0196078431372549, 0.01568627450980392, 0.6666666666666666)
    XKCD_NIGHT_BLUE = (0.01568627450980392, 0.011764705882352941, 0.2823529411764706)
    XKCD_PRIMARY_BLUE = (0.03137254901960784, 0.01568627450980392, 0.9764705882352941)
    XKCD_DEEP_BLUE = (0.01568627450980392, 0.00784313725490196, 0.45098039215686275)
    XKCD_STRONG_BLUE = (0.047058823529411764, 0.023529411764705882, 0.9686274509803922)
    XKCD_LAVENDER_BLUE = (0.5450980392156862, 0.5333333333333333, 0.9725490196078431)
    XKCD_PERRYWINKLE = (0.5607843137254902, 0.5490196078431373, 0.9058823529411765)
    XKCD_MIDNIGHT_BLUE = (0.00784313725490196, 0.0, 0.20784313725490197)
    XKCD_MIDNIGHT = (0.011764705882352941, 0.00392156862745098, 0.17647058823529413)
    XKCD_LIGHT_ROYAL_BLUE = (0.22745098039215686, 0.1803921568627451, 0.996078431372549)
    XKCD_BLUEBERRY = (0.27450980392156865, 0.2549019607843137, 0.5882352941176471)
    XKCD_DARK_PERIWINKLE = (0.4, 0.37254901960784315, 0.8196078431372549)
    XKCD_ULTRAMARINE_BLUE = (
        0.09411764705882353,
        0.0196078431372549,
        0.8588235294117647,
    )
    XKCD_IRIS = (0.3843137254901961, 0.34509803921568627, 0.7686274509803922)
    XKCD_PERIWINKLE = (0.5568627450980392, 0.5098039215686274, 0.996078431372549)
    SLATEBLUE = (0.41568627450980394, 0.35294117647058826, 0.803921568627451)
    DARKSLATEBLUE = (0.2823529411764706, 0.23921568627450981, 0.5450980392156862)
    MEDIUMSLATEBLUE = (0.4823529411764706, 0.40784313725490196, 0.9333333333333333)
    XKCD_LIGHT_INDIGO = (0.42745098039215684, 0.35294117647058826, 0.8117647058823529)
    XKCD_BLUE_WITH_A_HINT_OF_PURPLE = (
        0.3254901960784314,
        0.23529411764705882,
        0.7764705882352941,
    )
    XKCD_ULTRAMARINE = (0.12549019607843137, 0.0, 0.6941176470588235)
    XKCD_PURPLEISH_BLUE = (0.3803921568627451, 0.25098039215686274, 0.9372549019607843)
    XKCD_BLURPLE = (0.3333333333333333, 0.2235294117647059, 0.8)
    XKCD_INDIGO_BLUE = (0.22745098039215686, 0.09411764705882353, 0.6941176470588235)
    XKCD_PURPLEY_BLUE = (0.37254901960784315, 0.20392156862745098, 0.9058823529411765)
    XKCD_BLUEY_PURPLE = (0.3843137254901961, 0.2549019607843137, 0.7803921568627451)
    XKCD_BLUE_PURPLE = (0.3411764705882353, 0.1607843137254902, 0.807843137254902)
    XKCD_PURPLE_BLUE = (0.38823529411764707, 0.17647058823529413, 0.9137254901960784)
    XKCD_DARK_INDIGO = (0.12156862745098039, 0.03529411764705882, 0.32941176470588235)
    XKCD_PURPLISH_BLUE = (0.3764705882352941, 0.11764705882352941, 0.9764705882352941)
    XKCD_BURPLE = (0.40784313725490196, 0.19607843137254902, 0.8901960784313725)
    XKCD_BLUISH_PURPLE = (0.4392156862745098, 0.23137254901960785, 0.9058823529411765)
    MEDIUMPURPLE = (0.5764705882352941, 0.4392156862745098, 0.8588235294117647)
    XKCD_PURPLE_SLASH_BLUE = (
        0.36470588235294116,
        0.12941176470588237,
        0.8156862745098039,
    )
    XKCD_PURPLEY = (0.5294117647058824, 0.33725490196078434, 0.8941176470588236)
    XKCD_PURPLY_BLUE = (0.4, 0.10196078431372549, 0.9333333333333333)
    XKCD_BLUE_SLASH_PURPLE = (
        0.35294117647058826,
        0.023529411764705882,
        0.9372549019607843,
    )
    XKCD_VIOLET_BLUE = (0.3176470588235294, 0.0392156862745098, 0.788235294117647)
    XKCD_BLUE_VIOLET = (0.36470588235294116, 0.023529411764705882, 0.9137254901960784)
    XKCD_PALE_VIOLET = (0.807843137254902, 0.6823529411764706, 0.9803921568627451)
    XKCD_INDIGO = (0.2196078431372549, 0.00784313725490196, 0.5098039215686274)
    XKCD_PASTEL_PURPLE = (0.792156862745098, 0.6274509803921569, 1.0)
    XKCD_LIGHT_LAVENDER = (0.8745098039215686, 0.7725490196078432, 0.996078431372549)
    XKCD_LIGHT_VIOLET = (0.8392156862745098, 0.7058823529411765, 0.9882352941176471)
    XKCD_PALE_LILAC = (0.8941176470588236, 0.796078431372549, 1.0)
    XKCD_LILAC = (0.807843137254902, 0.6352941176470588, 0.9921568627450981)
    XKCD_LILIAC = (0.7686274509803922, 0.5568627450980392, 0.9921568627450981)
    XKCD_LIGHTER_PURPLE = (0.6470588235294118, 0.35294117647058826, 0.9568627450980393)
    XKCD_LAVENDER = (0.7803921568627451, 0.6235294117647059, 0.9372549019607843)
    REBECCAPURPLE = (0.4, 0.2, 0.6)
    XKCD_LIGHT_URPLE = (0.7019607843137254, 0.43529411764705883, 0.9647058823529412)
    XKCD_DEEP_LILAC = (0.5882352941176471, 0.43137254901960786, 0.7411764705882353)
    XKCD_BABY_PURPLE = (0.792156862745098, 0.6078431372549019, 0.9686274509803922)
    BLUEVIOLET = (0.5411764705882353, 0.16862745098039217, 0.8862745098039215)
    TAB_PURPLE = (0.5803921568627451, 0.403921568627451, 0.7411764705882353)
    XKCD_DEEP_LAVENDER = (0.5529411764705883, 0.3686274509803922, 0.7176470588235294)
    XKCD_EASTER_PURPLE = (0.7529411764705882, 0.44313725490196076, 0.996078431372549)
    XKCD_LIGHTISH_PURPLE = (0.6470588235294118, 0.3215686274509804, 0.9019607843137255)
    XKCD_LIGHT_PURPLE = (0.7490196078431373, 0.4666666666666667, 0.9647058823529412)
    XKCD_PALE_PURPLE = (0.7176470588235294, 0.5647058823529412, 0.8313725490196079)
    INDIGO = (0.29411764705882354, 0.0, 0.5098039215686274)
    XKCD_VIVID_PURPLE = (0.6, 0.0, 0.9803921568627451)
    XKCD_DARK_LAVENDER = (0.5215686274509804, 0.403921568627451, 0.596078431372549)
    XKCD_ELECTRIC_PURPLE = (0.6666666666666666, 0.13725490196078433, 1.0)
    XKCD_AMETHYST = (0.6078431372549019, 0.37254901960784315, 0.7529411764705882)
    XKCD_WISTERIA = (0.6588235294117647, 0.49019607843137253, 0.7607843137254902)
    XKCD_VIOLET = (0.6039215686274509, 0.054901960784313725, 0.9176470588235294)
    XKCD_BRIGHT_LAVENDER = (0.7803921568627451, 0.3764705882352941, 1.0)
    XKCD_PALE_LAVENDER = (0.9333333333333333, 0.8117647058823529, 0.996078431372549)
    DARKORCHID = (0.6, 0.19607843137254902, 0.8)
    XKCD_BRIGHT_VIOLET = (0.6784313725490196, 0.0392156862745098, 0.9921568627450981)
    XKCD_LIGHT_LILAC = (0.9294117647058824, 0.7843137254901961, 1.0)
    XKCD_GRAY_PURPLE = (0.5098039215686274, 0.42745098039215684, 0.5490196078431373)
    XKCD_GREY_PURPLE = (0.5098039215686274, 0.42745098039215684, 0.5490196078431373)
    XKCD_BRIGHT_LILAC = (0.788235294117647, 0.3686274509803922, 0.984313725490196)
    XKCD_ROYAL_PURPLE = (0.29411764705882354, 0.0, 0.43137254901960786)
    DARKVIOLET = (0.5803921568627451, 0.0, 0.8274509803921568)
    XKCD_GRAYISH_PURPLE = (0.5333333333333333, 0.44313725490196076, 0.5686274509803921)
    XKCD_GREYISH_PURPLE = (0.5333333333333333, 0.44313725490196076, 0.5686274509803921)
    XKCD_NEON_PURPLE = (0.7372549019607844, 0.07450980392156863, 0.996078431372549)
    XKCD_MIDNIGHT_PURPLE = (
        0.1568627450980392,
        0.00392156862745098,
        0.21568627450980393,
    )
    XKCD_BRIGHT_PURPLE = (0.7450980392156863, 0.011764705882352941, 0.9921568627450981)
    XKCD_LIGHT_LAVENDAR = (0.9372549019607843, 0.7529411764705882, 0.996078431372549)
    XKCD_PURPLE = (0.49411764705882355, 0.11764705882352941, 0.611764705882353)
    XKCD_PURPLY = (0.596078431372549, 0.24705882352941178, 0.6980392156862745)
    XKCD_VIBRANT_PURPLE = (0.6784313725490196, 0.011764705882352941, 0.8705882352941177)
    XKCD_PURPLISH_GRAY = (0.47843137254901963, 0.40784313725490196, 0.4980392156862745)
    XKCD_PURPLISH_GREY = (0.47843137254901963, 0.40784313725490196, 0.4980392156862745)
    XKCD_SOFT_PURPLE = (0.6509803921568628, 0.43529411764705883, 0.7098039215686275)
    XKCD_HEATHER = (0.6431372549019608, 0.5176470588235295, 0.6745098039215687)
    MEDIUMORCHID = (0.7294117647058823, 0.3333333333333333, 0.8274509803921568)
    XKCD_VERY_DARK_PURPLE = (
        0.16470588235294117,
        0.00392156862745098,
        0.20392156862745098,
    )
    XKCD_FADED_PURPLE = (0.5686274509803921, 0.43137254901960786, 0.6)
    XKCD_DARK_VIOLET = (0.20392156862745098, 0.00392156862745098, 0.24705882352941178)
    XKCD_HOT_PURPLE = (0.796078431372549, 0.0, 0.9607843137254902)
    XKCD_HELIOTROPE = (0.8509803921568627, 0.30980392156862746, 0.9607843137254902)
    XKCD_DARK_LILAC = (0.611764705882353, 0.42745098039215684, 0.6470588235294118)
    XKCD_DARK_PURPLE = (0.20784313725490197, 0.023529411764705882, 0.24313725490196078)
    XKCD_MUTED_PURPLE = (0.5019607843137255, 0.3568627450980392, 0.5294117647058824)
    XKCD_DEEP_PURPLE = (0.21176470588235294, 0.00392156862745098, 0.24705882352941178)
    XKCD_VERY_LIGHT_PURPLE = (0.9647058823529412, 0.807843137254902, 0.9882352941176471)
    XKCD_DUSTY_PURPLE = (0.5098039215686274, 0.37254901960784315, 0.5294117647058824)
    XKCD_BARNEY = (0.6745098039215687, 0.11372549019607843, 0.7215686274509804)
    XKCD_MEDIUM_PURPLE = (0.6196078431372549, 0.2627450980392157, 0.6352941176470588)
    XKCD_PURPLE_SLASH_PINK = (
        0.8431372549019608,
        0.1450980392156863,
        0.8705882352941177,
    )
    XKCD_PLUM_PURPLE = (0.3058823529411765, 0.0196078431372549, 0.3137254901960784)
    XKCD_PINKISH_PURPLE = (0.8392156862745098, 0.2823529411764706, 0.8431372549019608)
    XKCD_VIOLET_PINK = (0.984313725490196, 0.37254901960784315, 0.9882352941176471)
    THISTLE = (0.8470588235294118, 0.7490196078431373, 0.8470588235294118)
    XKCD_PURPLEY_GRAY = (0.5803921568627451, 0.49411764705882355, 0.5803921568627451)
    XKCD_PURPLEY_GREY = (0.5803921568627451, 0.49411764705882355, 0.5803921568627451)
    PLUM = (0.8666666666666667, 0.6274509803921569, 0.8666666666666667)
    VIOLET = (0.9333333333333333, 0.5098039215686274, 0.9333333333333333)
    PURPLE = (0.5019607843137255, 0.0, 0.5019607843137255)
    DARKMAGENTA = (0.5450980392156862, 0.0, 0.5450980392156862)
    M = (0.75, 0.0, 0.75)
    FUCHSIA = (1.0, 0.0, 1.0)
    MAGENTA = (1.0, 0.0, 1.0)
    XKCD_PINK_PURPLE = (0.8588235294117647, 0.29411764705882354, 0.8549019607843137)
    XKCD_DEEP_VIOLET = (0.28627450980392155, 0.023529411764705882, 0.2823529411764706)
    XKCD_LIGHT_MAGENTA = (0.9803921568627451, 0.37254901960784315, 0.9686274509803922)
    XKCD_DARKISH_PURPLE = (0.4588235294117647, 0.09803921568627451, 0.45098039215686275)
    XKCD_EGGPLANT_PURPLE = (0.2627450980392157, 0.0196078431372549, 0.2549019607843137)
    ORCHID = (0.8549019607843137, 0.4392156862745098, 0.8392156862745098)
    XKCD_PINK_SLASH_PURPLE = (
        0.9372549019607843,
        0.11372549019607843,
        0.9058823529411765,
    )
    XKCD_UGLY_PURPLE = (0.6431372549019608, 0.25882352941176473, 0.6274509803921569)
    XKCD_PURPLE_GRAY = (0.5254901960784314, 0.43529411764705883, 0.5215686274509804)
    XKCD_PURPLE_GREY = (0.5254901960784314, 0.43529411764705883, 0.5215686274509804)
    XKCD_PALE_MAUVE = (0.996078431372549, 0.8156862745098039, 0.9882352941176471)
    XKCD_ORCHID = (0.7843137254901961, 0.4588235294117647, 0.7686274509803922)
    XKCD_PURPLE_PINK = (0.8784313725490196, 0.24705882352941178, 0.8470588235294118)
    XKCD_BARNEY_PURPLE = (0.6274509803921569, 0.01568627450980392, 0.596078431372549)
    XKCD_WARM_PURPLE = (0.5843137254901961, 0.1803921568627451, 0.5607843137254902)
    XKCD_LIGHT_EGGPLANT = (0.5372549019607843, 0.27058823529411763, 0.5215686274509804)
    XKCD_EGGPLANT = (0.2196078431372549, 0.03137254901960784, 0.20784313725490197)
    XKCD_LAVENDER_PINK = (0.8666666666666667, 0.5215686274509804, 0.8431372549019608)
    XKCD_PURPLY_PINK = (0.9411764705882353, 0.4588235294117647, 0.9019607843137255)
    XKCD_PINKY_PURPLE = (0.788235294117647, 0.2980392156862745, 0.7450980392156863)
    XKCD_FUCHSIA = (0.9294117647058824, 0.050980392156862744, 0.8509803921568627)
    XKCD_BRIGHT_MAGENTA = (1.0, 0.03137254901960784, 0.9098039215686274)
    XKCD_DUSTY_LAVENDER = (0.6745098039215687, 0.5254901960784314, 0.6588235294117647)
    XKCD_PURPLEY_PINK = (0.7843137254901961, 0.23529411764705882, 0.7254901960784313)
    XKCD_PURPLISH = (0.5803921568627451, 0.33725490196078434, 0.5490196078431373)
    XKCD_DULL_PURPLE = (0.5176470588235295, 0.34901960784313724, 0.49411764705882355)
    XKCD_CANDY_PINK = (1.0, 0.38823529411764707, 0.9137254901960784)
    XKCD_PURPLEISH_PINK = (0.8745098039215686, 0.3058823529411765, 0.7843137254901961)
    XKCD_GRAPE_PURPLE = (0.36470588235294116, 0.0784313725490196, 0.3176470588235294)
    XKCD_PURPLEISH = (0.596078431372549, 0.33725490196078434, 0.5529411764705883)
    XKCD_AUBERGINE = (0.23921568627450981, 0.027450980392156862, 0.20392156862745098)
    XKCD_HOT_MAGENTA = (0.9607843137254902, 0.01568627450980392, 0.788235294117647)
    XKCD_GRAPE = (0.4235294117647059, 0.20392156862745098, 0.3803921568627451)
    XKCD_BRUISE = (0.49411764705882355, 0.25098039215686274, 0.44313725490196076)
    XKCD_RICH_PURPLE = (0.4470588235294118, 0.0, 0.34509803921568627)
    XKCD_PURPLISH_PINK = (0.807843137254902, 0.36470588235294116, 0.6823529411764706)
    XKCD_DUSKY_PURPLE = (0.5372549019607843, 0.3568627450980392, 0.4823529411764706)
    XKCD_BRIGHT_PINK = (0.996078431372549, 0.00392156862745098, 0.6941176470588235)
    TAB_PINK = (0.8901960784313725, 0.4666666666666667, 0.7607843137254902)
    XKCD_DARK_PLUM = (0.24705882352941178, 0.00392156862745098, 0.17254901960784313)
    XKCD_PLUM = (0.34509803921568627, 0.058823529411764705, 0.2549019607843137)
    XKCD_VELVET = (0.4588235294117647, 0.03137254901960784, 0.3176470588235294)
    XKCD_DIRTY_PURPLE = (0.45098039215686275, 0.2901960784313726, 0.396078431372549)
    XKCD_RED_VIOLET = (0.6196078431372549, 0.00392156862745098, 0.40784313725490196)
    XKCD_SHOCKING_PINK = (0.996078431372549, 0.00784313725490196, 0.6352941176470588)
    MEDIUMVIOLETRED = (0.7803921568627451, 0.08235294117647059, 0.5215686274509804)
    XKCD_LIGHT_PLUM = (0.615686274509804, 0.3411764705882353, 0.5137254901960784)
    XKCD_PALE_MAGENTA = (0.8431372549019608, 0.403921568627451, 0.6784313725490196)
    XKCD_MAGENTA = (0.7607843137254902, 0.0, 0.47058823529411764)
    XKCD_NEON_PINK = (0.996078431372549, 0.00392156862745098, 0.6039215686274509)
    XKCD_BUBBLEGUM_PINK = (0.996078431372549, 0.5137254901960784, 0.8)
    XKCD_DARK_MAGENTA = (0.5882352941176471, 0.0, 0.33725490196078434)
    XKCD_DEEP_MAGENTA = (0.6274509803921569, 0.00784313725490196, 0.3607843137254902)
    XKCD_ELECTRIC_PINK = (1.0, 0.01568627450980392, 0.5647058823529412)
    XKCD_HOT_PINK = (1.0, 0.00784313725490196, 0.5529411764705883)
    XKCD_DARK_FUCHSIA = (0.615686274509804, 0.027450980392156862, 0.34901960784313724)
    DEEPPINK = (1.0, 0.0784313725490196, 0.5764705882352941)
    XKCD_REDDISH_PURPLE = (0.5686274509803921, 0.03529411764705882, 0.3176470588235294)
    XKCD_STRONG_PINK = (1.0, 0.027450980392156862, 0.5372549019607843)
    XKCD_RED_PURPLE = (0.5098039215686274, 0.027450980392156862, 0.2784313725490196)
    XKCD_BARBIE_PINK = (0.996078431372549, 0.27450980392156865, 0.6470588235294118)
    XKCD_VIOLET_RED = (0.6470588235294118, 0.0, 0.3333333333333333)
    XKCD_PINK = (1.0, 0.5058823529411764, 0.7529411764705882)
    HOTPINK = (1.0, 0.4117647058823529, 0.7058823529411765)
    XKCD_MULBERRY = (0.5725490196078431, 0.0392156862745098, 0.3058823529411765)
    XKCD_BUBBLEGUM = (1.0, 0.4235294117647059, 0.7098039215686275)
    XKCD_MERLOT = (0.45098039215686275, 0.0, 0.2235294117647059)
    XKCD_WINE = (0.5019607843137255, 0.00392156862745098, 0.24705882352941178)
    XKCD_DEEP_PINK = (0.796078431372549, 0.00392156862745098, 0.3843137254901961)
    XKCD_DARK_HOT_PINK = (0.8509803921568627, 0.00392156862745098, 0.4)
    XKCD_BUBBLE_GUM_PINK = (1.0, 0.4117647058823529, 0.6862745098039216)
    XKCD_PURPLE_RED = (0.6, 0.00392156862745098, 0.2784313725490196)
    XKCD_BERRY = (0.6, 0.058823529411764705, 0.29411764705882354)
    XKCD_RASPBERRY = (0.6901960784313725, 0.00392156862745098, 0.28627450980392155)
    XKCD_CERISE = (0.8705882352941177, 0.047058823529411764, 0.3843137254901961)
    XKCD_PURPLISH_RED = (0.6901960784313725, 0.0196078431372549, 0.29411764705882354)
    XKCD_POWDER_PINK = (1.0, 0.6980392156862745, 0.8156862745098039)
    XKCD_DARK_MAUVE = (0.5294117647058824, 0.2980392156862745, 0.3843137254901961)
    XKCD_DARKISH_PINK = (0.8549019607843137, 0.27450980392156865, 0.49019607843137253)
    XKCD_RED_WINE = (0.5490196078431373, 0.0, 0.20392156862745098)
    XKCD_CRANBERRY = (0.6196078431372549, 0.0, 0.22745098039215686)
    XKCD_MEDIUM_PINK = (0.9529411764705882, 0.3803921568627451, 0.5882352941176471)
    XKCD_BURGUNDY = (0.3803921568627451, 0.0, 0.13725490196078433)
    XKCD_BORDEAUX = (0.4823529411764706, 0.0, 0.17254901960784313)
    XKCD_RUBY = (0.792156862745098, 0.00392156862745098, 0.2784313725490196)
    LAVENDERBLUSH = (1.0, 0.9411764705882353, 0.9607843137254902)
    PALEVIOLETRED = (0.8588235294117647, 0.4392156862745098, 0.5764705882352941)
    XKCD_MAROON = (0.396078431372549, 0.0, 0.12941176470588237)
    XKCD_BABY_PINK = (1.0, 0.7176470588235294, 0.807843137254902)
    XKCD_LIGHT_MAUVE = (0.7607843137254902, 0.5725490196078431, 0.6313725490196078)
    XKCD_CARNATION_PINK = (1.0, 0.4980392156862745, 0.6549019607843137)
    XKCD_ROSE_RED = (0.7450980392156863, 0.00392156862745098, 0.23529411764705882)
    XKCD_PINK_RED = (0.9607843137254902, 0.0196078431372549, 0.30980392156862746)
    XKCD_PINKY = (0.9882352941176471, 0.5254901960784314, 0.6666666666666666)
    XKCD_LIGHT_PINK = (1.0, 0.8196078431372549, 0.8745098039215686)
    XKCD_DARK_PINK = (0.796078431372549, 0.2549019607843137, 0.4196078431372549)
    XKCD_DULL_PINK = (0.8352941176470589, 0.5254901960784314, 0.615686274509804)
    XKCD_LIPSTICK = (0.8352941176470589, 0.09019607843137255, 0.3058823529411765)
    XKCD_PASTEL_PINK = (1.0, 0.7294117647058823, 0.803921568627451)
    XKCD_MUTED_PINK = (0.8196078431372549, 0.4627450980392157, 0.5607843137254902)
    XKCD_PALE_PINK = (1.0, 0.8117647058823529, 0.8627450980392157)
    XKCD_ROSY_PINK = (0.9647058823529412, 0.40784313725490196, 0.5568627450980392)
    XKCD_WINE_RED = (0.4823529411764706, 0.011764705882352941, 0.13725490196078433)
    XKCD_WARM_PINK = (0.984313725490196, 0.3333333333333333, 0.5058823529411764)
    XKCD_MAUVE = (0.6823529411764706, 0.44313725490196076, 0.5058823529411764)
    XKCD_PIG_PINK = (0.9058823529411765, 0.5568627450980392, 0.6470588235294118)
    XKCD_ROUGE = (0.6705882352941176, 0.07058823529411765, 0.2235294117647059)
    XKCD_LIGHT_BURGUNDY = (0.6588235294117647, 0.2549019607843137, 0.3568627450980392)
    XKCD_ROSA = (0.996078431372549, 0.5254901960784314, 0.6431372549019608)
    XKCD_DEEP_ROSE = (0.7803921568627451, 0.2784313725490196, 0.403921568627451)
    XKCD_PINKISH_RED = (0.9450980392156862, 0.047058823529411764, 0.27058823529411763)
    XKCD_CHERRY = (0.8117647058823529, 0.00784313725490196, 0.20392156862745098)
    XKCD_LIPSTICK_RED = (0.7529411764705882, 0.00784313725490196, 0.1843137254901961)
    XKCD_FADED_PINK = (0.8705882352941177, 0.615686274509804, 0.6745098039215687)
    XKCD_BROWNISH_PURPLE = (0.4627450980392157, 0.25882352941176473, 0.3058823529411765)
    XKCD_CLARET = (0.40784313725490196, 0.0, 0.09411764705882353)
    XKCD_GRAY_PINK = (0.7647058823529411, 0.5647058823529412, 0.6078431372549019)
    XKCD_GREY_PINK = (0.7647058823529411, 0.5647058823529412, 0.6078431372549019)
    XKCD_SOFT_PINK = (0.9921568627450981, 0.6901960784313725, 0.7529411764705882)
    XKCD_DUSKY_PINK = (0.8, 0.47843137254901963, 0.5450980392156862)
    XKCD_RED_PINK = (0.9803921568627451, 0.16470588235294117, 0.3333333333333333)
    XKCD_NEON_RED = (1.0, 0.027450980392156862, 0.22745098039215686)
    CRIMSON = (0.8627450980392157, 0.0784313725490196, 0.23529411764705882)
    XKCD_DARK_ROSE = (0.7098039215686275, 0.2823529411764706, 0.36470588235294116)
    XKCD_REDDISH_PINK = (0.996078431372549, 0.17254901960784313, 0.32941176470588235)
    XKCD_PINKISH = (0.8313725490196079, 0.41568627450980394, 0.49411764705882355)
    PINK = (1.0, 0.7529411764705882, 0.796078431372549)
    XKCD_ROSE = (0.8117647058823529, 0.3843137254901961, 0.4588235294117647)
    XKCD_UGLY_PINK = (0.803921568627451, 0.4588235294117647, 0.5176470588235295)
    XKCD_ROSE_PINK = (0.9686274509803922, 0.5294117647058824, 0.6039215686274509)
    XKCD_OLD_PINK = (0.7803921568627451, 0.4745098039215686, 0.5254901960784314)
    XKCD_CARNATION = (0.9921568627450981, 0.4745098039215686, 0.5607843137254902)
    XKCD_LIGHT_MAROON = (0.6352941176470588, 0.2823529411764706, 0.3411764705882353)
    XKCD_CHERRY_RED = (0.9686274509803922, 0.00784313725490196, 0.16470588235294117)
    XKCD_PINKY_RED = (0.9882352941176471, 0.14901960784313725, 0.2784313725490196)
    LIGHTPINK = (1.0, 0.7137254901960784, 0.7568627450980392)
    XKCD_OLD_ROSE = (0.7843137254901961, 0.4980392156862745, 0.5372549019607843)
    XKCD_DUSKY_ROSE = (0.7294117647058823, 0.40784313725490196, 0.45098039215686275)
    XKCD_DUSTY_PINK = (0.8352941176470589, 0.5411764705882353, 0.5803921568627451)
    XKCD_DARK_MAROON = (0.23529411764705882, 0.0, 0.03137254901960784)
    XKCD_LIGHTISH_RED = (0.996078431372549, 0.1843137254901961, 0.2901960784313726)
    XKCD_CARMINE = (0.615686274509804, 0.00784313725490196, 0.08627450980392157)
    XKCD_SCARLET = (0.7450980392156863, 0.00392156862745098, 0.09803921568627451)
    XKCD_STRAWBERRY = (0.984313725490196, 0.1607843137254902, 0.2627450980392157)
    XKCD_PURPLISH_BROWN = (0.4196078431372549, 0.25882352941176473, 0.2784313725490196)
    XKCD_GRAYISH_PINK = (0.7843137254901961, 0.5529411764705883, 0.5803921568627451)
    XKCD_GREYISH_PINK = (0.7843137254901961, 0.5529411764705883, 0.5803921568627451)
    XKCD_PURPLE_BROWN = (0.403921568627451, 0.22745098039215686, 0.24705882352941178)
    XKCD_CRIMSON = (0.5490196078431373, 0.0, 0.058823529411764705)
    XKCD_WATERMELON = (0.9921568627450981, 0.27450980392156865, 0.34901960784313724)
    XKCD_LIGHT_ROSE = (1.0, 0.7725490196078432, 0.796078431372549)
    XKCD_DUSTY_ROSE = (0.7529411764705882, 0.45098039215686275, 0.47843137254901963)
    XKCD_BLUSH_PINK = (0.996078431372549, 0.5098039215686274, 0.5490196078431373)
    XKCD_PALE_ROSE = (0.9921568627450981, 0.7568627450980392, 0.7725490196078432)
    XKCD_DIRTY_PINK = (0.792156862745098, 0.4823529411764706, 0.5019607843137255)
    XKCD_DUSTY_RED = (0.7254901960784313, 0.2823529411764706, 0.3058823529411765)
    XKCD_BRIGHT_RED = (1.0, 0.0, 0.050980392156862744)
    XKCD_FADED_RED = (0.8274509803921568, 0.28627450980392155, 0.3058823529411765)
    XKCD_DARKISH_RED = (0.6627450980392157, 0.011764705882352941, 0.03137254901960784)
    XKCD_LIGHT_RED = (1.0, 0.2784313725490196, 0.2980392156862745)
    XKCD_BLOOD_RED = (0.596078431372549, 0.0, 0.00784313725490196)
    XKCD_CORAL_PINK = (1.0, 0.3803921568627451, 0.38823529411764707)
    XKCD_BLOOD = (0.4666666666666667, 0.0, 0.00392156862745098)
    XKCD_FIRE_ENGINE_RED = (0.996078431372549, 0.0, 0.00784313725490196)
    XKCD_SALMON_PINK = (0.996078431372549, 0.4823529411764706, 0.48627450980392156)
    TAB_RED = (0.8392156862745098, 0.15294117647058825, 0.1568627450980392)
