"""
    Merge CRM API

    The unified API for building rich integrations with multiple CRM platforms.  # noqa: E501

    The version of the OpenAPI document: 1.0
    Contact: hello@merge.dev
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from typing import (
    Optional,
    Union,
    List,
    Dict,
)

from MergePythonSDK.shared.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    OpenApiModel,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
)
from MergePythonSDK.shared.exceptions import ApiAttributeError
from MergePythonSDK.shared.model_utils import import_model_by_name


def lazy_import():
    from MergePythonSDK.crm.model.field_format_enum import FieldFormatEnum
    from MergePythonSDK.crm.model.field_type_enum import FieldTypeEnum
    from MergePythonSDK.crm.model.item_schema import ItemSchema
    globals()['FieldFormatEnum'] = FieldFormatEnum
    globals()['FieldTypeEnum'] = FieldTypeEnum
    globals()['ItemSchema'] = ItemSchema

class RemoteFieldClass(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
    }

    validations = {
    }

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        return (bool, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()

        defined_types = {
            'id': (str, none_type,),  # noqa: E501
            'display_name': (str, none_type,),  # noqa: E501
            'remote_key_name': (str, none_type,),  # noqa: E501
            'description': (str, none_type,),  # noqa: E501
            'is_custom': (bool, none_type,),  # noqa: E501
            'is_required': (bool, none_type,),  # noqa: E501
            'field_type': (FieldTypeEnum, none_type,),  # noqa: E501
            'field_format': (FieldFormatEnum, none_type,),  # noqa: E501
            'field_choices': ([str], none_type,),  # noqa: E501
            'item_schema': (ItemSchema, none_type,),  # noqa: E501
        }
        return defined_types

    @cached_property
    def discriminator():
        return None


    attribute_map = {
        'id': 'id',  # noqa: E501
        'display_name': 'display_name',  # noqa: E501
        'remote_key_name': 'remote_key_name',  # noqa: E501
        'description': 'description',  # noqa: E501
        'is_custom': 'is_custom',  # noqa: E501
        'is_required': 'is_required',  # noqa: E501
        'field_type': 'field_type',  # noqa: E501
        'field_format': 'field_format',  # noqa: E501
        'field_choices': 'field_choices',  # noqa: E501
        'item_schema': 'item_schema',  # noqa: E501
    }

    read_only_vars = {
    }

    _composed_schemas = {}

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, *args, **kwargs):  # noqa: E501
        """RemoteFieldClass - a model defined in OpenAPI

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            id (str): [optional]  # noqa: E501
            display_name (str): [optional]  # noqa: E501
            remote_key_name (str): [optional]  # noqa: E501
            description (str): [optional]  # noqa: E501
            is_custom (bool): [optional]  # noqa: E501
            is_required (bool): [optional]  # noqa: E501
            field_type (FieldTypeEnum): [optional]  # noqa: E501
            field_format (FieldFormatEnum): [optional]  # noqa: E501
            field_choices ([str]): [optional]  # noqa: E501
            item_schema (ItemSchema): [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', True)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)


        self.id = kwargs.get("id", None)
        self.display_name = kwargs.get("display_name", None)
        self.remote_key_name = kwargs.get("remote_key_name", None)
        self.description = kwargs.get("description", None)
        self.is_custom = kwargs.get("is_custom", None)
        self.is_required = kwargs.get("is_required", None)
        self.field_type = kwargs.get("field_type", None)
        self.field_format = kwargs.get("field_format", None)
        self.field_choices = kwargs.get("field_choices", None)
        self.item_schema = kwargs.get("item_schema", None)
        return self

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self, *args, **kwargs):  # noqa: E501
        """RemoteFieldClass - a model defined in OpenAPI

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            id (str): [optional]  # noqa: E501
            display_name (str): [optional]  # noqa: E501
            remote_key_name (str): [optional]  # noqa: E501
            description (str): [optional]  # noqa: E501
            is_custom (bool): [optional]  # noqa: E501
            is_required (bool): [optional]  # noqa: E501
            field_type (FieldTypeEnum): [optional]  # noqa: E501
            field_format (FieldFormatEnum): [optional]  # noqa: E501
            field_choices ([str]): [optional]  # noqa: E501
            item_schema (ItemSchema): [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.id: Union[str] = kwargs.get("id", str())
        self.display_name: Union[str] = kwargs.get("display_name", str())
        self.remote_key_name: Union[str] = kwargs.get("remote_key_name", str())
        self.description: Union[str] = kwargs.get("description", str())
        self.is_custom: Union[bool] = kwargs.get("is_custom", bool())
        self.is_required: Union[bool] = kwargs.get("is_required", bool())
        self.field_type: Union["FieldTypeEnum"] = kwargs.get("field_type", None)
        self.field_format: Union["FieldFormatEnum"] = kwargs.get("field_format", None)
        self.field_choices: Union[List[str]] = kwargs.get("field_choices", list())
        self.item_schema: Union["ItemSchema"] = kwargs.get("item_schema", None)


