# generated by datamodel-codegen:
#   filename:  api/dataInsight/custom/createDataInsightCustomChart.json
#   timestamp: 2025-08-12T13:13:31+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional, Union

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ....dataInsight.custom import lineChart, summaryCard
from ....type import basic, entityReference


class ChartType(Enum):
    LineChart = 'LineChart'
    AreaChart = 'AreaChart'
    BarChart = 'BarChart'
    SummaryCard = 'SummaryCard'


class CreateDataInsightCustomChart(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: Annotated[
        basic.EntityName,
        Field(description='Name that identifies this data insight chart.'),
    ]
    displayName: Annotated[
        Optional[str], Field(None, description='Display Name the data insight chart.')
    ]
    description: Annotated[
        Optional[basic.Markdown],
        Field(None, description='Description of the data insight chart.'),
    ]
    chartType: Annotated[
        Optional[ChartType],
        Field(None, description='Type of chart, used for UI to render the chart'),
    ]
    chartDetails: Union[lineChart.LineChart, summaryCard.SummaryCard]
    owner: Annotated[
        Optional[entityReference.EntityReference],
        Field(None, description='Owner of this chart'),
    ]
    dashboard: Annotated[
        Optional[entityReference.EntityReference],
        Field(None, description='Dashboard where this chart is displayed'),
    ]
