# generated by datamodel-codegen:
#   filename:  dataInsight/custom/lineChart.json
#   timestamp: 2025-08-12T13:13:31+00:00

from __future__ import annotations

from enum import Enum
from typing import List, Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from . import dataInsightCustomChart


class Type(Enum):
    LineChart = 'LineChart'


class Metrics(BaseModel):
    name: Annotated[
        Optional[str],
        Field(None, description='Name of the metric for the data insight chart.'),
    ]
    function: Optional[dataInsightCustomChart.Function] = None
    field: Annotated[
        Optional[str],
        Field(None, description='Filter field for the data insight chart.'),
    ]
    filter: Annotated[
        Optional[str],
        Field(None, description='Filter value for the data insight chart.'),
    ]
    treeFilter: Annotated[
        Optional[str],
        Field(
            None,
            description='Tree filter value for the data insight chart. Needed for UI to recreate advance filter tree.',
        ),
    ]
    formula: Annotated[
        Optional[str],
        Field(None, description='Formula for the data insight chart calculation.'),
    ]


class LineChart(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Annotated[
        Optional[Type],
        Field(Type.LineChart, description='Type of the data insight chart.'),
    ]
    metrics: Annotated[
        Optional[List[Metrics]],
        Field(None, description='Metrics for the data insight chart.'),
    ]
    groupBy: Annotated[
        Optional[str],
        Field(None, description='Breakdown field for the data insight chart.'),
    ]
    includeGroups: Annotated[
        Optional[List[str]],
        Field(
            None,
            description='List of groups to be included in the data insight chart when groupBy is specified.',
        ),
    ]
    excludeGroups: Annotated[
        Optional[List[str]],
        Field(
            None,
            description='List of groups to be excluded in the data insight chart when groupBy is specified.',
        ),
    ]
    xAxisLabel: Annotated[
        Optional[str],
        Field(None, description='X-axis label for the data insight chart.'),
    ]
    yAxisLabel: Annotated[
        Optional[str],
        Field(None, description='Y-axis label for the data insight chart.'),
    ]
    kpiDetails: Optional[dataInsightCustomChart.KpiDetails] = None
    xAxisField: Annotated[
        Optional[str],
        Field('@timestamp', description='X-axis field for the data insight chart.'),
    ]
