# generated by datamodel-codegen:
#   filename:  entity/applications/configuration/external/automator/lineagePropagationAction.json
#   timestamp: 2025-08-12T13:13:31+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel


class LineagePropagationActionType(Enum):
    LineagePropagationAction = 'LineagePropagationAction'


class LineagePropagationAction(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Annotated[
        LineagePropagationActionType,
        Field(description='Application Type', title='Application Type'),
    ]
    propagateDescription: Annotated[
        Optional[bool],
        Field(
            True,
            description='Propagate description through lineage',
            title='Propagate Description',
        ),
    ]
    propagateTags: Annotated[
        Optional[bool],
        Field(
            True, description='Propagate tags through lineage', title='Propagate Tags'
        ),
    ]
    propagateGlossaryTerms: Annotated[
        Optional[bool],
        Field(
            True,
            description='Propagate glossary terms through lineage',
            title='Propagate Glossary Terms',
        ),
    ]
    propagateTier: Annotated[
        Optional[bool],
        Field(
            False, description='Propagate tier from the parent', title='Propagate Tier'
        ),
    ]
    propagateOwner: Annotated[
        Optional[bool],
        Field(
            False,
            description='Propagate owner from the parent',
            title='Propagate Owner',
        ),
    ]
    propagateColumnLevel: Annotated[
        Optional[bool],
        Field(
            True,
            description='Propagate the metadata to columns via column-level lineage.',
            title='Propagate Column Level',
        ),
    ]
    propagateParent: Annotated[
        Optional[bool],
        Field(
            False,
            description='Propagate the metadata to the parents (e.g., tables) via lineage.',
            title='Propagate Parent',
        ),
    ]
    overwriteMetadata: Annotated[
        Optional[bool],
        Field(
            False,
            description='Update descriptions, tags and Glossary Terms via lineage even if they are already defined in the asset. By default, descriptions are only updated if they are not already defined in the asset, and incoming tags are merged with the existing ones.',
            title='Overwrite Metadata',
        ),
    ]
