# generated by datamodel-codegen:
#   filename:  entity/data/databaseSchema.json
#   timestamp: 2025-08-12T13:13:31+00:00

from __future__ import annotations

from typing import List, Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ...type import (
    assetCertification,
    basic,
    entityHistory,
    entityReference,
    entityReferenceList,
    lifeCycle,
    tagLabel,
    usageDetails,
    votes,
)
from ..services import databaseService
from ..services.connections import connectionBasicType
from . import table


class DatabaseSchemaProfilerConfig(BaseModel):
    profileSample: Annotated[
        Optional[float],
        Field(
            None,
            description='Percentage of data or no. of rows we want to execute the profiler and tests on',
        ),
    ]
    profileSampleType: Optional[
        table.ProfileSampleType
    ] = table.ProfileSampleType.PERCENTAGE
    sampleDataCount: Annotated[
        Optional[int],
        Field(
            50,
            description='Number of row of sample data to be generated',
            title='Sample Data Rows Count',
        ),
    ]
    samplingMethodType: Optional[table.SamplingMethodType] = None
    sampleDataStorageConfig: Annotated[
        Optional[connectionBasicType.SampleDataStorageConfig],
        Field(None, title='Storage Config for Sample Data'),
    ]


class DatabaseSchema(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    id: Annotated[
        Optional[basic.Uuid],
        Field(
            None, description='Unique identifier that identifies this schema instance.'
        ),
    ]
    name: Annotated[
        basic.EntityName, Field(description='Name that identifies the schema.')
    ]
    fullyQualifiedName: Annotated[
        Optional[basic.FullyQualifiedEntityName],
        Field(
            None,
            description="Name that uniquely identifies a schema in the format 'ServiceName.DatabaseName.SchemaName'.",
        ),
    ]
    displayName: Annotated[
        Optional[str],
        Field(None, description='Display Name that identifies this schema.'),
    ]
    description: Annotated[
        Optional[basic.Markdown],
        Field(None, description='Description of the schema instance.'),
    ]
    dataProducts: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='List of data products this entity is part of.'),
    ]
    version: Annotated[
        Optional[entityHistory.EntityVersion],
        Field(None, description='Metadata version of the entity.'),
    ]
    updatedAt: Annotated[
        Optional[basic.Timestamp],
        Field(
            None,
            description='Last update time corresponding to the new version of the entity in Unix epoch time milliseconds.',
        ),
    ]
    updatedBy: Annotated[
        Optional[str], Field(None, description='User who made the update.')
    ]
    href: Annotated[
        Optional[basic.Href],
        Field(None, description='Link to the resource corresponding to this entity.'),
    ]
    owners: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='Owner of this schema.'),
    ]
    service: Annotated[
        entityReference.EntityReference,
        Field(
            description='Link to the database cluster/service where this schema is hosted in.'
        ),
    ]
    serviceType: Annotated[
        Optional[databaseService.DatabaseServiceType],
        Field(None, description='Service type where this schema is hosted in.'),
    ]
    database: Annotated[
        entityReference.EntityReference,
        Field(description='Reference to Database that contains this table.'),
    ]
    tables: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='References to tables in the schema.'),
    ]
    usageSummary: Annotated[
        Optional[usageDetails.UsageDetails],
        Field(None, description='Latest usage information for this database.'),
    ]
    tags: Annotated[
        Optional[List[tagLabel.TagLabel]],
        Field([], description='Tags for this Database Schema Service.'),
    ]
    changeDescription: Annotated[
        Optional[entityHistory.ChangeDescription],
        Field(None, description='Change that lead to this version of the entity.'),
    ]
    incrementalChangeDescription: Annotated[
        Optional[entityHistory.ChangeDescription],
        Field(None, description='Change that lead to this version of the entity.'),
    ]
    deleted: Annotated[
        Optional[bool],
        Field(
            False, description='When `true` indicates the entity has been soft deleted.'
        ),
    ]
    retentionPeriod: Annotated[
        Optional[basic.Duration],
        Field(
            None,
            description='Retention period of the data in the database schema. Period is expressed as duration in ISO 8601 format in UTC. Example - `P23DT23H`. When not set, the retention period is inherited from the parent database, if it exists.',
        ),
    ]
    extension: Annotated[
        Optional[basic.EntityExtension],
        Field(
            None,
            description='Entity extension data with custom attributes added to the entity.',
        ),
    ]
    sourceUrl: Annotated[
        Optional[basic.SourceUrl],
        Field(None, description='Source URL of database schema.'),
    ]
    domain: Annotated[
        Optional[entityReference.EntityReference],
        Field(
            None,
            description='Domain the Database Schema belongs to. When not set, the Schema inherits the domain from the database it belongs to.',
        ),
    ]
    votes: Annotated[
        Optional[votes.Votes], Field(None, description='Votes on the entity.')
    ]
    lifeCycle: Annotated[
        Optional[lifeCycle.LifeCycle],
        Field(None, description='Life Cycle properties of the entity'),
    ]
    certification: Optional[assetCertification.AssetCertification] = None
    sourceHash: Annotated[
        Optional[str],
        Field(
            None, description='Source hash of the entity', max_length=32, min_length=1
        ),
    ]
    databaseSchemaProfilerConfig: Annotated[
        Optional[DatabaseSchemaProfilerConfig],
        Field(
            None, description='This schema defines the type for Schema profile config.'
        ),
    ]
