# generated by datamodel-codegen:
#   filename:  governance/workflows/workflowInstance.json
#   timestamp: 2025-08-12T13:13:31+00:00

from __future__ import annotations

from typing import Any, Dict, Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ...type import basic


class WorkflowInstance(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    id: Annotated[
        Optional[basic.Uuid],
        Field(None, description='Unique identifier of this workflow instance state.'),
    ]
    workflowDefinitionId: Annotated[
        Optional[basic.Uuid], Field(None, description='Workflow Definition Id.')
    ]
    startedAt: Annotated[
        Optional[basic.Timestamp],
        Field(None, description='Timestamp on which the workflow instance started.'),
    ]
    endedAt: Annotated[
        Optional[basic.Timestamp],
        Field(None, description='Timestamp on which the workflow instance ended.'),
    ]
    variables: Optional[Dict[str, Any]] = None
    timestamp: Annotated[
        Optional[basic.Timestamp],
        Field(
            None,
            description='Timestamp on which the workflow instance state was created.',
        ),
    ]
    exception: Annotated[
        Optional[bool],
        Field(
            None,
            description="If the Workflow Instance has errors, 'True'. Else, 'False'.",
        ),
    ]
