# generated by datamodel-codegen:
#   filename:  api/automations/createWorkflow.json
#   timestamp: 2024-10-24T15:21:08+00:00

from __future__ import annotations

from typing import Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ...entity.automations import testServiceConnection, workflow
from ...entity.services.connections import testConnectionResult
from ...type import basic, entityReferenceList


class CreateWorkflowRequest(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: Annotated[basic.EntityName, Field(description='Name of the workflow.')]
    displayName: Annotated[
        Optional[str],
        Field(
            None, description='Display Name that identifies this workflow definition.'
        ),
    ]
    description: Annotated[
        Optional[basic.Markdown],
        Field(None, description='Description of the test connection def.'),
    ]
    workflowType: Annotated[
        workflow.WorkflowType, Field(description='Type of the workflow.')
    ]
    request: Annotated[
        testServiceConnection.TestServiceConnectionRequest,
        Field(description='Request body for a specific workflow type'),
    ]
    status: Annotated[
        Optional[workflow.WorkflowStatus],
        Field(
            workflow.WorkflowStatus.Pending, description='Workflow computation status.'
        ),
    ]
    response: Annotated[
        Optional[testConnectionResult.TestConnectionResult],
        Field(None, description='Response to the request.'),
    ]
    owners: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='Owners of this workflow.'),
    ]
    domain: Annotated[
        Optional[str],
        Field(
            None, description='Fully qualified name of the domain the Table belongs to.'
        ),
    ]
