# generated by datamodel-codegen:
#   filename:  api/createType.json
#   timestamp: 2024-10-24T15:21:08+00:00

from __future__ import annotations

from typing import Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ..entity import type
from ..type import basic


class CreateType(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: Annotated[
        type.EntityName, Field(description='Unique name that identifies a Type.')
    ]
    displayName: Annotated[
        Optional[str],
        Field(None, description='Display Name that identifies this Type.'),
    ]
    description: Annotated[
        basic.Markdown, Field(description='Optional description of the type.')
    ]
    nameSpace: Annotated[
        str, Field(description='Namespace or group to which this type belongs to.')
    ]
    category: Optional[type.Category] = None
    schema_: Annotated[
        basic.JsonSchema,
        Field(
            alias='schema',
            description='JSON schema encoded as string. This will be used to validate the type values.',
        ),
    ]
    domain: Annotated[
        Optional[str],
        Field(
            None, description='Fully qualified name of the domain the Table belongs to.'
        ),
    ]
