# generated by datamodel-codegen:
#   filename:  api/teams/createTeam.json
#   timestamp: 2024-10-24T15:21:08+00:00

from __future__ import annotations

from typing import List, Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ...entity.teams import team
from ...type import basic, entityReferenceList, profile


class CreateTeamRequest(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    teamType: Annotated[team.TeamType, Field(description='Team type')]
    name: basic.EntityName
    email: Annotated[
        Optional[basic.Email], Field(None, description='Email address of the team.')
    ]
    displayName: Annotated[
        Optional[str],
        Field(
            None,
            description="Optional name used for display purposes. Example 'Marketing Team'.",
        ),
    ]
    description: Annotated[
        Optional[basic.Markdown],
        Field(None, description='Optional description of the team.'),
    ]
    profile: Annotated[
        Optional[profile.Profile],
        Field(None, description='Optional team profile information.'),
    ]
    parents: Annotated[
        Optional[List[basic.Uuid]],
        Field(
            None,
            description='Parent teams. For an `Organization` the `parent` is always null. A `BusinessUnit` always has only one parent of type `BusinessUnit` or an `Organization`. A `Division` can have multiple parents of type `BusinessUnit` or `Division`. A `Department` can have multiple parents of type `Division` or `Department`.',
        ),
    ]
    children: Annotated[
        Optional[List[basic.Uuid]],
        Field(
            None,
            description='Children teams. An `Organization` can have `BusinessUnit`, `Division` or `Department` as children. A `BusinessUnit` can have `BusinessUnit`, `Division`, or `Department` as children. A `Division` can have `Division` or `Department` as children. A `Department` can have `Department` as children.',
        ),
    ]
    users: Annotated[
        Optional[List[basic.Uuid]],
        Field(None, description='Optional IDs of users that are part of the team.'),
    ]
    defaultRoles: Annotated[
        Optional[List[basic.Uuid]],
        Field(
            None,
            description='Roles to be assigned to all users that are part of this team.',
        ),
    ]
    owners: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='Owners sof this team. '),
    ]
    isJoinable: Annotated[
        Optional[bool],
        Field(
            True,
            description='Can any user join this team during sign up? Value of true indicates yes, and false no.',
        ),
    ]
    policies: Annotated[
        Optional[List[basic.Uuid]],
        Field(None, description='Policies that is attached to this team.'),
    ]
    domains: Annotated[
        Optional[List[basic.EntityName]],
        Field(None, description='Domains the team belongs to.'),
    ]
