# generated by datamodel-codegen:
#   filename:  dataInsight/dataInsightChartResult.json
#   timestamp: 2024-10-24T15:21:08+00:00

from __future__ import annotations

from enum import Enum
from typing import List, Optional, Union

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from .type import (
    aggregatedUnusedAssetsCount,
    aggregatedUnusedAssetsSize,
    aggregatedUsedVsUnusedAssetsCount,
    aggregatedUsedVsUnusedAssetsSize,
    dailyActiveUsers,
    mostActiveUsers,
    mostViewedEntities,
    pageViewsByEntities,
    unusedAssets,
)


class DataInsightChartType(Enum):
    DailyActiveUsers = 'DailyActiveUsers'
    MostActiveUsers = 'MostActiveUsers'
    MostViewedEntities = 'MostViewedEntities'
    PageViewsByEntities = 'PageViewsByEntities'
    UnusedAssets = 'UnusedAssets'
    AggregatedUnusedAssetsSize = 'AggregatedUnusedAssetsSize'
    AggregatedUnusedAssetsCount = 'AggregatedUnusedAssetsCount'
    AggregatedUsedVsUnusedAssetsSize = 'AggregatedUsedVsUnusedAssetsSize'
    AggregatedUsedVsUnusedAssetsCount = 'AggregatedUsedVsUnusedAssetsCount'


class DataInsightChartResult(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    chartType: Annotated[
        DataInsightChartType,
        Field(
            description='Chart Type that will consume the data. Must match name of dataInsightChart.'
        ),
    ]
    total: Annotated[
        Optional[int],
        Field(None, description='Total number of hits returned by the aggregation.'),
    ]
    data: Annotated[
        Optional[
            List[
                Union[
                    dailyActiveUsers.DailyActiveUsers,
                    pageViewsByEntities.PageViewsByEntities,
                    mostActiveUsers.MostActiveUsers,
                    mostViewedEntities.MostViewedEntities,
                    unusedAssets.UnusedAssets,
                    aggregatedUnusedAssetsSize.AggregatedUnusedAssetsSize,
                    aggregatedUnusedAssetsCount.AggregatedUnusedAssetsCount,
                    aggregatedUsedVsUnusedAssetsSize.AggregatedUsedVsUnusedAssetsSize,
                    aggregatedUsedVsUnusedAssetsCount.AggregatedUsedVsUnusedAssetsCount,
                ]
            ]
        ],
        Field(None, description='Array of consumable data.'),
    ]
