# generated by datamodel-codegen:
#   filename:  entity/classification/tag.json
#   timestamp: 2024-10-24T15:21:08+00:00

from __future__ import annotations

from typing import Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ...type import basic, entityHistory, entityReference, entityReferenceList


class Tag(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    id: Annotated[
        Optional[basic.Uuid],
        Field(None, description='Unique identifier of this entity instance.'),
    ]
    name: Annotated[basic.EntityName, Field(description='Name of the tag.')]
    displayName: Annotated[
        Optional[str], Field(None, description='Display Name that identifies this tag.')
    ]
    fullyQualifiedName: Annotated[
        Optional[str],
        Field(
            None,
            description='Unique name of the tag of format `Classification.tag1.tag2`.',
        ),
    ]
    description: Annotated[basic.Markdown, Field(description='Description of the tag.')]
    style: Optional[basic.Style] = None
    classification: Annotated[
        Optional[entityReference.EntityReference],
        Field(
            None,
            description='Reference to the classification that this tag is part of.',
        ),
    ]
    parent: Annotated[
        Optional[entityReference.EntityReference],
        Field(
            None,
            description='Reference to the parent tag. When null, the term is at the root of the Classification.',
        ),
    ]
    children: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='Children tags under this tag.'),
    ]
    version: Annotated[
        Optional[entityHistory.EntityVersion],
        Field(None, description='Metadata version of the entity.'),
    ]
    updatedAt: Annotated[
        Optional[basic.Timestamp],
        Field(
            None,
            description='Last update time corresponding to the new version of the entity in Unix epoch time milliseconds.',
        ),
    ]
    updatedBy: Annotated[
        Optional[str], Field(None, description='User who made the update.')
    ]
    href: Annotated[
        Optional[basic.Href],
        Field(None, description='Link to the resource corresponding to the tag.'),
    ]
    usageCount: Annotated[
        Optional[int],
        Field(
            None,
            description='Count of how many times this tag and children tags are used.',
        ),
    ]
    deprecated: Annotated[
        Optional[bool], Field(False, description='If the tag is deprecated.')
    ]
    deleted: Annotated[
        Optional[bool],
        Field(
            False, description='When `true` indicates the entity has been soft deleted.'
        ),
    ]
    changeDescription: Annotated[
        Optional[entityHistory.ChangeDescription],
        Field(None, description='Change that lead to this version of the entity.'),
    ]
    provider: Optional[basic.ProviderType] = basic.ProviderType.user
    disabled: Annotated[
        Optional[bool],
        Field(
            None,
            description="System tags can't be deleted. Use this flag to disable them.",
        ),
    ]
    mutuallyExclusive: Annotated[
        Optional[bool],
        Field(
            'false',
            description='Children tags under this group are mutually exclusive. When mutually exclusive is `true` the tags from this group are used to **classify** an entity. An entity can only be in one class - example, it can only be either `tier1` or `tier2` and not both. When mutually exclusive is `false`, the tags from this group are used to **categorize** an entity. An entity can be in multiple categories simultaneously - example a customer can be `newCustomer` and `atRisk` simultaneously.',
        ),
    ]
    domain: Annotated[
        Optional[entityReference.EntityReference],
        Field(
            None,
            description='Domain the asset belongs to. When not set, the asset inherits the domain from the parent it belongs to.',
        ),
    ]
    dataProducts: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='List of data products this entity is part of.'),
    ]
