# generated by datamodel-codegen:
#   filename:  entity/data/database.json
#   timestamp: 2024-10-24T15:21:08+00:00

from __future__ import annotations

from typing import List, Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ...type import (
    basic,
    entityHistory,
    entityReference,
    entityReferenceList,
    lifeCycle,
    tagLabel,
    usageDetails,
    votes,
)
from ..services import databaseService
from ..services.connections import connectionBasicType
from . import table


class DatabaseProfilerConfig(BaseModel):
    profileSample: Annotated[
        Optional[float],
        Field(
            None,
            description='Percentage of data or no. of rows we want to execute the profiler and tests on',
        ),
    ]
    profileSampleType: Optional[
        table.ProfileSampleType
    ] = table.ProfileSampleType.PERCENTAGE
    sampleDataCount: Annotated[
        Optional[int],
        Field(
            50,
            description='Number of row of sample data to be generated',
            title='Sample Data Rows Count',
        ),
    ]
    sampleDataStorageConfig: Annotated[
        Optional[connectionBasicType.SampleDataStorageConfig],
        Field(None, title='Storage Config for Sample Data'),
    ]


class Database(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    id: Annotated[
        Optional[basic.Uuid],
        Field(
            None,
            description='Unique identifier that identifies this database instance.',
        ),
    ]
    name: Annotated[
        basic.EntityName, Field(description='Name that identifies the database.')
    ]
    fullyQualifiedName: Annotated[
        Optional[basic.FullyQualifiedEntityName],
        Field(
            None,
            description="Name that uniquely identifies a database in the format 'ServiceName.DatabaseName'.",
        ),
    ]
    displayName: Annotated[
        Optional[str],
        Field(None, description='Display Name that identifies this database.'),
    ]
    description: Annotated[
        Optional[basic.Markdown],
        Field(None, description='Description of the database instance.'),
    ]
    dataProducts: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='List of data products this entity is part of.'),
    ]
    tags: Annotated[
        Optional[List[tagLabel.TagLabel]],
        Field(None, description='Tags for this Database.'),
    ]
    version: Annotated[
        Optional[entityHistory.EntityVersion],
        Field(None, description='Metadata version of the entity.'),
    ]
    updatedAt: Annotated[
        Optional[basic.Timestamp],
        Field(
            None,
            description='Last update time corresponding to the new version of the entity in Unix epoch time milliseconds.',
        ),
    ]
    updatedBy: Annotated[
        Optional[str], Field(None, description='User who made the update.')
    ]
    href: Annotated[
        Optional[basic.Href],
        Field(None, description='Link to the resource corresponding to this entity.'),
    ]
    owners: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='Owners of this database.'),
    ]
    service: Annotated[
        entityReference.EntityReference,
        Field(
            description='Link to the database cluster/service where this database is hosted in.'
        ),
    ]
    serviceType: Annotated[
        Optional[databaseService.DatabaseServiceType],
        Field(None, description='Service type where this database is hosted in.'),
    ]
    location: Annotated[
        Optional[entityReference.EntityReference],
        Field(
            None, description='Reference to the Location that contains this database.'
        ),
    ]
    usageSummary: Annotated[
        Optional[usageDetails.UsageDetails],
        Field(None, description='Latest usage information for this database.'),
    ]
    databaseSchemas: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='References to schemas in the database.'),
    ]
    changeDescription: Annotated[
        Optional[entityHistory.ChangeDescription],
        Field(None, description='Change that lead to this version of the entity.'),
    ]
    default: Annotated[
        Optional[bool],
        Field(
            False,
            description="Some databases don't support a database/catalog in the hierarchy and use default database. For example, `MySql`. For such databases, set this flag to true to indicate that this is a default database.",
        ),
    ]
    deleted: Annotated[
        Optional[bool],
        Field(
            False, description='When `true` indicates the entity has been soft deleted.'
        ),
    ]
    retentionPeriod: Annotated[
        Optional[basic.Duration],
        Field(
            None,
            description='Retention period of the data in the database. Period is expressed as duration in ISO 8601 format in UTC. Example - `P23DT23H`.',
        ),
    ]
    extension: Annotated[
        Optional[basic.EntityExtension],
        Field(
            None,
            description='Entity extension data with custom attributes added to the entity.',
        ),
    ]
    sourceUrl: Annotated[
        Optional[basic.SourceUrl], Field(None, description='Source URL of database.')
    ]
    domain: Annotated[
        Optional[entityReference.EntityReference],
        Field(
            None,
            description='Domain the Database belongs to. When not set, the Database inherits the domain from the database service it belongs to.',
        ),
    ]
    votes: Annotated[
        Optional[votes.Votes], Field(None, description='Votes on the entity.')
    ]
    lifeCycle: Annotated[
        Optional[lifeCycle.LifeCycle],
        Field(None, description='Life Cycle properties of the entity'),
    ]
    sourceHash: Annotated[
        Optional[str],
        Field(
            None, description='Source hash of the entity', max_length=32, min_length=1
        ),
    ]
    databaseProfilerConfig: Annotated[
        Optional[DatabaseProfilerConfig],
        Field(
            None,
            description='This schema defines the type for Database profile config.',
        ),
    ]
